/* <<< Start of information >>>                                             */
/* This file is part of the xwatch package.                                 */
/* Copyright (C) 1995 Karel Kubat.  All rights reserved.                    */
/*                                                                          */
/* This program is free software; you can redistribute it and/or modify it  */
/* under the terms of the GNU General Public License as published by the    */
/* Free Software Foundation; either version 2 of the License, or (at your   */
/* option) any later version.                                               */
/*                                                                          */
/* You may link this software with XForms (Copyright (C) by T.C. Zhao and   */
/* Mark Overmars) and distribute the resulting binary, under the            */
/* restrictions in clause 3 of the GPL, even though the resulting binary is */
/* not, as a whole, covered by the GPL. (You still need a separate license  */
/* to do so from the owner(s) of the copyright for XForms, however).  If a  */
/* derivative no longer requires XForms, you may use the unsupplemented GPL */
/* as its license by deleting this paragraph and therefore removing this    */
/* exemption for XForms.                                                    */
/*                                                                          */
/* This program is distributed in the hope that it will be useful,          */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/* GNU General Public License for more details.                             */
/*                                                                          */
/* You should have received a copy of the GNU General Public License        */
/* along with this program; if not, write to the Free Software              */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA */
/* <<< End of information >>>                                               */

static FL_CMD_OPT cmdopt [] =	    /* resource options */
{
    { "-border",        "*.border",        XrmoptionSepArg, 0 },
    { "-printtime",     "*.printtime",     XrmoptionSepArg, 0 },
    { "-printname",     "*.filename",      XrmoptionSepArg, 0 },
    { "-newline",       "*.newline",       XrmoptionSepArg, 0 },
    { "-nlines",        "*.nlines",        XrmoptionSepArg, 0 },
    { "-interval",      "*.interval",      XrmoptionSepArg, 0 },
    { "-linelen",       "*.linelen",       XrmoptionSepArg, 0 },
    { "-fontsize",      "*.fontsize",      XrmoptionSepArg, 0 },
    { "-fontstyle",     "*.fontstyle",     XrmoptionSepArg, 0 },
    { "-firstwarnings", "*.firstwarnings", XrmoptionSepArg, 0 },
    { "-printversion",  "*.printversion",  XrmoptionSepArg, 0 },
    { "-gag",           "*.gag",           XrmoptionSepArg, 0 },
    { "-title",         "*.title",         XrmoptionSepArg, 0 },
    { "-colorstring",   "*.colorstring",   XrmoptionSepArg, 0 },
    { "-geometry",      "*.geometry",      XrmoptionSepArg, 0 },
    { "-ignore",        "*.ignore",        XrmoptionSepArg, 0 },
    { "-fg",            "*.foreground",    XrmoptionSepArg, 0 },
    { "-bg",            "*.background",    XrmoptionSepArg, 0 },
};

static FL_resource res [] =
{
    { "border",        "XWatch", FL_INT,    &border,             "1",   0 },
    { "printtime",     "XWatch", FL_INT,    &printtime,          "1",   0 },
    { "printname",     "XWatch", FL_INT,    &printname,          "1",   0 },
    { "newline",       "XWatch", FL_INT,    &newline,            "0",   0 },
    { "nlines",        "XWatch", FL_INT,    &nlines,             "200", 0 },
    { "interval",      "XWatch", FL_INT,    &interval,           "5",   0 },
    { "fontsize",      "XWatch", FL_INT,    &fontsize,           "2",   0 },
    { "fontstyle",     "XWatch", FL_INT,    &fontstyle,          "0",   0 },
    { "firstwarnings", "XWatch", FL_INT,    &firstwarnings,      "1",   0 },
    { "printversion",  "XWatch", FL_INT,    &printversion,	 "1",   0 },
    { "gag",           "XWatch", FL_STRING, gagbuffer,           "", 1023 },
    { "title",         "XWatch", FL_STRING, titlebuffer,         "",  127 },
    { "colorstring",   "XWatch", FL_STRING, colorstring,         "", 1023 },
    { "geometry",      "XWatch", FL_STRING, geometry,  "550x70+0+0",   79 },
    { "ignore",        "XWatch", FL_STRING, ignorestring,        "", 1023 },
    { "foreground",    "XWatch", FL_STRING, fgstring,       "black",   79 },
    { "background",    "XWatch", FL_STRING, bgstring,       "white",   79 },
};
