/***************************************************************
 * Name:      wxEDID.h
 * Purpose:   Defines Application Frame
 * Author:    Tomasz Pawlak (tomasz.pawlak@wp.eu)
 * Copyright: Tomasz Pawlak (C) 2014-2024
 * License:   GPLv3+
 **************************************************************/

#ifndef wxEDIDMAIN_H
#define wxEDIDMAIN_H 1

#ifndef _RCD_AUTOGEN
   #include "config.h"
#else
   #define VERSION "1"
#endif

// REMARK: code sections: //(* ... //*) are generated by wxSmith.
//         Do not change the code.

//(*Headers(wxEDID_Frame)
#include <wx/aui/aui.h>
#include <wx/frame.h>
#include <wx/grid.h>
#include <wx/menu.h>
#include <wx/panel.h>
#include <wx/sizer.h>
#include <wx/spinctrl.h>
#include <wx/stattext.h>
#include <wx/statusbr.h>
#include <wx/textctrl.h>
#include <wx/treectrl.h>
//*)

#include "rcode/rcode.h"
#include "EDID_class.h"
#include "CEA_ET_class.h"
#include "guilog.h"

#include <wx/dialog.h>
#include <wx/menu.h>
#include <wx/dcclient.h>
#include <wx/bitmap.h>
#include <wx/artprov.h>

//config
typedef struct {
   bool     b_dtd_keep_aspect;
   bool     b_blk_name_dynamic;
   bool     b_dta_grid_details;
   bool     b_have_last_fpath;
   bool     b_cmd_bin_file;
   bool     b_cmd_txt_file;
   bool     b_cmd_ignore_err;
   bool     b_cmd_ignore_rd;
   bool     b_have_layout;
   wxString cmd_open_file_path;
   wxString last_used_fpath;
   wxString last_used_fname;
   wxString aui_layout;
   wxPoint  win_pos;
   wxSize   win_size;
} config_t;

class blktree_cl;
class fgrid_cl;
class dtd_sct_cl;
class dtd_screen_cl;

enum { //cell column idx'es for BlkDataGrid
   DATGR_COL_NAME   = 0,
   DATGR_COL_TYPE   = 1,
   DATGR_COL_VAL    = 2,
   DATGR_COL_UNIT   = 3,
   DATGR_COL_FLG    = 4,

   DATGR_COL_OFFS   = 5,
   DATGR_COL_SHIFT  = 6,
   DATGR_COL_FSZ    = 7,

   DATGR_NCOL_1    = 5,
   DATGR_NCOL_2    = 8,
   DATGR_NCOL_DIFF = 3
};

enum { //status bar field idx
   SBAR_LOG     = 0,
   SBAR_GRPOFFS = 1
};

enum { //evt client data for blktree_cl::evt_Lmouse_down()
   BLKTR_RESEL_EVT = 0xF0
};

typedef union main_flags_u {
   u32_t u32;
   struct {
      uint ctrl_enabled : 1;
      uint data_loaded  : 1;
      uint grid_blk_ok  : 1;
      uint grp_refresh  : 1;
      uint res          :28;
   } bits;
} mflags_t;

typedef union op_flags_u {
   u32_t u32;
   struct {
      uint CanCopy     : 1;
      uint CanPaste    : 1;
      uint CanCut      : 1;
      uint CanDelete   : 1;
      uint CanInsertUp : 1;
      uint CanInsInto  : 1;
      uint CanInsertDn : 1;
      uint CanMoveUp   : 1;
      uint CanMoveDn   : 1;
      uint CanReparse  : 1;
      uint res         :22;
   } bits;
} op_flags_t;

class wxEDID_Frame: public wxFrame {
    friend class dtd_screen_cl;

    public:
        rcode OpenEDID();
        rcode SaveEDID();
        rcode SaveRep_SubGrps(edi_grp_cl *pgrp, wxString& reps);
        rcode SaveReport();
        rcode ExportEDID_hex();
        rcode ImportEDID_hex();
        rcode AssembleEDID_main();

        rcode CreateBlockTree();
        rcode UpdateDataGrid(edi_grp_cl* edigrp);
        void  DataGrid_ChangeView();
        rcode UpdateDataGridRow(int nrow, edi_dynfld_t *field);

        void  DTD_Ctor_Layout();
        rcode DTD_Ctor_Recalc();
        rcode DTD_Ctor_read_field(dtd_sct_cl* sct, const edi_grp_cl* group, u32_t idx_field);
        rcode DTD_Ctor_set_DTD();
        rcode DTD_Ctor_ModeLine();
        rcode DTD_Ctor_WriteInt(dtd_sct_cl& sct);

        rcode SetFieldDesc(int row);
        rcode WriteField();

        rcode VerifyChksum(uint block);
        rcode CalcVerifyChksum(uint block);
        rcode Reparse();

        void  AppLayout();
        void  ClearAll(bool b_clrBlocks = true);
        void  EnableControl(bool enb);
        void  SetOpFlags();
        void  AutoSelectBED();
        void  DataGridSetColors();
        void  GetFullGroupName(edi_grp_cl* pgrp, wxString& grp_name);
        void  LogGroupOP(edi_grp_cl* pgrp, const wxString& opName);
        void  InitBlkTreeMenu();

        wxTreeItemId  BlkTreeInsGrp(wxTreeItemId trItemID, edi_grp_cl* pgrp, u32_t idx);
                void  BlkTreeDelGrp(edi_grp_cl* pgrp, bool del_subg);
                void  BlkTreeUpdateGrp();
                void  BlkTreeUpdateGrpName();
                void  BlkTreeSwitchDynamicNames();
                rcode BlkTreeChangeGrpType(bool dbc_type);

        wxEDID_Frame(wxWindow* parent, wxWindowID id = -1);
       ~wxEDID_Frame();

        guilog_cl     GLog;
        bool          b_cmdln_have_file;

    private:
        //grid colors for marking data types:
        wxColour      grid_color_bit;
        wxColour      grid_color_float;
        wxColour      grid_color_hex;
        wxColour      grid_bg_color;
        wxColour      grid_fg_color;

        wxBitmap      bmpUp;
        wxBitmap      bmpIn;
        wxBitmap      bmpDn;
        wxBitmap      bmpNOK;

        wxMenu       *mnu_BlkTree;
        wxMenu       *mnu_SubInfo;
        wxMenuItem   *miInfoOK;
        wxMenuItem   *miInfoNOK;
        wxMenuItem   *miRemoved;
        wxMenuItem   *miSubInfo;

        wxAcceleratorEntry *accDelete;
        wxAcceleratorEntry *accMoveUp;
        wxAcceleratorEntry *accMoveDn;

        mflags_t      flags;

        EDID_cl       EDID;
        wxString      tmps;
        wxString      sval;
        wxString      edid_file_name;

        wxTreeItemId  BT_Root;
        wxTreeItemId  BT_Item_sel;
        wxTreeItemId  BT_Iparent;

        edi_grp_cl*   CopyGroup(edi_grp_cl* pgrp);
        edi_grp_cl   *edigrp_sel;
        edi_grp_cl   *edigrp_src; //EDID group to be cloned on paste/insert
        int           subg_idx;   //index of selected subgroup: restore selection after reparse/re-init
        op_flags_t    opFlags;

        int           row_sel;
        int           row_op;

        bool          b_dta_grid_details;
        bool          b_dtd_keep_aspect;
        int           dtd_Htotal; //for DTD aspect ratio calculations, updated by evt_dtdctor_sct()
        int           dtd_Vtotal;
        int           dtd_pclk_factor; //DTD: 10K or T7VTDB: 1KHz

        /* empty wxSmith section: no handlers defined in wxSmith project */
        //(*Handlers(wxEDID_Frame)
        //*)

        void evt_sys_color_chg  (wxSysColourChangedEvent &evt);
        void evt_ntbook_page    (wxAuiNotebookEvent      &evt);

        void evt_open_edid_bin  (wxCommandEvent &evt);
        void evt_save_edid_bin  (wxCommandEvent &evt);
        void evt_save_report    (wxCommandEvent &evt);
        void evt_export_hex     (wxCommandEvent &evt);
        void evt_import_hex     (wxCommandEvent &evt);

        void evt_Deferred       (wxCommandEvent &evt);
        void evt_Quit           (wxCommandEvent &evt);
        void evt_About          (wxCommandEvent &evt);

        void evt_Flags          (wxCommandEvent &evt);
        void evt_frame_size     (wxSizeEvent    &evt);

        void evt_ignore_rd      (wxCommandEvent &evt);
        void evt_ignore_err     (wxCommandEvent &evt);
        void evt_reparse        (wxCommandEvent &evt);
        void evt_assemble_edid  (wxCommandEvent &evt);
        void evt_log_win        (wxCommandEvent &evt);
        void evt_dtd_asp        (wxCommandEvent &evt);
        void evt_blk_fdetails   (wxCommandEvent &evt);
        void evt_dyn_blk_names  (wxCommandEvent &evt);

        void evt_dgrid_select   (wxGridEvent    &evt);
        void evt_dgrid_vsel     (wxGridEvent    &evt); //show value selector menu
        void evt_dgrid_edit_hide(wxGridEvent    &evt);
        void evt_dgrid_write    (wxGridEvent    &evt);
        void evt_dtdctor_sct    (wxSpinEvent    &evt);

        void evt_blktr_sel      (wxTreeEvent    &evt);
        void evt_blktr_rmb      (wxTreeEvent    &evt);
        void evt_blktr_key      (wxTreeEvent    &evt);
        void evt_blktr_focus    (wxFocusEvent   &evt) {evt.Skip(false);};
        void evt_blktr_reparse  (wxCommandEvent &evt);
        void evt_blktr_copy     (wxCommandEvent &evt);
        void evt_blktr_paste    (wxCommandEvent &evt);
        void evt_blktr_cut      (wxCommandEvent &evt);
        void evt_blktr_delete   (wxCommandEvent &evt);
        void evt_blktr_insert   (wxCommandEvent &evt);
        void evt_blktr_move     (wxCommandEvent &evt);

        /* code generated by wxSmith */
        //(*Identifiers(wxEDID_Frame)
        static const wxWindowID id_block_tree;
        static const wxWindowID id_grid_blkdat;
        static const wxWindowID id_txc_edid_info;
        static const wxWindowID id_panel_edid;
        static const wxWindowID ID_STATICTEXT5;
        static const wxWindowID ID_STATICTEXT6;
        static const wxWindowID id_sct_pixclk;
        static const wxWindowID id_sct_pclk_factor;
        static const wxWindowID id_txc_vrefresh;
        static const wxWindowID ID_STATICTEXT2;
        static const wxWindowID id_sct_desc_type;
        static const wxWindowID id_dtd_screen;
        static const wxWindowID ID_STATICTEXT12;
        static const wxWindowID id_sct_xres;
        static const wxWindowID ID_STATICTEXT11;
        static const wxWindowID id_txres;
        static const wxWindowID ID_STATICTEXT33;
        static const wxWindowID id_txt_hborder;
        static const wxWindowID id_sct_hborder;
        static const wxWindowID id_txt_hbpix;
        static const wxWindowID ID_STATICTEXT7;
        static const wxWindowID id_sct_hblank;
        static const wxWindowID ID_STATICTEXT3;
        static const wxWindowID id_txc_thblank;
        static const wxWindowID ID_STATICTEXT29;
        static const wxWindowID ID_STATICTEXT8;
        static const wxWindowID id_sct_hsoffs;
        static const wxWindowID ID_STATICTEXT4;
        static const wxWindowID id_txc_thsoffs;
        static const wxWindowID ID_STATICTEXT30;
        static const wxWindowID ID_STATICTEXT9;
        static const wxWindowID id_sct_hswidth;
        static const wxWindowID ID_STATICTEXT10;
        static const wxWindowID id_thswidth;
        static const wxWindowID ID_STATICTEXT31;
        static const wxWindowID ID_STATICTEXT27;
        static const wxWindowID id_txc_htotal;
        static const wxWindowID ID_STATICTEXT32;
        static const wxWindowID id_txc_thtotal;
        static const wxWindowID ID_STATICTEXT28;
        static const wxWindowID ID_STATICTEXT25;
        static const wxWindowID id_txc_hfreq;
        static const wxWindowID ID_STATICTEXT26;
        static const wxWindowID ID_STATICTEXT15;
        static const wxWindowID id_sct_vres;
        static const wxWindowID ID_STATICTEXT16;
        static const wxWindowID id_txc_tvres;
        static const wxWindowID ID_STATICTEXT34;
        static const wxWindowID id_txt_vborder;
        static const wxWindowID id_sct_vborder;
        static const wxWindowID id_txt_vb_lines;
        static const wxWindowID ID_STATICTEXT19;
        static const wxWindowID id_sct_vblank;
        static const wxWindowID ID_STATICTEXT20;
        static const wxWindowID id_txc_tvblank;
        static const wxWindowID ID_STATICTEXT35;
        static const wxWindowID ID_STATICTEXT21;
        static const wxWindowID id_sct_vsoffs;
        static const wxWindowID ID_STATICTEXT22;
        static const wxWindowID id_txc_tvsoffs;
        static const wxWindowID ID_STATICTEXT36;
        static const wxWindowID ID_STATICTEXT23;
        static const wxWindowID id_sct_vswidth;
        static const wxWindowID ID_STATICTEXT24;
        static const wxWindowID id_txc_vswidth;
        static const wxWindowID ID_STATICTEXT37;
        static const wxWindowID ID_STATICTEXT38;
        static const wxWindowID id_txc_vtotal;
        static const wxWindowID ID_STATICTEXT39;
        static const wxWindowID id_txc_tvtotal;
        static const wxWindowID ID_STATICTEXT40;
        static const wxWindowID ID_STATICTEXT41;
        static const wxWindowID id_txc_modeline;
        static const wxWindowID id_panel_dtd;
        static const wxWindowID id_ntbook;
        static const wxWindowID id_mnu_imphex;
        static const wxWindowID id_mnu_exphex;
        static const wxWindowID id_mnu_parse;
        static const wxWindowID id_mnu_asmchg;
        static const wxWindowID id_mnu_ignerr;
        static const wxWindowID id_mnu_allwr;
        static const wxWindowID id_mnu_dtd_asp;
        static const wxWindowID id_mnu_fdetails;
        static const wxWindowID id_mnu_dbn;
        static const wxWindowID id_mnu_logw;
        static const wxWindowID id_mnu_flags;
        static const wxWindowID id_win_stat_bar;
        //*)
        static const long id_app_layout;
        static const long id_mnu_info;
        static const long id_mnu_ins_up;
        static const long id_mnu_ins_dn;
        static const long id_mnu_ins_in;

        /* code generated by wxSmith */
        //(*Declarations(wxEDID_Frame)
        blktree_cl* BlockTree;
        dtd_screen_cl* dtd_screen;
        dtd_sct_cl* sct_hblank;
        dtd_sct_cl* sct_hborder;
        dtd_sct_cl* sct_hsoffs;
        dtd_sct_cl* sct_hswidth;
        dtd_sct_cl* sct_pixclk;
        dtd_sct_cl* sct_vblank;
        dtd_sct_cl* sct_vborder;
        dtd_sct_cl* sct_vres;
        dtd_sct_cl* sct_vsoffs;
        dtd_sct_cl* sct_vswidth;
        dtd_sct_cl* sct_xres;
        fgrid_cl* BlkDataGrid;
        wxAuiManager* AuiMgrEDID;
        wxAuiManager* AuiMgrMain;
        wxAuiNotebook* ntbook;
        wxBoxSizer* bs_dtd_main;
        wxFlexGridSizer* fgs_dtd;
        wxFlexGridSizer* fgs_dtd_bottom;
        wxFlexGridSizer* fgs_dtd_right;
        wxFlexGridSizer* fgs_dtd_top;
        wxMenu* Menu3;
        wxMenuItem* MenuItem1;
        wxMenuItem* mnu_allwritable;
        wxMenuItem* mnu_assemble;
        wxMenuItem* mnu_dbn;
        wxMenuItem* mnu_dtd_aspect;
        wxMenuItem* mnu_exphex;
        wxMenuItem* mnu_fdetails;
        wxMenuItem* mnu_ignore_err;
        wxMenuItem* mnu_imphex;
        wxMenuItem* mnu_logw;
        wxMenuItem* mnu_open_edi;
        wxMenuItem* mnu_reparse;
        wxMenuItem* mnu_save_edi;
        wxMenuItem* mnu_save_text;
        wxPanel* dtd_panel;
        wxPanel* edid_panel;
        wxStaticText* StaticText10;
        wxStaticText* StaticText11;
        wxStaticText* StaticText12;
        wxStaticText* StaticText15;
        wxStaticText* StaticText16;
        wxStaticText* StaticText19;
        wxStaticText* StaticText20;
        wxStaticText* StaticText21;
        wxStaticText* StaticText22;
        wxStaticText* StaticText23;
        wxStaticText* StaticText24;
        wxStaticText* StaticText25;
        wxStaticText* StaticText26;
        wxStaticText* StaticText27;
        wxStaticText* StaticText28;
        wxStaticText* StaticText29;
        wxStaticText* StaticText2;
        wxStaticText* StaticText30;
        wxStaticText* StaticText31;
        wxStaticText* StaticText32;
        wxStaticText* StaticText33;
        wxStaticText* StaticText34;
        wxStaticText* StaticText35;
        wxStaticText* StaticText36;
        wxStaticText* StaticText37;
        wxStaticText* StaticText38;
        wxStaticText* StaticText39;
        wxStaticText* StaticText3;
        wxStaticText* StaticText40;
        wxStaticText* StaticText41;
        wxStaticText* StaticText4;
        wxStaticText* StaticText5;
        wxStaticText* StaticText6;
        wxStaticText* StaticText7;
        wxStaticText* StaticText8;
        wxStaticText* StaticText9;
        wxStaticText* sct_desc_type;
        wxStaticText* sct_pclk_factor;
        wxStaticText* txt_hborder;
        wxStaticText* txt_hbpix;
        wxStaticText* txt_vb_lines;
        wxStaticText* txt_vborder;
        wxStatusBar* win_stat_bar;
        wxTextCtrl* txc_edid_info;
        wxTextCtrl* txc_hfreq;
        wxTextCtrl* txc_htotal;
        wxTextCtrl* txc_modeline;
        wxTextCtrl* txc_thblank;
        wxTextCtrl* txc_thsoffs;
        wxTextCtrl* txc_thswidth;
        wxTextCtrl* txc_thtotal;
        wxTextCtrl* txc_tvblank;
        wxTextCtrl* txc_tvres;
        wxTextCtrl* txc_tvsoffs;
        wxTextCtrl* txc_tvswidth;
        wxTextCtrl* txc_tvtotal;
        wxTextCtrl* txc_txres;
        wxTextCtrl* txc_vrefresh;
        wxTextCtrl* txc_vtotal;
        //*)

        wxDECLARE_EVENT_TABLE();
};

class blktree_cl : public wxTreeCtrl {
   private:
      wxDECLARE_EVENT_TABLE();

      int   keycode;

      void  evt_key         (wxKeyEvent   &evt);
      void  evt_Lmouse_down(wxMouseEvent &evt);
      void  evt_Lmouse_dclick(wxMouseEvent &evt);

   public:
      bool  b_key_block;

   blktree_cl(wxWindow *parent, wxWindowID id=wxID_ANY,
              const wxPoint &pos=wxDefaultPosition,
              const wxSize &size=wxDefaultSize,
              long style=wxTR_DEFAULT_STYLE,
              const wxValidator &validator=wxDefaultValidator,
              const wxString &name=wxTreeCtrlNameStr) :
              wxTreeCtrl(parent, id, pos, size, style, validator, name),
              keycode(0), b_key_block(false)
              {};
};

class fgrid_cl : public wxGrid {
   private:
      wxDECLARE_EVENT_TABLE();

      const edi_field_t* evt_field;

      wxString      tmps;
      wxEDID_Frame *pwin;

   public:
      inline void SetParentFrame (wxEDID_Frame *pW) {pwin = pW;};

      inline void SetMenuEvtField(edi_field_t* p_field) {evt_field = p_field;};

      void evt_dgrid_vmnu(wxCommandEvent& event);

   fgrid_cl(wxWindow* parentW, wxWindowID id = wxID_ANY,
            const wxPoint& pos = wxDefaultPosition,
            const wxSize& size = wxDefaultSize,
            long style = wxWANTS_CHARS,
            const wxString& name = wxPanelNameStr) :
            wxGrid(parentW, id, pos, size, style, name) {evt_field = NULL;};
};

class dtd_screen_cl : public wxPanel {
   private:
      wxDECLARE_EVENT_TABLE();

      wxColour cScrArea, cHsync, cVsync, cSandC, cResStr;
      wxRect   rcHsync, rcVsync, rcScreen;
      wxSize   szHborder, szVborder;
      wxString tmps;

      wxEDID_Frame *pwin;

      void    scr_aspect_ratio(wxSize& dcsize, wxPaintDC& dc);
      rcode   calc_coords     (wxSize& dcsize);
      void    scr_area_str    (wxPaintDC& dc);
      void    evt_paint       (wxPaintEvent& event);

   public:
      inline void SetParentFrame  (wxEDID_Frame *pW) {pwin = pW;};

   dtd_screen_cl(wxWindow* parentW, wxWindowID id = wxID_ANY,
                 const wxPoint& pos = wxDefaultPosition,
                 const wxSize& size = wxDefaultSize,
                 long style = wxTAB_TRAVERSAL, const wxString& name = "dtd") :
                 wxPanel(parentW, id, pos, size, style, name)
            {
               pwin      = dynamic_cast <wxEDID_Frame*> (parentW);

               cScrArea  = wxColour(0x88, 0x88, 0xFF);
               cHsync    = wxColour(0x77, 0x77, 0x99);
               cVsync    = wxColour(0xCC, 0xDD, 0x20);
               cSandC    = wxColour(0xFF, 0xFF, 0xFF);
               cResStr   = wxColour(0xFF, 0xFF, 0xFF);

               rcHsync   = wxRect(0,0,0,0);
               rcVsync   = rcHsync;
               rcScreen  = rcHsync;

            };
};

class dtd_sct_cl : public wxSpinCtrl {
   public:
      edi_dynfld_t *field;
      int           data;

   dtd_sct_cl(wxWindow* parent, wxWindowID id = -1, const wxString& value = wxEmptyString,
              const wxPoint& pos = wxDefaultPosition, const wxSize& size = wxDefaultSize,
              long style = wxSP_ARROW_KEYS, int min = 0, int max = 1000, int initial = 0,
              const wxString& name = "wxSpinCtrl") :
              wxSpinCtrl(parent, id, value, pos, size, style, min, max, initial, name),
              field(NULL), data(0)
            {};
};

class dlg : public wxDialog {
   private:
    //the events are currently useless
    //wxDECLARE_EVENT_TABLE();

    //void  evt_close(wxCloseEvent   &evt);
    //void  evt_ok   (wxCommandEvent &evt);

      dlg  (wxWindow* parent, const wxArtID& id_icon,
            const wxString& caption, const wxString& msg);

   public:

      static int MessageBox(wxWindow* parent, const wxString& msg,
                            const wxString& caption, const wxArtID& id_icon);
};


#endif // wxEDIDMAIN_H
