target=distptplan1 distptplan2 distplan3

#if #TARGET(distptplan1)
\title{Distance d'un point  un plan 1}
#endif
#if #TARGET(distptplan2)
\title{Distance d'un point  un plan 2}
#endif
#if #TARGET(distplan3)
\title{Distance entre deux plans parallles}
#endif
\author{Rgine Mangeard}
\email{regine@mangeard.fr}
\format{html}
\precision{1000}

\matrix{V=slib(matrix/invertible 3,3)}
\matrix{u=\V[1;]}
\matrix{v=\V[2;]}
\matrix{w=\V[3;]}

\integer{ux=\V[1;1]}
\integer{uy=\V[1;2]}
\integer{uz=\V[1;3]}
\integer{vx=\V[2;1]}
\integer{vy=\V[2;2]}
\integer{vz=\V[2;3]}
\integer{wx=\V[3;1]}
\integer{wy=\V[3;2]}
\integer{wz=\V[3;3]}
\integer{xa=randint(-9..9)}
\integer{ya=randint(-9..9)}
\integer{za=randint(-9..9)}

## equation paramtrique de P(A,u,v)
\text{eqx=simplify(\xa+\ux*t+\vx*s)}
\text{eqy=simplify(\ya+\uy*t+\vy*s)}
\text{eqz=simplify(\za+\uz*t+\vz*s)}

## equation du plan (A,u,v)
\integer{nx=\uy*\vz-\uz*\vy}
\integer{ny=\uz*\vx-\ux*\vz}
\integer{nz=\ux*\vy-\uy*\vx}
\integer{d1=\xa*\nx+\ya*\ny+\za*\nz}
\text{eqpl1=texmath(simplify(\nx*x+\ny*y+\nz*z-\d1)=0)}

\integer{d2=\d1+randint(5..20)*randint(1,-1)}
\text{eqpl2=texmath(simplify(\nx*x+\ny*y+\nz*z-\d2)=0)}


\text{txtsol=}
\text{eqxx=texmath(\eqx)}
\text{eqyy=texmath(\eqy)}
\text{eqzz=texmath(\eqz)}

## coordonnes du point B
\integer{xb=randint(-9..9)}
\integer{yb=randint(-9..9)}
\integer{zb=randint(-9..9)}
#if #TARGET(distplan3)
\if{\nx=0}
   {
   \if{\ny=0}
     {
     \integer{xb=0}
     \integer{yb=0}
     \rational{zb=\d2 / \nz}
     }
     {
     \integer{xb=0}
     \integer{zb=0}
     \rational{yb=\d2 / \ny}
     }
   }
   {
    \integer{yb=0}
    \integer{zb=0}
    \rational{xb=\d2 / \nx}
   }
#endif

## distance de P au plan
\real{dist=pari(abs(\nx*\xb + \ny*\yb + \nz*\zb -\d1) /sqrt((\nx)^2+(\ny)^2+(\nz)^2))}

#if #TARGET(distptplan1)
\statement{<p>
On considre un plan \((P)) dfini par un systme d'quations paramtriques de variable \(t) et \(s):

<center>
<center>
x=\(\eqxx)<br>
y=\(\eqyy)<br>
z=\(\eqzz)<br>
</center>
</center>
Calculer la distance du point \(B(\xb,\yb,\zb)) au plan \((P))
<br>
<center>distance=\embed{reply1,7}</center>

}
\answer{distance}{\dist}{type=numeric}
\hint{Il faut d'abord tablir une quation cartsienne de \((P))}
#endif
#if #TARGET(distptplan2)
\statement{<p>
On considre un plan \((P)) dfini par l'quation cartsienne:
<center>
\( \eqpl1).
<p>
Calculer la distance du point \(B(\xb,\yb,\zb)) au plan \((P))
<br>
<center>distance=\embed{reply1,7}</center>

}
\answer{distance}{\dist}{type=numeric}
#endif
#if #TARGET(distplan3)
\statement{<p>
On considre un plan \((P)) dfini par l'quation cartsienne:
<center>
\( \eqpl1).
</center>
et un plan parallle \((Q)) dfini par l'quation cartsienne:
<center>
\( \eqpl2).
</center>
Calculer la distance du plan \((P)) au plan \((Q))
<br>
<center>distance=\embed{reply1,7}</center>

}
\answer{distance}{\dist}{type=numeric}
\hint{ Soit un point \(A) de \((P)). La distance de \(A)  \((Q)) est constante quel que soit ce point \(A).}

#endif
