/* powerpc64le-linux.elf-entry.h
   created from powerpc64le-linux.elf-entry.bin, 10907 (0x2a9b) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2017 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2017 Laszlo Molnar
   Copyright (C) 2000-2017 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */


#define STUB_POWERPC64LE_LINUX_ELF_ENTRY_SIZE    10907
#define STUB_POWERPC64LE_LINUX_ELF_ENTRY_ADLER32 0xce11351c
#define STUB_POWERPC64LE_LINUX_ELF_ENTRY_CRC32   0x02d43381

unsigned char stub_powerpc64le_linux_elf_entry[10907] = {
/* 0x0000 */ 127, 69, 76, 70,  2,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0, 21,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */   0,  0,  0,  0,  0,  0,  0,  0,240, 32,  0,  0,  0,  0,  0,  0,
/* 0x0030 */   0,  0,  0,  0, 64,  0,  0,  0,  0,  0, 64,  0,  0,  0,  0,  0,
/* 0x0040 */   1,  0,  0, 72,236, 41,  0,124,166,  2,168,125,  8,  0,  7, 40,
/* 0x0050 */  92,  1,130, 64,  0,  0,166,248, 20, 26,132,124,  0,128,  0, 60,
/* 0x0060 */ 198,  7,  0,120,  0,128, 32, 61,198,  7, 41,121,255,255, 99, 56,
/* 0x0070 */ 255,255,165, 56,255,255, 64, 57, 36,  1,  0, 72,  1,  0, 32, 57,
/* 0x0080 */  46, 24, 41,125,  4,  0, 99, 56,198,  7, 41,121, 64,  0, 41,124,
/* 0x0090 */  20, 72, 41,125,  1,  0,128, 57,198,  7,140,121,120, 99, 41,125,
/* 0x00a0 */  32,  0,128, 78,  1,  0,  3,141,  1,  0,  5,157, 64,  0, 41,124,
/* 0x00b0 */  20, 74, 41,125,201,255,194, 65,236,255,225, 65,  1,  0,224, 56,
/* 0x00c0 */  20,  0,  0, 72,255,255,231, 56, 21, 72, 41,125,177,255,194, 65,
/* 0x00d0 */  20, 57,231,124, 21, 72, 41,125,165,255,194, 65, 20, 57,231,124,
/* 0x00e0 */  64,  0, 41,124, 20, 74, 41,125,149,255,194, 65,216,255,192, 65,
/* 0x00f0 */   0,  0,  0, 57,253,255,231, 52, 46, 64,231, 84,255,255,128, 57,
/* 0x0100 */ 198,  7,140,121,120, 99,231,124, 32,  0,192, 65,  1,  0, 67,140,
/* 0x0110 */ 249, 16,234,124,112, 14, 74,125,  0,  0,194, 65,  1,  0, 66,112,
/* 0x0120 */  80,  0,226, 65, 20,  0,  0, 72, 64,  0, 41,124, 20, 74, 41,125,
/* 0x0130 */  77,255,194, 65, 60,  0,225, 65,  1,  0,  0, 57, 64,  0, 41,124,
/* 0x0140 */  20, 74, 41,125, 57,255,194, 65, 40,  0,225, 65, 21, 72, 41,125,
/* 0x0150 */  45,255,194, 65, 20, 65,  8,125, 64,  0, 41,124, 20, 74, 41,125,
/* 0x0160 */  29,255,194, 65,232,255,192, 65,  2,  0,  8, 57, 16,  0,  0, 72,
/* 0x0170 */  21, 72, 41,125,  9,255,194, 65, 20, 65,  8,125,255,250,234, 32,
/* 0x0180 */   2,  0,  8, 57,148,  1,  8,125, 20, 42,234,124,166,  3,  9,125,
/* 0x0190 */   1,  0,  7,141,  1,  0,  5,157,248,255, 32, 67,  0,  1,224, 56,
/* 0x01a0 */ 236, 41,  7,124, 44, 26,  7,124,  4,255,255, 75,236, 41,  0,124,
/* 0x01b0 */ 166,  2,168,125,  5,  0,  7, 40, 56,  1,130, 64,  0,  0,166,248,
/* 0x01c0 */  20, 26,132,124,  0,128,  0, 60,198,  7,  0,120,  0,128, 32, 61,
/* 0x01d0 */ 198,  7, 41,121,255,255, 99, 56,255,255,165, 56,255,255, 64, 57,
/* 0x01e0 */   0,  1,  0, 72,  1,  0, 32, 57, 46, 24, 41,125,  4,  0, 99, 56,
/* 0x01f0 */ 198,  7, 41,121, 64,  0, 41,124, 20, 72, 41,125,  1,  0,128, 57,
/* 0x0200 */ 198,  7,140,121,120, 99, 41,125, 32,  0,128, 78,  1,  0,  3,141,
/* 0x0210 */   1,  0,  5,157, 64,  0, 41,124, 20, 74, 41,125,201,255,194, 65,
/* 0x0220 */ 236,255,225, 65,  1,  0,224, 56, 20,  0,  0, 72,255,255,231, 56,
/* 0x0230 */  21, 72, 41,125,177,255,194, 65, 21, 57,231,124, 21, 72, 41,125,
/* 0x0240 */ 165,255,194, 65, 21, 57,231,124, 64,  0, 41,124, 20, 74, 41,125,
/* 0x0250 */ 149,255,194, 65,216,255,192, 65,  0,  0,  0, 57,253,255,231, 52,
/* 0x0260 */  46, 64,231, 84, 28,  0,192, 65,  1,  0, 67,140,249, 16,234,124,
/* 0x0270 */ 112, 14, 74,125,  0,  0, 42, 44,  0,  0,194, 65, 12,  0,  0, 72,
/* 0x0280 */  21, 72, 41,125, 97,255,194, 65, 21, 65,  8,125, 21, 72, 41,125,
/* 0x0290 */  85,255,194, 65, 21, 65,  8,125, 40,  0,130, 64,  1,  0,  0, 57,
/* 0x02a0 */  21, 72, 41,125, 65,255,194, 65, 21, 65,  8,125, 64,  0, 41,124,
/* 0x02b0 */  20, 74, 41,125, 49,255,194, 65,232,255,192, 65,  2,  0,  8, 57,
/* 0x02c0 */ 255,250,234, 32,  1,  0,  8, 57,148,  1,  8,125, 20, 42,234,124,
/* 0x02d0 */ 166,  3,  9,125,  1,  0,  7,141,  1,  0,  5,157,248,255, 32, 67,
/* 0x02e0 */   0,  1,224, 56,236, 41,  7,124, 44, 26,  7,124, 40,255,255, 75,
/* 0x02f0 */ 236, 41,  0,124,166,  2,168,125,  2,  0,  7, 40, 12,  1,130, 64,
/* 0x0300 */   0,  0,166,248, 20, 26,132,124,  0,128,  0, 60,198,  7,  0,120,
/* 0x0310 */   0,128, 32, 61,198,  7, 41,121,255,255, 99, 56,255,255,165, 56,
/* 0x0320 */ 255,255, 64, 57,212,  0,  0, 72, 64,  0, 41,124, 20, 72, 41,125,
/* 0x0330 */  32,  0,226, 76,  0,  0,128, 57, 20, 97,140,125,198,  7,140,121,
/* 0x0340 */   1,  0, 32, 57, 46, 24, 41,125,  4,  0, 99, 56,198,  7, 41,121,
/* 0x0350 */  64,  0, 41,124, 20, 72, 41,125, 20, 98, 41,125, 32,  0,128, 78,
/* 0x0360 */   1,  0,  3,141,  1,  0,  5,157,193,255,255, 75,244,255,225, 65,
/* 0x0370 */   1,  0,224, 56,181,255,255, 75, 21, 57,231,124,173,255,255, 75,
/* 0x0380 */ 244,255,192, 65,253,255,231, 52,  0,  0,  0, 57, 32,  0,192, 65,
/* 0x0390 */  46, 64,231, 84,  1,  0, 67,140,249, 16,234,124,255,255,128, 57,
/* 0x03a0 */ 198,  7,140,121,  0, 96, 42,124,  0,  0,194, 65,125,255,255, 75,
/* 0x03b0 */  21, 65,  8,125,117,255,255, 75, 21, 65,  8,125,  1,  0,224, 56,
/* 0x03c0 */  28,  0,194, 64,  3,  0,224, 56,  1,  0,  0, 57, 93,255,255, 75,
/* 0x03d0 */  21, 65,  8,125, 85,255,255, 75,244,255,192, 65,255,242, 74, 32,
/* 0x03e0 */  20, 57,  8,125, 20, 42,234,124,166,  3,  9,125,  1,  0,  7,141,
/* 0x03f0 */   1,  0,  5,157,248,255, 32, 67,  0,  1,224, 56,236, 41,  7,124,
/* 0x0400 */  44, 26,  7,124,100,255,255, 75, 14,  0,  7, 40,  0,  0,130, 64,
/* 0x0410 */ 209,255, 33,248,166,  2,  8,124,120, 51,201,124,  0,  0,  6,129,
/* 0x0420 */ 120, 43,167,124,254,255,164, 56,  2,  0,131, 56, 16,  0,  1,248,
/* 0x0430 */   0,  0,  3,136,194,232, 11,120, 96,  7,  2,120,  0,250, 96, 56,
/* 0x0440 */  54, 88, 99,124,100,241, 99, 56,120, 11, 38,124, 20, 26, 33,124,
/* 0x0450 */ 164,  6, 33,120,  0,  0,  0, 56,120, 51,195,124,  0,  0,  9,248,
/* 0x0460 */ 249,255,  3,248, 64, 24, 33,124,248,255,128, 65,  0,  0,193,248,
/* 0x0470 */ 255,255,  4,136, 32,  0,193, 56, 40,  0, 97, 56, 16,  0,225,248,
/* 0x0480 */  24,  0, 33,249,  2,225, 11,120, 32,  7,  0,120,  2,  0, 67,152,
/* 0x0490 */   1,  0, 99,153,  0,  0,  3,152,209,255, 33,248,166,  2,  8,124,
/* 0x04a0 */   1,  0, 64, 57,  1,  0,  0, 72,  2,  0, 99,137,  4,  0, 99, 59,
/* 0x04b0 */  48, 88, 75,125,255,255,107, 57, 32,  0,107,121, 96,255, 97,249,
/* 0x04c0 */   1,  0, 99,137,  2,  0,227, 59, 48, 88, 74,125,255,255, 74, 57,
/* 0x04d0 */   0,  0, 96, 57, 32,  0, 74,121,166,  3, 72,125,  0,  0, 67,137,
/* 0x04e0 */   0,  0,102,145,  0,  0,105,145,180,  7, 84,125,  1,  0, 99,137,
/* 0x04f0 */   0,  4,  0, 56, 20, 82, 75,125,  0,  3, 96, 57, 48, 80,106,125,
/* 0x0500 */  54,  7, 74, 57, 32,  0, 74,121,  0,  0,138, 47,  1,  0,106, 57,
/* 0x0510 */   8,  0,190, 64,  1,  0, 96, 57,255,255,107, 53, 12,  0,130, 65,
/* 0x0520 */   2,  0, 31,180,244,255,255, 75,  5,  0,  0, 56,166,  3,  9,124,
/* 0x0530 */  20, 42,164,124,  5,  0,100, 57,120, 35,159,124,  0,  0, 64, 57,
/* 0x0540 */  64, 40,191,127, 12,  0,190, 64,  1,  0, 96, 56, 88, 10,  0, 72,
/* 0x0550 */   1,  0,255, 59,255,255, 31,136, 46, 64, 74, 85,120, 83, 10,124,
/* 0x0560 */  32,  0, 74,121,220,255,  0, 66,255,255,  0, 56,255,  0, 32, 63,
/* 0x0570 */  32,  0,  0,120,  1,  0,160, 58,  1,  0,  0, 59,  1,  0,192, 58,
/* 0x0580 */   1,  0,160, 59,  0,  0,128, 57,  0,  0,192, 59,  0,  0, 64, 59,
/* 0x0590 */ 255,255, 57, 99,  1,  0, 96, 58,  8,  0, 84, 34, 64, 64,154,127,
/* 0x05a0 */ 216,  9,156, 64, 96,255,225,235, 54, 32,156, 85, 56,248, 87,127,
/* 0x05b0 */  64,200,128,127,180,  7,241,126,180,  7,156,127, 20,226,145,127,
/* 0x05c0 */ 164, 15,145,123, 36,  0,157, 65, 64, 40,171,127,124,255,190, 65,
/* 0x05d0 */   0,  0,235,139, 46, 64, 74, 85,120, 83,234,127, 40, 64,  0,120,
/* 0x05e0 */  32,  0, 74,121,  1,  0,107, 57, 46,138,251,125,254,170, 16, 84,
/* 0x05f0 */ 214,121, 16,126, 64,128,138,127, 32,  0, 28,122,228,  1,156, 64,
/* 0x0600 */   0,  8,239, 35,112, 46,255,127,166,  2,  8,124, 20,122,255,127,
/* 0x0610 */  46,139,251,127, 48,150,223,127, 56,  0, 94,127, 48,160,222,127,
/* 0x0620 */  20,242,223,127,  0,  3,222, 31,  6,  0,140, 47, 32,  0,222,123,
/* 0x0630 */  54,  7,222, 59,164, 15,222,123, 20,242,219,127, 16,  0,157, 65,
/* 0x0640 */   1,  0,224, 59,120,227,128,127, 12,  1,  0, 72, 80,208, 29,124,
/* 0x0650 */  32,  0,  0,120,174,  0,231,125,  1,  0,224, 59, 60,  8,247, 85,
/* 0x0660 */ 180,  7,239,126,238,  5,247, 86,180,  7,247,126, 64,200,156,127,
/* 0x0670 */   0,  1, 55, 58, 20,250, 49,126,164, 15, 49,122, 36,  0,157, 65,
/* 0x0680 */  64, 40,171,127,196,254,190, 65,  0,  0, 11,136, 46, 64, 74, 85,
/* 0x0690 */ 120, 83, 10,124, 40, 64,156,123, 32,  0, 74,121,  1,  0,107, 57,
/* 0x06a0 */  46,138, 30,126,254,170,128, 87,214,129,  0,124, 60,  8,255, 87,
/* 0x06b0 */  64,  0, 10,127, 32,  0, 14,120,  0,  0,183, 47, 36,  0,152, 64,
/* 0x06c0 */   0,  8, 16, 32,112, 46,  0,124, 20,130,  0,126, 46,139, 30,126,
/* 0x06d0 */ 180,  7,255,127,120,115,220,125, 48,  0,190, 65,104,255,255, 75,
/* 0x06e0 */  80,224,128,127, 80, 80, 64,125,126,217,  0, 86, 80,128,  0,126,
/* 0x06f0 */   1,  0,255, 59, 32,  0,156,123, 32,  0, 74,121, 46,139, 30,126,
/* 0x0700 */ 180,  7,255,127, 64,255,190, 65,255,  0,159, 47, 80,255,157, 64,
/* 0x0710 */  52,255,255, 75, 64,200,128,127,164, 15,241,123, 68,  0,157, 64,
/* 0x0720 */  46,138,254,126,254,170, 28, 84,214,185,156,127, 60,  8,255, 87,
/* 0x0730 */  64,224,138,127, 32,  0,144,123, 76,  0,156, 64,  0,  8,151, 35,
/* 0x0740 */ 112, 46,156,127, 20,186,156,127, 46,139,158,127,180,  7,255,127,
/* 0x0750 */ 120,131,  0,126,255,  0,159, 47,188,255,157, 64, 80,  0,  0, 72,
/* 0x0760 */  64, 40,171,127,228,253,190, 65,  0,  0,139,139, 46, 64, 74, 85,
/* 0x0770 */ 120, 83,138,127, 40, 64,  0,120, 32,  0, 74,121,  1,  0,107, 57,
/* 0x0780 */ 160,255,255, 75, 80,  0, 28,124, 80, 80, 92,125,126,217,252, 86,
/* 0x0790 */  80,184,156,127,  1,  0,255, 59, 32,  0, 74,121, 46,139,158,127,
/* 0x07a0 */ 180,  7,255,127, 32,  0, 16,120,168,255,255, 75,  3,  0,140, 47,
/* 0x07b0 */  32,  6,254,123,  1,  0,154, 59, 32,  0,156,123,174,209,199,127,
/* 0x07c0 */ 172,  7,157, 64,  9,  0,140, 47, 12,  0,157, 65,253,255,140, 57,
/* 0x07d0 */   8,  0,  0, 72,250,255,140, 57,180,  7,140,125,148,  7,  0, 72,
/* 0x07e0 */  80,  0, 16,124, 64,200,128,127,126,217,255, 85, 80, 80, 16,126,
/* 0x07f0 */  80,120,255,127,192,  0,204, 59, 32,  0, 28,120, 32,  0, 10,122,
/* 0x0800 */  46,139,251,127,164, 15,222,123, 36,  0,157, 65, 64, 40,171,127,
/* 0x0810 */  56,253,190, 65,  0,  0, 75,137, 46, 64, 16, 86,120,131, 74,125,
/* 0x0820 */  40, 64, 28,120, 32,  0, 74,121,  1,  0,107, 57, 46,242, 27,124,
/* 0x0830 */ 254,170,159, 87,214,  1, 31,126, 64,128,138,127, 32,  0, 31,122,
/* 0x0840 */  68,  0,156, 64,  7,  0,140, 47,  0,  8,128, 35,112, 46,156,127,
/* 0x0850 */  38,  0,128,125,254,239,140, 85, 20,  2, 28,124,208,  0,140,125,
/* 0x0860 */  66,240,140,121,  0, 16,140,121, 46,243, 27,124,120,195, 21,127,
/* 0x0870 */   3,  0,140, 57,120,179,216,126,104,  6,195, 59,120,235,182,127,
/* 0x0880 */ 124,  2,  0, 72, 80,224,240,125, 64,200,143,127, 80, 80,240,127,
/* 0x0890 */ 126,217, 16, 84, 80,  0, 16,124, 32,  0,252,121, 32,  0,234,123,
/* 0x08a0 */  46,243, 27,124, 24,  0, 30, 58, 36,  0,157, 65, 64, 40,171,127,
/* 0x08b0 */ 152,252,190, 65,  0,  0, 11,136, 46, 64,234, 87,120, 83, 10,124,
/* 0x08c0 */  40, 64,252,121, 32,  0, 74,121,  1,  0,107, 57, 46,130,251,125,
/* 0x08d0 */ 254,170,128, 87,214,121,  0,124, 64,  0,138,127, 32,  0, 31,120,
/* 0x08e0 */ 208,  0,156, 64,  0,  8,207, 35, 64,200,128,127,112, 46,222,127,
/* 0x08f0 */  20,122,254,125, 46,131,251,125,224,  1,145, 59, 36,  0,157, 65,
/* 0x0900 */  64, 40,171,127, 68,252,190, 65, 40, 64, 31,120,  0,  0, 11,136,
/* 0x0910 */  46, 64, 74, 85,120, 83, 10,124, 32,  0, 74,121,  1,  0,107, 57,
/* 0x0920 */  46,226, 59,126,254,170,254, 87,214,137,222,127, 64,240,138,127,
/* 0x0930 */  32,  0,192,123, 80,  0,156, 64,  0,  8,241, 35,  0,  0,186, 47,
/* 0x0940 */ 112, 46,255,127, 20,138, 63,126, 46,227, 59,126,252,251,190, 65,
/* 0x0950 */   7,  0,140, 47, 80,208,253,127, 32,  0,255,123, 38,  0,128,125,
/* 0x0960 */ 254,239,140, 85,174,248,199,127,208,  0,140,125,164,  7,140,121,
/* 0x0970 */   1,  0,154, 59, 11,  0,140, 57, 32,  0,156,123,174,209,199,127,
/* 0x0980 */ 240,  5,  0, 72,126,217, 32, 86, 80,136, 32,126, 80,248,254,127,
/* 0x0990 */  80, 80, 94,125,120,195,  0,127, 32,  0,255,123,120,235,184,127,
/* 0x09a0 */  32,  0, 74,121, 46,227, 59,126,120,179,221,126,124,  0,  0, 72,
/* 0x09b0 */  80,224,128,127, 64,200,156,127,126,217,255, 85, 80, 80,  0,124,
/* 0x09c0 */  80,120,255,127, 46,131,251,127, 32,  0,145,123, 32,  0, 10,120,
/* 0x09d0 */  48,  0, 30, 58, 36,  0,157, 65, 64, 40,171,127,108,251,190, 65,
/* 0x09e0 */   0,  0, 75,137, 46, 64,  0, 84,120,  3, 74,125, 40, 64,145,123,
/* 0x09f0 */  32,  0, 74,121,  1,  0,107, 57, 46,130, 27,124,254,170, 63, 86,
/* 0x0a00 */ 214,  1,255,125, 64,120,138,127, 32,  0,255,121, 36,  0,156, 64,
/* 0x0a10 */   0,  8,192, 35,112, 46,222,127, 20,  2, 30,124, 46,131, 27,124,
/* 0x0a20 */ 120,195,  0,127,120,179,216,126,120,  3, 22,124,160,  0,  0, 72,
/* 0x0a30 */  80,136, 47,126, 64,200,145,127, 80, 80,239,127,126,217, 15, 84,
/* 0x0a40 */  80,  0, 15,124, 32,  0, 60,122, 32,  0,234,123, 46,131, 27,124,
/* 0x0a50 */  72,  0,222, 59, 36,  0,157, 65, 64, 40,171,127,236,250,190, 65,
/* 0x0a60 */   0,  0, 11,136, 46, 64,234, 87,120, 83, 10,124, 40, 64, 60,122,
/* 0x0a70 */  32,  0, 74,121,  1,  0,107, 57, 46,242, 59,126,254,170,128, 87,
/* 0x0a80 */ 214,137,  0,124, 64,  0,138,127, 32,  0, 31,120, 24,  0,156, 64,
/* 0x0a90 */   0,  8, 17, 32,112, 46,  0,124, 20,138,  0,124, 46,243, 27,124,
/* 0x0aa0 */  44,  0,  0, 72, 80,224,224,127, 80, 80, 64,125,126,217, 32, 86,
/* 0x0ab0 */  80,136,  0,124, 46,243, 27,124,120,195,  0,127, 32,  0, 74,121,
/* 0x0ac0 */ 120,171,184,126, 32,  0,255,123,120,  3, 21,124,  7,  0,140, 47,
/* 0x0ad0 */ 120,235,160,127,108, 10,195, 59, 38,  0,128,125,254,239,140, 85,
/* 0x0ae0 */ 120,195, 29,127,208,  0,140,125, 66,240,140,121,  0, 16,140,121,
/* 0x0af0 */ 120,179,216,126, 11,  0,140, 57,120,  3, 22,124, 64,200,159,127,
/* 0x0b00 */  36,  0,157, 65, 64, 40,171,127, 64,250,190, 65,  0,  0, 11,136,
/* 0x0b10 */  46, 64, 74, 85,120, 83, 10,124, 40, 64,255,123, 32,  0, 74,121,
/* 0x0b20 */   1,  0,107, 57,  0,  0, 30,162,254,170,252, 87,214,129,156,127,
/* 0x0b30 */  64,224,138,127, 32,  0,128,123, 48,  0,156, 64, 56, 24,247, 86,
/* 0x0b40 */   0,  8,240, 35,180,  7,247,126,112, 46,255,127,  2,  0,247, 58,
/* 0x0b50 */  20,130, 31,126,164, 15,247,122,  0,  0, 30,178,  0,  0,192, 57,
/* 0x0b60 */  20,186,222,127,136,  0,  0, 72, 80,248,252,127, 64,200,159,127,
/* 0x0b70 */ 126,217,  0, 86, 80, 80,156,127, 80,128,  0,126, 32,  0,241,123,
/* 0x0b80 */  32,  0,138,123,  0,  0, 30,178, 36,  0,157, 65, 64, 40,171,127,
/* 0x0b90 */ 184,249,190, 65,  0,  0, 75,137, 46, 64,156, 87,120,227, 74,125,
/* 0x0ba0 */  40, 64,241,123, 32,  0, 74,121,  1,  0,107, 57,  2,  0,158,163,
/* 0x0bb0 */ 254,170, 63, 86,214,225,255,127, 64,248,138,127, 32,  0,224,123,
/* 0x0bc0 */  52,  0,156, 64, 56, 24,247, 86,  0,  8,252, 35,180,  7,247,126,
/* 0x0bd0 */ 112, 46,255,127,130,  0,247, 58, 20,226,255,127,164, 15,247,122,
/* 0x0be0 */   2,  0,254,179,  8,  0,192, 57, 20,186,222,127,  3,  0,224, 57,
/* 0x0bf0 */  44,  0,  0, 72, 80,136, 31,124, 80, 80, 95,125,126,217,159, 87,
/* 0x0c00 */  80,224,255,127,  2,  0,254,179, 32,  0, 74,121,  4,  2,222, 59,
/* 0x0c10 */  32,  0,  0,120, 16,  0,192, 57,  8,  0,224, 57,255,255,143, 59,
/* 0x0c20 */  32,  0,156,123,  1,  0,156, 59,166,  3,137,127,  1,  0,224, 59,
/* 0x0c30 */  64,200,128,127,164, 15,240,123, 20,130, 30,126, 36,  0,157, 65,
/* 0x0c40 */  64, 40,171,127,  4,249,190, 65,  0,  0,139,139, 46, 64, 74, 85,
/* 0x0c50 */ 120, 83,138,127, 40, 64,  0,120, 32,  0, 74,121,  1,  0,107, 57,
/* 0x0c60 */   0,  0, 48,162,254,170, 23, 84,214,137,247,126, 60,  8,255, 87,
/* 0x0c70 */  64,184,138,127, 32,  0,252,122, 32,  0,156, 64,  0,  8, 17, 32,
/* 0x0c80 */ 112, 46,  0,124, 20,138, 32,126,  0,  0, 48,178,180,  7,255,127,
/* 0x0c90 */ 120,227,128,127, 40,  0,  0, 72,126,217, 60, 86, 80,136, 60,126,
/* 0x0ca0 */  80,  0, 23,124, 80, 80, 87,125,  1,  0,255, 59,  0,  0, 48,178,
/* 0x0cb0 */  32,  0,  0,120, 32,  0, 74,121,180,  7,255,127,116,255,  0, 66,
/* 0x0cc0 */   3,  0,140, 47, 48,120,111,126, 80,112,239,125, 20,250,143,127,
/* 0x0cd0 */  80,  2,157, 65,  3,  0,156, 47,120,227,159,127,  8,  0,157, 64,
/* 0x0ce0 */   3,  0,224, 59,  6,  0,192, 59, 50, 48,255, 87,166,  3,201,127,
/* 0x0cf0 */ 180,  7,255,127,176,  1,255, 59,164, 15,253,123,  1,  0,224, 59,
/* 0x0d00 */  64,200,128,127,164, 15,241,123, 20,234, 49,126, 36,  0,157, 65,
/* 0x0d10 */  64, 40,171,127, 52,248,190, 65,  0,  0,203,139, 46, 64, 74, 85,
/* 0x0d20 */ 120, 83,202,127, 40, 64,  0,120, 32,  0, 74,121,  1,  0,107, 57,
/* 0x0d30 */  46,138,251,126,254,170, 30, 84,214,185,222,127, 60,  8,255, 87,
/* 0x0d40 */  64,240,138,127, 32,  0,208,123, 32,  0,156, 64,  0,  8,215, 35,
/* 0x0d50 */ 112, 46,222,127, 20,186,222,127, 46,139,219,127,180,  7,255,127,
/* 0x0d60 */ 120,131,  0,126, 40,  0,  0, 72, 80,  0, 30,124, 80, 80, 94,125,
/* 0x0d70 */ 126,217,254, 86, 80,184,222,127,  1,  0,255, 59, 46,139,219,127,
/* 0x0d80 */  32,  0,  0,120, 32,  0, 74,121,180,  7,255,127,116,255,  0, 66,
/* 0x0d90 */ 192,255,223, 59,  3,  0,158, 47,180,  7,215,127,108,  1,157, 64,
/* 0x0da0 */  13,  0,158, 47,254,  7,223, 87,  2,  0,240, 99,112, 14,221,127,
/* 0x0db0 */  32,  0, 17,122, 40,  0,157, 65,255,255,221, 59, 48,240, 31,126,
/* 0x0dc0 */ 180,  7,221,127,176,  2,215, 35, 20,250,222,127,164, 15,222,123,
/* 0x0dd0 */ 254,255,222, 59, 20,242,219,127,116,  0,  0, 72,250,255,221, 59,
/* 0x0de0 */  32,  0,222,123,  1,  0,222, 59,166,  3,201,127, 64,200,128,127,
/* 0x0df0 */  36,  0,157, 65, 64, 40,171,127, 80,247,190, 65,  0,  0,235,139,
/* 0x0e00 */  46, 64, 74, 85,120, 83,234,127, 40, 64,  0,120, 32,  0, 74,121,
/* 0x0e10 */   1,  0,107, 57,126,248, 29, 84, 64,232,138,127, 60,  8, 63, 86,
/* 0x0e20 */  32,  0,160,123, 32,  0,241,123, 20,  0,156, 65, 80, 80, 93,125,
/* 0x0e30 */   1,  0,255, 99, 32,  0, 74,121, 32,  0,241,123,176,255,  0, 66,
/* 0x0e40 */  72,  6,195, 59, 40, 32, 63,122,  4,  0,160, 59,255,255,189, 59,
/* 0x0e50 */  32,  0,189,123,  1,  0,189, 59,166,  3,169,127,  1,  0,224, 58,
/* 0x0e60 */   1,  0,224, 57, 64,200,128,127,164, 15,241,122, 20,138, 62,126,
/* 0x0e70 */  36,  0,157, 65, 64, 40,171,127,208,246,190, 65,  0,  0,171,139,
/* 0x0e80 */  46, 64, 74, 85,120, 83,170,127, 40, 64,  0,120, 32,  0, 74,121,
/* 0x0e90 */   1,  0,107, 57,  0,  0, 17,162,254,170, 29, 84,214,129,189,127,
/* 0x0ea0 */  60,  8,247, 86, 64,232,138,127, 32,  0,174,123, 32,  0,156, 64,
/* 0x0eb0 */   0,  8, 16, 32,112, 46,  0,124, 20,130,  0,126,  0,  0, 17,178,
/* 0x0ec0 */ 180,  7,247,126,120,115,192,125, 48,  0,  0, 72, 80,  0, 29,124,
/* 0x0ed0 */  80, 80, 93,125,126,217, 29, 86, 80,128, 29,126,  1,  0,247, 58,
/* 0x0ee0 */ 120,251,255,125,  0,  0, 17,178, 32,  0,  0,120, 32,  0, 74,121,
/* 0x0ef0 */ 180,  7,247,126, 32,  0,255,123, 60,  8,239, 85,180,  7,239,125,
/* 0x0f00 */ 100,255,  0, 66,  8,  0,  0, 72, 32,  0,223,123,  1,  0,255, 59,
/* 0x0f10 */  33,  0,253,123,100,  0,130, 65,  7,  0,140, 57,180,  7,140,125,
/* 0x0f20 */  64,208,157,127,  2,  0,252, 59,180,  7,255,127, 28,246,189, 65,
/* 0x0f30 */ 255,255,255, 59, 32,  0,255,123,  1,  0,255, 59,166,  3,233,127,
/* 0x0f40 */  80,208,253,127, 32,  0,255,123,174,248,199,127,  1,  0,250, 59,
/* 0x0f50 */  32,  0,252,123,174,209,199,127, 24,  0, 64, 66, 64, 64,159,127,
/* 0x0f60 */ 120,227,154,127,220,255,156, 65,  8,  0,  0, 72,  0,  0,128, 57,
/* 0x0f70 */ 120,227,154,127, 40,246,255, 75,255,  0, 64, 61,255,255, 74, 97,
/* 0x0f80 */  64, 80,128,127, 16,  0,157, 65, 64, 40,171,127,188,245,190, 65,
/* 0x0f90 */   1,  0,107, 57, 80, 88,132,124,  0,  0,134,144,  0,  0, 73,147,
/* 0x0fa0 */   0,  0, 96, 56,  0,  0,  0, 72,112,255,193,249,120,255,225,249,
/* 0x0fb0 */ 128,255,  1,250,136,255, 33,250,144,255, 65,250,152,255, 97,250,
/* 0x0fc0 */ 160,255,129,250,168,255,161,250,176,255,193,250,184,255,225,250,
/* 0x0fd0 */ 192,255,  1,251,200,255, 33,251,208,255, 65,251,216,255, 97,251,
/* 0x0fe0 */ 224,255,129,251,232,255,161,251,240,255,193,251,248,255,225,251,
/* 0x0ff0 */  16,  0,  1,248, 32,  0,128, 78,112,255,193,233,120,255,225,233,
/* 0x1000 */ 128,255,  1,234,136,255, 33,234,144,255, 65,234,152,255, 97,234,
/* 0x1010 */ 160,255,129,234,168,255,161,234,176,255,193,234,184,255,225,234,
/* 0x1020 */ 192,255,  1,235,200,255, 33,235,208,255, 65,235,216,255, 97,235,
/* 0x1030 */ 224,255,129,235, 16,  0,  1,232,232,255,161,235,166,  3,  8,124,
/* 0x1040 */ 240,255,193,235,248,255,225,235, 32,  0,128, 78,  0,  0,  0,  0,
/* 0x1050 */   0,  0,  0,  1,  9,  0,  0, 72, 44, 12,  0, 72,166,  2,  8,124,
/* 0x1060 */ 160,255,129,250, 16,  0,  1,248,112,255,193,249,120,255,225,249,
/* 0x1070 */ 128,255,  1,250,136,255, 33,250,144,255, 65,250,152,255, 97,250,
/* 0x1080 */ 168,255,161,250,176,255,193,250,184,255,225,250,192,255,  1,251,
/* 0x1090 */ 200,255, 33,251,208,255, 65,251,216,255, 97,251,224,255,129,251,
/* 0x10a0 */ 232,255,161,251,240,255,193,251,248,255,225,251,  0,  0, 64, 57,
/* 0x10b0 */   0,  0,  3,138,  2,  0, 35,138,  1,  0, 67,138,  0,  0, 70,145,
/* 0x10c0 */   0,  0, 73,145,  0,  3, 64, 57,  1,  0, 99,137,  1,  0,  0, 56,
/* 0x10d0 */  20,130,107,125, 48, 88, 75,125,202,248,139, 47, 48,136, 17,124,
/* 0x10e0 */  48,144, 18,124,255,255, 49, 58,255,255, 82, 58,  4,  0,131, 58,
/* 0x10f0 */  32,  0, 49,122, 32,  0, 82,122,180,  7, 16,126, 36,  0,158, 65,
/* 0x1100 */  53,  7,107, 57,200, 15,107,121,  2,  0, 67, 57, 20, 90,116,125,
/* 0x1110 */   0,  4,  0, 56,  2,  0, 10,180, 64, 88,170,127,248,255,158, 64,
/* 0x1120 */  20, 42,164,124, 64, 40,164,127, 20,  2,158, 65,  4,  0,192, 59,
/* 0x1130 */ 166,  3,201,127,  0,  0, 68,137,  1,  0,100, 57,  5,  0,228, 59,
/* 0x1140 */  64, 40,171,127, 46, 64, 74, 85,  1,  0,107, 57,240,  1,158, 65,
/* 0x1150 */ 255,255, 11,136,120, 83, 10,124, 32,  0, 74,121,228,255,  0, 66,
/* 0x1160 */   0,  0,168, 47, 16, 11,158, 65,  1,  0,192, 57,  1,  0,  0, 56,
/* 0x1170 */ 166,  3,200,125, 96,255,  1,248,  8,  0, 16, 32,255,255,192, 59,
/* 0x1180 */ 255,  0, 32, 63, 88,255,  1,144, 32,  0,222,123,  1,  0,224, 57,
/* 0x1190 */   0,  0,160, 58,  0,  0, 96, 57,  0,  0,192, 58,255,255, 57, 99,
/* 0x11a0 */  56,136,219,126, 54, 32,160, 86, 64,200,158,127,180,  7,125,127,
/* 0x11b0 */ 180,  7,  0,124, 20,  2,189,127,164, 15,189,123, 36,  0,157, 65,
/* 0x11c0 */  64, 40,191,127,120,  1,158, 65,  0,  0, 31,136, 46, 64, 74, 85,
/* 0x11d0 */ 120, 83, 10,124, 40, 64,222,123, 32,  0, 74,121,  1,  0,255, 59,
/* 0x11e0 */  46,234,148,127,254,170,218, 87,214,225, 90,127, 64,208,138,127,
/* 0x11f0 */  32,  0, 64,123,160,  1,156, 64, 88,255,193,131,  0,  8,124, 35,
/* 0x1200 */  48,246,107,125, 56,144,222,126, 48,128,222,127, 20,242,107,125,
/* 0x1210 */  46, 64,126, 85, 42, 80,107, 85, 80, 88,126,125, 32,  0,107,121,
/* 0x1220 */   6,  0,149, 47,112, 46,123,127, 54,  7,203, 59, 20,226,155,127,
/* 0x1230 */ 164, 15,222,123, 46,235,148,127, 20,242,212,127,192,  4,157, 64,
/* 0x1240 */  80,176,111,125, 32,  0,107,121,174, 88, 71,127,  1,  0, 96, 57,
/* 0x1250 */  28,  0,  0, 72, 46, 99,126,127,180,  7,107,125,120,235,160,127,
/* 0x1260 */ 172,  0,130, 64,255,  0,139, 47,172,  0,157, 65, 60,  8, 90, 87,
/* 0x1270 */ 238,  5, 76, 87,180,  7,140,125,  0,  0, 44, 44, 64,200,128,127,
/* 0x1280 */   0,  1,140, 57, 60,  8,120, 85, 20, 90,140,125, 64, 40, 63,127,
/* 0x1290 */ 120,195, 11,127, 46, 64, 93, 85,  0,  0,128, 76,  1,  0, 24, 59,
/* 0x12a0 */ 164, 15,140,121,180,  7, 90,127, 28,  0,157, 65,144,  0,154, 65,
/* 0x12b0 */   0,  0, 95,137, 40, 64,  0,120,120,235, 74,125, 32,  0, 74,121,
/* 0x12c0 */   1,  0,255, 59, 46, 98,158,127,254,170, 29, 84,214,225,189,127,
/* 0x12d0 */   0,  8,124, 35, 64,232,138,127,112, 46,123,127,126,217,151, 87,
/* 0x12e0 */  20,226,123,127, 80,  0, 29,124, 80, 80,125,126, 80,224,151,127,
/* 0x12f0 */  32,  0,189,123, 96,255,188, 65, 46, 99,158,127,180,  7, 11,127,
/* 0x1300 */  32,  0,  0,120, 32,  0,106,122, 92,255,134, 64,255,  0,139, 47,
/* 0x1310 */   4,  4,189, 64, 32,  6,107,121,  1,  0,182, 59,174,177,103,125,
/* 0x1320 */ 120,  3, 30,124, 32,  0,182,123,  9,  0,149, 47, 68,  8,157, 65,
/* 0x1330 */ 253,255,181, 58,180,  7,181,126, 64,  6,  0, 72,  1,  0, 96, 56,
/* 0x1340 */  16,  0,  1,232,112,255,193,233,166,  3,  8,124,120,255,225,233,
/* 0x1350 */ 128,255,  1,234,136,255, 33,234,144,255, 65,234,152,255, 97,234,
/* 0x1360 */ 160,255,129,234,168,255,161,234,176,255,193,234,184,255,225,234,
/* 0x1370 */ 192,255,  1,235,200,255, 33,235,208,255, 65,235,216,255, 97,235,
/* 0x1380 */ 224,255,129,235,232,255,161,235,240,255,193,235,248,255,225,235,
/* 0x1390 */  32,  0,128, 78, 80,240,218,127, 64,200,158,127,126,217,139, 87,
/* 0x13a0 */  80,224,139,127, 80, 80, 90,127,192,  0,117, 57, 46,235,148,127,
/* 0x13b0 */  32,  0,216,123, 32,  0, 74,123,164, 15,124,121, 36,  0,157, 65,
/* 0x13c0 */  64, 40,191,127,120,255,190, 65,  0,  0, 95,137, 46, 64, 90, 87,
/* 0x13d0 */ 120,211, 74,125, 40, 64,216,123, 32,  0, 74,121,  1,  0,255, 59,
/* 0x13e0 */  46,226, 20,124,254,170, 11, 87,214,  1,107,125, 64, 88,138,127,
/* 0x13f0 */  32,  0,122,121,204,  3,156, 64,  7,  0,149, 47,  0,  8, 96, 33,
/* 0x1400 */ 112, 46,107,125, 38,  0,160,126,254,239,181, 86, 20,  2, 11,124,
/* 0x1410 */ 208,  0,181,126, 66,240,181,122,  0, 16,181,122, 46,227, 20,124,
/* 0x1420 */ 104,255,225,249,  3,  0,181, 58,104,  6, 99, 58, 64,200,154,127,
/* 0x1430 */  36,  0,157, 65, 64, 40,191,127,  4,255,190, 65,  0,  0,127,137,
/* 0x1440 */  46, 64, 74, 85,120, 83,106,125, 40, 64, 90,123, 32,  0, 74,121,
/* 0x1450 */   1,  0,255, 59,  0,  0, 19,160,254,170, 75, 87,214,  1,107,125,
/* 0x1460 */  64, 88,138,127, 32,  0,126,121, 72,  5,156, 64,  0,  8, 96, 33,
/* 0x1470 */  56, 24,123, 87,112, 46,107,125,180,  7,123,127, 20,  2, 11,124,
/* 0x1480 */   2,  0,123, 59,  0,  0, 96, 57,164, 15,123,123, 80,255, 97,249,
/* 0x1490 */   0,  0, 19,176,  3,  0,128, 57, 20,218,115,126,255,255, 12, 59,
/* 0x14a0 */  32,  0, 24,123,  1,  0, 24, 59,166,  3,  9,127,  1,  0,160, 59,
/* 0x14b0 */  64,200,158,127, 60,  8,187, 87,164, 15,188,123, 64, 40, 63,127,
/* 0x14c0 */ 120,219,125,127, 46, 64, 75, 85,  1,  0,123, 59, 20,226,147,127,
/* 0x14d0 */  28,  0,157, 65,104,254,186, 65,  0,  0, 95,137, 40, 64,222,123,
/* 0x14e0 */ 120, 91, 74,125, 32,  0, 74,121,  1,  0,255, 59,  0,  0,252,162,
/* 0x14f0 */ 254,170,203, 87,214,185,107,125,  0,  8, 23, 32, 64, 88,138,127,
/* 0x1500 */ 126,217,250, 86,112, 46,  0,124, 80,184, 90,127, 20,186,  0,124,
/* 0x1510 */  80,240,203,127, 80, 80,235,126, 32,  0,107,121,164,  3,156, 64,
/* 0x1520 */   0,  0, 28,176,180,  7,189,127,120, 91,126,125,132,255,  0, 66,
/* 0x1530 */  80,255, 97,233,  1,  0,  0, 56, 48, 96, 12,124,  3,  0,149, 47,
/* 0x1540 */  80, 88,140,125, 20,234,140,125, 80,255,129,145,188,  3,157, 65,
/* 0x1550 */   3,  0,140, 47, 32,  0,139,121, 36,  6,157, 65,  6,  0,  0, 56,
/* 0x1560 */  50, 48,107, 85,166,  3,  9,124,180,  7,107,125,176,  1,107, 57,
/* 0x1570 */ 164, 15,119,121,  1,  0,128, 59, 64,200,158,127, 60,  8,155, 87,
/* 0x1580 */ 164, 15,157,123, 64, 40, 63,127,120,219,124,127, 46, 64, 75, 85,
/* 0x1590 */   1,  0,123, 59, 20,186,189,127, 28,  0,157, 65,160,253,186, 65,
/* 0x15a0 */   0,  0, 95,137, 40, 64,222,123,120, 91, 74,125, 32,  0, 74,121,
/* 0x15b0 */   1,  0,255, 59, 46,234,116,126,254,170,203, 87,214,153,107,125,
/* 0x15c0 */   0,  8, 19, 32, 64, 88,138,127,126,217,122, 86,112, 46,  0,124,
/* 0x15d0 */  80,152, 90,127, 20,154,  0,124, 80,240,235,125, 80, 80,107,126,
/* 0x15e0 */  32,  0,126,121,244,  2,156, 64, 46,235, 20,124,180,  7,156,127,
/* 0x15f0 */ 136,255,  0, 66,192,255,156, 59,  3,  0,156, 47,180,  7,155,127,
/* 0x1600 */ 240,  2,157, 64, 13,  0,156, 47,254,  7,128, 87,  2,  0,  0, 96,
/* 0x1610 */ 112, 14,139,127, 32,  0, 29,120,192,  5,157, 65,255,255,107, 57,
/* 0x1620 */  48, 88, 28,124,176,  2,187, 35, 20,226,189,127,164, 15,189,123,
/* 0x1630 */ 254,255,189, 59,180,  7,123,125, 20,234,116,125,255,255, 27, 56,
/* 0x1640 */  32,  0, 29,120,  1,  0,189, 59,  1,  0, 96, 59,  1,  0, 64, 59,
/* 0x1650 */ 166,  3,169,127, 28,  0,  0, 72,  0,  0,184,179,180,  7,123,127,
/* 0x1660 */ 120,  3, 30,124, 60,  8, 90, 87,180,  7, 90,127,136,  2, 64, 66,
/* 0x1670 */  64,200,158,127, 60,  8,119, 87,164, 15,120,123, 64, 40, 63,127,
/* 0x1680 */ 120,187,251,126, 46, 64, 64, 85,120,227, 79,127,  1,  0,247, 58,
/* 0x1690 */  20,194, 11,127, 28,  0,157, 65,164,252,186, 65,  0,  0, 95,137,
/* 0x16a0 */  40, 64,222,123,120,  3, 74,125, 32,  0, 74,121,  1,  0,255, 59,
/* 0x16b0 */   0,  0,152,161,254,170,192, 87,214, 97,  0,124,  0,  8,172, 35,
/* 0x16c0 */  64,  0,138,127,126,217,147, 85,112, 46,189,127, 80, 96,115,126,
/* 0x16d0 */  20, 98,189,127, 80,240,192,127, 80, 80,128,125, 32,  0,  0,120,
/* 0x16e0 */ 120,255,188, 65,  0,  0,120,178, 32,  0,222,123, 32,  0,138,121,
/* 0x16f0 */ 180,  7,251,126, 32,  0,252,121,108,255,255, 75,  1,  0, 96, 57,
/* 0x1700 */  20,  0,  0, 72, 46, 91,158,127,180,  7, 11,127,255,  0,139, 47,
/* 0x1710 */ 136,  0,157, 65, 64,200,128,127, 60,  8,122, 85,120,211, 88,127,
/* 0x1720 */  64, 40, 63,127, 46, 64, 93, 85,  1,  0, 90, 59,164, 15,107,121,
/* 0x1730 */  28,  0,157, 65,  8,252,186, 65,  0,  0, 95,137, 40, 64,  0,120,
/* 0x1740 */ 120,235, 74,125, 32,  0, 74,121,  1,  0,255, 59, 46, 90,254,126,
/* 0x1750 */ 254,170, 29, 84,214,185,189,127,  0,  8,151, 35, 64,232,138,127,
/* 0x1760 */ 126,217,251, 86,112, 46,156,127, 80,184,123,127, 20,186,156,127,
/* 0x1770 */  80,  0,125,126, 80, 80,253,126, 32,  0,160,123,136,255,188, 65,
/* 0x1780 */  46, 91,126,127,180,  7, 75,127,255,  0,139, 47, 32,  0, 96,122,
/* 0x1790 */  32,  0,234,122,128,255,157, 64,  3,  0,149, 47,  1,  0,182, 59,
/* 0x17a0 */  32,  6,107,121, 32,  0,189,123,174,177,103,125,120,  3, 30,124,
/* 0x17b0 */ 120,235,182,127,116,251,189, 65,  0,  0,160, 58,188,  1,  0, 72,
/* 0x17c0 */  80,192, 11,127, 64,200,152,127,126,217, 30, 84, 80,  0, 30,124,
/* 0x17d0 */  80, 80,107,125, 46,227, 20,124, 32,  0, 30,123, 32,  0,106,121,
/* 0x17e0 */  24,  0, 28, 56, 36,  0,157, 65, 64, 40,191,127, 80,251,190, 65,
/* 0x17f0 */   0,  0, 95,137, 46, 64,107, 85,120, 91, 74,125, 40, 64, 30,123,
/* 0x1800 */  32,  0, 74,121,  1,  0,255, 59, 46,  2,116,125,254,170,216, 87,
/* 0x1810 */ 214, 89, 24,127, 64,192,138,127, 32,  0, 26,123, 36,  2,156, 64,
/* 0x1820 */   0,  8,203, 35, 64,200,152,127,112, 46,222,127, 20, 90,126,125,
/* 0x1830 */  46,  3,116,125,224,  1,189, 59, 36,  0,157, 65, 64, 40,191,127,
/* 0x1840 */ 252,250,190, 65,  0,  0,127,137, 46, 64, 74, 85,120, 83,106,125,
/* 0x1850 */  40, 64, 26,123, 32,  0, 74,121,  1,  0,255, 59, 46,234, 20,124,
/* 0x1860 */ 254,170, 75, 87,214,  1,107,125, 64, 88,138,127, 32,  0,126,121,
/* 0x1870 */  20,  3,156, 64,  0,  8, 96, 33,  0,  0,182, 47,112, 46,107,125,
/* 0x1880 */  20,  2,107,125, 46,235,116,125,180,250,190, 65,  7,  0,149, 47,
/* 0x1890 */  80,176,111,125, 32,  0,107,121, 38,  0,160,126,254,239,181, 86,
/* 0x18a0 */ 174, 88,103,125,208,  0,181,126,164,  7,181,122,  1,  0, 22, 56,
/* 0x18b0 */ 174,177,103,125, 11,  0,181, 58, 32,  0, 22,120,188,  0,  0, 72,
/* 0x18c0 */   0,  0, 92,179, 32,  0,222,123, 32,  0,234,122,180,  7,125,127,
/* 0x18d0 */ 224,251,  0, 66, 92,252,255, 75, 46,235, 84,127, 32,  0,254,121,
/* 0x18e0 */  32,  0,106,122,180,  7,124,127,144,252,  0, 66,  8,253,255, 75,
/* 0x18f0 */  32,  0,156,123,  1,  0,156, 59, 33,  0,143,123,132,  0,130, 65,
/* 0x1900 */   7,  0,181, 58,180,  7,181,126, 64,176,143,127, 48,250,189, 65,
/* 0x1910 */  80,255, 97,129,  1,  0,150, 59, 20, 90, 28,124, 80,176,175,127,
/* 0x1920 */  32,  0,189,123, 80,  0, 15,124, 80,  0, 29,124, 32,  0, 11,120,
/* 0x1930 */   1,  0,107, 57,120,179,219,126,166,  3,105,125, 20,  0,  0, 72,
/* 0x1940 */ 120,179,219,126, 32,  0,189,123, 56,  0,157, 64,  1,  0,150, 59,
/* 0x1950 */ 174,232,103,125, 64,224,136,127,  1,  0,189, 59, 32,  0,150,123,
/* 0x1960 */ 174,217,103,125,220,255,  0, 66,104,255,  1,232, 96,255,193,249,
/* 0x1970 */ 166,  2,200,125,166,  3,  8,124, 64,176,136,127, 36,248,157, 65,
/* 0x1980 */ 255,  0, 64, 61,255,255, 74, 97, 64, 80,158,127, 16,  0,157, 65,
/* 0x1990 */  64, 40,191,127,168,249,190, 65,  1,  0,255, 59, 80,248,132,124,
/* 0x19a0 */   0,  0,134,144,  0,  0, 96, 56,  0,  0,201,146,148,249,255, 75,
/* 0x19b0 */  80,208, 75,127, 64,200,154,127,126,217, 30, 84, 80, 80,107,125,
/* 0x19c0 */  80,  0, 30,124, 32,  0, 93,123, 32,  0,106,121,  0,  0, 19,176,
/* 0x19d0 */  36,  0,157, 65, 64, 40,191,127,100,249,190, 65,  0,  0, 31,136,
/* 0x19e0 */  46, 64,106, 85,120, 83, 10,124, 40, 64, 93,123, 32,  0, 74,121,
/* 0x19f0 */   1,  0,255, 59,  2,  0, 19,160,254,170,171, 87,214,  1,107,125,
/* 0x1a00 */  64, 88,138,127, 32,  0,126,121, 56,  1,156, 64,  0,  8,160, 35,
/* 0x1a10 */  56, 24,107, 87,180,  7,107,125,112, 46,189,127, 20,  2, 29,124,
/* 0x1a20 */ 130,  0,107, 57,  2,  0, 19,176,164, 15,107,121,  8,  0,  0, 56,
/* 0x1a30 */  20, 90,115,126, 80,255,  1,248,  3,  0,128, 57, 96,250,255, 75,
/* 0x1a40 */  80,240,216,127, 64,200,158,127,126,217,125, 85, 80, 88,125,125,
/* 0x1a50 */  80, 80, 24,127, 32,  0,221,123, 32,  0, 10,123, 46,  3,116,125,
/* 0x1a60 */  48,  0,252, 58, 36,  0,157, 65, 64, 40,191,127,208,248,190, 65,
/* 0x1a70 */   0,  0,127,137, 46, 64, 10, 87,120, 83,106,125, 40, 64,221,123,
/* 0x1a80 */  32,  0, 74,121,  1,  0,255, 59, 46,186, 20,124,254,170,171, 87,
/* 0x1a90 */ 214,  1,107,125, 64, 88,138,127, 32,  0,122,121, 24,  1,156, 65,
/* 0x1aa0 */  80,232,171,127, 64,200,157,127,126,217, 30, 84, 80,  0, 30,124,
/* 0x1ab0 */  80, 80,107,125, 32,  0,190,123, 32,  0,106,121, 46,187, 20,124,
/* 0x1ac0 */  72,  0,156, 59, 36,  0,157, 65, 64, 40,191,127,112,248,190, 65,
/* 0x1ad0 */   0,  0, 95,137, 46, 64,107, 85,120, 91, 74,125, 40, 64,190,123,
/* 0x1ae0 */  32,  0, 74,121,  1,  0,255, 59, 46,226, 20,124,254,170,203, 87,
/* 0x1af0 */ 214,  1,107,125, 64, 88,138,127, 32,  0,122,121, 80,  1,156, 64,
/* 0x1b00 */   0,  8, 96, 33,112, 46,107,125, 20,  2, 11,124,104,255,225,249,
/* 0x1b10 */  46,227, 20,124,120,115,207,125, 96,255,193,233,  7,  0,149, 47,
/* 0x1b20 */ 108, 10, 99, 58, 38,  0,160,126,254,239,181, 86,208,  0,181,126,
/* 0x1b30 */  66,240,181,122,  0, 16,181,122, 11,  0,181, 58,240,248,255, 75,
/* 0x1b40 */ 126,217, 30, 84, 80,  0, 30,124, 80, 80, 75,125, 80,232,203,127,
/* 0x1b50 */  16,  0, 96, 57,  2,  0, 19,176, 32,  0, 74,121,  4,  2,115, 58,
/* 0x1b60 */  32,  0,222,123, 80,255, 97,249,  8,  0,128, 57, 48,249,255, 75,
/* 0x1b70 */ 250,255,181, 58,180,  7,181,126,  0,254,255, 75,  3,  0, 96, 57,
/* 0x1b80 */ 220,249,255, 75,126,217, 30, 84, 80,208, 75,127, 80, 80, 75,125,
/* 0x1b90 */  80,  0,126,125,166,  2,  8,124, 32,  0, 90,123,166,  3,200,125,
/* 0x1ba0 */ 104,255,  1,248, 32,  0, 74,121, 46,235,116,125, 96,255,193,233,
/* 0x1bb0 */ 108,255,255, 75,  0,  8, 96, 33,112, 46,107,125, 20,  2, 11,124,
/* 0x1bc0 */ 104,255,225,249, 46,187, 20,124,166,  2,232,125,166,  3,200,125,
/* 0x1bd0 */  96,255,193,233, 72,255,255, 75,250,255,107, 57, 32,  0,107,121,
/* 0x1be0 */   1,  0,107, 57,166,  3,105,125, 64,200,158,127, 60,  8,188, 87,
/* 0x1bf0 */  64, 40, 63,127, 46, 64, 64, 85,  1,  0,155, 99, 28,  0,157, 65,
/* 0x1c00 */  60,247,186, 65,  0,  0, 95,137, 40, 64,222,123,120,  3, 74,125,
/* 0x1c10 */  32,  0, 74,121,  1,  0,255, 59,126,248,222, 87, 64,240,138,127,
/* 0x1c20 */  80, 80, 30,124, 32,  0,157,123, 32,  0,222,123, 12,  0,156, 65,
/* 0x1c30 */  32,  0, 10,120, 32,  0,125,123,176,255,  0, 66, 72,  6, 99, 57,
/* 0x1c40 */  40, 32,188,123,  4,  0, 96, 59,244,249,255, 75,126,217, 29, 84,
/* 0x1c50 */  80,  0, 29,124, 80,240,203,127, 80, 80, 75,125,104,255,225,249,
/* 0x1c60 */  46,227, 20,124, 32,  0, 74,121, 32,  0,218,123, 96,255,225,233,
/* 0x1c70 */ 172,254,255, 75,  0,  0,192, 58, 36,253,255, 75,  0,  0,  0,  0,
/* 0x1c80 */   0,  0,  0,  1, 48,  0, 33, 56, 24,  0,161,232, 16,  0,225,232,
/* 0x1c90 */   0,  0,165,232,  0,  0, 33,232, 20, 58,165,124, 16,  0,  1,232,
/* 0x1ca0 */ 255,255,165, 56,  0,  0, 33,232,166,  3,  8,124,  0,  0,230,232,
/* 0x1cb0 */ 166,  3,168,125, 80, 24,100,124, 80, 40,135,124,  1,  0, 99, 56,
/* 0x1cc0 */   1,  0,132, 56,  0,  0,134,248, 31,  0,231, 96,108, 56,  0,124,
/* 0x1cd0 */  64, 40, 39,124,172, 63,  0,124, 32,  0,231, 56,240,255,128, 65,
/* 0x1ce0 */ 172,  4,  0,124, 44,  1,  0, 76, 32,  0,128, 78,  0,  0,  0,  0,
/* 0x1cf0 */   1,  0,  0, 72, 80, 82, 79, 84, 95, 69, 88, 69, 67,124, 80, 82,
/* 0x1d00 */  79, 84, 95, 87, 82, 73, 84, 69, 32,102, 97,105,108,101,100, 46,
/* 0x1d10 */  10,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1d20 */  44,  0,160, 56,166,  2,136,124,  2,  0, 96, 56,  4,  0,  0, 56,
/* 0x1d30 */   2,  0,  0, 68,127,  0, 96, 56,  1,  0,  0, 56,  2,  0,  0, 68,
/* 0x1d40 */ 166,  2,200,127,  0,  0,  0, 57,255,255,224, 56,  4,  0,126,128,
/* 0x1d50 */  50,  0,192, 56,  7,  0,160, 56,  1,  0,128, 60, 20,242, 99,124,
/* 0x1d60 */  90,  0,  0, 56, 11,  0, 99, 56, 20, 34, 99,124, 30,  0, 99, 84,
/* 0x1d70 */   2,  0,  0, 68,  0,  0,195, 65,166,  3,233,127,  0,  0, 30,128,
/* 0x1d80 */   8,  0,254,136,248,  0,193, 56,248,  0,  1,248,120, 27,101,124,
/* 0x1d90 */ 166,  3,104,124,  4,  0,158,128, 12,  0,126, 56,145,255, 33,248,
/* 0x1da0 */  32,  4,128, 78,  1,255, 33,248,  8,  0, 65,248, 16,  0, 97,248,
/* 0x1db0 */  24,  0,129,248, 32,  0,161,248, 40,  0,193,248, 48,  0,225,248,
/* 0x1dc0 */  56,  0,  1,249, 64,  0, 33,249, 72,  0, 65,249, 80,  0, 97,249,
/* 0x1dd0 */  88,  0,129,249, 96,  0,161,249,104,  0,193,249,112,  0,225,249,
/* 0x1de0 */ 120,  0,  1,250,128,  0, 33,250,136,  0, 65,250,144,  0, 97,250,
/* 0x1df0 */ 152,  0,129,250,160,  0,161,250,168,  0,193,250,176,  0,225,250,
/* 0x1e00 */ 184,  0,  1,251,192,  0, 33,251,200,  0, 65,251,208,  0, 97,251,
/* 0x1e10 */ 216,  0,129,251,224,  0,161,251,232,  0,193,251,240,  0,225,251,
/* 0x1e20 */ 166,  2,232,127, 29,255,255, 75,102,105,108,101, 32,102,111,114,
/* 0x1e30 */ 109, 97,116, 32,101,108,102, 54, 52, 45,112,111,119,101,114,112,
/* 0x1e40 */  99,108,101, 10, 10, 83,101, 99,116,105,111,110,115, 58, 10, 73,
/* 0x1e50 */ 100,120, 32, 78, 97,109,101, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1e60 */  32, 83,105,122,101, 32, 32, 32, 32, 32, 32, 86, 77, 65, 32, 32,
/* 0x1e70 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 76, 77, 65,
/* 0x1e80 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 70,
/* 0x1e90 */ 105,108,101, 32,111,102,102, 32, 32, 65,108,103,110, 32, 32, 70,
/* 0x1ea0 */ 108, 97,103,115, 10, 32, 32, 48, 32, 69, 76, 70, 77, 65, 73, 78,
/* 0x1eb0 */  88, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 52, 32,
/* 0x1ec0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1ed0 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1ee0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 52, 48, 32, 32, 50,
/* 0x1ef0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x1f00 */  69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x1f10 */  32, 49, 32, 78, 82, 86, 95, 72, 69, 65, 68, 32, 32, 32, 32, 32,
/* 0x1f20 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x1f30 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x1f40 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x1f50 */  48, 48, 48, 48, 48, 52, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x1f60 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x1f70 */  89, 10, 32, 32, 50, 32, 78, 82, 86, 50, 69, 32, 32, 32, 32, 32,
/* 0x1f80 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 49, 54, 56, 32, 32, 48, 48,
/* 0x1f90 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x1fa0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1fb0 */  32, 32, 48, 48, 48, 48, 48, 48, 52, 52, 32, 32, 50, 42, 42, 48,
/* 0x1fc0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,
/* 0x1fd0 */  67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 51, 32,
/* 0x1fe0 */  78, 82, 86, 50, 68, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x1ff0 */  48, 48, 48, 49, 52, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2000 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2010 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x2020 */  48, 49, 97, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2030 */  69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,
/* 0x2040 */  68, 79, 78, 76, 89, 10, 32, 32, 52, 32, 78, 82, 86, 50, 66, 32,
/* 0x2050 */  32, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 49, 49, 56,
/* 0x2060 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2070 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2080 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50,102, 48, 32, 32,
/* 0x2090 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x20a0 */  82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x20b0 */  32, 32, 53, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 32, 32,
/* 0x20c0 */  32, 32, 48, 48, 48, 48, 48, 48, 57, 52, 32, 32, 48, 48, 48, 48,
/* 0x20d0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x20e0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x20f0 */  48, 48, 48, 48, 48, 52, 48, 56, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2100 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,
/* 0x2110 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 54, 32, 76, 90,
/* 0x2120 */  77, 65, 95, 68, 69, 67, 49, 48, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x2130 */  48, 98, 98, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2140 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2150 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 52,
/* 0x2160 */  57, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2170 */  84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 55,
/* 0x2180 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 32, 32, 32, 32, 48,
/* 0x2190 */  48, 48, 48, 48, 99, 51, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x21a0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x21b0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x21c0 */  48, 49, 48, 53, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x21d0 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x21e0 */  32, 32, 56, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 32, 32,
/* 0x21f0 */  32, 32, 48, 48, 48, 48, 48, 48, 50, 56, 32, 32, 48, 48, 48, 48,
/* 0x2200 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x2210 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x2220 */  48, 48, 48, 48, 49, 99, 56, 52, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2230 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x2240 */  76, 89, 10, 32, 32, 57, 32, 78, 82, 86, 95, 84, 65, 73, 76, 32,
/* 0x2250 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 99, 32, 32, 48,
/* 0x2260 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2270 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2280 */  48, 32, 32, 48, 48, 48, 48, 49, 99, 97, 99, 32, 32, 50, 42, 42,
/* 0x2290 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,
/* 0x22a0 */  68, 79, 78, 76, 89, 10, 32, 49, 48, 32, 67, 70, 76, 85, 83, 72,
/* 0x22b0 */  32, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 50, 52,
/* 0x22c0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x22d0 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x22e0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 99, 99, 56, 32, 32,
/* 0x22f0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x2300 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 49, 32, 69, 76, 70,
/* 0x2310 */  77, 65, 73, 78, 89, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x2320 */  48, 51, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2330 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2340 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 99,102,
/* 0x2350 */  48, 32, 32, 50, 42, 42, 52, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2360 */  83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x2370 */  76, 89, 10, 32, 49, 50, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32,
/* 0x2380 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 49, 48, 56, 32, 32, 48,
/* 0x2390 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x23a0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x23b0 */  48, 32, 32, 48, 48, 48, 48, 49,100, 50, 48, 32, 32, 50, 42, 42,
/* 0x23c0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,
/* 0x23d0 */  79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 83, 89, 77,
/* 0x23e0 */  66, 79, 76, 32, 84, 65, 66, 76, 69, 58, 10, 48, 48, 48, 48, 48,
/* 0x23f0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x2400 */  32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48,  9, 48,
/* 0x2410 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2420 */  76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48,
/* 0x2430 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x2440 */  32,100, 32, 32, 78, 82, 86, 95, 84, 65, 73, 76,  9, 48, 48, 48,
/* 0x2450 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82,
/* 0x2460 */  86, 95, 84, 65, 73, 76, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2470 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x2480 */  69, 76, 70, 77, 65, 73, 78, 89,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x2490 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 69, 76, 70, 77, 65, 73,
/* 0x24a0 */  78, 89, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x24b0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 69, 76, 70, 77,
/* 0x24c0 */  65, 73, 78, 90,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x24d0 */  48, 48, 48, 48, 48, 32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48,
/* 0x24e0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x24f0 */ 108, 32, 32, 32, 32,100, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88,
/* 0x2500 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2510 */  48, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48,
/* 0x2520 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x2530 */  32,100, 32, 32, 78, 82, 86, 95, 72, 69, 65, 68,  9, 48, 48, 48,
/* 0x2540 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82,
/* 0x2550 */  86, 95, 72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2560 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x2570 */  78, 82, 86, 50, 69,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2580 */  48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48,
/* 0x2590 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x25a0 */  32, 32, 32,100, 32, 32, 78, 82, 86, 50, 68,  9, 48, 48, 48, 48,
/* 0x25b0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86,
/* 0x25c0 */  50, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x25d0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50,
/* 0x25e0 */  66,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x25f0 */  48, 48, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x2600 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x2610 */  32, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48,  9, 48, 48, 48,
/* 0x2620 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90,
/* 0x2630 */  77, 65, 95, 69, 76, 70, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x2640 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x2650 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,  9, 48, 48, 48,
/* 0x2660 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90,
/* 0x2670 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x2680 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x2690 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,  9, 48, 48, 48,
/* 0x26a0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90,
/* 0x26b0 */  77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x26c0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x26d0 */  32, 32, 67, 70, 76, 85, 83, 72,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x26e0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 70, 76, 85, 83, 72,
/* 0x26f0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2700 */  48, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73,
/* 0x2710 */  78, 88,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2720 */  48, 48, 48, 32, 95,115,116, 97,114,116, 10, 10, 82, 69, 76, 79,
/* 0x2730 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x2740 */  79, 82, 32, 91, 69, 76, 70, 77, 65, 73, 78, 88, 93, 58, 10, 79,
/* 0x2750 */  70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2760 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2770 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2780 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 82, 95, 80, 80, 67, 54, 52,
/* 0x2790 */  95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65,
/* 0x27a0 */  73, 78, 90, 43, 48,120, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x27b0 */  48, 48, 48, 48, 56, 52, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x27c0 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x27d0 */  78, 82, 86, 50, 69, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x27e0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x27f0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x2800 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,100,
/* 0x2810 */  52, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 49, 52, 32,
/* 0x2820 */  32, 32, 32, 32, 78, 82, 86, 95, 84, 65, 73, 76, 10, 10, 82, 69,
/* 0x2830 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x2840 */  32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 68, 93, 58, 10, 79, 70,
/* 0x2850 */  70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84,
/* 0x2860 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2870 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2880 */  48, 48, 48, 48, 48, 99, 99, 32, 82, 95, 80, 80, 67, 54, 52, 95,
/* 0x2890 */  82, 69, 76, 49, 52, 32, 32, 32, 32, 32, 78, 82, 86, 95, 84, 65,
/* 0x28a0 */  73, 76, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x28b0 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50,
/* 0x28c0 */  66, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32,
/* 0x28d0 */  32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x28e0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x28f0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 98, 56, 32, 82, 95,
/* 0x2900 */  80, 80, 67, 54, 52, 95, 82, 69, 76, 49, 52, 32, 32, 32, 32, 32,
/* 0x2910 */  78, 82, 86, 95, 84, 65, 73, 76, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x2920 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x2930 */  32, 91, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 93, 58, 10, 79,
/* 0x2940 */  70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2950 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2960 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2970 */  48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 80, 80, 67, 54, 52,
/* 0x2980 */  95, 82, 69, 76, 49, 52, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x2990 */  68, 69, 67, 51, 48, 43, 48,120, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x29a0 */  48, 48, 48, 48, 48, 48, 50, 56, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x29b0 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x29c0 */  32, 91, 69, 76, 70, 77, 65, 73, 78, 89, 93, 58, 10, 79, 70, 70,
/* 0x29d0 */  83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89,
/* 0x29e0 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x29f0 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2a00 */  48, 48, 48, 48, 48, 48, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82,
/* 0x2a10 */  69, 76, 50, 52, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78,
/* 0x2a20 */  90, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x2a30 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 69, 76, 70, 77, 65,
/* 0x2a40 */  73, 78, 90, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32,
/* 0x2a50 */  32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x2a60 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x2a70 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 53, 52, 32,
/* 0x2a80 */  82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 49, 52, 32, 32, 32,
/* 0x2a90 */  32, 32, 69, 76, 70, 77, 65, 73, 78, 89, 10
};
