/*******************************************************************************
 * Part of "Intel(R) Active Management Technology (Intel(R) AMT)
 *                   User Notification Service (UNS)"
 *
 * Copyright (c) 2007 Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification.
 * 2. Redistributions in binary form must reproduce at minimum a disclaimer
 *    substantially similar to the "NO WARRANTY" disclaimer below
 *    ("Disclaimer") and any redistribution must be conditioned upon
 *    including a substantially similar Disclaimer requirement for further
 *    binary redistribution.
 * 3. Neither the names of the above-listed copyright holders nor the names
 *    of any contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * Alternatively, this software may be distributed under the terms of the
 * GNU General Public License ("GPL") version 2 as published by the Free
 * Software Foundation.
 *
 * NO WARRANTY
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *******************************************************************************/

#ifndef __CIM_LOGICALELEMENT_H
#define __CIM_LOGICALELEMENT_H
#include "CIM_ManagedSystemElement.h"
namespace CimClassNamespace
{

	// Class CIM_LogicalElement:
	// CIM_LogicalElement is a base class for all the components of a System that represent abstract system components, such as Files, Processes, or LogicalDevices.
	class CIM_LogicalElement  : public CIM_ManagedSystemElement
	{
	public:
		// type definitions
		typedef CimClassContainer<CIM_LogicalElement> CIM_LogicalElementContainer;

		// static const declarations
		static const string CLASS_NAME;
		static const string CLASS_URI;
		static const string CLASS_NS;
		static const string CLASS_NS_PREFIX;

		// class fields
		// Class Constructor
		CIM_LogicalElement(
			const string& objName = CIM_LogicalElement::CLASS_NAME,
			const string& uri = CIM_LogicalElement::CLASS_URI,
			const string& ns = CIM_LogicalElement::CLASS_NS,
			const string& nsPrefix = CIM_LogicalElement::CLASS_NS_PREFIX);

		// Class Destructor
		virtual ~CIM_LogicalElement(){}

		// This function appends a serialization of this instance to the given node.
		virtual void SerializeMembers(XMLElement& node) const;

		// This function returns the selector set of this instance.
		virtual NameValuePairs GetSelectorsList() const;

		// This function sets a field value according to the given node.
		virtual void SetValue(const XMLElement& node);

	};
}
#endif
