/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef AUTOBOOTUI_H
#define AUTOBOOTUI_H

#include <QObject>
#include <QWidget>

#include "titlelabel.h"
#include "hoverwidget.h"
#include "addbutton.h"
#include "switchwidget.h"
#include "settinggroup.h"
#include "ukccframe.h"

class AutoBootUi : public QWidget
{
    Q_OBJECT
public:
    explicit AutoBootUi(QWidget *parent = nullptr);
    void initUi();
    void resetUi();

    SettingGroup *getAutobootWidget()
    {
        return mAutobootWidget;
    }

    UkccFrame *getAddWidget()
    {
        return mAddWidget;
    }

    AddButton *getAddBtn()
    {
        return mAddBtn;
    }

private:
    SettingGroup *mAutobootWidget = nullptr;
    UkccFrame *mAddWidget = nullptr;
    AddButton *mAddBtn = nullptr;

};

#endif // AUTOBOOTUI_H
