/*
Copyright (c) 2003, Dinesh Nadarajah
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice, 
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice, 
      this list of conditions and the following disclaimer in the documentation and/or 
      other materials provided with the distribution.
    * Neither the name of the author nor the names of its contributors 
      may be used to endorse or promote products derived from this software 
      without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED 
TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef __TA_XIM_H__
#define __TA_XIM_H__

#include "gtkintl.h"
#include <gtk/gtkimmodule.h>
#include <gdk/gdkkeysyms.h>
#include <string.h>

#define		TAMIL		1
#define		ENGLISH		0

void gtk_im_context_ta_tsc_xim_register_type (GTypeModule *type_module);
void gtk_im_context_ta_tsc_xim_shutdown (void);
void gtk_im_context_ta_tsc_xim_class_init (GtkIMContextClass *class);
void gtk_im_context_ta_tsc_xim_init (GtkIMContext *im_context_xim);
gboolean gtk_im_context_ta_tsc_xim_filter_keypress (GtkIMContext *context,
				                    GdkEventKey  *event);
gboolean process_tscii_tamil99(GtkIMContext *context, GdkEventKey *event);
void send_1_unicode_value(GtkIMContext *context, guint32 u1);
void send_2_unicode_value(GtkIMContext *context, guint32 u1, guint32 u2);
void send_3_unicode_value(GtkIMContext *context, guint32 u1, guint32 u2, guint32 u3);



#endif /* __TA_XIM_H__ */
