/* ====================================================================
 * Copyright (c) 2009       Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "TextStatusFilter.h"


bool TextStatusFilter::test( StatusId statusId ) const
{
  std::set<StatusId>::const_iterator it = _filter.find(statusId);
  if( it != _filter.end() )
    return true;
  else
    return false;
}

void TextStatusFilter::set( StatusId statusId )
{
  _filter.insert(statusId);
}

void TextStatusFilter::clear( StatusId statusId )
{
  _filter.erase(statusId);
}

bool TextStatusFilter::isDefault() const
{
  TextStatusFilter defFilter = getDefaultFilter();
  return std::equal( _filter.begin(), _filter.end(),
    defFilter._filter.begin() );
}

const std::set<StatusId>& TextStatusFilter::getStatusIds() const
{
  return _filter;
}

TextStatusFilter TextStatusFilter::getDefaultFilter()
{
  TextStatusFilter filter;
  filter.set(StatusUnversioned);
  filter.set(StatusAdded);
  filter.set(StatusModified);
  filter.set(StatusDeleted);
  filter.set(StatusMerged);
  filter.set(StatusReplaced);
  filter.set(StatusMissing);
  filter.set(StatusConflicted);
  filter.set(StatusObstructed);
  filter.set(StatusExternal);
  return filter;
}
