import unittest

import numpy as np
from spglib import get_symmetry
from vasp import read_vasp_from_strings

Al222 = """Al
   1.0
     8.0786564361761641    0.0000000000000000    0.0000000000000000
     0.0000000000000000    8.0786564361761641    0.0000000000000000
     0.0000000000000000    0.0000000000000000    8.0786564361761641
  32
Direct
  0.0000000000000000  0.0000000000000000  0.0000000000000000
  0.5000000000000000  0.0000000000000000  0.0000000000000000
  0.0000000000000000  0.5000000000000000  0.0000000000000000
  0.5000000000000000  0.5000000000000000  0.0000000000000000
  0.0000000000000000  0.0000000000000000  0.5000000000000000
  0.5000000000000000  0.0000000000000000  0.5000000000000000
  0.0000000000000000  0.5000000000000000  0.5000000000000000
  0.5000000000000000  0.5000000000000000  0.5000000000000000
  0.0000000000000000  0.2500000000000000  0.2500000000000000
  0.5000000000000000  0.2500000000000000  0.2500000000000000
  0.0000000000000000  0.7500000000000000  0.2500000000000000
  0.5000000000000000  0.7500000000000000  0.2500000000000000
  0.0000000000000000  0.2500000000000000  0.7500000000000000
  0.5000000000000000  0.2500000000000000  0.7500000000000000
  0.0000000000000000  0.7500000000000000  0.7500000000000000
  0.5000000000000000  0.7500000000000000  0.7500000000000000
  0.2500000000000000  0.0000000000000000  0.2500000000000000
  0.7500000000000000  0.0000000000000000  0.2500000000000000
  0.2500000000000000  0.5000000000000000  0.2500000000000000
  0.7500000000000000  0.5000000000000000  0.2500000000000000
  0.2500000000000000  0.0000000000000000  0.7500000000000000
  0.7500000000000000  0.0000000000000000  0.7500000000000000
  0.2500000000000000  0.5000000000000000  0.7500000000000000
  0.7500000000000000  0.5000000000000000  0.7500000000000000
  0.2500000000000000  0.2500000000000000  0.0000000000000000
  0.7500000000000000  0.2500000000000000  0.0000000000000000
  0.2500000000000000  0.7500000000000000  0.0000000000000000
  0.7500000000000000  0.7500000000000000  0.0000000000000000
  0.2500000000000000  0.2500000000000000  0.5000000000000000
  0.7500000000000000  0.2500000000000000  0.5000000000000000
  0.2500000000000000  0.7500000000000000  0.5000000000000000
  0.7500000000000000  0.7500000000000000  0.5000000000000000"""

sym_ops_str = """ 1  0  0  0  1  0  0  0  1    0.0000000    0.0000000    0.0000000
-1  0  0  0 -1  0  0  0 -1    0.0000000    0.0000000    0.0000000
 0  0 -1  0  1  0  1  0  0    0.0000000    0.0000000    0.0000000
 0  0  1  0 -1  0 -1  0  0    0.0000000    0.0000000    0.0000000
-1  0  0  0  1  0  0  0 -1    0.0000000    0.0000000    0.0000000
 1  0  0  0 -1  0  0  0  1    0.0000000    0.0000000    0.0000000
 0  0  1  0  1  0 -1  0  0    0.0000000    0.0000000    0.0000000
 0  0 -1  0 -1  0  1  0  0    0.0000000    0.0000000    0.0000000
 1  0  0  0 -1  0  0  0 -1    0.0000000    0.0000000    0.0000000
-1  0  0  0  1  0  0  0  1    0.0000000    0.0000000    0.0000000
 0  0 -1  0 -1  0 -1  0  0    0.0000000    0.0000000    0.0000000
 0  0  1  0  1  0  1  0  0    0.0000000    0.0000000    0.0000000
-1  0  0  0 -1  0  0  0  1    0.0000000    0.0000000    0.0000000
 1  0  0  0  1  0  0  0 -1    0.0000000    0.0000000    0.0000000
 0  0  1  0 -1  0  1  0  0    0.0000000    0.0000000    0.0000000
 0  0 -1  0  1  0 -1  0  0    0.0000000    0.0000000    0.0000000
 0  1  0  0  0  1  1  0  0    0.0000000    0.0000000    0.0000000
 0 -1  0  0  0 -1 -1  0  0    0.0000000    0.0000000    0.0000000
 0  1  0  1  0  0  0  0 -1    0.0000000    0.0000000    0.0000000
 0 -1  0 -1  0  0  0  0  1    0.0000000    0.0000000    0.0000000
 0  1  0  0  0 -1 -1  0  0    0.0000000    0.0000000    0.0000000
 0 -1  0  0  0  1  1  0  0    0.0000000    0.0000000    0.0000000
 0  1  0 -1  0  0  0  0  1    0.0000000    0.0000000    0.0000000
 0 -1  0  1  0  0  0  0 -1    0.0000000    0.0000000    0.0000000
 0 -1  0  0  0 -1  1  0  0    0.0000000    0.0000000    0.0000000
 0  1  0  0  0  1 -1  0  0    0.0000000    0.0000000    0.0000000
 0 -1  0 -1  0  0  0  0 -1    0.0000000    0.0000000    0.0000000
 0  1  0  1  0  0  0  0  1    0.0000000    0.0000000    0.0000000
 0 -1  0  0  0  1 -1  0  0    0.0000000    0.0000000    0.0000000
 0  1  0  0  0 -1  1  0  0    0.0000000    0.0000000    0.0000000
 0 -1  0  1  0  0  0  0  1    0.0000000    0.0000000    0.0000000
 0  1  0 -1  0  0  0  0 -1    0.0000000    0.0000000    0.0000000
 0  0  1  1  0  0  0  1  0    0.0000000    0.0000000    0.0000000
 0  0 -1 -1  0  0  0 -1  0    0.0000000    0.0000000    0.0000000
 1  0  0  0  0 -1  0  1  0    0.0000000    0.0000000    0.0000000
-1  0  0  0  0  1  0 -1  0    0.0000000    0.0000000    0.0000000
 0  0 -1 -1  0  0  0  1  0    0.0000000    0.0000000    0.0000000
 0  0  1  1  0  0  0 -1  0    0.0000000    0.0000000    0.0000000
-1  0  0  0  0  1  0  1  0    0.0000000    0.0000000    0.0000000
 1  0  0  0  0 -1  0 -1  0    0.0000000    0.0000000    0.0000000
 0  0 -1  1  0  0  0 -1  0    0.0000000    0.0000000    0.0000000
 0  0  1 -1  0  0  0  1  0    0.0000000    0.0000000    0.0000000
-1  0  0  0  0 -1  0 -1  0    0.0000000    0.0000000    0.0000000
 1  0  0  0  0  1  0  1  0    0.0000000    0.0000000    0.0000000
 0  0  1 -1  0  0  0 -1  0    0.0000000    0.0000000    0.0000000
 0  0 -1  1  0  0  0  1  0    0.0000000    0.0000000    0.0000000
 1  0  0  0  0  1  0 -1  0    0.0000000    0.0000000    0.0000000
-1  0  0  0  0 -1  0  1  0    0.0000000    0.0000000    0.0000000
 1  0  0  0  1  0  0  0  1    0.7500000    0.7500000    0.0000000
-1  0  0  0 -1  0  0  0 -1    0.7500000    0.7500000    0.0000000
 0  0 -1  0  1  0  1  0  0    0.7500000    0.7500000    0.0000000
 0  0  1  0 -1  0 -1  0  0    0.7500000    0.7500000    0.0000000
-1  0  0  0  1  0  0  0 -1    0.7500000    0.7500000    0.0000000
 1  0  0  0 -1  0  0  0  1    0.7500000    0.7500000    0.0000000
 0  0  1  0  1  0 -1  0  0    0.7500000    0.7500000    0.0000000
 0  0 -1  0 -1  0  1  0  0    0.7500000    0.7500000    0.0000000
 1  0  0  0 -1  0  0  0 -1    0.7500000    0.7500000    0.0000000
-1  0  0  0  1  0  0  0  1    0.7500000    0.7500000    0.0000000
 0  0 -1  0 -1  0 -1  0  0    0.7500000    0.7500000    0.0000000
 0  0  1  0  1  0  1  0  0    0.7500000    0.7500000    0.0000000
-1  0  0  0 -1  0  0  0  1    0.7500000    0.7500000    0.0000000
 1  0  0  0  1  0  0  0 -1    0.7500000    0.7500000    0.0000000
 0  0  1  0 -1  0  1  0  0    0.7500000    0.7500000    0.0000000
 0  0 -1  0  1  0 -1  0  0    0.7500000    0.7500000    0.0000000
 0  1  0  0  0  1  1  0  0    0.7500000    0.7500000    0.0000000
 0 -1  0  0  0 -1 -1  0  0    0.7500000    0.7500000    0.0000000
 0  1  0  1  0  0  0  0 -1    0.7500000    0.7500000    0.0000000
 0 -1  0 -1  0  0  0  0  1    0.7500000    0.7500000    0.0000000
 0  1  0  0  0 -1 -1  0  0    0.7500000    0.7500000    0.0000000
 0 -1  0  0  0  1  1  0  0    0.7500000    0.7500000    0.0000000
 0  1  0 -1  0  0  0  0  1    0.7500000    0.7500000    0.0000000
 0 -1  0  1  0  0  0  0 -1    0.7500000    0.7500000    0.0000000
 0 -1  0  0  0 -1  1  0  0    0.7500000    0.7500000    0.0000000
 0  1  0  0  0  1 -1  0  0    0.7500000    0.7500000    0.0000000
 0 -1  0 -1  0  0  0  0 -1    0.7500000    0.7500000    0.0000000
 0  1  0  1  0  0  0  0  1    0.7500000    0.7500000    0.0000000
 0 -1  0  0  0  1 -1  0  0    0.7500000    0.7500000    0.0000000
 0  1  0  0  0 -1  1  0  0    0.7500000    0.7500000    0.0000000
 0 -1  0  1  0  0  0  0  1    0.7500000    0.7500000    0.0000000
 0  1  0 -1  0  0  0  0 -1    0.7500000    0.7500000    0.0000000
 0  0  1  1  0  0  0  1  0    0.7500000    0.7500000    0.0000000
 0  0 -1 -1  0  0  0 -1  0    0.7500000    0.7500000    0.0000000
 1  0  0  0  0 -1  0  1  0    0.7500000    0.7500000    0.0000000
-1  0  0  0  0  1  0 -1  0    0.7500000    0.7500000    0.0000000
 0  0 -1 -1  0  0  0  1  0    0.7500000    0.7500000    0.0000000
 0  0  1  1  0  0  0 -1  0    0.7500000    0.7500000    0.0000000
-1  0  0  0  0  1  0  1  0    0.7500000    0.7500000    0.0000000
 1  0  0  0  0 -1  0 -1  0    0.7500000    0.7500000    0.0000000
 0  0 -1  1  0  0  0 -1  0    0.7500000    0.7500000    0.0000000
 0  0  1 -1  0  0  0  1  0    0.7500000    0.7500000    0.0000000
-1  0  0  0  0 -1  0 -1  0    0.7500000    0.7500000    0.0000000
 1  0  0  0  0  1  0  1  0    0.7500000    0.7500000    0.0000000
 0  0  1 -1  0  0  0 -1  0    0.7500000    0.7500000    0.0000000
 0  0 -1  1  0  0  0  1  0    0.7500000    0.7500000    0.0000000
 1  0  0  0  0  1  0 -1  0    0.7500000    0.7500000    0.0000000
-1  0  0  0  0 -1  0  1  0    0.7500000    0.7500000    0.0000000
 1  0  0  0  1  0  0  0  1    0.5000000    0.5000000    0.0000000
-1  0  0  0 -1  0  0  0 -1    0.5000000    0.5000000    0.0000000
 0  0 -1  0  1  0  1  0  0    0.5000000    0.5000000    0.0000000
 0  0  1  0 -1  0 -1  0  0    0.5000000    0.5000000    0.0000000
-1  0  0  0  1  0  0  0 -1    0.5000000    0.5000000    0.0000000
 1  0  0  0 -1  0  0  0  1    0.5000000    0.5000000    0.0000000
 0  0  1  0  1  0 -1  0  0    0.5000000    0.5000000    0.0000000
 0  0 -1  0 -1  0  1  0  0    0.5000000    0.5000000    0.0000000
 1  0  0  0 -1  0  0  0 -1    0.5000000    0.5000000    0.0000000
-1  0  0  0  1  0  0  0  1    0.5000000    0.5000000    0.0000000
 0  0 -1  0 -1  0 -1  0  0    0.5000000    0.5000000    0.0000000
 0  0  1  0  1  0  1  0  0    0.5000000    0.5000000    0.0000000
-1  0  0  0 -1  0  0  0  1    0.5000000    0.5000000    0.0000000
 1  0  0  0  1  0  0  0 -1    0.5000000    0.5000000    0.0000000
 0  0  1  0 -1  0  1  0  0    0.5000000    0.5000000    0.0000000
 0  0 -1  0  1  0 -1  0  0    0.5000000    0.5000000    0.0000000
 0  1  0  0  0  1  1  0  0    0.5000000    0.5000000    0.0000000
 0 -1  0  0  0 -1 -1  0  0    0.5000000    0.5000000    0.0000000
 0  1  0  1  0  0  0  0 -1    0.5000000    0.5000000    0.0000000
 0 -1  0 -1  0  0  0  0  1    0.5000000    0.5000000    0.0000000
 0  1  0  0  0 -1 -1  0  0    0.5000000    0.5000000    0.0000000
 0 -1  0  0  0  1  1  0  0    0.5000000    0.5000000    0.0000000
 0  1  0 -1  0  0  0  0  1    0.5000000    0.5000000    0.0000000
 0 -1  0  1  0  0  0  0 -1    0.5000000    0.5000000    0.0000000
 0 -1  0  0  0 -1  1  0  0    0.5000000    0.5000000    0.0000000
 0  1  0  0  0  1 -1  0  0    0.5000000    0.5000000    0.0000000
 0 -1  0 -1  0  0  0  0 -1    0.5000000    0.5000000    0.0000000
 0  1  0  1  0  0  0  0  1    0.5000000    0.5000000    0.0000000
 0 -1  0  0  0  1 -1  0  0    0.5000000    0.5000000    0.0000000
 0  1  0  0  0 -1  1  0  0    0.5000000    0.5000000    0.0000000
 0 -1  0  1  0  0  0  0  1    0.5000000    0.5000000    0.0000000
 0  1  0 -1  0  0  0  0 -1    0.5000000    0.5000000    0.0000000
 0  0  1  1  0  0  0  1  0    0.5000000    0.5000000    0.0000000
 0  0 -1 -1  0  0  0 -1  0    0.5000000    0.5000000    0.0000000
 1  0  0  0  0 -1  0  1  0    0.5000000    0.5000000    0.0000000
-1  0  0  0  0  1  0 -1  0    0.5000000    0.5000000    0.0000000
 0  0 -1 -1  0  0  0  1  0    0.5000000    0.5000000    0.0000000
 0  0  1  1  0  0  0 -1  0    0.5000000    0.5000000    0.0000000
-1  0  0  0  0  1  0  1  0    0.5000000    0.5000000    0.0000000
 1  0  0  0  0 -1  0 -1  0    0.5000000    0.5000000    0.0000000
 0  0 -1  1  0  0  0 -1  0    0.5000000    0.5000000    0.0000000
 0  0  1 -1  0  0  0  1  0    0.5000000    0.5000000    0.0000000
-1  0  0  0  0 -1  0 -1  0    0.5000000    0.5000000    0.0000000
 1  0  0  0  0  1  0  1  0    0.5000000    0.5000000    0.0000000
 0  0  1 -1  0  0  0 -1  0    0.5000000    0.5000000    0.0000000
 0  0 -1  1  0  0  0  1  0    0.5000000    0.5000000    0.0000000
 1  0  0  0  0  1  0 -1  0    0.5000000    0.5000000    0.0000000
-1  0  0  0  0 -1  0  1  0    0.5000000    0.5000000    0.0000000
 1  0  0  0  1  0  0  0  1    0.2500000    0.2500000    0.0000000
-1  0  0  0 -1  0  0  0 -1    0.2500000    0.2500000    0.0000000
 0  0 -1  0  1  0  1  0  0    0.2500000    0.2500000    0.0000000
 0  0  1  0 -1  0 -1  0  0    0.2500000    0.2500000    0.0000000
-1  0  0  0  1  0  0  0 -1    0.2500000    0.2500000    0.0000000
 1  0  0  0 -1  0  0  0  1    0.2500000    0.2500000    0.0000000
 0  0  1  0  1  0 -1  0  0    0.2500000    0.2500000    0.0000000
 0  0 -1  0 -1  0  1  0  0    0.2500000    0.2500000    0.0000000
 1  0  0  0 -1  0  0  0 -1    0.2500000    0.2500000    0.0000000
-1  0  0  0  1  0  0  0  1    0.2500000    0.2500000    0.0000000
 0  0 -1  0 -1  0 -1  0  0    0.2500000    0.2500000    0.0000000
 0  0  1  0  1  0  1  0  0    0.2500000    0.2500000    0.0000000
-1  0  0  0 -1  0  0  0  1    0.2500000    0.2500000    0.0000000
 1  0  0  0  1  0  0  0 -1    0.2500000    0.2500000    0.0000000
 0  0  1  0 -1  0  1  0  0    0.2500000    0.2500000    0.0000000
 0  0 -1  0  1  0 -1  0  0    0.2500000    0.2500000    0.0000000
 0  1  0  0  0  1  1  0  0    0.2500000    0.2500000    0.0000000
 0 -1  0  0  0 -1 -1  0  0    0.2500000    0.2500000    0.0000000
 0  1  0  1  0  0  0  0 -1    0.2500000    0.2500000    0.0000000
 0 -1  0 -1  0  0  0  0  1    0.2500000    0.2500000    0.0000000
 0  1  0  0  0 -1 -1  0  0    0.2500000    0.2500000    0.0000000
 0 -1  0  0  0  1  1  0  0    0.2500000    0.2500000    0.0000000
 0  1  0 -1  0  0  0  0  1    0.2500000    0.2500000    0.0000000
 0 -1  0  1  0  0  0  0 -1    0.2500000    0.2500000    0.0000000
 0 -1  0  0  0 -1  1  0  0    0.2500000    0.2500000    0.0000000
 0  1  0  0  0  1 -1  0  0    0.2500000    0.2500000    0.0000000
 0 -1  0 -1  0  0  0  0 -1    0.2500000    0.2500000    0.0000000
 0  1  0  1  0  0  0  0  1    0.2500000    0.2500000    0.0000000
 0 -1  0  0  0  1 -1  0  0    0.2500000    0.2500000    0.0000000
 0  1  0  0  0 -1  1  0  0    0.2500000    0.2500000    0.0000000
 0 -1  0  1  0  0  0  0  1    0.2500000    0.2500000    0.0000000
 0  1  0 -1  0  0  0  0 -1    0.2500000    0.2500000    0.0000000
 0  0  1  1  0  0  0  1  0    0.2500000    0.2500000    0.0000000
 0  0 -1 -1  0  0  0 -1  0    0.2500000    0.2500000    0.0000000
 1  0  0  0  0 -1  0  1  0    0.2500000    0.2500000    0.0000000
-1  0  0  0  0  1  0 -1  0    0.2500000    0.2500000    0.0000000
 0  0 -1 -1  0  0  0  1  0    0.2500000    0.2500000    0.0000000
 0  0  1  1  0  0  0 -1  0    0.2500000    0.2500000    0.0000000
-1  0  0  0  0  1  0  1  0    0.2500000    0.2500000    0.0000000
 1  0  0  0  0 -1  0 -1  0    0.2500000    0.2500000    0.0000000
 0  0 -1  1  0  0  0 -1  0    0.2500000    0.2500000    0.0000000
 0  0  1 -1  0  0  0  1  0    0.2500000    0.2500000    0.0000000
-1  0  0  0  0 -1  0 -1  0    0.2500000    0.2500000    0.0000000
 1  0  0  0  0  1  0  1  0    0.2500000    0.2500000    0.0000000
 0  0  1 -1  0  0  0 -1  0    0.2500000    0.2500000    0.0000000
 0  0 -1  1  0  0  0  1  0    0.2500000    0.2500000    0.0000000
 1  0  0  0  0  1  0 -1  0    0.2500000    0.2500000    0.0000000
-1  0  0  0  0 -1  0  1  0    0.2500000    0.2500000    0.0000000
 1  0  0  0  1  0  0  0  1    0.2500000    0.0000000    0.7500000
-1  0  0  0 -1  0  0  0 -1    0.2500000    0.0000000    0.7500000
 0  0 -1  0  1  0  1  0  0    0.2500000    0.0000000    0.7500000
 0  0  1  0 -1  0 -1  0  0    0.2500000    0.0000000    0.7500000
-1  0  0  0  1  0  0  0 -1    0.2500000    0.0000000    0.7500000
 1  0  0  0 -1  0  0  0  1    0.2500000    0.0000000    0.7500000
 0  0  1  0  1  0 -1  0  0    0.2500000    0.0000000    0.7500000
 0  0 -1  0 -1  0  1  0  0    0.2500000    0.0000000    0.7500000
 1  0  0  0 -1  0  0  0 -1    0.2500000    0.0000000    0.7500000
-1  0  0  0  1  0  0  0  1    0.2500000    0.0000000    0.7500000
 0  0 -1  0 -1  0 -1  0  0    0.2500000    0.0000000    0.7500000
 0  0  1  0  1  0  1  0  0    0.2500000    0.0000000    0.7500000
-1  0  0  0 -1  0  0  0  1    0.2500000    0.0000000    0.7500000
 1  0  0  0  1  0  0  0 -1    0.2500000    0.0000000    0.7500000
 0  0  1  0 -1  0  1  0  0    0.2500000    0.0000000    0.7500000
 0  0 -1  0  1  0 -1  0  0    0.2500000    0.0000000    0.7500000
 0  1  0  0  0  1  1  0  0    0.2500000    0.0000000    0.7500000
 0 -1  0  0  0 -1 -1  0  0    0.2500000    0.0000000    0.7500000
 0  1  0  1  0  0  0  0 -1    0.2500000    0.0000000    0.7500000
 0 -1  0 -1  0  0  0  0  1    0.2500000    0.0000000    0.7500000
 0  1  0  0  0 -1 -1  0  0    0.2500000    0.0000000    0.7500000
 0 -1  0  0  0  1  1  0  0    0.2500000    0.0000000    0.7500000
 0  1  0 -1  0  0  0  0  1    0.2500000    0.0000000    0.7500000
 0 -1  0  1  0  0  0  0 -1    0.2500000    0.0000000    0.7500000
 0 -1  0  0  0 -1  1  0  0    0.2500000    0.0000000    0.7500000
 0  1  0  0  0  1 -1  0  0    0.2500000    0.0000000    0.7500000
 0 -1  0 -1  0  0  0  0 -1    0.2500000    0.0000000    0.7500000
 0  1  0  1  0  0  0  0  1    0.2500000    0.0000000    0.7500000
 0 -1  0  0  0  1 -1  0  0    0.2500000    0.0000000    0.7500000
 0  1  0  0  0 -1  1  0  0    0.2500000    0.0000000    0.7500000
 0 -1  0  1  0  0  0  0  1    0.2500000    0.0000000    0.7500000
 0  1  0 -1  0  0  0  0 -1    0.2500000    0.0000000    0.7500000
 0  0  1  1  0  0  0  1  0    0.2500000    0.0000000    0.7500000
 0  0 -1 -1  0  0  0 -1  0    0.2500000    0.0000000    0.7500000
 1  0  0  0  0 -1  0  1  0    0.2500000    0.0000000    0.7500000
-1  0  0  0  0  1  0 -1  0    0.2500000    0.0000000    0.7500000
 0  0 -1 -1  0  0  0  1  0    0.2500000    0.0000000    0.7500000
 0  0  1  1  0  0  0 -1  0    0.2500000    0.0000000    0.7500000
-1  0  0  0  0  1  0  1  0    0.2500000    0.0000000    0.7500000
 1  0  0  0  0 -1  0 -1  0    0.2500000    0.0000000    0.7500000
 0  0 -1  1  0  0  0 -1  0    0.2500000    0.0000000    0.7500000
 0  0  1 -1  0  0  0  1  0    0.2500000    0.0000000    0.7500000
-1  0  0  0  0 -1  0 -1  0    0.2500000    0.0000000    0.7500000
 1  0  0  0  0  1  0  1  0    0.2500000    0.0000000    0.7500000
 0  0  1 -1  0  0  0 -1  0    0.2500000    0.0000000    0.7500000
 0  0 -1  1  0  0  0  1  0    0.2500000    0.0000000    0.7500000
 1  0  0  0  0  1  0 -1  0    0.2500000    0.0000000    0.7500000
-1  0  0  0  0 -1  0  1  0    0.2500000    0.0000000    0.7500000
 1  0  0  0  1  0  0  0  1    0.0000000    0.7500000    0.7500000
-1  0  0  0 -1  0  0  0 -1    0.0000000    0.7500000    0.7500000
 0  0 -1  0  1  0  1  0  0    0.0000000    0.7500000    0.7500000
 0  0  1  0 -1  0 -1  0  0    0.0000000    0.7500000    0.7500000
-1  0  0  0  1  0  0  0 -1    0.0000000    0.7500000    0.7500000
 1  0  0  0 -1  0  0  0  1    0.0000000    0.7500000    0.7500000
 0  0  1  0  1  0 -1  0  0    0.0000000    0.7500000    0.7500000
 0  0 -1  0 -1  0  1  0  0    0.0000000    0.7500000    0.7500000
 1  0  0  0 -1  0  0  0 -1    0.0000000    0.7500000    0.7500000
-1  0  0  0  1  0  0  0  1    0.0000000    0.7500000    0.7500000
 0  0 -1  0 -1  0 -1  0  0    0.0000000    0.7500000    0.7500000
 0  0  1  0  1  0  1  0  0    0.0000000    0.7500000    0.7500000
-1  0  0  0 -1  0  0  0  1    0.0000000    0.7500000    0.7500000
 1  0  0  0  1  0  0  0 -1    0.0000000    0.7500000    0.7500000
 0  0  1  0 -1  0  1  0  0    0.0000000    0.7500000    0.7500000
 0  0 -1  0  1  0 -1  0  0    0.0000000    0.7500000    0.7500000
 0  1  0  0  0  1  1  0  0    0.0000000    0.7500000    0.7500000
 0 -1  0  0  0 -1 -1  0  0    0.0000000    0.7500000    0.7500000
 0  1  0  1  0  0  0  0 -1    0.0000000    0.7500000    0.7500000
 0 -1  0 -1  0  0  0  0  1    0.0000000    0.7500000    0.7500000
 0  1  0  0  0 -1 -1  0  0    0.0000000    0.7500000    0.7500000
 0 -1  0  0  0  1  1  0  0    0.0000000    0.7500000    0.7500000
 0  1  0 -1  0  0  0  0  1    0.0000000    0.7500000    0.7500000
 0 -1  0  1  0  0  0  0 -1    0.0000000    0.7500000    0.7500000
 0 -1  0  0  0 -1  1  0  0    0.0000000    0.7500000    0.7500000
 0  1  0  0  0  1 -1  0  0    0.0000000    0.7500000    0.7500000
 0 -1  0 -1  0  0  0  0 -1    0.0000000    0.7500000    0.7500000
 0  1  0  1  0  0  0  0  1    0.0000000    0.7500000    0.7500000
 0 -1  0  0  0  1 -1  0  0    0.0000000    0.7500000    0.7500000
 0  1  0  0  0 -1  1  0  0    0.0000000    0.7500000    0.7500000
 0 -1  0  1  0  0  0  0  1    0.0000000    0.7500000    0.7500000
 0  1  0 -1  0  0  0  0 -1    0.0000000    0.7500000    0.7500000
 0  0  1  1  0  0  0  1  0    0.0000000    0.7500000    0.7500000
 0  0 -1 -1  0  0  0 -1  0    0.0000000    0.7500000    0.7500000
 1  0  0  0  0 -1  0  1  0    0.0000000    0.7500000    0.7500000
-1  0  0  0  0  1  0 -1  0    0.0000000    0.7500000    0.7500000
 0  0 -1 -1  0  0  0  1  0    0.0000000    0.7500000    0.7500000
 0  0  1  1  0  0  0 -1  0    0.0000000    0.7500000    0.7500000
-1  0  0  0  0  1  0  1  0    0.0000000    0.7500000    0.7500000
 1  0  0  0  0 -1  0 -1  0    0.0000000    0.7500000    0.7500000
 0  0 -1  1  0  0  0 -1  0    0.0000000    0.7500000    0.7500000
 0  0  1 -1  0  0  0  1  0    0.0000000    0.7500000    0.7500000
-1  0  0  0  0 -1  0 -1  0    0.0000000    0.7500000    0.7500000
 1  0  0  0  0  1  0  1  0    0.0000000    0.7500000    0.7500000
 0  0  1 -1  0  0  0 -1  0    0.0000000    0.7500000    0.7500000
 0  0 -1  1  0  0  0  1  0    0.0000000    0.7500000    0.7500000
 1  0  0  0  0  1  0 -1  0    0.0000000    0.7500000    0.7500000
-1  0  0  0  0 -1  0  1  0    0.0000000    0.7500000    0.7500000
 1  0  0  0  1  0  0  0  1    0.7500000    0.5000000    0.7500000
-1  0  0  0 -1  0  0  0 -1    0.7500000    0.5000000    0.7500000
 0  0 -1  0  1  0  1  0  0    0.7500000    0.5000000    0.7500000
 0  0  1  0 -1  0 -1  0  0    0.7500000    0.5000000    0.7500000
-1  0  0  0  1  0  0  0 -1    0.7500000    0.5000000    0.7500000
 1  0  0  0 -1  0  0  0  1    0.7500000    0.5000000    0.7500000
 0  0  1  0  1  0 -1  0  0    0.7500000    0.5000000    0.7500000
 0  0 -1  0 -1  0  1  0  0    0.7500000    0.5000000    0.7500000
 1  0  0  0 -1  0  0  0 -1    0.7500000    0.5000000    0.7500000
-1  0  0  0  1  0  0  0  1    0.7500000    0.5000000    0.7500000
 0  0 -1  0 -1  0 -1  0  0    0.7500000    0.5000000    0.7500000
 0  0  1  0  1  0  1  0  0    0.7500000    0.5000000    0.7500000
-1  0  0  0 -1  0  0  0  1    0.7500000    0.5000000    0.7500000
 1  0  0  0  1  0  0  0 -1    0.7500000    0.5000000    0.7500000
 0  0  1  0 -1  0  1  0  0    0.7500000    0.5000000    0.7500000
 0  0 -1  0  1  0 -1  0  0    0.7500000    0.5000000    0.7500000
 0  1  0  0  0  1  1  0  0    0.7500000    0.5000000    0.7500000
 0 -1  0  0  0 -1 -1  0  0    0.7500000    0.5000000    0.7500000
 0  1  0  1  0  0  0  0 -1    0.7500000    0.5000000    0.7500000
 0 -1  0 -1  0  0  0  0  1    0.7500000    0.5000000    0.7500000
 0  1  0  0  0 -1 -1  0  0    0.7500000    0.5000000    0.7500000
 0 -1  0  0  0  1  1  0  0    0.7500000    0.5000000    0.7500000
 0  1  0 -1  0  0  0  0  1    0.7500000    0.5000000    0.7500000
 0 -1  0  1  0  0  0  0 -1    0.7500000    0.5000000    0.7500000
 0 -1  0  0  0 -1  1  0  0    0.7500000    0.5000000    0.7500000
 0  1  0  0  0  1 -1  0  0    0.7500000    0.5000000    0.7500000
 0 -1  0 -1  0  0  0  0 -1    0.7500000    0.5000000    0.7500000
 0  1  0  1  0  0  0  0  1    0.7500000    0.5000000    0.7500000
 0 -1  0  0  0  1 -1  0  0    0.7500000    0.5000000    0.7500000
 0  1  0  0  0 -1  1  0  0    0.7500000    0.5000000    0.7500000
 0 -1  0  1  0  0  0  0  1    0.7500000    0.5000000    0.7500000
 0  1  0 -1  0  0  0  0 -1    0.7500000    0.5000000    0.7500000
 0  0  1  1  0  0  0  1  0    0.7500000    0.5000000    0.7500000
 0  0 -1 -1  0  0  0 -1  0    0.7500000    0.5000000    0.7500000
 1  0  0  0  0 -1  0  1  0    0.7500000    0.5000000    0.7500000
-1  0  0  0  0  1  0 -1  0    0.7500000    0.5000000    0.7500000
 0  0 -1 -1  0  0  0  1  0    0.7500000    0.5000000    0.7500000
 0  0  1  1  0  0  0 -1  0    0.7500000    0.5000000    0.7500000
-1  0  0  0  0  1  0  1  0    0.7500000    0.5000000    0.7500000
 1  0  0  0  0 -1  0 -1  0    0.7500000    0.5000000    0.7500000
 0  0 -1  1  0  0  0 -1  0    0.7500000    0.5000000    0.7500000
 0  0  1 -1  0  0  0  1  0    0.7500000    0.5000000    0.7500000
-1  0  0  0  0 -1  0 -1  0    0.7500000    0.5000000    0.7500000
 1  0  0  0  0  1  0  1  0    0.7500000    0.5000000    0.7500000
 0  0  1 -1  0  0  0 -1  0    0.7500000    0.5000000    0.7500000
 0  0 -1  1  0  0  0  1  0    0.7500000    0.5000000    0.7500000
 1  0  0  0  0  1  0 -1  0    0.7500000    0.5000000    0.7500000
-1  0  0  0  0 -1  0  1  0    0.7500000    0.5000000    0.7500000
 1  0  0  0  1  0  0  0  1    0.5000000    0.2500000    0.7500000
-1  0  0  0 -1  0  0  0 -1    0.5000000    0.2500000    0.7500000
 0  0 -1  0  1  0  1  0  0    0.5000000    0.2500000    0.7500000
 0  0  1  0 -1  0 -1  0  0    0.5000000    0.2500000    0.7500000
-1  0  0  0  1  0  0  0 -1    0.5000000    0.2500000    0.7500000
 1  0  0  0 -1  0  0  0  1    0.5000000    0.2500000    0.7500000
 0  0  1  0  1  0 -1  0  0    0.5000000    0.2500000    0.7500000
 0  0 -1  0 -1  0  1  0  0    0.5000000    0.2500000    0.7500000
 1  0  0  0 -1  0  0  0 -1    0.5000000    0.2500000    0.7500000
-1  0  0  0  1  0  0  0  1    0.5000000    0.2500000    0.7500000
 0  0 -1  0 -1  0 -1  0  0    0.5000000    0.2500000    0.7500000
 0  0  1  0  1  0  1  0  0    0.5000000    0.2500000    0.7500000
-1  0  0  0 -1  0  0  0  1    0.5000000    0.2500000    0.7500000
 1  0  0  0  1  0  0  0 -1    0.5000000    0.2500000    0.7500000
 0  0  1  0 -1  0  1  0  0    0.5000000    0.2500000    0.7500000
 0  0 -1  0  1  0 -1  0  0    0.5000000    0.2500000    0.7500000
 0  1  0  0  0  1  1  0  0    0.5000000    0.2500000    0.7500000
 0 -1  0  0  0 -1 -1  0  0    0.5000000    0.2500000    0.7500000
 0  1  0  1  0  0  0  0 -1    0.5000000    0.2500000    0.7500000
 0 -1  0 -1  0  0  0  0  1    0.5000000    0.2500000    0.7500000
 0  1  0  0  0 -1 -1  0  0    0.5000000    0.2500000    0.7500000
 0 -1  0  0  0  1  1  0  0    0.5000000    0.2500000    0.7500000
 0  1  0 -1  0  0  0  0  1    0.5000000    0.2500000    0.7500000
 0 -1  0  1  0  0  0  0 -1    0.5000000    0.2500000    0.7500000
 0 -1  0  0  0 -1  1  0  0    0.5000000    0.2500000    0.7500000
 0  1  0  0  0  1 -1  0  0    0.5000000    0.2500000    0.7500000
 0 -1  0 -1  0  0  0  0 -1    0.5000000    0.2500000    0.7500000
 0  1  0  1  0  0  0  0  1    0.5000000    0.2500000    0.7500000
 0 -1  0  0  0  1 -1  0  0    0.5000000    0.2500000    0.7500000
 0  1  0  0  0 -1  1  0  0    0.5000000    0.2500000    0.7500000
 0 -1  0  1  0  0  0  0  1    0.5000000    0.2500000    0.7500000
 0  1  0 -1  0  0  0  0 -1    0.5000000    0.2500000    0.7500000
 0  0  1  1  0  0  0  1  0    0.5000000    0.2500000    0.7500000
 0  0 -1 -1  0  0  0 -1  0    0.5000000    0.2500000    0.7500000
 1  0  0  0  0 -1  0  1  0    0.5000000    0.2500000    0.7500000
-1  0  0  0  0  1  0 -1  0    0.5000000    0.2500000    0.7500000
 0  0 -1 -1  0  0  0  1  0    0.5000000    0.2500000    0.7500000
 0  0  1  1  0  0  0 -1  0    0.5000000    0.2500000    0.7500000
-1  0  0  0  0  1  0  1  0    0.5000000    0.2500000    0.7500000
 1  0  0  0  0 -1  0 -1  0    0.5000000    0.2500000    0.7500000
 0  0 -1  1  0  0  0 -1  0    0.5000000    0.2500000    0.7500000
 0  0  1 -1  0  0  0  1  0    0.5000000    0.2500000    0.7500000
-1  0  0  0  0 -1  0 -1  0    0.5000000    0.2500000    0.7500000
 1  0  0  0  0  1  0  1  0    0.5000000    0.2500000    0.7500000
 0  0  1 -1  0  0  0 -1  0    0.5000000    0.2500000    0.7500000
 0  0 -1  1  0  0  0  1  0    0.5000000    0.2500000    0.7500000
 1  0  0  0  0  1  0 -1  0    0.5000000    0.2500000    0.7500000
-1  0  0  0  0 -1  0  1  0    0.5000000    0.2500000    0.7500000
 1  0  0  0  1  0  0  0  1    0.5000000    0.0000000    0.5000000
-1  0  0  0 -1  0  0  0 -1    0.5000000    0.0000000    0.5000000
 0  0 -1  0  1  0  1  0  0    0.5000000    0.0000000    0.5000000
 0  0  1  0 -1  0 -1  0  0    0.5000000    0.0000000    0.5000000
-1  0  0  0  1  0  0  0 -1    0.5000000    0.0000000    0.5000000
 1  0  0  0 -1  0  0  0  1    0.5000000    0.0000000    0.5000000
 0  0  1  0  1  0 -1  0  0    0.5000000    0.0000000    0.5000000
 0  0 -1  0 -1  0  1  0  0    0.5000000    0.0000000    0.5000000
 1  0  0  0 -1  0  0  0 -1    0.5000000    0.0000000    0.5000000
-1  0  0  0  1  0  0  0  1    0.5000000    0.0000000    0.5000000
 0  0 -1  0 -1  0 -1  0  0    0.5000000    0.0000000    0.5000000
 0  0  1  0  1  0  1  0  0    0.5000000    0.0000000    0.5000000
-1  0  0  0 -1  0  0  0  1    0.5000000    0.0000000    0.5000000
 1  0  0  0  1  0  0  0 -1    0.5000000    0.0000000    0.5000000
 0  0  1  0 -1  0  1  0  0    0.5000000    0.0000000    0.5000000
 0  0 -1  0  1  0 -1  0  0    0.5000000    0.0000000    0.5000000
 0  1  0  0  0  1  1  0  0    0.5000000    0.0000000    0.5000000
 0 -1  0  0  0 -1 -1  0  0    0.5000000    0.0000000    0.5000000
 0  1  0  1  0  0  0  0 -1    0.5000000    0.0000000    0.5000000
 0 -1  0 -1  0  0  0  0  1    0.5000000    0.0000000    0.5000000
 0  1  0  0  0 -1 -1  0  0    0.5000000    0.0000000    0.5000000
 0 -1  0  0  0  1  1  0  0    0.5000000    0.0000000    0.5000000
 0  1  0 -1  0  0  0  0  1    0.5000000    0.0000000    0.5000000
 0 -1  0  1  0  0  0  0 -1    0.5000000    0.0000000    0.5000000
 0 -1  0  0  0 -1  1  0  0    0.5000000    0.0000000    0.5000000
 0  1  0  0  0  1 -1  0  0    0.5000000    0.0000000    0.5000000
 0 -1  0 -1  0  0  0  0 -1    0.5000000    0.0000000    0.5000000
 0  1  0  1  0  0  0  0  1    0.5000000    0.0000000    0.5000000
 0 -1  0  0  0  1 -1  0  0    0.5000000    0.0000000    0.5000000
 0  1  0  0  0 -1  1  0  0    0.5000000    0.0000000    0.5000000
 0 -1  0  1  0  0  0  0  1    0.5000000    0.0000000    0.5000000
 0  1  0 -1  0  0  0  0 -1    0.5000000    0.0000000    0.5000000
 0  0  1  1  0  0  0  1  0    0.5000000    0.0000000    0.5000000
 0  0 -1 -1  0  0  0 -1  0    0.5000000    0.0000000    0.5000000
 1  0  0  0  0 -1  0  1  0    0.5000000    0.0000000    0.5000000
-1  0  0  0  0  1  0 -1  0    0.5000000    0.0000000    0.5000000
 0  0 -1 -1  0  0  0  1  0    0.5000000    0.0000000    0.5000000
 0  0  1  1  0  0  0 -1  0    0.5000000    0.0000000    0.5000000
-1  0  0  0  0  1  0  1  0    0.5000000    0.0000000    0.5000000
 1  0  0  0  0 -1  0 -1  0    0.5000000    0.0000000    0.5000000
 0  0 -1  1  0  0  0 -1  0    0.5000000    0.0000000    0.5000000
 0  0  1 -1  0  0  0  1  0    0.5000000    0.0000000    0.5000000
-1  0  0  0  0 -1  0 -1  0    0.5000000    0.0000000    0.5000000
 1  0  0  0  0  1  0  1  0    0.5000000    0.0000000    0.5000000
 0  0  1 -1  0  0  0 -1  0    0.5000000    0.0000000    0.5000000
 0  0 -1  1  0  0  0  1  0    0.5000000    0.0000000    0.5000000
 1  0  0  0  0  1  0 -1  0    0.5000000    0.0000000    0.5000000
-1  0  0  0  0 -1  0  1  0    0.5000000    0.0000000    0.5000000
 1  0  0  0  1  0  0  0  1    0.2500000    0.7500000    0.5000000
-1  0  0  0 -1  0  0  0 -1    0.2500000    0.7500000    0.5000000
 0  0 -1  0  1  0  1  0  0    0.2500000    0.7500000    0.5000000
 0  0  1  0 -1  0 -1  0  0    0.2500000    0.7500000    0.5000000
-1  0  0  0  1  0  0  0 -1    0.2500000    0.7500000    0.5000000
 1  0  0  0 -1  0  0  0  1    0.2500000    0.7500000    0.5000000
 0  0  1  0  1  0 -1  0  0    0.2500000    0.7500000    0.5000000
 0  0 -1  0 -1  0  1  0  0    0.2500000    0.7500000    0.5000000
 1  0  0  0 -1  0  0  0 -1    0.2500000    0.7500000    0.5000000
-1  0  0  0  1  0  0  0  1    0.2500000    0.7500000    0.5000000
 0  0 -1  0 -1  0 -1  0  0    0.2500000    0.7500000    0.5000000
 0  0  1  0  1  0  1  0  0    0.2500000    0.7500000    0.5000000
-1  0  0  0 -1  0  0  0  1    0.2500000    0.7500000    0.5000000
 1  0  0  0  1  0  0  0 -1    0.2500000    0.7500000    0.5000000
 0  0  1  0 -1  0  1  0  0    0.2500000    0.7500000    0.5000000
 0  0 -1  0  1  0 -1  0  0    0.2500000    0.7500000    0.5000000
 0  1  0  0  0  1  1  0  0    0.2500000    0.7500000    0.5000000
 0 -1  0  0  0 -1 -1  0  0    0.2500000    0.7500000    0.5000000
 0  1  0  1  0  0  0  0 -1    0.2500000    0.7500000    0.5000000
 0 -1  0 -1  0  0  0  0  1    0.2500000    0.7500000    0.5000000
 0  1  0  0  0 -1 -1  0  0    0.2500000    0.7500000    0.5000000
 0 -1  0  0  0  1  1  0  0    0.2500000    0.7500000    0.5000000
 0  1  0 -1  0  0  0  0  1    0.2500000    0.7500000    0.5000000
 0 -1  0  1  0  0  0  0 -1    0.2500000    0.7500000    0.5000000
 0 -1  0  0  0 -1  1  0  0    0.2500000    0.7500000    0.5000000
 0  1  0  0  0  1 -1  0  0    0.2500000    0.7500000    0.5000000
 0 -1  0 -1  0  0  0  0 -1    0.2500000    0.7500000    0.5000000
 0  1  0  1  0  0  0  0  1    0.2500000    0.7500000    0.5000000
 0 -1  0  0  0  1 -1  0  0    0.2500000    0.7500000    0.5000000
 0  1  0  0  0 -1  1  0  0    0.2500000    0.7500000    0.5000000
 0 -1  0  1  0  0  0  0  1    0.2500000    0.7500000    0.5000000
 0  1  0 -1  0  0  0  0 -1    0.2500000    0.7500000    0.5000000
 0  0  1  1  0  0  0  1  0    0.2500000    0.7500000    0.5000000
 0  0 -1 -1  0  0  0 -1  0    0.2500000    0.7500000    0.5000000
 1  0  0  0  0 -1  0  1  0    0.2500000    0.7500000    0.5000000
-1  0  0  0  0  1  0 -1  0    0.2500000    0.7500000    0.5000000
 0  0 -1 -1  0  0  0  1  0    0.2500000    0.7500000    0.5000000
 0  0  1  1  0  0  0 -1  0    0.2500000    0.7500000    0.5000000
-1  0  0  0  0  1  0  1  0    0.2500000    0.7500000    0.5000000
 1  0  0  0  0 -1  0 -1  0    0.2500000    0.7500000    0.5000000
 0  0 -1  1  0  0  0 -1  0    0.2500000    0.7500000    0.5000000
 0  0  1 -1  0  0  0  1  0    0.2500000    0.7500000    0.5000000
-1  0  0  0  0 -1  0 -1  0    0.2500000    0.7500000    0.5000000
 1  0  0  0  0  1  0  1  0    0.2500000    0.7500000    0.5000000
 0  0  1 -1  0  0  0 -1  0    0.2500000    0.7500000    0.5000000
 0  0 -1  1  0  0  0  1  0    0.2500000    0.7500000    0.5000000
 1  0  0  0  0  1  0 -1  0    0.2500000    0.7500000    0.5000000
-1  0  0  0  0 -1  0  1  0    0.2500000    0.7500000    0.5000000
 1  0  0  0  1  0  0  0  1    0.0000000    0.5000000    0.5000000
-1  0  0  0 -1  0  0  0 -1    0.0000000    0.5000000    0.5000000
 0  0 -1  0  1  0  1  0  0    0.0000000    0.5000000    0.5000000
 0  0  1  0 -1  0 -1  0  0    0.0000000    0.5000000    0.5000000
-1  0  0  0  1  0  0  0 -1    0.0000000    0.5000000    0.5000000
 1  0  0  0 -1  0  0  0  1    0.0000000    0.5000000    0.5000000
 0  0  1  0  1  0 -1  0  0    0.0000000    0.5000000    0.5000000
 0  0 -1  0 -1  0  1  0  0    0.0000000    0.5000000    0.5000000
 1  0  0  0 -1  0  0  0 -1    0.0000000    0.5000000    0.5000000
-1  0  0  0  1  0  0  0  1    0.0000000    0.5000000    0.5000000
 0  0 -1  0 -1  0 -1  0  0    0.0000000    0.5000000    0.5000000
 0  0  1  0  1  0  1  0  0    0.0000000    0.5000000    0.5000000
-1  0  0  0 -1  0  0  0  1    0.0000000    0.5000000    0.5000000
 1  0  0  0  1  0  0  0 -1    0.0000000    0.5000000    0.5000000
 0  0  1  0 -1  0  1  0  0    0.0000000    0.5000000    0.5000000
 0  0 -1  0  1  0 -1  0  0    0.0000000    0.5000000    0.5000000
 0  1  0  0  0  1  1  0  0    0.0000000    0.5000000    0.5000000
 0 -1  0  0  0 -1 -1  0  0    0.0000000    0.5000000    0.5000000
 0  1  0  1  0  0  0  0 -1    0.0000000    0.5000000    0.5000000
 0 -1  0 -1  0  0  0  0  1    0.0000000    0.5000000    0.5000000
 0  1  0  0  0 -1 -1  0  0    0.0000000    0.5000000    0.5000000
 0 -1  0  0  0  1  1  0  0    0.0000000    0.5000000    0.5000000
 0  1  0 -1  0  0  0  0  1    0.0000000    0.5000000    0.5000000
 0 -1  0  1  0  0  0  0 -1    0.0000000    0.5000000    0.5000000
 0 -1  0  0  0 -1  1  0  0    0.0000000    0.5000000    0.5000000
 0  1  0  0  0  1 -1  0  0    0.0000000    0.5000000    0.5000000
 0 -1  0 -1  0  0  0  0 -1    0.0000000    0.5000000    0.5000000
 0  1  0  1  0  0  0  0  1    0.0000000    0.5000000    0.5000000
 0 -1  0  0  0  1 -1  0  0    0.0000000    0.5000000    0.5000000
 0  1  0  0  0 -1  1  0  0    0.0000000    0.5000000    0.5000000
 0 -1  0  1  0  0  0  0  1    0.0000000    0.5000000    0.5000000
 0  1  0 -1  0  0  0  0 -1    0.0000000    0.5000000    0.5000000
 0  0  1  1  0  0  0  1  0    0.0000000    0.5000000    0.5000000
 0  0 -1 -1  0  0  0 -1  0    0.0000000    0.5000000    0.5000000
 1  0  0  0  0 -1  0  1  0    0.0000000    0.5000000    0.5000000
-1  0  0  0  0  1  0 -1  0    0.0000000    0.5000000    0.5000000
 0  0 -1 -1  0  0  0  1  0    0.0000000    0.5000000    0.5000000
 0  0  1  1  0  0  0 -1  0    0.0000000    0.5000000    0.5000000
-1  0  0  0  0  1  0  1  0    0.0000000    0.5000000    0.5000000
 1  0  0  0  0 -1  0 -1  0    0.0000000    0.5000000    0.5000000
 0  0 -1  1  0  0  0 -1  0    0.0000000    0.5000000    0.5000000
 0  0  1 -1  0  0  0  1  0    0.0000000    0.5000000    0.5000000
-1  0  0  0  0 -1  0 -1  0    0.0000000    0.5000000    0.5000000
 1  0  0  0  0  1  0  1  0    0.0000000    0.5000000    0.5000000
 0  0  1 -1  0  0  0 -1  0    0.0000000    0.5000000    0.5000000
 0  0 -1  1  0  0  0  1  0    0.0000000    0.5000000    0.5000000
 1  0  0  0  0  1  0 -1  0    0.0000000    0.5000000    0.5000000
-1  0  0  0  0 -1  0  1  0    0.0000000    0.5000000    0.5000000
 1  0  0  0  1  0  0  0  1    0.7500000    0.2500000    0.5000000
-1  0  0  0 -1  0  0  0 -1    0.7500000    0.2500000    0.5000000
 0  0 -1  0  1  0  1  0  0    0.7500000    0.2500000    0.5000000
 0  0  1  0 -1  0 -1  0  0    0.7500000    0.2500000    0.5000000
-1  0  0  0  1  0  0  0 -1    0.7500000    0.2500000    0.5000000
 1  0  0  0 -1  0  0  0  1    0.7500000    0.2500000    0.5000000
 0  0  1  0  1  0 -1  0  0    0.7500000    0.2500000    0.5000000
 0  0 -1  0 -1  0  1  0  0    0.7500000    0.2500000    0.5000000
 1  0  0  0 -1  0  0  0 -1    0.7500000    0.2500000    0.5000000
-1  0  0  0  1  0  0  0  1    0.7500000    0.2500000    0.5000000
 0  0 -1  0 -1  0 -1  0  0    0.7500000    0.2500000    0.5000000
 0  0  1  0  1  0  1  0  0    0.7500000    0.2500000    0.5000000
-1  0  0  0 -1  0  0  0  1    0.7500000    0.2500000    0.5000000
 1  0  0  0  1  0  0  0 -1    0.7500000    0.2500000    0.5000000
 0  0  1  0 -1  0  1  0  0    0.7500000    0.2500000    0.5000000
 0  0 -1  0  1  0 -1  0  0    0.7500000    0.2500000    0.5000000
 0  1  0  0  0  1  1  0  0    0.7500000    0.2500000    0.5000000
 0 -1  0  0  0 -1 -1  0  0    0.7500000    0.2500000    0.5000000
 0  1  0  1  0  0  0  0 -1    0.7500000    0.2500000    0.5000000
 0 -1  0 -1  0  0  0  0  1    0.7500000    0.2500000    0.5000000
 0  1  0  0  0 -1 -1  0  0    0.7500000    0.2500000    0.5000000
 0 -1  0  0  0  1  1  0  0    0.7500000    0.2500000    0.5000000
 0  1  0 -1  0  0  0  0  1    0.7500000    0.2500000    0.5000000
 0 -1  0  1  0  0  0  0 -1    0.7500000    0.2500000    0.5000000
 0 -1  0  0  0 -1  1  0  0    0.7500000    0.2500000    0.5000000
 0  1  0  0  0  1 -1  0  0    0.7500000    0.2500000    0.5000000
 0 -1  0 -1  0  0  0  0 -1    0.7500000    0.2500000    0.5000000
 0  1  0  1  0  0  0  0  1    0.7500000    0.2500000    0.5000000
 0 -1  0  0  0  1 -1  0  0    0.7500000    0.2500000    0.5000000
 0  1  0  0  0 -1  1  0  0    0.7500000    0.2500000    0.5000000
 0 -1  0  1  0  0  0  0  1    0.7500000    0.2500000    0.5000000
 0  1  0 -1  0  0  0  0 -1    0.7500000    0.2500000    0.5000000
 0  0  1  1  0  0  0  1  0    0.7500000    0.2500000    0.5000000
 0  0 -1 -1  0  0  0 -1  0    0.7500000    0.2500000    0.5000000
 1  0  0  0  0 -1  0  1  0    0.7500000    0.2500000    0.5000000
-1  0  0  0  0  1  0 -1  0    0.7500000    0.2500000    0.5000000
 0  0 -1 -1  0  0  0  1  0    0.7500000    0.2500000    0.5000000
 0  0  1  1  0  0  0 -1  0    0.7500000    0.2500000    0.5000000
-1  0  0  0  0  1  0  1  0    0.7500000    0.2500000    0.5000000
 1  0  0  0  0 -1  0 -1  0    0.7500000    0.2500000    0.5000000
 0  0 -1  1  0  0  0 -1  0    0.7500000    0.2500000    0.5000000
 0  0  1 -1  0  0  0  1  0    0.7500000    0.2500000    0.5000000
-1  0  0  0  0 -1  0 -1  0    0.7500000    0.2500000    0.5000000
 1  0  0  0  0  1  0  1  0    0.7500000    0.2500000    0.5000000
 0  0  1 -1  0  0  0 -1  0    0.7500000    0.2500000    0.5000000
 0  0 -1  1  0  0  0  1  0    0.7500000    0.2500000    0.5000000
 1  0  0  0  0  1  0 -1  0    0.7500000    0.2500000    0.5000000
-1  0  0  0  0 -1  0  1  0    0.7500000    0.2500000    0.5000000
 1  0  0  0  1  0  0  0  1    0.7500000    0.0000000    0.2500000
-1  0  0  0 -1  0  0  0 -1    0.7500000    0.0000000    0.2500000
 0  0 -1  0  1  0  1  0  0    0.7500000    0.0000000    0.2500000
 0  0  1  0 -1  0 -1  0  0    0.7500000    0.0000000    0.2500000
-1  0  0  0  1  0  0  0 -1    0.7500000    0.0000000    0.2500000
 1  0  0  0 -1  0  0  0  1    0.7500000    0.0000000    0.2500000
 0  0  1  0  1  0 -1  0  0    0.7500000    0.0000000    0.2500000
 0  0 -1  0 -1  0  1  0  0    0.7500000    0.0000000    0.2500000
 1  0  0  0 -1  0  0  0 -1    0.7500000    0.0000000    0.2500000
-1  0  0  0  1  0  0  0  1    0.7500000    0.0000000    0.2500000
 0  0 -1  0 -1  0 -1  0  0    0.7500000    0.0000000    0.2500000
 0  0  1  0  1  0  1  0  0    0.7500000    0.0000000    0.2500000
-1  0  0  0 -1  0  0  0  1    0.7500000    0.0000000    0.2500000
 1  0  0  0  1  0  0  0 -1    0.7500000    0.0000000    0.2500000
 0  0  1  0 -1  0  1  0  0    0.7500000    0.0000000    0.2500000
 0  0 -1  0  1  0 -1  0  0    0.7500000    0.0000000    0.2500000
 0  1  0  0  0  1  1  0  0    0.7500000    0.0000000    0.2500000
 0 -1  0  0  0 -1 -1  0  0    0.7500000    0.0000000    0.2500000
 0  1  0  1  0  0  0  0 -1    0.7500000    0.0000000    0.2500000
 0 -1  0 -1  0  0  0  0  1    0.7500000    0.0000000    0.2500000
 0  1  0  0  0 -1 -1  0  0    0.7500000    0.0000000    0.2500000
 0 -1  0  0  0  1  1  0  0    0.7500000    0.0000000    0.2500000
 0  1  0 -1  0  0  0  0  1    0.7500000    0.0000000    0.2500000
 0 -1  0  1  0  0  0  0 -1    0.7500000    0.0000000    0.2500000
 0 -1  0  0  0 -1  1  0  0    0.7500000    0.0000000    0.2500000
 0  1  0  0  0  1 -1  0  0    0.7500000    0.0000000    0.2500000
 0 -1  0 -1  0  0  0  0 -1    0.7500000    0.0000000    0.2500000
 0  1  0  1  0  0  0  0  1    0.7500000    0.0000000    0.2500000
 0 -1  0  0  0  1 -1  0  0    0.7500000    0.0000000    0.2500000
 0  1  0  0  0 -1  1  0  0    0.7500000    0.0000000    0.2500000
 0 -1  0  1  0  0  0  0  1    0.7500000    0.0000000    0.2500000
 0  1  0 -1  0  0  0  0 -1    0.7500000    0.0000000    0.2500000
 0  0  1  1  0  0  0  1  0    0.7500000    0.0000000    0.2500000
 0  0 -1 -1  0  0  0 -1  0    0.7500000    0.0000000    0.2500000
 1  0  0  0  0 -1  0  1  0    0.7500000    0.0000000    0.2500000
-1  0  0  0  0  1  0 -1  0    0.7500000    0.0000000    0.2500000
 0  0 -1 -1  0  0  0  1  0    0.7500000    0.0000000    0.2500000
 0  0  1  1  0  0  0 -1  0    0.7500000    0.0000000    0.2500000
-1  0  0  0  0  1  0  1  0    0.7500000    0.0000000    0.2500000
 1  0  0  0  0 -1  0 -1  0    0.7500000    0.0000000    0.2500000
 0  0 -1  1  0  0  0 -1  0    0.7500000    0.0000000    0.2500000
 0  0  1 -1  0  0  0  1  0    0.7500000    0.0000000    0.2500000
-1  0  0  0  0 -1  0 -1  0    0.7500000    0.0000000    0.2500000
 1  0  0  0  0  1  0  1  0    0.7500000    0.0000000    0.2500000
 0  0  1 -1  0  0  0 -1  0    0.7500000    0.0000000    0.2500000
 0  0 -1  1  0  0  0  1  0    0.7500000    0.0000000    0.2500000
 1  0  0  0  0  1  0 -1  0    0.7500000    0.0000000    0.2500000
-1  0  0  0  0 -1  0  1  0    0.7500000    0.0000000    0.2500000
 1  0  0  0  1  0  0  0  1    0.5000000    0.7500000    0.2500000
-1  0  0  0 -1  0  0  0 -1    0.5000000    0.7500000    0.2500000
 0  0 -1  0  1  0  1  0  0    0.5000000    0.7500000    0.2500000
 0  0  1  0 -1  0 -1  0  0    0.5000000    0.7500000    0.2500000
-1  0  0  0  1  0  0  0 -1    0.5000000    0.7500000    0.2500000
 1  0  0  0 -1  0  0  0  1    0.5000000    0.7500000    0.2500000
 0  0  1  0  1  0 -1  0  0    0.5000000    0.7500000    0.2500000
 0  0 -1  0 -1  0  1  0  0    0.5000000    0.7500000    0.2500000
 1  0  0  0 -1  0  0  0 -1    0.5000000    0.7500000    0.2500000
-1  0  0  0  1  0  0  0  1    0.5000000    0.7500000    0.2500000
 0  0 -1  0 -1  0 -1  0  0    0.5000000    0.7500000    0.2500000
 0  0  1  0  1  0  1  0  0    0.5000000    0.7500000    0.2500000
-1  0  0  0 -1  0  0  0  1    0.5000000    0.7500000    0.2500000
 1  0  0  0  1  0  0  0 -1    0.5000000    0.7500000    0.2500000
 0  0  1  0 -1  0  1  0  0    0.5000000    0.7500000    0.2500000
 0  0 -1  0  1  0 -1  0  0    0.5000000    0.7500000    0.2500000
 0  1  0  0  0  1  1  0  0    0.5000000    0.7500000    0.2500000
 0 -1  0  0  0 -1 -1  0  0    0.5000000    0.7500000    0.2500000
 0  1  0  1  0  0  0  0 -1    0.5000000    0.7500000    0.2500000
 0 -1  0 -1  0  0  0  0  1    0.5000000    0.7500000    0.2500000
 0  1  0  0  0 -1 -1  0  0    0.5000000    0.7500000    0.2500000
 0 -1  0  0  0  1  1  0  0    0.5000000    0.7500000    0.2500000
 0  1  0 -1  0  0  0  0  1    0.5000000    0.7500000    0.2500000
 0 -1  0  1  0  0  0  0 -1    0.5000000    0.7500000    0.2500000
 0 -1  0  0  0 -1  1  0  0    0.5000000    0.7500000    0.2500000
 0  1  0  0  0  1 -1  0  0    0.5000000    0.7500000    0.2500000
 0 -1  0 -1  0  0  0  0 -1    0.5000000    0.7500000    0.2500000
 0  1  0  1  0  0  0  0  1    0.5000000    0.7500000    0.2500000
 0 -1  0  0  0  1 -1  0  0    0.5000000    0.7500000    0.2500000
 0  1  0  0  0 -1  1  0  0    0.5000000    0.7500000    0.2500000
 0 -1  0  1  0  0  0  0  1    0.5000000    0.7500000    0.2500000
 0  1  0 -1  0  0  0  0 -1    0.5000000    0.7500000    0.2500000
 0  0  1  1  0  0  0  1  0    0.5000000    0.7500000    0.2500000
 0  0 -1 -1  0  0  0 -1  0    0.5000000    0.7500000    0.2500000
 1  0  0  0  0 -1  0  1  0    0.5000000    0.7500000    0.2500000
-1  0  0  0  0  1  0 -1  0    0.5000000    0.7500000    0.2500000
 0  0 -1 -1  0  0  0  1  0    0.5000000    0.7500000    0.2500000
 0  0  1  1  0  0  0 -1  0    0.5000000    0.7500000    0.2500000
-1  0  0  0  0  1  0  1  0    0.5000000    0.7500000    0.2500000
 1  0  0  0  0 -1  0 -1  0    0.5000000    0.7500000    0.2500000
 0  0 -1  1  0  0  0 -1  0    0.5000000    0.7500000    0.2500000
 0  0  1 -1  0  0  0  1  0    0.5000000    0.7500000    0.2500000
-1  0  0  0  0 -1  0 -1  0    0.5000000    0.7500000    0.2500000
 1  0  0  0  0  1  0  1  0    0.5000000    0.7500000    0.2500000
 0  0  1 -1  0  0  0 -1  0    0.5000000    0.7500000    0.2500000
 0  0 -1  1  0  0  0  1  0    0.5000000    0.7500000    0.2500000
 1  0  0  0  0  1  0 -1  0    0.5000000    0.7500000    0.2500000
-1  0  0  0  0 -1  0  1  0    0.5000000    0.7500000    0.2500000
 1  0  0  0  1  0  0  0  1    0.2500000    0.5000000    0.2500000
-1  0  0  0 -1  0  0  0 -1    0.2500000    0.5000000    0.2500000
 0  0 -1  0  1  0  1  0  0    0.2500000    0.5000000    0.2500000
 0  0  1  0 -1  0 -1  0  0    0.2500000    0.5000000    0.2500000
-1  0  0  0  1  0  0  0 -1    0.2500000    0.5000000    0.2500000
 1  0  0  0 -1  0  0  0  1    0.2500000    0.5000000    0.2500000
 0  0  1  0  1  0 -1  0  0    0.2500000    0.5000000    0.2500000
 0  0 -1  0 -1  0  1  0  0    0.2500000    0.5000000    0.2500000
 1  0  0  0 -1  0  0  0 -1    0.2500000    0.5000000    0.2500000
-1  0  0  0  1  0  0  0  1    0.2500000    0.5000000    0.2500000
 0  0 -1  0 -1  0 -1  0  0    0.2500000    0.5000000    0.2500000
 0  0  1  0  1  0  1  0  0    0.2500000    0.5000000    0.2500000
-1  0  0  0 -1  0  0  0  1    0.2500000    0.5000000    0.2500000
 1  0  0  0  1  0  0  0 -1    0.2500000    0.5000000    0.2500000
 0  0  1  0 -1  0  1  0  0    0.2500000    0.5000000    0.2500000
 0  0 -1  0  1  0 -1  0  0    0.2500000    0.5000000    0.2500000
 0  1  0  0  0  1  1  0  0    0.2500000    0.5000000    0.2500000
 0 -1  0  0  0 -1 -1  0  0    0.2500000    0.5000000    0.2500000
 0  1  0  1  0  0  0  0 -1    0.2500000    0.5000000    0.2500000
 0 -1  0 -1  0  0  0  0  1    0.2500000    0.5000000    0.2500000
 0  1  0  0  0 -1 -1  0  0    0.2500000    0.5000000    0.2500000
 0 -1  0  0  0  1  1  0  0    0.2500000    0.5000000    0.2500000
 0  1  0 -1  0  0  0  0  1    0.2500000    0.5000000    0.2500000
 0 -1  0  1  0  0  0  0 -1    0.2500000    0.5000000    0.2500000
 0 -1  0  0  0 -1  1  0  0    0.2500000    0.5000000    0.2500000
 0  1  0  0  0  1 -1  0  0    0.2500000    0.5000000    0.2500000
 0 -1  0 -1  0  0  0  0 -1    0.2500000    0.5000000    0.2500000
 0  1  0  1  0  0  0  0  1    0.2500000    0.5000000    0.2500000
 0 -1  0  0  0  1 -1  0  0    0.2500000    0.5000000    0.2500000
 0  1  0  0  0 -1  1  0  0    0.2500000    0.5000000    0.2500000
 0 -1  0  1  0  0  0  0  1    0.2500000    0.5000000    0.2500000
 0  1  0 -1  0  0  0  0 -1    0.2500000    0.5000000    0.2500000
 0  0  1  1  0  0  0  1  0    0.2500000    0.5000000    0.2500000
 0  0 -1 -1  0  0  0 -1  0    0.2500000    0.5000000    0.2500000
 1  0  0  0  0 -1  0  1  0    0.2500000    0.5000000    0.2500000
-1  0  0  0  0  1  0 -1  0    0.2500000    0.5000000    0.2500000
 0  0 -1 -1  0  0  0  1  0    0.2500000    0.5000000    0.2500000
 0  0  1  1  0  0  0 -1  0    0.2500000    0.5000000    0.2500000
-1  0  0  0  0  1  0  1  0    0.2500000    0.5000000    0.2500000
 1  0  0  0  0 -1  0 -1  0    0.2500000    0.5000000    0.2500000
 0  0 -1  1  0  0  0 -1  0    0.2500000    0.5000000    0.2500000
 0  0  1 -1  0  0  0  1  0    0.2500000    0.5000000    0.2500000
-1  0  0  0  0 -1  0 -1  0    0.2500000    0.5000000    0.2500000
 1  0  0  0  0  1  0  1  0    0.2500000    0.5000000    0.2500000
 0  0  1 -1  0  0  0 -1  0    0.2500000    0.5000000    0.2500000
 0  0 -1  1  0  0  0  1  0    0.2500000    0.5000000    0.2500000
 1  0  0  0  0  1  0 -1  0    0.2500000    0.5000000    0.2500000
-1  0  0  0  0 -1  0  1  0    0.2500000    0.5000000    0.2500000
 1  0  0  0  1  0  0  0  1    0.0000000    0.2500000    0.2500000
-1  0  0  0 -1  0  0  0 -1    0.0000000    0.2500000    0.2500000
 0  0 -1  0  1  0  1  0  0    0.0000000    0.2500000    0.2500000
 0  0  1  0 -1  0 -1  0  0    0.0000000    0.2500000    0.2500000
-1  0  0  0  1  0  0  0 -1    0.0000000    0.2500000    0.2500000
 1  0  0  0 -1  0  0  0  1    0.0000000    0.2500000    0.2500000
 0  0  1  0  1  0 -1  0  0    0.0000000    0.2500000    0.2500000
 0  0 -1  0 -1  0  1  0  0    0.0000000    0.2500000    0.2500000
 1  0  0  0 -1  0  0  0 -1    0.0000000    0.2500000    0.2500000
-1  0  0  0  1  0  0  0  1    0.0000000    0.2500000    0.2500000
 0  0 -1  0 -1  0 -1  0  0    0.0000000    0.2500000    0.2500000
 0  0  1  0  1  0  1  0  0    0.0000000    0.2500000    0.2500000
-1  0  0  0 -1  0  0  0  1    0.0000000    0.2500000    0.2500000
 1  0  0  0  1  0  0  0 -1    0.0000000    0.2500000    0.2500000
 0  0  1  0 -1  0  1  0  0    0.0000000    0.2500000    0.2500000
 0  0 -1  0  1  0 -1  0  0    0.0000000    0.2500000    0.2500000
 0  1  0  0  0  1  1  0  0    0.0000000    0.2500000    0.2500000
 0 -1  0  0  0 -1 -1  0  0    0.0000000    0.2500000    0.2500000
 0  1  0  1  0  0  0  0 -1    0.0000000    0.2500000    0.2500000
 0 -1  0 -1  0  0  0  0  1    0.0000000    0.2500000    0.2500000
 0  1  0  0  0 -1 -1  0  0    0.0000000    0.2500000    0.2500000
 0 -1  0  0  0  1  1  0  0    0.0000000    0.2500000    0.2500000
 0  1  0 -1  0  0  0  0  1    0.0000000    0.2500000    0.2500000
 0 -1  0  1  0  0  0  0 -1    0.0000000    0.2500000    0.2500000
 0 -1  0  0  0 -1  1  0  0    0.0000000    0.2500000    0.2500000
 0  1  0  0  0  1 -1  0  0    0.0000000    0.2500000    0.2500000
 0 -1  0 -1  0  0  0  0 -1    0.0000000    0.2500000    0.2500000
 0  1  0  1  0  0  0  0  1    0.0000000    0.2500000    0.2500000
 0 -1  0  0  0  1 -1  0  0    0.0000000    0.2500000    0.2500000
 0  1  0  0  0 -1  1  0  0    0.0000000    0.2500000    0.2500000
 0 -1  0  1  0  0  0  0  1    0.0000000    0.2500000    0.2500000
 0  1  0 -1  0  0  0  0 -1    0.0000000    0.2500000    0.2500000
 0  0  1  1  0  0  0  1  0    0.0000000    0.2500000    0.2500000
 0  0 -1 -1  0  0  0 -1  0    0.0000000    0.2500000    0.2500000
 1  0  0  0  0 -1  0  1  0    0.0000000    0.2500000    0.2500000
-1  0  0  0  0  1  0 -1  0    0.0000000    0.2500000    0.2500000
 0  0 -1 -1  0  0  0  1  0    0.0000000    0.2500000    0.2500000
 0  0  1  1  0  0  0 -1  0    0.0000000    0.2500000    0.2500000
-1  0  0  0  0  1  0  1  0    0.0000000    0.2500000    0.2500000
 1  0  0  0  0 -1  0 -1  0    0.0000000    0.2500000    0.2500000
 0  0 -1  1  0  0  0 -1  0    0.0000000    0.2500000    0.2500000
 0  0  1 -1  0  0  0  1  0    0.0000000    0.2500000    0.2500000
-1  0  0  0  0 -1  0 -1  0    0.0000000    0.2500000    0.2500000
 1  0  0  0  0  1  0  1  0    0.0000000    0.2500000    0.2500000
 0  0  1 -1  0  0  0 -1  0    0.0000000    0.2500000    0.2500000
 0  0 -1  1  0  0  0  1  0    0.0000000    0.2500000    0.2500000
 1  0  0  0  0  1  0 -1  0    0.0000000    0.2500000    0.2500000
-1  0  0  0  0 -1  0  1  0    0.0000000    0.2500000    0.2500000
 1  0  0  0  1  0  0  0  1    0.7500000    0.2500000    0.0000000
-1  0  0  0 -1  0  0  0 -1    0.7500000    0.2500000    0.0000000
 0  0 -1  0  1  0  1  0  0    0.7500000    0.2500000    0.0000000
 0  0  1  0 -1  0 -1  0  0    0.7500000    0.2500000    0.0000000
-1  0  0  0  1  0  0  0 -1    0.7500000    0.2500000    0.0000000
 1  0  0  0 -1  0  0  0  1    0.7500000    0.2500000    0.0000000
 0  0  1  0  1  0 -1  0  0    0.7500000    0.2500000    0.0000000
 0  0 -1  0 -1  0  1  0  0    0.7500000    0.2500000    0.0000000
 1  0  0  0 -1  0  0  0 -1    0.7500000    0.2500000    0.0000000
-1  0  0  0  1  0  0  0  1    0.7500000    0.2500000    0.0000000
 0  0 -1  0 -1  0 -1  0  0    0.7500000    0.2500000    0.0000000
 0  0  1  0  1  0  1  0  0    0.7500000    0.2500000    0.0000000
-1  0  0  0 -1  0  0  0  1    0.7500000    0.2500000    0.0000000
 1  0  0  0  1  0  0  0 -1    0.7500000    0.2500000    0.0000000
 0  0  1  0 -1  0  1  0  0    0.7500000    0.2500000    0.0000000
 0  0 -1  0  1  0 -1  0  0    0.7500000    0.2500000    0.0000000
 0  1  0  0  0  1  1  0  0    0.7500000    0.2500000    0.0000000
 0 -1  0  0  0 -1 -1  0  0    0.7500000    0.2500000    0.0000000
 0  1  0  1  0  0  0  0 -1    0.7500000    0.2500000    0.0000000
 0 -1  0 -1  0  0  0  0  1    0.7500000    0.2500000    0.0000000
 0  1  0  0  0 -1 -1  0  0    0.7500000    0.2500000    0.0000000
 0 -1  0  0  0  1  1  0  0    0.7500000    0.2500000    0.0000000
 0  1  0 -1  0  0  0  0  1    0.7500000    0.2500000    0.0000000
 0 -1  0  1  0  0  0  0 -1    0.7500000    0.2500000    0.0000000
 0 -1  0  0  0 -1  1  0  0    0.7500000    0.2500000    0.0000000
 0  1  0  0  0  1 -1  0  0    0.7500000    0.2500000    0.0000000
 0 -1  0 -1  0  0  0  0 -1    0.7500000    0.2500000    0.0000000
 0  1  0  1  0  0  0  0  1    0.7500000    0.2500000    0.0000000
 0 -1  0  0  0  1 -1  0  0    0.7500000    0.2500000    0.0000000
 0  1  0  0  0 -1  1  0  0    0.7500000    0.2500000    0.0000000
 0 -1  0  1  0  0  0  0  1    0.7500000    0.2500000    0.0000000
 0  1  0 -1  0  0  0  0 -1    0.7500000    0.2500000    0.0000000
 0  0  1  1  0  0  0  1  0    0.7500000    0.2500000    0.0000000
 0  0 -1 -1  0  0  0 -1  0    0.7500000    0.2500000    0.0000000
 1  0  0  0  0 -1  0  1  0    0.7500000    0.2500000    0.0000000
-1  0  0  0  0  1  0 -1  0    0.7500000    0.2500000    0.0000000
 0  0 -1 -1  0  0  0  1  0    0.7500000    0.2500000    0.0000000
 0  0  1  1  0  0  0 -1  0    0.7500000    0.2500000    0.0000000
-1  0  0  0  0  1  0  1  0    0.7500000    0.2500000    0.0000000
 1  0  0  0  0 -1  0 -1  0    0.7500000    0.2500000    0.0000000
 0  0 -1  1  0  0  0 -1  0    0.7500000    0.2500000    0.0000000
 0  0  1 -1  0  0  0  1  0    0.7500000    0.2500000    0.0000000
-1  0  0  0  0 -1  0 -1  0    0.7500000    0.2500000    0.0000000
 1  0  0  0  0  1  0  1  0    0.7500000    0.2500000    0.0000000
 0  0  1 -1  0  0  0 -1  0    0.7500000    0.2500000    0.0000000
 0  0 -1  1  0  0  0  1  0    0.7500000    0.2500000    0.0000000
 1  0  0  0  0  1  0 -1  0    0.7500000    0.2500000    0.0000000
-1  0  0  0  0 -1  0  1  0    0.7500000    0.2500000    0.0000000
 1  0  0  0  1  0  0  0  1    0.5000000    0.0000000    0.0000000
-1  0  0  0 -1  0  0  0 -1    0.5000000    0.0000000    0.0000000
 0  0 -1  0  1  0  1  0  0    0.5000000    0.0000000    0.0000000
 0  0  1  0 -1  0 -1  0  0    0.5000000    0.0000000    0.0000000
-1  0  0  0  1  0  0  0 -1    0.5000000    0.0000000    0.0000000
 1  0  0  0 -1  0  0  0  1    0.5000000    0.0000000    0.0000000
 0  0  1  0  1  0 -1  0  0    0.5000000    0.0000000    0.0000000
 0  0 -1  0 -1  0  1  0  0    0.5000000    0.0000000    0.0000000
 1  0  0  0 -1  0  0  0 -1    0.5000000    0.0000000    0.0000000
-1  0  0  0  1  0  0  0  1    0.5000000    0.0000000    0.0000000
 0  0 -1  0 -1  0 -1  0  0    0.5000000    0.0000000    0.0000000
 0  0  1  0  1  0  1  0  0    0.5000000    0.0000000    0.0000000
-1  0  0  0 -1  0  0  0  1    0.5000000    0.0000000    0.0000000
 1  0  0  0  1  0  0  0 -1    0.5000000    0.0000000    0.0000000
 0  0  1  0 -1  0  1  0  0    0.5000000    0.0000000    0.0000000
 0  0 -1  0  1  0 -1  0  0    0.5000000    0.0000000    0.0000000
 0  1  0  0  0  1  1  0  0    0.5000000    0.0000000    0.0000000
 0 -1  0  0  0 -1 -1  0  0    0.5000000    0.0000000    0.0000000
 0  1  0  1  0  0  0  0 -1    0.5000000    0.0000000    0.0000000
 0 -1  0 -1  0  0  0  0  1    0.5000000    0.0000000    0.0000000
 0  1  0  0  0 -1 -1  0  0    0.5000000    0.0000000    0.0000000
 0 -1  0  0  0  1  1  0  0    0.5000000    0.0000000    0.0000000
 0  1  0 -1  0  0  0  0  1    0.5000000    0.0000000    0.0000000
 0 -1  0  1  0  0  0  0 -1    0.5000000    0.0000000    0.0000000
 0 -1  0  0  0 -1  1  0  0    0.5000000    0.0000000    0.0000000
 0  1  0  0  0  1 -1  0  0    0.5000000    0.0000000    0.0000000
 0 -1  0 -1  0  0  0  0 -1    0.5000000    0.0000000    0.0000000
 0  1  0  1  0  0  0  0  1    0.5000000    0.0000000    0.0000000
 0 -1  0  0  0  1 -1  0  0    0.5000000    0.0000000    0.0000000
 0  1  0  0  0 -1  1  0  0    0.5000000    0.0000000    0.0000000
 0 -1  0  1  0  0  0  0  1    0.5000000    0.0000000    0.0000000
 0  1  0 -1  0  0  0  0 -1    0.5000000    0.0000000    0.0000000
 0  0  1  1  0  0  0  1  0    0.5000000    0.0000000    0.0000000
 0  0 -1 -1  0  0  0 -1  0    0.5000000    0.0000000    0.0000000
 1  0  0  0  0 -1  0  1  0    0.5000000    0.0000000    0.0000000
-1  0  0  0  0  1  0 -1  0    0.5000000    0.0000000    0.0000000
 0  0 -1 -1  0  0  0  1  0    0.5000000    0.0000000    0.0000000
 0  0  1  1  0  0  0 -1  0    0.5000000    0.0000000    0.0000000
-1  0  0  0  0  1  0  1  0    0.5000000    0.0000000    0.0000000
 1  0  0  0  0 -1  0 -1  0    0.5000000    0.0000000    0.0000000
 0  0 -1  1  0  0  0 -1  0    0.5000000    0.0000000    0.0000000
 0  0  1 -1  0  0  0  1  0    0.5000000    0.0000000    0.0000000
-1  0  0  0  0 -1  0 -1  0    0.5000000    0.0000000    0.0000000
 1  0  0  0  0  1  0  1  0    0.5000000    0.0000000    0.0000000
 0  0  1 -1  0  0  0 -1  0    0.5000000    0.0000000    0.0000000
 0  0 -1  1  0  0  0  1  0    0.5000000    0.0000000    0.0000000
 1  0  0  0  0  1  0 -1  0    0.5000000    0.0000000    0.0000000
-1  0  0  0  0 -1  0  1  0    0.5000000    0.0000000    0.0000000
 1  0  0  0  1  0  0  0  1    0.2500000    0.7500000    0.0000000
-1  0  0  0 -1  0  0  0 -1    0.2500000    0.7500000    0.0000000
 0  0 -1  0  1  0  1  0  0    0.2500000    0.7500000    0.0000000
 0  0  1  0 -1  0 -1  0  0    0.2500000    0.7500000    0.0000000
-1  0  0  0  1  0  0  0 -1    0.2500000    0.7500000    0.0000000
 1  0  0  0 -1  0  0  0  1    0.2500000    0.7500000    0.0000000
 0  0  1  0  1  0 -1  0  0    0.2500000    0.7500000    0.0000000
 0  0 -1  0 -1  0  1  0  0    0.2500000    0.7500000    0.0000000
 1  0  0  0 -1  0  0  0 -1    0.2500000    0.7500000    0.0000000
-1  0  0  0  1  0  0  0  1    0.2500000    0.7500000    0.0000000
 0  0 -1  0 -1  0 -1  0  0    0.2500000    0.7500000    0.0000000
 0  0  1  0  1  0  1  0  0    0.2500000    0.7500000    0.0000000
-1  0  0  0 -1  0  0  0  1    0.2500000    0.7500000    0.0000000
 1  0  0  0  1  0  0  0 -1    0.2500000    0.7500000    0.0000000
 0  0  1  0 -1  0  1  0  0    0.2500000    0.7500000    0.0000000
 0  0 -1  0  1  0 -1  0  0    0.2500000    0.7500000    0.0000000
 0  1  0  0  0  1  1  0  0    0.2500000    0.7500000    0.0000000
 0 -1  0  0  0 -1 -1  0  0    0.2500000    0.7500000    0.0000000
 0  1  0  1  0  0  0  0 -1    0.2500000    0.7500000    0.0000000
 0 -1  0 -1  0  0  0  0  1    0.2500000    0.7500000    0.0000000
 0  1  0  0  0 -1 -1  0  0    0.2500000    0.7500000    0.0000000
 0 -1  0  0  0  1  1  0  0    0.2500000    0.7500000    0.0000000
 0  1  0 -1  0  0  0  0  1    0.2500000    0.7500000    0.0000000
 0 -1  0  1  0  0  0  0 -1    0.2500000    0.7500000    0.0000000
 0 -1  0  0  0 -1  1  0  0    0.2500000    0.7500000    0.0000000
 0  1  0  0  0  1 -1  0  0    0.2500000    0.7500000    0.0000000
 0 -1  0 -1  0  0  0  0 -1    0.2500000    0.7500000    0.0000000
 0  1  0  1  0  0  0  0  1    0.2500000    0.7500000    0.0000000
 0 -1  0  0  0  1 -1  0  0    0.2500000    0.7500000    0.0000000
 0  1  0  0  0 -1  1  0  0    0.2500000    0.7500000    0.0000000
 0 -1  0  1  0  0  0  0  1    0.2500000    0.7500000    0.0000000
 0  1  0 -1  0  0  0  0 -1    0.2500000    0.7500000    0.0000000
 0  0  1  1  0  0  0  1  0    0.2500000    0.7500000    0.0000000
 0  0 -1 -1  0  0  0 -1  0    0.2500000    0.7500000    0.0000000
 1  0  0  0  0 -1  0  1  0    0.2500000    0.7500000    0.0000000
-1  0  0  0  0  1  0 -1  0    0.2500000    0.7500000    0.0000000
 0  0 -1 -1  0  0  0  1  0    0.2500000    0.7500000    0.0000000
 0  0  1  1  0  0  0 -1  0    0.2500000    0.7500000    0.0000000
-1  0  0  0  0  1  0  1  0    0.2500000    0.7500000    0.0000000
 1  0  0  0  0 -1  0 -1  0    0.2500000    0.7500000    0.0000000
 0  0 -1  1  0  0  0 -1  0    0.2500000    0.7500000    0.0000000
 0  0  1 -1  0  0  0  1  0    0.2500000    0.7500000    0.0000000
-1  0  0  0  0 -1  0 -1  0    0.2500000    0.7500000    0.0000000
 1  0  0  0  0  1  0  1  0    0.2500000    0.7500000    0.0000000
 0  0  1 -1  0  0  0 -1  0    0.2500000    0.7500000    0.0000000
 0  0 -1  1  0  0  0  1  0    0.2500000    0.7500000    0.0000000
 1  0  0  0  0  1  0 -1  0    0.2500000    0.7500000    0.0000000
-1  0  0  0  0 -1  0  1  0    0.2500000    0.7500000    0.0000000
 1  0  0  0  1  0  0  0  1    0.0000000    0.5000000    0.0000000
-1  0  0  0 -1  0  0  0 -1    0.0000000    0.5000000    0.0000000
 0  0 -1  0  1  0  1  0  0    0.0000000    0.5000000    0.0000000
 0  0  1  0 -1  0 -1  0  0    0.0000000    0.5000000    0.0000000
-1  0  0  0  1  0  0  0 -1    0.0000000    0.5000000    0.0000000
 1  0  0  0 -1  0  0  0  1    0.0000000    0.5000000    0.0000000
 0  0  1  0  1  0 -1  0  0    0.0000000    0.5000000    0.0000000
 0  0 -1  0 -1  0  1  0  0    0.0000000    0.5000000    0.0000000
 1  0  0  0 -1  0  0  0 -1    0.0000000    0.5000000    0.0000000
-1  0  0  0  1  0  0  0  1    0.0000000    0.5000000    0.0000000
 0  0 -1  0 -1  0 -1  0  0    0.0000000    0.5000000    0.0000000
 0  0  1  0  1  0  1  0  0    0.0000000    0.5000000    0.0000000
-1  0  0  0 -1  0  0  0  1    0.0000000    0.5000000    0.0000000
 1  0  0  0  1  0  0  0 -1    0.0000000    0.5000000    0.0000000
 0  0  1  0 -1  0  1  0  0    0.0000000    0.5000000    0.0000000
 0  0 -1  0  1  0 -1  0  0    0.0000000    0.5000000    0.0000000
 0  1  0  0  0  1  1  0  0    0.0000000    0.5000000    0.0000000
 0 -1  0  0  0 -1 -1  0  0    0.0000000    0.5000000    0.0000000
 0  1  0  1  0  0  0  0 -1    0.0000000    0.5000000    0.0000000
 0 -1  0 -1  0  0  0  0  1    0.0000000    0.5000000    0.0000000
 0  1  0  0  0 -1 -1  0  0    0.0000000    0.5000000    0.0000000
 0 -1  0  0  0  1  1  0  0    0.0000000    0.5000000    0.0000000
 0  1  0 -1  0  0  0  0  1    0.0000000    0.5000000    0.0000000
 0 -1  0  1  0  0  0  0 -1    0.0000000    0.5000000    0.0000000
 0 -1  0  0  0 -1  1  0  0    0.0000000    0.5000000    0.0000000
 0  1  0  0  0  1 -1  0  0    0.0000000    0.5000000    0.0000000
 0 -1  0 -1  0  0  0  0 -1    0.0000000    0.5000000    0.0000000
 0  1  0  1  0  0  0  0  1    0.0000000    0.5000000    0.0000000
 0 -1  0  0  0  1 -1  0  0    0.0000000    0.5000000    0.0000000
 0  1  0  0  0 -1  1  0  0    0.0000000    0.5000000    0.0000000
 0 -1  0  1  0  0  0  0  1    0.0000000    0.5000000    0.0000000
 0  1  0 -1  0  0  0  0 -1    0.0000000    0.5000000    0.0000000
 0  0  1  1  0  0  0  1  0    0.0000000    0.5000000    0.0000000
 0  0 -1 -1  0  0  0 -1  0    0.0000000    0.5000000    0.0000000
 1  0  0  0  0 -1  0  1  0    0.0000000    0.5000000    0.0000000
-1  0  0  0  0  1  0 -1  0    0.0000000    0.5000000    0.0000000
 0  0 -1 -1  0  0  0  1  0    0.0000000    0.5000000    0.0000000
 0  0  1  1  0  0  0 -1  0    0.0000000    0.5000000    0.0000000
-1  0  0  0  0  1  0  1  0    0.0000000    0.5000000    0.0000000
 1  0  0  0  0 -1  0 -1  0    0.0000000    0.5000000    0.0000000
 0  0 -1  1  0  0  0 -1  0    0.0000000    0.5000000    0.0000000
 0  0  1 -1  0  0  0  1  0    0.0000000    0.5000000    0.0000000
-1  0  0  0  0 -1  0 -1  0    0.0000000    0.5000000    0.0000000
 1  0  0  0  0  1  0  1  0    0.0000000    0.5000000    0.0000000
 0  0  1 -1  0  0  0 -1  0    0.0000000    0.5000000    0.0000000
 0  0 -1  1  0  0  0  1  0    0.0000000    0.5000000    0.0000000
 1  0  0  0  0  1  0 -1  0    0.0000000    0.5000000    0.0000000
-1  0  0  0  0 -1  0  1  0    0.0000000    0.5000000    0.0000000
 1  0  0  0  1  0  0  0  1    0.0000000    0.2500000    0.7500000
-1  0  0  0 -1  0  0  0 -1    0.0000000    0.2500000    0.7500000
 0  0 -1  0  1  0  1  0  0    0.0000000    0.2500000    0.7500000
 0  0  1  0 -1  0 -1  0  0    0.0000000    0.2500000    0.7500000
-1  0  0  0  1  0  0  0 -1    0.0000000    0.2500000    0.7500000
 1  0  0  0 -1  0  0  0  1    0.0000000    0.2500000    0.7500000
 0  0  1  0  1  0 -1  0  0    0.0000000    0.2500000    0.7500000
 0  0 -1  0 -1  0  1  0  0    0.0000000    0.2500000    0.7500000
 1  0  0  0 -1  0  0  0 -1    0.0000000    0.2500000    0.7500000
-1  0  0  0  1  0  0  0  1    0.0000000    0.2500000    0.7500000
 0  0 -1  0 -1  0 -1  0  0    0.0000000    0.2500000    0.7500000
 0  0  1  0  1  0  1  0  0    0.0000000    0.2500000    0.7500000
-1  0  0  0 -1  0  0  0  1    0.0000000    0.2500000    0.7500000
 1  0  0  0  1  0  0  0 -1    0.0000000    0.2500000    0.7500000
 0  0  1  0 -1  0  1  0  0    0.0000000    0.2500000    0.7500000
 0  0 -1  0  1  0 -1  0  0    0.0000000    0.2500000    0.7500000
 0  1  0  0  0  1  1  0  0    0.0000000    0.2500000    0.7500000
 0 -1  0  0  0 -1 -1  0  0    0.0000000    0.2500000    0.7500000
 0  1  0  1  0  0  0  0 -1    0.0000000    0.2500000    0.7500000
 0 -1  0 -1  0  0  0  0  1    0.0000000    0.2500000    0.7500000
 0  1  0  0  0 -1 -1  0  0    0.0000000    0.2500000    0.7500000
 0 -1  0  0  0  1  1  0  0    0.0000000    0.2500000    0.7500000
 0  1  0 -1  0  0  0  0  1    0.0000000    0.2500000    0.7500000
 0 -1  0  1  0  0  0  0 -1    0.0000000    0.2500000    0.7500000
 0 -1  0  0  0 -1  1  0  0    0.0000000    0.2500000    0.7500000
 0  1  0  0  0  1 -1  0  0    0.0000000    0.2500000    0.7500000
 0 -1  0 -1  0  0  0  0 -1    0.0000000    0.2500000    0.7500000
 0  1  0  1  0  0  0  0  1    0.0000000    0.2500000    0.7500000
 0 -1  0  0  0  1 -1  0  0    0.0000000    0.2500000    0.7500000
 0  1  0  0  0 -1  1  0  0    0.0000000    0.2500000    0.7500000
 0 -1  0  1  0  0  0  0  1    0.0000000    0.2500000    0.7500000
 0  1  0 -1  0  0  0  0 -1    0.0000000    0.2500000    0.7500000
 0  0  1  1  0  0  0  1  0    0.0000000    0.2500000    0.7500000
 0  0 -1 -1  0  0  0 -1  0    0.0000000    0.2500000    0.7500000
 1  0  0  0  0 -1  0  1  0    0.0000000    0.2500000    0.7500000
-1  0  0  0  0  1  0 -1  0    0.0000000    0.2500000    0.7500000
 0  0 -1 -1  0  0  0  1  0    0.0000000    0.2500000    0.7500000
 0  0  1  1  0  0  0 -1  0    0.0000000    0.2500000    0.7500000
-1  0  0  0  0  1  0  1  0    0.0000000    0.2500000    0.7500000
 1  0  0  0  0 -1  0 -1  0    0.0000000    0.2500000    0.7500000
 0  0 -1  1  0  0  0 -1  0    0.0000000    0.2500000    0.7500000
 0  0  1 -1  0  0  0  1  0    0.0000000    0.2500000    0.7500000
-1  0  0  0  0 -1  0 -1  0    0.0000000    0.2500000    0.7500000
 1  0  0  0  0  1  0  1  0    0.0000000    0.2500000    0.7500000
 0  0  1 -1  0  0  0 -1  0    0.0000000    0.2500000    0.7500000
 0  0 -1  1  0  0  0  1  0    0.0000000    0.2500000    0.7500000
 1  0  0  0  0  1  0 -1  0    0.0000000    0.2500000    0.7500000
-1  0  0  0  0 -1  0  1  0    0.0000000    0.2500000    0.7500000
 1  0  0  0  1  0  0  0  1    0.7500000    0.0000000    0.7500000
-1  0  0  0 -1  0  0  0 -1    0.7500000    0.0000000    0.7500000
 0  0 -1  0  1  0  1  0  0    0.7500000    0.0000000    0.7500000
 0  0  1  0 -1  0 -1  0  0    0.7500000    0.0000000    0.7500000
-1  0  0  0  1  0  0  0 -1    0.7500000    0.0000000    0.7500000
 1  0  0  0 -1  0  0  0  1    0.7500000    0.0000000    0.7500000
 0  0  1  0  1  0 -1  0  0    0.7500000    0.0000000    0.7500000
 0  0 -1  0 -1  0  1  0  0    0.7500000    0.0000000    0.7500000
 1  0  0  0 -1  0  0  0 -1    0.7500000    0.0000000    0.7500000
-1  0  0  0  1  0  0  0  1    0.7500000    0.0000000    0.7500000
 0  0 -1  0 -1  0 -1  0  0    0.7500000    0.0000000    0.7500000
 0  0  1  0  1  0  1  0  0    0.7500000    0.0000000    0.7500000
-1  0  0  0 -1  0  0  0  1    0.7500000    0.0000000    0.7500000
 1  0  0  0  1  0  0  0 -1    0.7500000    0.0000000    0.7500000
 0  0  1  0 -1  0  1  0  0    0.7500000    0.0000000    0.7500000
 0  0 -1  0  1  0 -1  0  0    0.7500000    0.0000000    0.7500000
 0  1  0  0  0  1  1  0  0    0.7500000    0.0000000    0.7500000
 0 -1  0  0  0 -1 -1  0  0    0.7500000    0.0000000    0.7500000
 0  1  0  1  0  0  0  0 -1    0.7500000    0.0000000    0.7500000
 0 -1  0 -1  0  0  0  0  1    0.7500000    0.0000000    0.7500000
 0  1  0  0  0 -1 -1  0  0    0.7500000    0.0000000    0.7500000
 0 -1  0  0  0  1  1  0  0    0.7500000    0.0000000    0.7500000
 0  1  0 -1  0  0  0  0  1    0.7500000    0.0000000    0.7500000
 0 -1  0  1  0  0  0  0 -1    0.7500000    0.0000000    0.7500000
 0 -1  0  0  0 -1  1  0  0    0.7500000    0.0000000    0.7500000
 0  1  0  0  0  1 -1  0  0    0.7500000    0.0000000    0.7500000
 0 -1  0 -1  0  0  0  0 -1    0.7500000    0.0000000    0.7500000
 0  1  0  1  0  0  0  0  1    0.7500000    0.0000000    0.7500000
 0 -1  0  0  0  1 -1  0  0    0.7500000    0.0000000    0.7500000
 0  1  0  0  0 -1  1  0  0    0.7500000    0.0000000    0.7500000
 0 -1  0  1  0  0  0  0  1    0.7500000    0.0000000    0.7500000
 0  1  0 -1  0  0  0  0 -1    0.7500000    0.0000000    0.7500000
 0  0  1  1  0  0  0  1  0    0.7500000    0.0000000    0.7500000
 0  0 -1 -1  0  0  0 -1  0    0.7500000    0.0000000    0.7500000
 1  0  0  0  0 -1  0  1  0    0.7500000    0.0000000    0.7500000
-1  0  0  0  0  1  0 -1  0    0.7500000    0.0000000    0.7500000
 0  0 -1 -1  0  0  0  1  0    0.7500000    0.0000000    0.7500000
 0  0  1  1  0  0  0 -1  0    0.7500000    0.0000000    0.7500000
-1  0  0  0  0  1  0  1  0    0.7500000    0.0000000    0.7500000
 1  0  0  0  0 -1  0 -1  0    0.7500000    0.0000000    0.7500000
 0  0 -1  1  0  0  0 -1  0    0.7500000    0.0000000    0.7500000
 0  0  1 -1  0  0  0  1  0    0.7500000    0.0000000    0.7500000
-1  0  0  0  0 -1  0 -1  0    0.7500000    0.0000000    0.7500000
 1  0  0  0  0  1  0  1  0    0.7500000    0.0000000    0.7500000
 0  0  1 -1  0  0  0 -1  0    0.7500000    0.0000000    0.7500000
 0  0 -1  1  0  0  0  1  0    0.7500000    0.0000000    0.7500000
 1  0  0  0  0  1  0 -1  0    0.7500000    0.0000000    0.7500000
-1  0  0  0  0 -1  0  1  0    0.7500000    0.0000000    0.7500000
 1  0  0  0  1  0  0  0  1    0.5000000    0.7500000    0.7500000
-1  0  0  0 -1  0  0  0 -1    0.5000000    0.7500000    0.7500000
 0  0 -1  0  1  0  1  0  0    0.5000000    0.7500000    0.7500000
 0  0  1  0 -1  0 -1  0  0    0.5000000    0.7500000    0.7500000
-1  0  0  0  1  0  0  0 -1    0.5000000    0.7500000    0.7500000
 1  0  0  0 -1  0  0  0  1    0.5000000    0.7500000    0.7500000
 0  0  1  0  1  0 -1  0  0    0.5000000    0.7500000    0.7500000
 0  0 -1  0 -1  0  1  0  0    0.5000000    0.7500000    0.7500000
 1  0  0  0 -1  0  0  0 -1    0.5000000    0.7500000    0.7500000
-1  0  0  0  1  0  0  0  1    0.5000000    0.7500000    0.7500000
 0  0 -1  0 -1  0 -1  0  0    0.5000000    0.7500000    0.7500000
 0  0  1  0  1  0  1  0  0    0.5000000    0.7500000    0.7500000
-1  0  0  0 -1  0  0  0  1    0.5000000    0.7500000    0.7500000
 1  0  0  0  1  0  0  0 -1    0.5000000    0.7500000    0.7500000
 0  0  1  0 -1  0  1  0  0    0.5000000    0.7500000    0.7500000
 0  0 -1  0  1  0 -1  0  0    0.5000000    0.7500000    0.7500000
 0  1  0  0  0  1  1  0  0    0.5000000    0.7500000    0.7500000
 0 -1  0  0  0 -1 -1  0  0    0.5000000    0.7500000    0.7500000
 0  1  0  1  0  0  0  0 -1    0.5000000    0.7500000    0.7500000
 0 -1  0 -1  0  0  0  0  1    0.5000000    0.7500000    0.7500000
 0  1  0  0  0 -1 -1  0  0    0.5000000    0.7500000    0.7500000
 0 -1  0  0  0  1  1  0  0    0.5000000    0.7500000    0.7500000
 0  1  0 -1  0  0  0  0  1    0.5000000    0.7500000    0.7500000
 0 -1  0  1  0  0  0  0 -1    0.5000000    0.7500000    0.7500000
 0 -1  0  0  0 -1  1  0  0    0.5000000    0.7500000    0.7500000
 0  1  0  0  0  1 -1  0  0    0.5000000    0.7500000    0.7500000
 0 -1  0 -1  0  0  0  0 -1    0.5000000    0.7500000    0.7500000
 0  1  0  1  0  0  0  0  1    0.5000000    0.7500000    0.7500000
 0 -1  0  0  0  1 -1  0  0    0.5000000    0.7500000    0.7500000
 0  1  0  0  0 -1  1  0  0    0.5000000    0.7500000    0.7500000
 0 -1  0  1  0  0  0  0  1    0.5000000    0.7500000    0.7500000
 0  1  0 -1  0  0  0  0 -1    0.5000000    0.7500000    0.7500000
 0  0  1  1  0  0  0  1  0    0.5000000    0.7500000    0.7500000
 0  0 -1 -1  0  0  0 -1  0    0.5000000    0.7500000    0.7500000
 1  0  0  0  0 -1  0  1  0    0.5000000    0.7500000    0.7500000
-1  0  0  0  0  1  0 -1  0    0.5000000    0.7500000    0.7500000
 0  0 -1 -1  0  0  0  1  0    0.5000000    0.7500000    0.7500000
 0  0  1  1  0  0  0 -1  0    0.5000000    0.7500000    0.7500000
-1  0  0  0  0  1  0  1  0    0.5000000    0.7500000    0.7500000
 1  0  0  0  0 -1  0 -1  0    0.5000000    0.7500000    0.7500000
 0  0 -1  1  0  0  0 -1  0    0.5000000    0.7500000    0.7500000
 0  0  1 -1  0  0  0  1  0    0.5000000    0.7500000    0.7500000
-1  0  0  0  0 -1  0 -1  0    0.5000000    0.7500000    0.7500000
 1  0  0  0  0  1  0  1  0    0.5000000    0.7500000    0.7500000
 0  0  1 -1  0  0  0 -1  0    0.5000000    0.7500000    0.7500000
 0  0 -1  1  0  0  0  1  0    0.5000000    0.7500000    0.7500000
 1  0  0  0  0  1  0 -1  0    0.5000000    0.7500000    0.7500000
-1  0  0  0  0 -1  0  1  0    0.5000000    0.7500000    0.7500000
 1  0  0  0  1  0  0  0  1    0.2500000    0.5000000    0.7500000
-1  0  0  0 -1  0  0  0 -1    0.2500000    0.5000000    0.7500000
 0  0 -1  0  1  0  1  0  0    0.2500000    0.5000000    0.7500000
 0  0  1  0 -1  0 -1  0  0    0.2500000    0.5000000    0.7500000
-1  0  0  0  1  0  0  0 -1    0.2500000    0.5000000    0.7500000
 1  0  0  0 -1  0  0  0  1    0.2500000    0.5000000    0.7500000
 0  0  1  0  1  0 -1  0  0    0.2500000    0.5000000    0.7500000
 0  0 -1  0 -1  0  1  0  0    0.2500000    0.5000000    0.7500000
 1  0  0  0 -1  0  0  0 -1    0.2500000    0.5000000    0.7500000
-1  0  0  0  1  0  0  0  1    0.2500000    0.5000000    0.7500000
 0  0 -1  0 -1  0 -1  0  0    0.2500000    0.5000000    0.7500000
 0  0  1  0  1  0  1  0  0    0.2500000    0.5000000    0.7500000
-1  0  0  0 -1  0  0  0  1    0.2500000    0.5000000    0.7500000
 1  0  0  0  1  0  0  0 -1    0.2500000    0.5000000    0.7500000
 0  0  1  0 -1  0  1  0  0    0.2500000    0.5000000    0.7500000
 0  0 -1  0  1  0 -1  0  0    0.2500000    0.5000000    0.7500000
 0  1  0  0  0  1  1  0  0    0.2500000    0.5000000    0.7500000
 0 -1  0  0  0 -1 -1  0  0    0.2500000    0.5000000    0.7500000
 0  1  0  1  0  0  0  0 -1    0.2500000    0.5000000    0.7500000
 0 -1  0 -1  0  0  0  0  1    0.2500000    0.5000000    0.7500000
 0  1  0  0  0 -1 -1  0  0    0.2500000    0.5000000    0.7500000
 0 -1  0  0  0  1  1  0  0    0.2500000    0.5000000    0.7500000
 0  1  0 -1  0  0  0  0  1    0.2500000    0.5000000    0.7500000
 0 -1  0  1  0  0  0  0 -1    0.2500000    0.5000000    0.7500000
 0 -1  0  0  0 -1  1  0  0    0.2500000    0.5000000    0.7500000
 0  1  0  0  0  1 -1  0  0    0.2500000    0.5000000    0.7500000
 0 -1  0 -1  0  0  0  0 -1    0.2500000    0.5000000    0.7500000
 0  1  0  1  0  0  0  0  1    0.2500000    0.5000000    0.7500000
 0 -1  0  0  0  1 -1  0  0    0.2500000    0.5000000    0.7500000
 0  1  0  0  0 -1  1  0  0    0.2500000    0.5000000    0.7500000
 0 -1  0  1  0  0  0  0  1    0.2500000    0.5000000    0.7500000
 0  1  0 -1  0  0  0  0 -1    0.2500000    0.5000000    0.7500000
 0  0  1  1  0  0  0  1  0    0.2500000    0.5000000    0.7500000
 0  0 -1 -1  0  0  0 -1  0    0.2500000    0.5000000    0.7500000
 1  0  0  0  0 -1  0  1  0    0.2500000    0.5000000    0.7500000
-1  0  0  0  0  1  0 -1  0    0.2500000    0.5000000    0.7500000
 0  0 -1 -1  0  0  0  1  0    0.2500000    0.5000000    0.7500000
 0  0  1  1  0  0  0 -1  0    0.2500000    0.5000000    0.7500000
-1  0  0  0  0  1  0  1  0    0.2500000    0.5000000    0.7500000
 1  0  0  0  0 -1  0 -1  0    0.2500000    0.5000000    0.7500000
 0  0 -1  1  0  0  0 -1  0    0.2500000    0.5000000    0.7500000
 0  0  1 -1  0  0  0  1  0    0.2500000    0.5000000    0.7500000
-1  0  0  0  0 -1  0 -1  0    0.2500000    0.5000000    0.7500000
 1  0  0  0  0  1  0  1  0    0.2500000    0.5000000    0.7500000
 0  0  1 -1  0  0  0 -1  0    0.2500000    0.5000000    0.7500000
 0  0 -1  1  0  0  0  1  0    0.2500000    0.5000000    0.7500000
 1  0  0  0  0  1  0 -1  0    0.2500000    0.5000000    0.7500000
-1  0  0  0  0 -1  0  1  0    0.2500000    0.5000000    0.7500000
 1  0  0  0  1  0  0  0  1    0.2500000    0.2500000    0.5000000
-1  0  0  0 -1  0  0  0 -1    0.2500000    0.2500000    0.5000000
 0  0 -1  0  1  0  1  0  0    0.2500000    0.2500000    0.5000000
 0  0  1  0 -1  0 -1  0  0    0.2500000    0.2500000    0.5000000
-1  0  0  0  1  0  0  0 -1    0.2500000    0.2500000    0.5000000
 1  0  0  0 -1  0  0  0  1    0.2500000    0.2500000    0.5000000
 0  0  1  0  1  0 -1  0  0    0.2500000    0.2500000    0.5000000
 0  0 -1  0 -1  0  1  0  0    0.2500000    0.2500000    0.5000000
 1  0  0  0 -1  0  0  0 -1    0.2500000    0.2500000    0.5000000
-1  0  0  0  1  0  0  0  1    0.2500000    0.2500000    0.5000000
 0  0 -1  0 -1  0 -1  0  0    0.2500000    0.2500000    0.5000000
 0  0  1  0  1  0  1  0  0    0.2500000    0.2500000    0.5000000
-1  0  0  0 -1  0  0  0  1    0.2500000    0.2500000    0.5000000
 1  0  0  0  1  0  0  0 -1    0.2500000    0.2500000    0.5000000
 0  0  1  0 -1  0  1  0  0    0.2500000    0.2500000    0.5000000
 0  0 -1  0  1  0 -1  0  0    0.2500000    0.2500000    0.5000000
 0  1  0  0  0  1  1  0  0    0.2500000    0.2500000    0.5000000
 0 -1  0  0  0 -1 -1  0  0    0.2500000    0.2500000    0.5000000
 0  1  0  1  0  0  0  0 -1    0.2500000    0.2500000    0.5000000
 0 -1  0 -1  0  0  0  0  1    0.2500000    0.2500000    0.5000000
 0  1  0  0  0 -1 -1  0  0    0.2500000    0.2500000    0.5000000
 0 -1  0  0  0  1  1  0  0    0.2500000    0.2500000    0.5000000
 0  1  0 -1  0  0  0  0  1    0.2500000    0.2500000    0.5000000
 0 -1  0  1  0  0  0  0 -1    0.2500000    0.2500000    0.5000000
 0 -1  0  0  0 -1  1  0  0    0.2500000    0.2500000    0.5000000
 0  1  0  0  0  1 -1  0  0    0.2500000    0.2500000    0.5000000
 0 -1  0 -1  0  0  0  0 -1    0.2500000    0.2500000    0.5000000
 0  1  0  1  0  0  0  0  1    0.2500000    0.2500000    0.5000000
 0 -1  0  0  0  1 -1  0  0    0.2500000    0.2500000    0.5000000
 0  1  0  0  0 -1  1  0  0    0.2500000    0.2500000    0.5000000
 0 -1  0  1  0  0  0  0  1    0.2500000    0.2500000    0.5000000
 0  1  0 -1  0  0  0  0 -1    0.2500000    0.2500000    0.5000000
 0  0  1  1  0  0  0  1  0    0.2500000    0.2500000    0.5000000
 0  0 -1 -1  0  0  0 -1  0    0.2500000    0.2500000    0.5000000
 1  0  0  0  0 -1  0  1  0    0.2500000    0.2500000    0.5000000
-1  0  0  0  0  1  0 -1  0    0.2500000    0.2500000    0.5000000
 0  0 -1 -1  0  0  0  1  0    0.2500000    0.2500000    0.5000000
 0  0  1  1  0  0  0 -1  0    0.2500000    0.2500000    0.5000000
-1  0  0  0  0  1  0  1  0    0.2500000    0.2500000    0.5000000
 1  0  0  0  0 -1  0 -1  0    0.2500000    0.2500000    0.5000000
 0  0 -1  1  0  0  0 -1  0    0.2500000    0.2500000    0.5000000
 0  0  1 -1  0  0  0  1  0    0.2500000    0.2500000    0.5000000
-1  0  0  0  0 -1  0 -1  0    0.2500000    0.2500000    0.5000000
 1  0  0  0  0  1  0  1  0    0.2500000    0.2500000    0.5000000
 0  0  1 -1  0  0  0 -1  0    0.2500000    0.2500000    0.5000000
 0  0 -1  1  0  0  0  1  0    0.2500000    0.2500000    0.5000000
 1  0  0  0  0  1  0 -1  0    0.2500000    0.2500000    0.5000000
-1  0  0  0  0 -1  0  1  0    0.2500000    0.2500000    0.5000000
 1  0  0  0  1  0  0  0  1    0.0000000    0.0000000    0.5000000
-1  0  0  0 -1  0  0  0 -1    0.0000000    0.0000000    0.5000000
 0  0 -1  0  1  0  1  0  0    0.0000000    0.0000000    0.5000000
 0  0  1  0 -1  0 -1  0  0    0.0000000    0.0000000    0.5000000
-1  0  0  0  1  0  0  0 -1    0.0000000    0.0000000    0.5000000
 1  0  0  0 -1  0  0  0  1    0.0000000    0.0000000    0.5000000
 0  0  1  0  1  0 -1  0  0    0.0000000    0.0000000    0.5000000
 0  0 -1  0 -1  0  1  0  0    0.0000000    0.0000000    0.5000000
 1  0  0  0 -1  0  0  0 -1    0.0000000    0.0000000    0.5000000
-1  0  0  0  1  0  0  0  1    0.0000000    0.0000000    0.5000000
 0  0 -1  0 -1  0 -1  0  0    0.0000000    0.0000000    0.5000000
 0  0  1  0  1  0  1  0  0    0.0000000    0.0000000    0.5000000
-1  0  0  0 -1  0  0  0  1    0.0000000    0.0000000    0.5000000
 1  0  0  0  1  0  0  0 -1    0.0000000    0.0000000    0.5000000
 0  0  1  0 -1  0  1  0  0    0.0000000    0.0000000    0.5000000
 0  0 -1  0  1  0 -1  0  0    0.0000000    0.0000000    0.5000000
 0  1  0  0  0  1  1  0  0    0.0000000    0.0000000    0.5000000
 0 -1  0  0  0 -1 -1  0  0    0.0000000    0.0000000    0.5000000
 0  1  0  1  0  0  0  0 -1    0.0000000    0.0000000    0.5000000
 0 -1  0 -1  0  0  0  0  1    0.0000000    0.0000000    0.5000000
 0  1  0  0  0 -1 -1  0  0    0.0000000    0.0000000    0.5000000
 0 -1  0  0  0  1  1  0  0    0.0000000    0.0000000    0.5000000
 0  1  0 -1  0  0  0  0  1    0.0000000    0.0000000    0.5000000
 0 -1  0  1  0  0  0  0 -1    0.0000000    0.0000000    0.5000000
 0 -1  0  0  0 -1  1  0  0    0.0000000    0.0000000    0.5000000
 0  1  0  0  0  1 -1  0  0    0.0000000    0.0000000    0.5000000
 0 -1  0 -1  0  0  0  0 -1    0.0000000    0.0000000    0.5000000
 0  1  0  1  0  0  0  0  1    0.0000000    0.0000000    0.5000000
 0 -1  0  0  0  1 -1  0  0    0.0000000    0.0000000    0.5000000
 0  1  0  0  0 -1  1  0  0    0.0000000    0.0000000    0.5000000
 0 -1  0  1  0  0  0  0  1    0.0000000    0.0000000    0.5000000
 0  1  0 -1  0  0  0  0 -1    0.0000000    0.0000000    0.5000000
 0  0  1  1  0  0  0  1  0    0.0000000    0.0000000    0.5000000
 0  0 -1 -1  0  0  0 -1  0    0.0000000    0.0000000    0.5000000
 1  0  0  0  0 -1  0  1  0    0.0000000    0.0000000    0.5000000
-1  0  0  0  0  1  0 -1  0    0.0000000    0.0000000    0.5000000
 0  0 -1 -1  0  0  0  1  0    0.0000000    0.0000000    0.5000000
 0  0  1  1  0  0  0 -1  0    0.0000000    0.0000000    0.5000000
-1  0  0  0  0  1  0  1  0    0.0000000    0.0000000    0.5000000
 1  0  0  0  0 -1  0 -1  0    0.0000000    0.0000000    0.5000000
 0  0 -1  1  0  0  0 -1  0    0.0000000    0.0000000    0.5000000
 0  0  1 -1  0  0  0  1  0    0.0000000    0.0000000    0.5000000
-1  0  0  0  0 -1  0 -1  0    0.0000000    0.0000000    0.5000000
 1  0  0  0  0  1  0  1  0    0.0000000    0.0000000    0.5000000
 0  0  1 -1  0  0  0 -1  0    0.0000000    0.0000000    0.5000000
 0  0 -1  1  0  0  0  1  0    0.0000000    0.0000000    0.5000000
 1  0  0  0  0  1  0 -1  0    0.0000000    0.0000000    0.5000000
-1  0  0  0  0 -1  0  1  0    0.0000000    0.0000000    0.5000000
 1  0  0  0  1  0  0  0  1    0.7500000    0.7500000    0.5000000
-1  0  0  0 -1  0  0  0 -1    0.7500000    0.7500000    0.5000000
 0  0 -1  0  1  0  1  0  0    0.7500000    0.7500000    0.5000000
 0  0  1  0 -1  0 -1  0  0    0.7500000    0.7500000    0.5000000
-1  0  0  0  1  0  0  0 -1    0.7500000    0.7500000    0.5000000
 1  0  0  0 -1  0  0  0  1    0.7500000    0.7500000    0.5000000
 0  0  1  0  1  0 -1  0  0    0.7500000    0.7500000    0.5000000
 0  0 -1  0 -1  0  1  0  0    0.7500000    0.7500000    0.5000000
 1  0  0  0 -1  0  0  0 -1    0.7500000    0.7500000    0.5000000
-1  0  0  0  1  0  0  0  1    0.7500000    0.7500000    0.5000000
 0  0 -1  0 -1  0 -1  0  0    0.7500000    0.7500000    0.5000000
 0  0  1  0  1  0  1  0  0    0.7500000    0.7500000    0.5000000
-1  0  0  0 -1  0  0  0  1    0.7500000    0.7500000    0.5000000
 1  0  0  0  1  0  0  0 -1    0.7500000    0.7500000    0.5000000
 0  0  1  0 -1  0  1  0  0    0.7500000    0.7500000    0.5000000
 0  0 -1  0  1  0 -1  0  0    0.7500000    0.7500000    0.5000000
 0  1  0  0  0  1  1  0  0    0.7500000    0.7500000    0.5000000
 0 -1  0  0  0 -1 -1  0  0    0.7500000    0.7500000    0.5000000
 0  1  0  1  0  0  0  0 -1    0.7500000    0.7500000    0.5000000
 0 -1  0 -1  0  0  0  0  1    0.7500000    0.7500000    0.5000000
 0  1  0  0  0 -1 -1  0  0    0.7500000    0.7500000    0.5000000
 0 -1  0  0  0  1  1  0  0    0.7500000    0.7500000    0.5000000
 0  1  0 -1  0  0  0  0  1    0.7500000    0.7500000    0.5000000
 0 -1  0  1  0  0  0  0 -1    0.7500000    0.7500000    0.5000000
 0 -1  0  0  0 -1  1  0  0    0.7500000    0.7500000    0.5000000
 0  1  0  0  0  1 -1  0  0    0.7500000    0.7500000    0.5000000
 0 -1  0 -1  0  0  0  0 -1    0.7500000    0.7500000    0.5000000
 0  1  0  1  0  0  0  0  1    0.7500000    0.7500000    0.5000000
 0 -1  0  0  0  1 -1  0  0    0.7500000    0.7500000    0.5000000
 0  1  0  0  0 -1  1  0  0    0.7500000    0.7500000    0.5000000
 0 -1  0  1  0  0  0  0  1    0.7500000    0.7500000    0.5000000
 0  1  0 -1  0  0  0  0 -1    0.7500000    0.7500000    0.5000000
 0  0  1  1  0  0  0  1  0    0.7500000    0.7500000    0.5000000
 0  0 -1 -1  0  0  0 -1  0    0.7500000    0.7500000    0.5000000
 1  0  0  0  0 -1  0  1  0    0.7500000    0.7500000    0.5000000
-1  0  0  0  0  1  0 -1  0    0.7500000    0.7500000    0.5000000
 0  0 -1 -1  0  0  0  1  0    0.7500000    0.7500000    0.5000000
 0  0  1  1  0  0  0 -1  0    0.7500000    0.7500000    0.5000000
-1  0  0  0  0  1  0  1  0    0.7500000    0.7500000    0.5000000
 1  0  0  0  0 -1  0 -1  0    0.7500000    0.7500000    0.5000000
 0  0 -1  1  0  0  0 -1  0    0.7500000    0.7500000    0.5000000
 0  0  1 -1  0  0  0  1  0    0.7500000    0.7500000    0.5000000
-1  0  0  0  0 -1  0 -1  0    0.7500000    0.7500000    0.5000000
 1  0  0  0  0  1  0  1  0    0.7500000    0.7500000    0.5000000
 0  0  1 -1  0  0  0 -1  0    0.7500000    0.7500000    0.5000000
 0  0 -1  1  0  0  0  1  0    0.7500000    0.7500000    0.5000000
 1  0  0  0  0  1  0 -1  0    0.7500000    0.7500000    0.5000000
-1  0  0  0  0 -1  0  1  0    0.7500000    0.7500000    0.5000000
 1  0  0  0  1  0  0  0  1    0.5000000    0.5000000    0.5000000
-1  0  0  0 -1  0  0  0 -1    0.5000000    0.5000000    0.5000000
 0  0 -1  0  1  0  1  0  0    0.5000000    0.5000000    0.5000000
 0  0  1  0 -1  0 -1  0  0    0.5000000    0.5000000    0.5000000
-1  0  0  0  1  0  0  0 -1    0.5000000    0.5000000    0.5000000
 1  0  0  0 -1  0  0  0  1    0.5000000    0.5000000    0.5000000
 0  0  1  0  1  0 -1  0  0    0.5000000    0.5000000    0.5000000
 0  0 -1  0 -1  0  1  0  0    0.5000000    0.5000000    0.5000000
 1  0  0  0 -1  0  0  0 -1    0.5000000    0.5000000    0.5000000
-1  0  0  0  1  0  0  0  1    0.5000000    0.5000000    0.5000000
 0  0 -1  0 -1  0 -1  0  0    0.5000000    0.5000000    0.5000000
 0  0  1  0  1  0  1  0  0    0.5000000    0.5000000    0.5000000
-1  0  0  0 -1  0  0  0  1    0.5000000    0.5000000    0.5000000
 1  0  0  0  1  0  0  0 -1    0.5000000    0.5000000    0.5000000
 0  0  1  0 -1  0  1  0  0    0.5000000    0.5000000    0.5000000
 0  0 -1  0  1  0 -1  0  0    0.5000000    0.5000000    0.5000000
 0  1  0  0  0  1  1  0  0    0.5000000    0.5000000    0.5000000
 0 -1  0  0  0 -1 -1  0  0    0.5000000    0.5000000    0.5000000
 0  1  0  1  0  0  0  0 -1    0.5000000    0.5000000    0.5000000
 0 -1  0 -1  0  0  0  0  1    0.5000000    0.5000000    0.5000000
 0  1  0  0  0 -1 -1  0  0    0.5000000    0.5000000    0.5000000
 0 -1  0  0  0  1  1  0  0    0.5000000    0.5000000    0.5000000
 0  1  0 -1  0  0  0  0  1    0.5000000    0.5000000    0.5000000
 0 -1  0  1  0  0  0  0 -1    0.5000000    0.5000000    0.5000000
 0 -1  0  0  0 -1  1  0  0    0.5000000    0.5000000    0.5000000
 0  1  0  0  0  1 -1  0  0    0.5000000    0.5000000    0.5000000
 0 -1  0 -1  0  0  0  0 -1    0.5000000    0.5000000    0.5000000
 0  1  0  1  0  0  0  0  1    0.5000000    0.5000000    0.5000000
 0 -1  0  0  0  1 -1  0  0    0.5000000    0.5000000    0.5000000
 0  1  0  0  0 -1  1  0  0    0.5000000    0.5000000    0.5000000
 0 -1  0  1  0  0  0  0  1    0.5000000    0.5000000    0.5000000
 0  1  0 -1  0  0  0  0 -1    0.5000000    0.5000000    0.5000000
 0  0  1  1  0  0  0  1  0    0.5000000    0.5000000    0.5000000
 0  0 -1 -1  0  0  0 -1  0    0.5000000    0.5000000    0.5000000
 1  0  0  0  0 -1  0  1  0    0.5000000    0.5000000    0.5000000
-1  0  0  0  0  1  0 -1  0    0.5000000    0.5000000    0.5000000
 0  0 -1 -1  0  0  0  1  0    0.5000000    0.5000000    0.5000000
 0  0  1  1  0  0  0 -1  0    0.5000000    0.5000000    0.5000000
-1  0  0  0  0  1  0  1  0    0.5000000    0.5000000    0.5000000
 1  0  0  0  0 -1  0 -1  0    0.5000000    0.5000000    0.5000000
 0  0 -1  1  0  0  0 -1  0    0.5000000    0.5000000    0.5000000
 0  0  1 -1  0  0  0  1  0    0.5000000    0.5000000    0.5000000
-1  0  0  0  0 -1  0 -1  0    0.5000000    0.5000000    0.5000000
 1  0  0  0  0  1  0  1  0    0.5000000    0.5000000    0.5000000
 0  0  1 -1  0  0  0 -1  0    0.5000000    0.5000000    0.5000000
 0  0 -1  1  0  0  0  1  0    0.5000000    0.5000000    0.5000000
 1  0  0  0  0  1  0 -1  0    0.5000000    0.5000000    0.5000000
-1  0  0  0  0 -1  0  1  0    0.5000000    0.5000000    0.5000000
 1  0  0  0  1  0  0  0  1    0.5000000    0.2500000    0.2500000
-1  0  0  0 -1  0  0  0 -1    0.5000000    0.2500000    0.2500000
 0  0 -1  0  1  0  1  0  0    0.5000000    0.2500000    0.2500000
 0  0  1  0 -1  0 -1  0  0    0.5000000    0.2500000    0.2500000
-1  0  0  0  1  0  0  0 -1    0.5000000    0.2500000    0.2500000
 1  0  0  0 -1  0  0  0  1    0.5000000    0.2500000    0.2500000
 0  0  1  0  1  0 -1  0  0    0.5000000    0.2500000    0.2500000
 0  0 -1  0 -1  0  1  0  0    0.5000000    0.2500000    0.2500000
 1  0  0  0 -1  0  0  0 -1    0.5000000    0.2500000    0.2500000
-1  0  0  0  1  0  0  0  1    0.5000000    0.2500000    0.2500000
 0  0 -1  0 -1  0 -1  0  0    0.5000000    0.2500000    0.2500000
 0  0  1  0  1  0  1  0  0    0.5000000    0.2500000    0.2500000
-1  0  0  0 -1  0  0  0  1    0.5000000    0.2500000    0.2500000
 1  0  0  0  1  0  0  0 -1    0.5000000    0.2500000    0.2500000
 0  0  1  0 -1  0  1  0  0    0.5000000    0.2500000    0.2500000
 0  0 -1  0  1  0 -1  0  0    0.5000000    0.2500000    0.2500000
 0  1  0  0  0  1  1  0  0    0.5000000    0.2500000    0.2500000
 0 -1  0  0  0 -1 -1  0  0    0.5000000    0.2500000    0.2500000
 0  1  0  1  0  0  0  0 -1    0.5000000    0.2500000    0.2500000
 0 -1  0 -1  0  0  0  0  1    0.5000000    0.2500000    0.2500000
 0  1  0  0  0 -1 -1  0  0    0.5000000    0.2500000    0.2500000
 0 -1  0  0  0  1  1  0  0    0.5000000    0.2500000    0.2500000
 0  1  0 -1  0  0  0  0  1    0.5000000    0.2500000    0.2500000
 0 -1  0  1  0  0  0  0 -1    0.5000000    0.2500000    0.2500000
 0 -1  0  0  0 -1  1  0  0    0.5000000    0.2500000    0.2500000
 0  1  0  0  0  1 -1  0  0    0.5000000    0.2500000    0.2500000
 0 -1  0 -1  0  0  0  0 -1    0.5000000    0.2500000    0.2500000
 0  1  0  1  0  0  0  0  1    0.5000000    0.2500000    0.2500000
 0 -1  0  0  0  1 -1  0  0    0.5000000    0.2500000    0.2500000
 0  1  0  0  0 -1  1  0  0    0.5000000    0.2500000    0.2500000
 0 -1  0  1  0  0  0  0  1    0.5000000    0.2500000    0.2500000
 0  1  0 -1  0  0  0  0 -1    0.5000000    0.2500000    0.2500000
 0  0  1  1  0  0  0  1  0    0.5000000    0.2500000    0.2500000
 0  0 -1 -1  0  0  0 -1  0    0.5000000    0.2500000    0.2500000
 1  0  0  0  0 -1  0  1  0    0.5000000    0.2500000    0.2500000
-1  0  0  0  0  1  0 -1  0    0.5000000    0.2500000    0.2500000
 0  0 -1 -1  0  0  0  1  0    0.5000000    0.2500000    0.2500000
 0  0  1  1  0  0  0 -1  0    0.5000000    0.2500000    0.2500000
-1  0  0  0  0  1  0  1  0    0.5000000    0.2500000    0.2500000
 1  0  0  0  0 -1  0 -1  0    0.5000000    0.2500000    0.2500000
 0  0 -1  1  0  0  0 -1  0    0.5000000    0.2500000    0.2500000
 0  0  1 -1  0  0  0  1  0    0.5000000    0.2500000    0.2500000
-1  0  0  0  0 -1  0 -1  0    0.5000000    0.2500000    0.2500000
 1  0  0  0  0  1  0  1  0    0.5000000    0.2500000    0.2500000
 0  0  1 -1  0  0  0 -1  0    0.5000000    0.2500000    0.2500000
 0  0 -1  1  0  0  0  1  0    0.5000000    0.2500000    0.2500000
 1  0  0  0  0  1  0 -1  0    0.5000000    0.2500000    0.2500000
-1  0  0  0  0 -1  0  1  0    0.5000000    0.2500000    0.2500000
 1  0  0  0  1  0  0  0  1    0.2500000    0.0000000    0.2500000
-1  0  0  0 -1  0  0  0 -1    0.2500000    0.0000000    0.2500000
 0  0 -1  0  1  0  1  0  0    0.2500000    0.0000000    0.2500000
 0  0  1  0 -1  0 -1  0  0    0.2500000    0.0000000    0.2500000
-1  0  0  0  1  0  0  0 -1    0.2500000    0.0000000    0.2500000
 1  0  0  0 -1  0  0  0  1    0.2500000    0.0000000    0.2500000
 0  0  1  0  1  0 -1  0  0    0.2500000    0.0000000    0.2500000
 0  0 -1  0 -1  0  1  0  0    0.2500000    0.0000000    0.2500000
 1  0  0  0 -1  0  0  0 -1    0.2500000    0.0000000    0.2500000
-1  0  0  0  1  0  0  0  1    0.2500000    0.0000000    0.2500000
 0  0 -1  0 -1  0 -1  0  0    0.2500000    0.0000000    0.2500000
 0  0  1  0  1  0  1  0  0    0.2500000    0.0000000    0.2500000
-1  0  0  0 -1  0  0  0  1    0.2500000    0.0000000    0.2500000
 1  0  0  0  1  0  0  0 -1    0.2500000    0.0000000    0.2500000
 0  0  1  0 -1  0  1  0  0    0.2500000    0.0000000    0.2500000
 0  0 -1  0  1  0 -1  0  0    0.2500000    0.0000000    0.2500000
 0  1  0  0  0  1  1  0  0    0.2500000    0.0000000    0.2500000
 0 -1  0  0  0 -1 -1  0  0    0.2500000    0.0000000    0.2500000
 0  1  0  1  0  0  0  0 -1    0.2500000    0.0000000    0.2500000
 0 -1  0 -1  0  0  0  0  1    0.2500000    0.0000000    0.2500000
 0  1  0  0  0 -1 -1  0  0    0.2500000    0.0000000    0.2500000
 0 -1  0  0  0  1  1  0  0    0.2500000    0.0000000    0.2500000
 0  1  0 -1  0  0  0  0  1    0.2500000    0.0000000    0.2500000
 0 -1  0  1  0  0  0  0 -1    0.2500000    0.0000000    0.2500000
 0 -1  0  0  0 -1  1  0  0    0.2500000    0.0000000    0.2500000
 0  1  0  0  0  1 -1  0  0    0.2500000    0.0000000    0.2500000
 0 -1  0 -1  0  0  0  0 -1    0.2500000    0.0000000    0.2500000
 0  1  0  1  0  0  0  0  1    0.2500000    0.0000000    0.2500000
 0 -1  0  0  0  1 -1  0  0    0.2500000    0.0000000    0.2500000
 0  1  0  0  0 -1  1  0  0    0.2500000    0.0000000    0.2500000
 0 -1  0  1  0  0  0  0  1    0.2500000    0.0000000    0.2500000
 0  1  0 -1  0  0  0  0 -1    0.2500000    0.0000000    0.2500000
 0  0  1  1  0  0  0  1  0    0.2500000    0.0000000    0.2500000
 0  0 -1 -1  0  0  0 -1  0    0.2500000    0.0000000    0.2500000
 1  0  0  0  0 -1  0  1  0    0.2500000    0.0000000    0.2500000
-1  0  0  0  0  1  0 -1  0    0.2500000    0.0000000    0.2500000
 0  0 -1 -1  0  0  0  1  0    0.2500000    0.0000000    0.2500000
 0  0  1  1  0  0  0 -1  0    0.2500000    0.0000000    0.2500000
-1  0  0  0  0  1  0  1  0    0.2500000    0.0000000    0.2500000
 1  0  0  0  0 -1  0 -1  0    0.2500000    0.0000000    0.2500000
 0  0 -1  1  0  0  0 -1  0    0.2500000    0.0000000    0.2500000
 0  0  1 -1  0  0  0  1  0    0.2500000    0.0000000    0.2500000
-1  0  0  0  0 -1  0 -1  0    0.2500000    0.0000000    0.2500000
 1  0  0  0  0  1  0  1  0    0.2500000    0.0000000    0.2500000
 0  0  1 -1  0  0  0 -1  0    0.2500000    0.0000000    0.2500000
 0  0 -1  1  0  0  0  1  0    0.2500000    0.0000000    0.2500000
 1  0  0  0  0  1  0 -1  0    0.2500000    0.0000000    0.2500000
-1  0  0  0  0 -1  0  1  0    0.2500000    0.0000000    0.2500000
 1  0  0  0  1  0  0  0  1    0.0000000    0.7500000    0.2500000
-1  0  0  0 -1  0  0  0 -1    0.0000000    0.7500000    0.2500000
 0  0 -1  0  1  0  1  0  0    0.0000000    0.7500000    0.2500000
 0  0  1  0 -1  0 -1  0  0    0.0000000    0.7500000    0.2500000
-1  0  0  0  1  0  0  0 -1    0.0000000    0.7500000    0.2500000
 1  0  0  0 -1  0  0  0  1    0.0000000    0.7500000    0.2500000
 0  0  1  0  1  0 -1  0  0    0.0000000    0.7500000    0.2500000
 0  0 -1  0 -1  0  1  0  0    0.0000000    0.7500000    0.2500000
 1  0  0  0 -1  0  0  0 -1    0.0000000    0.7500000    0.2500000
-1  0  0  0  1  0  0  0  1    0.0000000    0.7500000    0.2500000
 0  0 -1  0 -1  0 -1  0  0    0.0000000    0.7500000    0.2500000
 0  0  1  0  1  0  1  0  0    0.0000000    0.7500000    0.2500000
-1  0  0  0 -1  0  0  0  1    0.0000000    0.7500000    0.2500000
 1  0  0  0  1  0  0  0 -1    0.0000000    0.7500000    0.2500000
 0  0  1  0 -1  0  1  0  0    0.0000000    0.7500000    0.2500000
 0  0 -1  0  1  0 -1  0  0    0.0000000    0.7500000    0.2500000
 0  1  0  0  0  1  1  0  0    0.0000000    0.7500000    0.2500000
 0 -1  0  0  0 -1 -1  0  0    0.0000000    0.7500000    0.2500000
 0  1  0  1  0  0  0  0 -1    0.0000000    0.7500000    0.2500000
 0 -1  0 -1  0  0  0  0  1    0.0000000    0.7500000    0.2500000
 0  1  0  0  0 -1 -1  0  0    0.0000000    0.7500000    0.2500000
 0 -1  0  0  0  1  1  0  0    0.0000000    0.7500000    0.2500000
 0  1  0 -1  0  0  0  0  1    0.0000000    0.7500000    0.2500000
 0 -1  0  1  0  0  0  0 -1    0.0000000    0.7500000    0.2500000
 0 -1  0  0  0 -1  1  0  0    0.0000000    0.7500000    0.2500000
 0  1  0  0  0  1 -1  0  0    0.0000000    0.7500000    0.2500000
 0 -1  0 -1  0  0  0  0 -1    0.0000000    0.7500000    0.2500000
 0  1  0  1  0  0  0  0  1    0.0000000    0.7500000    0.2500000
 0 -1  0  0  0  1 -1  0  0    0.0000000    0.7500000    0.2500000
 0  1  0  0  0 -1  1  0  0    0.0000000    0.7500000    0.2500000
 0 -1  0  1  0  0  0  0  1    0.0000000    0.7500000    0.2500000
 0  1  0 -1  0  0  0  0 -1    0.0000000    0.7500000    0.2500000
 0  0  1  1  0  0  0  1  0    0.0000000    0.7500000    0.2500000
 0  0 -1 -1  0  0  0 -1  0    0.0000000    0.7500000    0.2500000
 1  0  0  0  0 -1  0  1  0    0.0000000    0.7500000    0.2500000
-1  0  0  0  0  1  0 -1  0    0.0000000    0.7500000    0.2500000
 0  0 -1 -1  0  0  0  1  0    0.0000000    0.7500000    0.2500000
 0  0  1  1  0  0  0 -1  0    0.0000000    0.7500000    0.2500000
-1  0  0  0  0  1  0  1  0    0.0000000    0.7500000    0.2500000
 1  0  0  0  0 -1  0 -1  0    0.0000000    0.7500000    0.2500000
 0  0 -1  1  0  0  0 -1  0    0.0000000    0.7500000    0.2500000
 0  0  1 -1  0  0  0  1  0    0.0000000    0.7500000    0.2500000
-1  0  0  0  0 -1  0 -1  0    0.0000000    0.7500000    0.2500000
 1  0  0  0  0  1  0  1  0    0.0000000    0.7500000    0.2500000
 0  0  1 -1  0  0  0 -1  0    0.0000000    0.7500000    0.2500000
 0  0 -1  1  0  0  0  1  0    0.0000000    0.7500000    0.2500000
 1  0  0  0  0  1  0 -1  0    0.0000000    0.7500000    0.2500000
-1  0  0  0  0 -1  0  1  0    0.0000000    0.7500000    0.2500000
 1  0  0  0  1  0  0  0  1    0.7500000    0.5000000    0.2500000
-1  0  0  0 -1  0  0  0 -1    0.7500000    0.5000000    0.2500000
 0  0 -1  0  1  0  1  0  0    0.7500000    0.5000000    0.2500000
 0  0  1  0 -1  0 -1  0  0    0.7500000    0.5000000    0.2500000
-1  0  0  0  1  0  0  0 -1    0.7500000    0.5000000    0.2500000
 1  0  0  0 -1  0  0  0  1    0.7500000    0.5000000    0.2500000
 0  0  1  0  1  0 -1  0  0    0.7500000    0.5000000    0.2500000
 0  0 -1  0 -1  0  1  0  0    0.7500000    0.5000000    0.2500000
 1  0  0  0 -1  0  0  0 -1    0.7500000    0.5000000    0.2500000
-1  0  0  0  1  0  0  0  1    0.7500000    0.5000000    0.2500000
 0  0 -1  0 -1  0 -1  0  0    0.7500000    0.5000000    0.2500000
 0  0  1  0  1  0  1  0  0    0.7500000    0.5000000    0.2500000
-1  0  0  0 -1  0  0  0  1    0.7500000    0.5000000    0.2500000
 1  0  0  0  1  0  0  0 -1    0.7500000    0.5000000    0.2500000
 0  0  1  0 -1  0  1  0  0    0.7500000    0.5000000    0.2500000
 0  0 -1  0  1  0 -1  0  0    0.7500000    0.5000000    0.2500000
 0  1  0  0  0  1  1  0  0    0.7500000    0.5000000    0.2500000
 0 -1  0  0  0 -1 -1  0  0    0.7500000    0.5000000    0.2500000
 0  1  0  1  0  0  0  0 -1    0.7500000    0.5000000    0.2500000
 0 -1  0 -1  0  0  0  0  1    0.7500000    0.5000000    0.2500000
 0  1  0  0  0 -1 -1  0  0    0.7500000    0.5000000    0.2500000
 0 -1  0  0  0  1  1  0  0    0.7500000    0.5000000    0.2500000
 0  1  0 -1  0  0  0  0  1    0.7500000    0.5000000    0.2500000
 0 -1  0  1  0  0  0  0 -1    0.7500000    0.5000000    0.2500000
 0 -1  0  0  0 -1  1  0  0    0.7500000    0.5000000    0.2500000
 0  1  0  0  0  1 -1  0  0    0.7500000    0.5000000    0.2500000
 0 -1  0 -1  0  0  0  0 -1    0.7500000    0.5000000    0.2500000
 0  1  0  1  0  0  0  0  1    0.7500000    0.5000000    0.2500000
 0 -1  0  0  0  1 -1  0  0    0.7500000    0.5000000    0.2500000
 0  1  0  0  0 -1  1  0  0    0.7500000    0.5000000    0.2500000
 0 -1  0  1  0  0  0  0  1    0.7500000    0.5000000    0.2500000
 0  1  0 -1  0  0  0  0 -1    0.7500000    0.5000000    0.2500000
 0  0  1  1  0  0  0  1  0    0.7500000    0.5000000    0.2500000
 0  0 -1 -1  0  0  0 -1  0    0.7500000    0.5000000    0.2500000
 1  0  0  0  0 -1  0  1  0    0.7500000    0.5000000    0.2500000
-1  0  0  0  0  1  0 -1  0    0.7500000    0.5000000    0.2500000
 0  0 -1 -1  0  0  0  1  0    0.7500000    0.5000000    0.2500000
 0  0  1  1  0  0  0 -1  0    0.7500000    0.5000000    0.2500000
-1  0  0  0  0  1  0  1  0    0.7500000    0.5000000    0.2500000
 1  0  0  0  0 -1  0 -1  0    0.7500000    0.5000000    0.2500000
 0  0 -1  1  0  0  0 -1  0    0.7500000    0.5000000    0.2500000
 0  0  1 -1  0  0  0  1  0    0.7500000    0.5000000    0.2500000
-1  0  0  0  0 -1  0 -1  0    0.7500000    0.5000000    0.2500000
 1  0  0  0  0  1  0  1  0    0.7500000    0.5000000    0.2500000
 0  0  1 -1  0  0  0 -1  0    0.7500000    0.5000000    0.2500000
 0  0 -1  1  0  0  0  1  0    0.7500000    0.5000000    0.2500000
 1  0  0  0  0  1  0 -1  0    0.7500000    0.5000000    0.2500000
-1  0  0  0  0 -1  0  1  0    0.7500000    0.5000000    0.2500000"""


class TestPureTrans(unittest.TestCase):
    """Test for new implementation of search_pure_translations in
    symmetry.c (ee97ad17) against a previous version. The order of
    symmetry operations found by this new implementation may be
    different from that obtained by the older version but the set must
    be the same in rotations and very close in translations.
    """

    def setUp(self):
        cell = read_vasp_from_strings(Al222)
        self._sym_ops = get_symmetry(cell)
        rot = []
        trans = []
        for i, line in enumerate(sym_ops_str.split("\n")):
            arr = line.split()
            rot += [int(x) for x in arr[:9]]
            trans += [float(x) for x in arr[9:]]
        self._rot_ref = np.reshape(rot, (-1, 3, 3))
        self._trans_ref = np.reshape(trans, (-1, 3))

    def tearDown(self):
        pass

    def test_pure_trans(self):
        nums = []
        for i, (r, t) in enumerate(
            zip(self._sym_ops["rotations"], self._sym_ops["translations"]),
        ):
            for j, (rr, tr) in enumerate(zip(self._rot_ref, self._trans_ref)):
                if (r == rr).all() and (np.abs(t - tr) < 1e-5).all():
                    nums.append(j)
                    break

        np.testing.assert_array_equal(np.sort(nums), np.arange(len(self._rot_ref)))


if __name__ == "__main__":
    suite = unittest.TestLoader().loadTestsFromTestCase(TestPureTrans)
    unittest.TextTestRunner(verbosity=2).run(suite)
    # unittest.main()
