/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a class managing widget.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgwidget.h"

#include <QtGui/QWidget>

#include "skgtreeview.h"
#include "skgtraces.h"

SKGWidget::SKGWidget(SKGDocument* iDocument)
    : QWidget(), m_document(iDocument)
{
    SKGTRACEINFUNC(5);
}

SKGWidget::~SKGWidget()
{
    SKGTRACEINFUNC(5);
    m_document = NULL;
}

SKGDocument* SKGWidget::getDocument() const
{
    return m_document;
}

QString SKGWidget::getState()
{
    return "";
}

QString SKGWidget::getDefaultStateAttribute()
{
    return "";
}

void SKGWidget::setState(const QString& /*iState*/)
{
}

SKGObjectBase::SKGListSKGObjectBase SKGWidget::getSelectedObjects()
{
    SKGObjectBase::SKGListSKGObjectBase selection;
    SKGTreeView* treeView = qobject_cast<SKGTreeView*>(mainWidget());
    if (treeView) {
        selection = treeView->getSelectedObjects();
    }

    return selection;
}

SKGObjectBase SKGWidget::getFirstSelectedObject()
{
    SKGObjectBase first;
    SKGTreeView* treeView = qobject_cast<SKGTreeView*>(mainWidget());
    if (treeView) {
        first = treeView->getFirstSelectedObject();
    }

    return first;
}

int SKGWidget::getNbSelectedObjects()
{
    int output = 0;
    SKGTreeView* treeView = qobject_cast<SKGTreeView*>(mainWidget());
    if (treeView) {
        output = treeView->getNbSelectedObjects();
    } else {
        output = getSelectedObjects().count();
    }

    return output;
}

QWidget* SKGWidget::mainWidget()
{
    return this;
}

#include "skgwidget.moc"
