#!/usr/bin/python
# -*-coding: UTF-8 -*-
# bbou@ac-toulouse.fr
# GPL license
# 2007-05-23 17:17:08 
# sadms-deps.py

import commands
import re

#######################################################################
#	CHECK DEPS
#######################################################################

def checkDeps():
	status,output=commands.getstatusoutput("if [ -f /etc/debian_version ]; then echo 'debian'; else echo 'default'; fi")
	if not status:
		distribution=output.strip('\n\r ')
	else:
		distribution='default'
	execs={}
	for fn in ['sadms','users','globs','shares','share','sharesparser','acls','remote','runner']:
		fn=fn+'.py'
		f=open(fn,'r')
		lines=f.readlines()
		f.close()
		start=-1
		finish=-1
		i=0
		within=False
		for l in lines:
			if re.search('sysSetting={',l):
				start=i+1
				within=True
				#print fn,l
			if within and re.search('^}',l):
				finish=i
				within=False
				#print fn,l
				break;
			i=i+1

		if (start,finish)!=(-1,-1):
			code=''.join(lines[start:finish])
			code='{%s}' % code
			dic=eval(code)
			for k in dic:
				e=dic[k]
				if type(e)==type({}):
					e=e[distribution]
				e=e.split()[0]
				execs[e]=None

	execs=execs.keys()
	execs.sort()
	for e in execs:
		#print '%s' % (e)
		if re.search('^file:',e):
			continue
		status,output=commands.getstatusoutput('type '+e)
		if not status:
			#print '%-16s\t%s' % (e,output)
			print '%s -> %s' % (e,output)
			pass
		else:
			print >>sys.stderr,'MISSING %s' % (e)
	return

def checkSignals():
	for fn in ['sadms','users','globs','shares','share','acls','remote','runner']:
		fn=fn+'.py'
		print '\n%s\n' % fn
		f=open(fn,'r')
		lines=f.readlines()
		f.close()
		start=-1
		finish=-1
		i=0
		within=False
		for l in lines:
			if re.search('handlers=',l):
				start=i+1
				within=True
				#print fn,l
			if within and re.search('}',l):
				finish=i
				within=False
				#print fn,l
				break;
			i=i+1

		if (start,finish)!=(-1,-1):
			code=''.join(lines[start:finish])
			code=code.replace('self.','"')
			code=code.replace(',','",')
			code='{%s}' % code
			#print code
			dic=eval(code)
			#print dic
			signals=dic.values()
			signals.sort()
			for s in signals:
				print '%-32s>' % s,
				for l in lines:
					if re.search('def\s%s\(' % s,l):
						print l.strip(),					
						if not re.search('\*options',l):
							print 'NO OPTION',
						break
				print
	return

def checkCommands():
	status,output=commands.getstatusoutput("if [ -f /etc/debian_version ]; then echo 'debian'; else echo 'default'; fi")
	if not status:
		distribution=output.strip('\n\r ')
	else:
		distribution='default'
	execs={}
	for fn in ['sadms','users','globs','shares','share','sharesparser','acls','remote','runner']:
		fn=fn+'.py'
		f=open(fn,'r')
		lines=f.readlines()
		f.close()
		start=-1
		finish=-1
		i=0
		within=False
		for l in lines:
			if re.search('sysSetting={',l):
				start=i+1
				within=True
				#print fn,l
			if within and re.search('^}',l):
				finish=i
				within=False
				#print fn,l
				break;
			i=i+1

		if (start,finish)!=(-1,-1):
			code=''.join(lines[start:finish])
			code='{%s}' % code
			dic=eval(code)
			for k in dic:
				e=dic[k]
				if type(e)==type({}):
					e=e[distribution]
				execs[e]=None

	execs=execs.keys()
	execs.sort()
	#for e in execs:
	#	if e.find('%')==-1:
	#		print '%s' % (e)
	#		if raw_input('execute (y/N) ?')=='y':
	#			status,output=commands.getstatusoutput(e)
	#			print status,output								
	for e in execs:
		if e.find('%')!=-1:
			e=e.replace('%USER%','auser')
			e=e.replace('%GROUP%','agroup')
			e=e.replace('%HOST%','ahost')
			e=e.replace('%SERVER%','aserver')
			e=e.replace('%SHARE%','ashare')
			e=e.replace('%HOME%','ahome')
			e=e.replace('%FSOBJECT%','afile')
			e=e.replace('%FILE%','afile')
			e=e.replace('%DIRECTORY%','adir')
			e=e.replace('%SERVICE%','aservice')
			e=e.replace('%PROCESS%','process')
			e=e.replace('%COMMAND%','acommand')
			e=e.replace('%DEV%','adev')
			e=e.replace('%KEY%','akey')
			e=e.replace('%MOUNT%','amount')
			e=e.replace('%TEXT%','atext')
			e=e.replace('%KEY%','akey')
			e=e.replace('%UMODE%','-')
			e=e.replace('%GMODE%','-')
			e=e.replace('%OMODE%','-')
			e=e.replace('%MODE%','mode')
			e=e.replace('%OPTIONS%','options')
			e=e.replace('%RECURSE%','recurse')
			e=e.replace('%SOURCE%','asource')
			e=e.replace('%DESTINATION%','adestination')
			e=e.replace('%DNSDOMAIN%','adnsdomain')
			e=e.replace('%ACLS%','acls')
			e=e.replace('%PASSWORD%','apass')
			e=e.replace('%STAMP%','stamp')
			print '#%s' % (e)
			continue
			if raw_input('execute (y/N) ?')=='y':
				status,output=commands.getstatusoutput(e)
				print status,output								
	return

#######################################################################
#	MAIN
#######################################################################

import sys
import os

if __name__=="__main__":
	e=sys.argv[0]
	e=os.path.realpath(e)
	d=os.path.dirname(e)
	os.chdir(d)

	checkDeps()
	#checkSignals()
	#checkCommands()

__author__='Bernard Bou <bou@ac-toulouse.fr>'
