/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.util.AbstractSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.sablecc.sablecc.Cast;
import org.sablecc.sablecc.NoCast;

public class TypedTreeMap
extends TreeMap {
    private Cast keyCast;
    private Cast valueCast;
    private Set entries;

    public TypedTreeMap() {
        this.keyCast = NoCast.instance;
        this.valueCast = NoCast.instance;
    }

    public TypedTreeMap(Comparator comparator) {
        super(comparator);
        this.keyCast = NoCast.instance;
        this.valueCast = NoCast.instance;
    }

    public TypedTreeMap(Map map) {
        this.keyCast = NoCast.instance;
        this.valueCast = NoCast.instance;
        Map.Entry[] entryArray = map.entrySet().toArray(new Map.Entry[0]);
        for (int i = 0; i < entryArray.length; ++i) {
            this.put(entryArray[i].getKey(), entryArray[i].getValue());
        }
    }

    public TypedTreeMap(SortedMap sortedMap) {
        super(sortedMap.comparator());
        this.keyCast = NoCast.instance;
        this.valueCast = NoCast.instance;
        Map.Entry[] entryArray = sortedMap.entrySet().toArray(new Map.Entry[0]);
        for (int i = 0; i < entryArray.length; ++i) {
            this.put(entryArray[i].getKey(), entryArray[i].getValue());
        }
    }

    public TypedTreeMap(Cast cast, Cast cast2) {
        this.keyCast = cast;
        this.valueCast = cast2;
    }

    public TypedTreeMap(Comparator comparator, Cast cast, Cast cast2) {
        super(comparator);
        this.keyCast = cast;
        this.valueCast = cast2;
    }

    public Object clone() {
        return new TypedTreeMap(this, this.keyCast, this.valueCast);
    }

    public TypedTreeMap(Map map, Cast cast, Cast cast2) {
        this.keyCast = cast;
        this.valueCast = cast2;
        Map.Entry[] entryArray = map.entrySet().toArray(new Map.Entry[0]);
        for (int i = 0; i < entryArray.length; ++i) {
            this.put(entryArray[i].getKey(), entryArray[i].getValue());
        }
    }

    public TypedTreeMap(SortedMap sortedMap, Cast cast, Cast cast2) {
        super(sortedMap.comparator());
        this.keyCast = cast;
        this.valueCast = cast2;
        Map.Entry[] entryArray = sortedMap.entrySet().toArray(new Map.Entry[0]);
        for (int i = 0; i < entryArray.length; ++i) {
            this.put(entryArray[i].getKey(), entryArray[i].getValue());
        }
    }

    public Cast getKeyCast() {
        return this.keyCast;
    }

    public Cast getValueCast() {
        return this.valueCast;
    }

    public Set entrySet() {
        if (this.entries == null) {
            this.entries = new EntrySet(super.entrySet());
        }
        return this.entries;
    }

    public Object put(Object object, Object object2) {
        return super.put(this.keyCast.cast(object), this.valueCast.cast(object2));
    }

    private class TypedEntry
    implements Map.Entry {
        private Map.Entry entry;

        TypedEntry(Map.Entry entry) {
            this.entry = entry;
        }

        public Object getKey() {
            return this.entry.getKey();
        }

        public Object getValue() {
            return this.entry.getValue();
        }

        public Object setValue(Object object) {
            return this.entry.setValue(TypedTreeMap.this.valueCast.cast(object));
        }
    }

    private class EntryIterator
    implements Iterator {
        private Iterator iterator;

        EntryIterator(Iterator iterator) {
            this.iterator = iterator;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            return new TypedEntry((Map.Entry)this.iterator.next());
        }

        public void remove() {
            this.iterator.remove();
        }
    }

    private class EntrySet
    extends AbstractSet {
        private Set set;

        EntrySet(Set set) {
            this.set = set;
        }

        public int size() {
            return this.set.size();
        }

        public Iterator iterator() {
            return new EntryIterator(this.set.iterator());
        }
    }
}

