Examples
===

This section contains a few example presentations that display different features and styles you can use in your own. In 
order to run the presentations locally, first [install 
presenterm](https://mfontanini.github.io/presenterm/guides/installation.html), clone this repo, and finally run:

```shell
presenterm examples/<name-of-the-presentation>.md
```

# Demo

[Source](/examples/demo.md)

This is the main demo presentation, which showcases most features and uses the default dark theme.

This is how it looks like when rendered:

![](/docs/src/assets/demo.gif)

# Code

[Source](/examples/code.md)

This example contains some piece of code and showcases some different styling properties to make it look a bit different 
than how it looks like by default by using:

* Use left alignment for code blocks.
* No background for code blocks.

[![asciicast](https://asciinema.org/a/irNPKwEkPZzFbQP6jIKfVL30b.svg)](https://asciinema.org/a/irNPKwEkPZzFbQP6jIKfVL30b)

# Footer

[Source](/examples/footer.md)

This example uses a template-style footer, which lets you place some text on the left, center, and right of every slide. 
A few template variables, such as `current_slide` and `total_slides` can be used to reference properties of the 
presentation.

![](../docs/src/assets/example-footer.png)

# Columns

[Source](/examples/columns.md)

This example shows how column layouts and pauses interact with each other. Note that the image shows up as pixels 
because asciinema doesn't support these and it will otherwise look like a normal image if your terminal supports images.

[![asciicast](https://asciinema.org/a/x2tTDt0BIesvOXeal3UpdzMHp.svg)](https://asciinema.org/a/x2tTDt0BIesvOXeal3UpdzMHp)

# Speaker notes

[Source](/examples/speaker-notes.md)

This example shows how to use speaker notes.

[![asciicast](https://asciinema.org/a/ETusvlmHuHrcLKzwa0CMQRX2J.svg)](https://asciinema.org/a/ETusvlmHuHrcLKzwa0CMQRX2J)

# Custom introduction slides

[Source](/examples/custom-intro-slides.md)

This example various custom introduction slides that contain images placed in different layouts. Note that the images 
looks pixelated because of asciinema but they will otherwise look normal in your terminal.

[![asciicast](https://asciinema.org/a/sBeAMJbpBxqKA2gF2RI3MmLT7.svg)](https://asciinema.org/a/sBeAMJbpBxqKA2gF2RI3MmLT7)
