#!/bin/sh

set -e

file=$(uscan --verbose | \
        sed -n '/Successfully downloaded updated package/ {s/.*updated package \(.*\)$/\1/; p}')
version="$(echo $file | sed 's/^v\(.*\)\.tar\.gz/\1/')+dfsg"
path=../$file

gzip -d < $path | \
    tar --delete --wildcards -f - '*/form*.rb' | \
    gzip > ../ruby-ncurses-${version}.tar.gz
rm $path
echo "Repackaged ../ruby-ncurses-${version}.tar.gz"
