//backend.h:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2012-2014
 *
 *  This file is part of RoarAudio PlayList Daemon,
 *  a playlist management daemon for RoarAudio.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#ifndef _RPLD_BACKEND_H_
#define _RPLD_BACKEND_H_

#define PLAYBACK_MAX_CODECBL    16

#define BACKEND_DEFAULT_NAME    "+default"

#define BACKEND_FLAG_NONE       0x0000
#define BACKEND_FLAG_CONNECTED  0x0001

struct rpld_backend {
 size_t refc;
 int                        flags;
 struct roar_connection     con;
 int                        codecbl[PLAYBACK_MAX_CODECBL];
};

int backend_init(void);
int backend_free(void);

struct rpld_backend * backend_get_connection(const char * name);
struct rpld_backend * backend_get_connection2(const char * name, int allow_stub);

int backend_ref(struct rpld_backend * backend);
int backend_unref(struct rpld_backend * backend);

const char * backend_get_name(struct rpld_backend * backend);

int backend_blacklist_codec(struct rpld_backend * backend, int codec);
int backend_blacklist_codec_global(int codec);
int backend_blacklist_check_codec(struct rpld_backend * backend, int codec);

#endif

//ll
