/**
 * Autogenerated by Thrift
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 */
#ifndef Types_TYPES_H
#define Types_TYPES_H

#include <Thrift.h>
#include <TApplicationException.h>
#include <protocol/TProtocol.h>
#include <transport/TTransport.h>

#include "Limits_types.h"


namespace evernote { namespace edam {

struct PrivilegeLevel {
  enum type {
    NORMAL = 1,
    PREMIUM = 3,
    VIP = 5,
    MANAGER = 7,
    SUPPORT = 8,
    ADMIN = 9
  };
};

struct QueryFormat {
  enum type {
    USER = 1,
    SEXP = 2
  };
};

struct NoteSortOrder {
  enum type {
    CREATED = 1,
    UPDATED = 2,
    RELEVANCE = 3,
    UPDATE_SEQUENCE_NUMBER = 4,
    TITLE = 5
  };
};

struct PremiumOrderStatus {
  enum type {
    NONE = 0,
    PENDING = 1,
    ACTIVE = 2,
    FAILED = 3,
    CANCELLATION_PENDING = 4,
    CANCELED = 5
  };
};

struct SharedNotebookPrivilegeLevel {
  enum type {
    READ_NOTEBOOK = 0,
    MODIFY_NOTEBOOK_PLUS_ACTIVITY = 1,
    READ_NOTEBOOK_PLUS_ACTIVITY = 2,
    GROUP = 3,
    FULL_ACCESS = 4,
    BUSINESS_FULL_ACCESS = 5
  };
};

struct SponsoredGroupRole {
  enum type {
    GROUP_MEMBER = 1,
    GROUP_ADMIN = 2,
    GROUP_OWNER = 3
  };
};

struct BusinessUserRole {
  enum type {
    ADMIN = 1,
    NORMAL = 2
  };
};

struct SharedNotebookInstanceRestrictions {
  enum type {
    ONLY_JOINED_OR_PREVIEW = 1,
    NO_SHARED_NOTEBOOKS = 2
  };
};

struct ReminderEmailConfig {
  enum type {
    DO_NOT_SEND = 1,
    SEND_DAILY_EMAIL = 2
  };
};

typedef int32_t UserID;

typedef std::string Guid;

typedef int64_t Timestamp;

typedef struct _Data__isset {
  _Data__isset() : bodyHash(false), size(false), body(false) {}
  bool bodyHash;
  bool size;
  bool body;
} _Data__isset;

class Data {
 public:

  static const char* ascii_fingerprint; // = "BAAB2C3118BDB468C051932BB163B2AF";
  static const uint8_t binary_fingerprint[16]; // = {0xBA,0xAB,0x2C,0x31,0x18,0xBD,0xB4,0x68,0xC0,0x51,0x93,0x2B,0xB1,0x63,0xB2,0xAF};

  Data() : bodyHash(""), size(0), body("") {
  }

  virtual ~Data() throw() {}

  std::string bodyHash;
  int32_t size;
  std::string body;

  _Data__isset __isset;

  bool operator == (const Data & rhs) const
  {
    if (__isset.bodyHash != rhs.__isset.bodyHash)
      return false;
    else if (__isset.bodyHash && !(bodyHash == rhs.bodyHash))
      return false;
    if (__isset.size != rhs.__isset.size)
      return false;
    else if (__isset.size && !(size == rhs.size))
      return false;
    if (__isset.body != rhs.__isset.body)
      return false;
    else if (__isset.body && !(body == rhs.body))
      return false;
    return true;
  }
  bool operator != (const Data &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Data & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _UserAttributes__isset {
  _UserAttributes__isset() : defaultLocationName(false), defaultLatitude(false), defaultLongitude(false), preactivation(false), viewedPromotions(false), incomingEmailAddress(false), recentMailedAddresses(false), comments(false), dateAgreedToTermsOfService(false), maxReferrals(false), referralCount(false), refererCode(false), sentEmailDate(false), sentEmailCount(false), dailyEmailLimit(false), emailOptOutDate(false), partnerEmailOptInDate(false), preferredLanguage(false), preferredCountry(false), clipFullPage(false), twitterUserName(false), twitterId(false), groupName(false), recognitionLanguage(false), referralProof(false), educationalDiscount(false), businessAddress(false), hideSponsorBilling(false), taxExempt(false), useEmailAutoFiling(false), reminderEmailConfig(false) {}
  bool defaultLocationName;
  bool defaultLatitude;
  bool defaultLongitude;
  bool preactivation;
  bool viewedPromotions;
  bool incomingEmailAddress;
  bool recentMailedAddresses;
  bool comments;
  bool dateAgreedToTermsOfService;
  bool maxReferrals;
  bool referralCount;
  bool refererCode;
  bool sentEmailDate;
  bool sentEmailCount;
  bool dailyEmailLimit;
  bool emailOptOutDate;
  bool partnerEmailOptInDate;
  bool preferredLanguage;
  bool preferredCountry;
  bool clipFullPage;
  bool twitterUserName;
  bool twitterId;
  bool groupName;
  bool recognitionLanguage;
  bool referralProof;
  bool educationalDiscount;
  bool businessAddress;
  bool hideSponsorBilling;
  bool taxExempt;
  bool useEmailAutoFiling;
  bool reminderEmailConfig;
} _UserAttributes__isset;

class UserAttributes {
 public:

  static const char* ascii_fingerprint; // = "93F29143B9EFCD4FBA381A30A4AF2684";
  static const uint8_t binary_fingerprint[16]; // = {0x93,0xF2,0x91,0x43,0xB9,0xEF,0xCD,0x4F,0xBA,0x38,0x1A,0x30,0xA4,0xAF,0x26,0x84};

  UserAttributes() : defaultLocationName(""), defaultLatitude(0), defaultLongitude(0), preactivation(0), incomingEmailAddress(""), comments(""), dateAgreedToTermsOfService(0), maxReferrals(0), referralCount(0), refererCode(""), sentEmailDate(0), sentEmailCount(0), dailyEmailLimit(0), emailOptOutDate(0), partnerEmailOptInDate(0), preferredLanguage(""), preferredCountry(""), clipFullPage(0), twitterUserName(""), twitterId(""), groupName(""), recognitionLanguage(""), referralProof(""), educationalDiscount(0), businessAddress(""), hideSponsorBilling(0), taxExempt(0), useEmailAutoFiling(0) {
  }

  virtual ~UserAttributes() throw() {}

  std::string defaultLocationName;
  double defaultLatitude;
  double defaultLongitude;
  bool preactivation;
  std::vector<std::string>  viewedPromotions;
  std::string incomingEmailAddress;
  std::vector<std::string>  recentMailedAddresses;
  std::string comments;
  Timestamp dateAgreedToTermsOfService;
  int32_t maxReferrals;
  int32_t referralCount;
  std::string refererCode;
  Timestamp sentEmailDate;
  int32_t sentEmailCount;
  int32_t dailyEmailLimit;
  Timestamp emailOptOutDate;
  Timestamp partnerEmailOptInDate;
  std::string preferredLanguage;
  std::string preferredCountry;
  bool clipFullPage;
  std::string twitterUserName;
  std::string twitterId;
  std::string groupName;
  std::string recognitionLanguage;
  std::string referralProof;
  bool educationalDiscount;
  std::string businessAddress;
  bool hideSponsorBilling;
  bool taxExempt;
  bool useEmailAutoFiling;
  ReminderEmailConfig::type reminderEmailConfig;

  _UserAttributes__isset __isset;

  bool operator == (const UserAttributes & rhs) const
  {
    if (__isset.defaultLocationName != rhs.__isset.defaultLocationName)
      return false;
    else if (__isset.defaultLocationName && !(defaultLocationName == rhs.defaultLocationName))
      return false;
    if (__isset.defaultLatitude != rhs.__isset.defaultLatitude)
      return false;
    else if (__isset.defaultLatitude && !(defaultLatitude == rhs.defaultLatitude))
      return false;
    if (__isset.defaultLongitude != rhs.__isset.defaultLongitude)
      return false;
    else if (__isset.defaultLongitude && !(defaultLongitude == rhs.defaultLongitude))
      return false;
    if (__isset.preactivation != rhs.__isset.preactivation)
      return false;
    else if (__isset.preactivation && !(preactivation == rhs.preactivation))
      return false;
    if (__isset.viewedPromotions != rhs.__isset.viewedPromotions)
      return false;
    else if (__isset.viewedPromotions && !(viewedPromotions == rhs.viewedPromotions))
      return false;
    if (__isset.incomingEmailAddress != rhs.__isset.incomingEmailAddress)
      return false;
    else if (__isset.incomingEmailAddress && !(incomingEmailAddress == rhs.incomingEmailAddress))
      return false;
    if (__isset.recentMailedAddresses != rhs.__isset.recentMailedAddresses)
      return false;
    else if (__isset.recentMailedAddresses && !(recentMailedAddresses == rhs.recentMailedAddresses))
      return false;
    if (__isset.comments != rhs.__isset.comments)
      return false;
    else if (__isset.comments && !(comments == rhs.comments))
      return false;
    if (__isset.dateAgreedToTermsOfService != rhs.__isset.dateAgreedToTermsOfService)
      return false;
    else if (__isset.dateAgreedToTermsOfService && !(dateAgreedToTermsOfService == rhs.dateAgreedToTermsOfService))
      return false;
    if (__isset.maxReferrals != rhs.__isset.maxReferrals)
      return false;
    else if (__isset.maxReferrals && !(maxReferrals == rhs.maxReferrals))
      return false;
    if (__isset.referralCount != rhs.__isset.referralCount)
      return false;
    else if (__isset.referralCount && !(referralCount == rhs.referralCount))
      return false;
    if (__isset.refererCode != rhs.__isset.refererCode)
      return false;
    else if (__isset.refererCode && !(refererCode == rhs.refererCode))
      return false;
    if (__isset.sentEmailDate != rhs.__isset.sentEmailDate)
      return false;
    else if (__isset.sentEmailDate && !(sentEmailDate == rhs.sentEmailDate))
      return false;
    if (__isset.sentEmailCount != rhs.__isset.sentEmailCount)
      return false;
    else if (__isset.sentEmailCount && !(sentEmailCount == rhs.sentEmailCount))
      return false;
    if (__isset.dailyEmailLimit != rhs.__isset.dailyEmailLimit)
      return false;
    else if (__isset.dailyEmailLimit && !(dailyEmailLimit == rhs.dailyEmailLimit))
      return false;
    if (__isset.emailOptOutDate != rhs.__isset.emailOptOutDate)
      return false;
    else if (__isset.emailOptOutDate && !(emailOptOutDate == rhs.emailOptOutDate))
      return false;
    if (__isset.partnerEmailOptInDate != rhs.__isset.partnerEmailOptInDate)
      return false;
    else if (__isset.partnerEmailOptInDate && !(partnerEmailOptInDate == rhs.partnerEmailOptInDate))
      return false;
    if (__isset.preferredLanguage != rhs.__isset.preferredLanguage)
      return false;
    else if (__isset.preferredLanguage && !(preferredLanguage == rhs.preferredLanguage))
      return false;
    if (__isset.preferredCountry != rhs.__isset.preferredCountry)
      return false;
    else if (__isset.preferredCountry && !(preferredCountry == rhs.preferredCountry))
      return false;
    if (__isset.clipFullPage != rhs.__isset.clipFullPage)
      return false;
    else if (__isset.clipFullPage && !(clipFullPage == rhs.clipFullPage))
      return false;
    if (__isset.twitterUserName != rhs.__isset.twitterUserName)
      return false;
    else if (__isset.twitterUserName && !(twitterUserName == rhs.twitterUserName))
      return false;
    if (__isset.twitterId != rhs.__isset.twitterId)
      return false;
    else if (__isset.twitterId && !(twitterId == rhs.twitterId))
      return false;
    if (__isset.groupName != rhs.__isset.groupName)
      return false;
    else if (__isset.groupName && !(groupName == rhs.groupName))
      return false;
    if (__isset.recognitionLanguage != rhs.__isset.recognitionLanguage)
      return false;
    else if (__isset.recognitionLanguage && !(recognitionLanguage == rhs.recognitionLanguage))
      return false;
    if (__isset.referralProof != rhs.__isset.referralProof)
      return false;
    else if (__isset.referralProof && !(referralProof == rhs.referralProof))
      return false;
    if (__isset.educationalDiscount != rhs.__isset.educationalDiscount)
      return false;
    else if (__isset.educationalDiscount && !(educationalDiscount == rhs.educationalDiscount))
      return false;
    if (__isset.businessAddress != rhs.__isset.businessAddress)
      return false;
    else if (__isset.businessAddress && !(businessAddress == rhs.businessAddress))
      return false;
    if (__isset.hideSponsorBilling != rhs.__isset.hideSponsorBilling)
      return false;
    else if (__isset.hideSponsorBilling && !(hideSponsorBilling == rhs.hideSponsorBilling))
      return false;
    if (__isset.taxExempt != rhs.__isset.taxExempt)
      return false;
    else if (__isset.taxExempt && !(taxExempt == rhs.taxExempt))
      return false;
    if (__isset.useEmailAutoFiling != rhs.__isset.useEmailAutoFiling)
      return false;
    else if (__isset.useEmailAutoFiling && !(useEmailAutoFiling == rhs.useEmailAutoFiling))
      return false;
    if (__isset.reminderEmailConfig != rhs.__isset.reminderEmailConfig)
      return false;
    else if (__isset.reminderEmailConfig && !(reminderEmailConfig == rhs.reminderEmailConfig))
      return false;
    return true;
  }
  bool operator != (const UserAttributes &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const UserAttributes & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Accounting__isset {
  _Accounting__isset() : uploadLimit(false), uploadLimitEnd(false), uploadLimitNextMonth(false), premiumServiceStatus(false), premiumOrderNumber(false), premiumCommerceService(false), premiumServiceStart(false), premiumServiceSKU(false), lastSuccessfulCharge(false), lastFailedCharge(false), lastFailedChargeReason(false), nextPaymentDue(false), premiumLockUntil(false), updated(false), premiumSubscriptionNumber(false), lastRequestedCharge(false), currency(false), unitPrice(false), businessId(false), businessName(false), businessRole(false), unitDiscount(false), nextChargeDate(false) {}
  bool uploadLimit;
  bool uploadLimitEnd;
  bool uploadLimitNextMonth;
  bool premiumServiceStatus;
  bool premiumOrderNumber;
  bool premiumCommerceService;
  bool premiumServiceStart;
  bool premiumServiceSKU;
  bool lastSuccessfulCharge;
  bool lastFailedCharge;
  bool lastFailedChargeReason;
  bool nextPaymentDue;
  bool premiumLockUntil;
  bool updated;
  bool premiumSubscriptionNumber;
  bool lastRequestedCharge;
  bool currency;
  bool unitPrice;
  bool businessId;
  bool businessName;
  bool businessRole;
  bool unitDiscount;
  bool nextChargeDate;
} _Accounting__isset;

class Accounting {
 public:

  static const char* ascii_fingerprint; // = "294DFAA0B15E429F7D5E31FEB816BD37";
  static const uint8_t binary_fingerprint[16]; // = {0x29,0x4D,0xFA,0xA0,0xB1,0x5E,0x42,0x9F,0x7D,0x5E,0x31,0xFE,0xB8,0x16,0xBD,0x37};

  Accounting() : uploadLimit(0), uploadLimitEnd(0), uploadLimitNextMonth(0), premiumOrderNumber(""), premiumCommerceService(""), premiumServiceStart(0), premiumServiceSKU(""), lastSuccessfulCharge(0), lastFailedCharge(0), lastFailedChargeReason(""), nextPaymentDue(0), premiumLockUntil(0), updated(0), premiumSubscriptionNumber(""), lastRequestedCharge(0), currency(""), unitPrice(0), businessId(0), businessName(""), unitDiscount(0), nextChargeDate(0) {
  }

  virtual ~Accounting() throw() {}

  int64_t uploadLimit;
  Timestamp uploadLimitEnd;
  int64_t uploadLimitNextMonth;
  PremiumOrderStatus::type premiumServiceStatus;
  std::string premiumOrderNumber;
  std::string premiumCommerceService;
  Timestamp premiumServiceStart;
  std::string premiumServiceSKU;
  Timestamp lastSuccessfulCharge;
  Timestamp lastFailedCharge;
  std::string lastFailedChargeReason;
  Timestamp nextPaymentDue;
  Timestamp premiumLockUntil;
  Timestamp updated;
  std::string premiumSubscriptionNumber;
  Timestamp lastRequestedCharge;
  std::string currency;
  int32_t unitPrice;
  int32_t businessId;
  std::string businessName;
  BusinessUserRole::type businessRole;
  int32_t unitDiscount;
  Timestamp nextChargeDate;

  _Accounting__isset __isset;

  bool operator == (const Accounting & rhs) const
  {
    if (__isset.uploadLimit != rhs.__isset.uploadLimit)
      return false;
    else if (__isset.uploadLimit && !(uploadLimit == rhs.uploadLimit))
      return false;
    if (__isset.uploadLimitEnd != rhs.__isset.uploadLimitEnd)
      return false;
    else if (__isset.uploadLimitEnd && !(uploadLimitEnd == rhs.uploadLimitEnd))
      return false;
    if (__isset.uploadLimitNextMonth != rhs.__isset.uploadLimitNextMonth)
      return false;
    else if (__isset.uploadLimitNextMonth && !(uploadLimitNextMonth == rhs.uploadLimitNextMonth))
      return false;
    if (__isset.premiumServiceStatus != rhs.__isset.premiumServiceStatus)
      return false;
    else if (__isset.premiumServiceStatus && !(premiumServiceStatus == rhs.premiumServiceStatus))
      return false;
    if (__isset.premiumOrderNumber != rhs.__isset.premiumOrderNumber)
      return false;
    else if (__isset.premiumOrderNumber && !(premiumOrderNumber == rhs.premiumOrderNumber))
      return false;
    if (__isset.premiumCommerceService != rhs.__isset.premiumCommerceService)
      return false;
    else if (__isset.premiumCommerceService && !(premiumCommerceService == rhs.premiumCommerceService))
      return false;
    if (__isset.premiumServiceStart != rhs.__isset.premiumServiceStart)
      return false;
    else if (__isset.premiumServiceStart && !(premiumServiceStart == rhs.premiumServiceStart))
      return false;
    if (__isset.premiumServiceSKU != rhs.__isset.premiumServiceSKU)
      return false;
    else if (__isset.premiumServiceSKU && !(premiumServiceSKU == rhs.premiumServiceSKU))
      return false;
    if (__isset.lastSuccessfulCharge != rhs.__isset.lastSuccessfulCharge)
      return false;
    else if (__isset.lastSuccessfulCharge && !(lastSuccessfulCharge == rhs.lastSuccessfulCharge))
      return false;
    if (__isset.lastFailedCharge != rhs.__isset.lastFailedCharge)
      return false;
    else if (__isset.lastFailedCharge && !(lastFailedCharge == rhs.lastFailedCharge))
      return false;
    if (__isset.lastFailedChargeReason != rhs.__isset.lastFailedChargeReason)
      return false;
    else if (__isset.lastFailedChargeReason && !(lastFailedChargeReason == rhs.lastFailedChargeReason))
      return false;
    if (__isset.nextPaymentDue != rhs.__isset.nextPaymentDue)
      return false;
    else if (__isset.nextPaymentDue && !(nextPaymentDue == rhs.nextPaymentDue))
      return false;
    if (__isset.premiumLockUntil != rhs.__isset.premiumLockUntil)
      return false;
    else if (__isset.premiumLockUntil && !(premiumLockUntil == rhs.premiumLockUntil))
      return false;
    if (__isset.updated != rhs.__isset.updated)
      return false;
    else if (__isset.updated && !(updated == rhs.updated))
      return false;
    if (__isset.premiumSubscriptionNumber != rhs.__isset.premiumSubscriptionNumber)
      return false;
    else if (__isset.premiumSubscriptionNumber && !(premiumSubscriptionNumber == rhs.premiumSubscriptionNumber))
      return false;
    if (__isset.lastRequestedCharge != rhs.__isset.lastRequestedCharge)
      return false;
    else if (__isset.lastRequestedCharge && !(lastRequestedCharge == rhs.lastRequestedCharge))
      return false;
    if (__isset.currency != rhs.__isset.currency)
      return false;
    else if (__isset.currency && !(currency == rhs.currency))
      return false;
    if (__isset.unitPrice != rhs.__isset.unitPrice)
      return false;
    else if (__isset.unitPrice && !(unitPrice == rhs.unitPrice))
      return false;
    if (__isset.businessId != rhs.__isset.businessId)
      return false;
    else if (__isset.businessId && !(businessId == rhs.businessId))
      return false;
    if (__isset.businessName != rhs.__isset.businessName)
      return false;
    else if (__isset.businessName && !(businessName == rhs.businessName))
      return false;
    if (__isset.businessRole != rhs.__isset.businessRole)
      return false;
    else if (__isset.businessRole && !(businessRole == rhs.businessRole))
      return false;
    if (__isset.unitDiscount != rhs.__isset.unitDiscount)
      return false;
    else if (__isset.unitDiscount && !(unitDiscount == rhs.unitDiscount))
      return false;
    if (__isset.nextChargeDate != rhs.__isset.nextChargeDate)
      return false;
    else if (__isset.nextChargeDate && !(nextChargeDate == rhs.nextChargeDate))
      return false;
    return true;
  }
  bool operator != (const Accounting &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Accounting & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _BusinessUserInfo__isset {
  _BusinessUserInfo__isset() : businessId(false), businessName(false), role(false), email(false) {}
  bool businessId;
  bool businessName;
  bool role;
  bool email;
} _BusinessUserInfo__isset;

class BusinessUserInfo {
 public:

  static const char* ascii_fingerprint; // = "F41110BF1C14BFD0DCB9D5A09F339E2D";
  static const uint8_t binary_fingerprint[16]; // = {0xF4,0x11,0x10,0xBF,0x1C,0x14,0xBF,0xD0,0xDC,0xB9,0xD5,0xA0,0x9F,0x33,0x9E,0x2D};

  BusinessUserInfo() : businessId(0), businessName(""), email("") {
  }

  virtual ~BusinessUserInfo() throw() {}

  int32_t businessId;
  std::string businessName;
  BusinessUserRole::type role;
  std::string email;

  _BusinessUserInfo__isset __isset;

  bool operator == (const BusinessUserInfo & rhs) const
  {
    if (__isset.businessId != rhs.__isset.businessId)
      return false;
    else if (__isset.businessId && !(businessId == rhs.businessId))
      return false;
    if (__isset.businessName != rhs.__isset.businessName)
      return false;
    else if (__isset.businessName && !(businessName == rhs.businessName))
      return false;
    if (__isset.role != rhs.__isset.role)
      return false;
    else if (__isset.role && !(role == rhs.role))
      return false;
    if (__isset.email != rhs.__isset.email)
      return false;
    else if (__isset.email && !(email == rhs.email))
      return false;
    return true;
  }
  bool operator != (const BusinessUserInfo &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const BusinessUserInfo & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _PremiumInfo__isset {
  _PremiumInfo__isset() : premiumExpirationDate(false), sponsoredGroupName(false), sponsoredGroupRole(false), premiumUpgradable(false) {}
  bool premiumExpirationDate;
  bool sponsoredGroupName;
  bool sponsoredGroupRole;
  bool premiumUpgradable;
} _PremiumInfo__isset;

class PremiumInfo {
 public:

  static const char* ascii_fingerprint; // = "0119FDD440C3B0E05C301B1B626B09F1";
  static const uint8_t binary_fingerprint[16]; // = {0x01,0x19,0xFD,0xD4,0x40,0xC3,0xB0,0xE0,0x5C,0x30,0x1B,0x1B,0x62,0x6B,0x09,0xF1};

  PremiumInfo() : currentTime(0), premium(0), premiumRecurring(0), premiumExpirationDate(0), premiumExtendable(0), premiumPending(0), premiumCancellationPending(0), canPurchaseUploadAllowance(0), sponsoredGroupName(""), premiumUpgradable(0) {
  }

  virtual ~PremiumInfo() throw() {}

  Timestamp currentTime;
  bool premium;
  bool premiumRecurring;
  Timestamp premiumExpirationDate;
  bool premiumExtendable;
  bool premiumPending;
  bool premiumCancellationPending;
  bool canPurchaseUploadAllowance;
  std::string sponsoredGroupName;
  SponsoredGroupRole::type sponsoredGroupRole;
  bool premiumUpgradable;

  _PremiumInfo__isset __isset;

  bool operator == (const PremiumInfo & rhs) const
  {
    if (!(currentTime == rhs.currentTime))
      return false;
    if (!(premium == rhs.premium))
      return false;
    if (!(premiumRecurring == rhs.premiumRecurring))
      return false;
    if (__isset.premiumExpirationDate != rhs.__isset.premiumExpirationDate)
      return false;
    else if (__isset.premiumExpirationDate && !(premiumExpirationDate == rhs.premiumExpirationDate))
      return false;
    if (!(premiumExtendable == rhs.premiumExtendable))
      return false;
    if (!(premiumPending == rhs.premiumPending))
      return false;
    if (!(premiumCancellationPending == rhs.premiumCancellationPending))
      return false;
    if (!(canPurchaseUploadAllowance == rhs.canPurchaseUploadAllowance))
      return false;
    if (__isset.sponsoredGroupName != rhs.__isset.sponsoredGroupName)
      return false;
    else if (__isset.sponsoredGroupName && !(sponsoredGroupName == rhs.sponsoredGroupName))
      return false;
    if (__isset.sponsoredGroupRole != rhs.__isset.sponsoredGroupRole)
      return false;
    else if (__isset.sponsoredGroupRole && !(sponsoredGroupRole == rhs.sponsoredGroupRole))
      return false;
    if (__isset.premiumUpgradable != rhs.__isset.premiumUpgradable)
      return false;
    else if (__isset.premiumUpgradable && !(premiumUpgradable == rhs.premiumUpgradable))
      return false;
    return true;
  }
  bool operator != (const PremiumInfo &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const PremiumInfo & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _User__isset {
  _User__isset() : id(false), username(false), email(false), name(false), timezone(false), privilege(false), created(false), updated(false), deleted(false), active(false), shardId(false), attributes(false), accounting(false), premiumInfo(false), businessUserInfo(false) {}
  bool id;
  bool username;
  bool email;
  bool name;
  bool timezone;
  bool privilege;
  bool created;
  bool updated;
  bool deleted;
  bool active;
  bool shardId;
  bool attributes;
  bool accounting;
  bool premiumInfo;
  bool businessUserInfo;
} _User__isset;

class User {
 public:

  static const char* ascii_fingerprint; // = "28005E28FBEBD399E3B2C130DE25F380";
  static const uint8_t binary_fingerprint[16]; // = {0x28,0x00,0x5E,0x28,0xFB,0xEB,0xD3,0x99,0xE3,0xB2,0xC1,0x30,0xDE,0x25,0xF3,0x80};

  User() : id(0), username(""), email(""), name(""), timezone(""), created(0), updated(0), deleted(0), active(0), shardId("") {
  }

  virtual ~User() throw() {}

  UserID id;
  std::string username;
  std::string email;
  std::string name;
  std::string timezone;
  PrivilegeLevel::type privilege;
  Timestamp created;
  Timestamp updated;
  Timestamp deleted;
  bool active;
  std::string shardId;
  UserAttributes attributes;
  Accounting accounting;
  PremiumInfo premiumInfo;
  BusinessUserInfo businessUserInfo;

  _User__isset __isset;

  bool operator == (const User & rhs) const
  {
    if (__isset.id != rhs.__isset.id)
      return false;
    else if (__isset.id && !(id == rhs.id))
      return false;
    if (__isset.username != rhs.__isset.username)
      return false;
    else if (__isset.username && !(username == rhs.username))
      return false;
    if (__isset.email != rhs.__isset.email)
      return false;
    else if (__isset.email && !(email == rhs.email))
      return false;
    if (__isset.name != rhs.__isset.name)
      return false;
    else if (__isset.name && !(name == rhs.name))
      return false;
    if (__isset.timezone != rhs.__isset.timezone)
      return false;
    else if (__isset.timezone && !(timezone == rhs.timezone))
      return false;
    if (__isset.privilege != rhs.__isset.privilege)
      return false;
    else if (__isset.privilege && !(privilege == rhs.privilege))
      return false;
    if (__isset.created != rhs.__isset.created)
      return false;
    else if (__isset.created && !(created == rhs.created))
      return false;
    if (__isset.updated != rhs.__isset.updated)
      return false;
    else if (__isset.updated && !(updated == rhs.updated))
      return false;
    if (__isset.deleted != rhs.__isset.deleted)
      return false;
    else if (__isset.deleted && !(deleted == rhs.deleted))
      return false;
    if (__isset.active != rhs.__isset.active)
      return false;
    else if (__isset.active && !(active == rhs.active))
      return false;
    if (__isset.shardId != rhs.__isset.shardId)
      return false;
    else if (__isset.shardId && !(shardId == rhs.shardId))
      return false;
    if (__isset.attributes != rhs.__isset.attributes)
      return false;
    else if (__isset.attributes && !(attributes == rhs.attributes))
      return false;
    if (__isset.accounting != rhs.__isset.accounting)
      return false;
    else if (__isset.accounting && !(accounting == rhs.accounting))
      return false;
    if (__isset.premiumInfo != rhs.__isset.premiumInfo)
      return false;
    else if (__isset.premiumInfo && !(premiumInfo == rhs.premiumInfo))
      return false;
    if (__isset.businessUserInfo != rhs.__isset.businessUserInfo)
      return false;
    else if (__isset.businessUserInfo && !(businessUserInfo == rhs.businessUserInfo))
      return false;
    return true;
  }
  bool operator != (const User &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const User & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Tag__isset {
  _Tag__isset() : guid(false), name(false), parentGuid(false), updateSequenceNum(false) {}
  bool guid;
  bool name;
  bool parentGuid;
  bool updateSequenceNum;
} _Tag__isset;

class Tag {
 public:

  static const char* ascii_fingerprint; // = "2E5BF02AE592E16964727D77D7FFB2D2";
  static const uint8_t binary_fingerprint[16]; // = {0x2E,0x5B,0xF0,0x2A,0xE5,0x92,0xE1,0x69,0x64,0x72,0x7D,0x77,0xD7,0xFF,0xB2,0xD2};

  Tag() : guid(""), name(""), parentGuid(""), updateSequenceNum(0) {
  }

  virtual ~Tag() throw() {}

  Guid guid;
  std::string name;
  Guid parentGuid;
  int32_t updateSequenceNum;

  _Tag__isset __isset;

  bool operator == (const Tag & rhs) const
  {
    if (__isset.guid != rhs.__isset.guid)
      return false;
    else if (__isset.guid && !(guid == rhs.guid))
      return false;
    if (__isset.name != rhs.__isset.name)
      return false;
    else if (__isset.name && !(name == rhs.name))
      return false;
    if (__isset.parentGuid != rhs.__isset.parentGuid)
      return false;
    else if (__isset.parentGuid && !(parentGuid == rhs.parentGuid))
      return false;
    if (__isset.updateSequenceNum != rhs.__isset.updateSequenceNum)
      return false;
    else if (__isset.updateSequenceNum && !(updateSequenceNum == rhs.updateSequenceNum))
      return false;
    return true;
  }
  bool operator != (const Tag &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Tag & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _LazyMap__isset {
  _LazyMap__isset() : keysOnly(false), fullMap(false) {}
  bool keysOnly;
  bool fullMap;
} _LazyMap__isset;

class LazyMap {
 public:

  static const char* ascii_fingerprint; // = "4C4C51B5D8C83C870E0A49A3B26C575F";
  static const uint8_t binary_fingerprint[16]; // = {0x4C,0x4C,0x51,0xB5,0xD8,0xC8,0x3C,0x87,0x0E,0x0A,0x49,0xA3,0xB2,0x6C,0x57,0x5F};

  LazyMap() {
  }

  virtual ~LazyMap() throw() {}

  std::set<std::string>  keysOnly;
  std::map<std::string, std::string>  fullMap;

  _LazyMap__isset __isset;

  bool operator == (const LazyMap & rhs) const
  {
    if (__isset.keysOnly != rhs.__isset.keysOnly)
      return false;
    else if (__isset.keysOnly && !(keysOnly == rhs.keysOnly))
      return false;
    if (__isset.fullMap != rhs.__isset.fullMap)
      return false;
    else if (__isset.fullMap && !(fullMap == rhs.fullMap))
      return false;
    return true;
  }
  bool operator != (const LazyMap &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const LazyMap & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _ResourceAttributes__isset {
  _ResourceAttributes__isset() : sourceURL(false), timestamp(false), latitude(false), longitude(false), altitude(false), cameraMake(false), cameraModel(false), clientWillIndex(false), recoType(false), fileName(false), attachment(false), applicationData(false) {}
  bool sourceURL;
  bool timestamp;
  bool latitude;
  bool longitude;
  bool altitude;
  bool cameraMake;
  bool cameraModel;
  bool clientWillIndex;
  bool recoType;
  bool fileName;
  bool attachment;
  bool applicationData;
} _ResourceAttributes__isset;

class ResourceAttributes {
 public:

  static const char* ascii_fingerprint; // = "5EB9A2A0FEC66DB9B16801F7F67ED0A4";
  static const uint8_t binary_fingerprint[16]; // = {0x5E,0xB9,0xA2,0xA0,0xFE,0xC6,0x6D,0xB9,0xB1,0x68,0x01,0xF7,0xF6,0x7E,0xD0,0xA4};

  ResourceAttributes() : sourceURL(""), timestamp(0), latitude(0), longitude(0), altitude(0), cameraMake(""), cameraModel(""), clientWillIndex(0), recoType(""), fileName(""), attachment(0) {
  }

  virtual ~ResourceAttributes() throw() {}

  std::string sourceURL;
  Timestamp timestamp;
  double latitude;
  double longitude;
  double altitude;
  std::string cameraMake;
  std::string cameraModel;
  bool clientWillIndex;
  std::string recoType;
  std::string fileName;
  bool attachment;
  LazyMap applicationData;

  _ResourceAttributes__isset __isset;

  bool operator == (const ResourceAttributes & rhs) const
  {
    if (__isset.sourceURL != rhs.__isset.sourceURL)
      return false;
    else if (__isset.sourceURL && !(sourceURL == rhs.sourceURL))
      return false;
    if (__isset.timestamp != rhs.__isset.timestamp)
      return false;
    else if (__isset.timestamp && !(timestamp == rhs.timestamp))
      return false;
    if (__isset.latitude != rhs.__isset.latitude)
      return false;
    else if (__isset.latitude && !(latitude == rhs.latitude))
      return false;
    if (__isset.longitude != rhs.__isset.longitude)
      return false;
    else if (__isset.longitude && !(longitude == rhs.longitude))
      return false;
    if (__isset.altitude != rhs.__isset.altitude)
      return false;
    else if (__isset.altitude && !(altitude == rhs.altitude))
      return false;
    if (__isset.cameraMake != rhs.__isset.cameraMake)
      return false;
    else if (__isset.cameraMake && !(cameraMake == rhs.cameraMake))
      return false;
    if (__isset.cameraModel != rhs.__isset.cameraModel)
      return false;
    else if (__isset.cameraModel && !(cameraModel == rhs.cameraModel))
      return false;
    if (__isset.clientWillIndex != rhs.__isset.clientWillIndex)
      return false;
    else if (__isset.clientWillIndex && !(clientWillIndex == rhs.clientWillIndex))
      return false;
    if (__isset.recoType != rhs.__isset.recoType)
      return false;
    else if (__isset.recoType && !(recoType == rhs.recoType))
      return false;
    if (__isset.fileName != rhs.__isset.fileName)
      return false;
    else if (__isset.fileName && !(fileName == rhs.fileName))
      return false;
    if (__isset.attachment != rhs.__isset.attachment)
      return false;
    else if (__isset.attachment && !(attachment == rhs.attachment))
      return false;
    if (__isset.applicationData != rhs.__isset.applicationData)
      return false;
    else if (__isset.applicationData && !(applicationData == rhs.applicationData))
      return false;
    return true;
  }
  bool operator != (const ResourceAttributes &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const ResourceAttributes & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Resource__isset {
  _Resource__isset() : guid(false), noteGuid(false), data(false), mime(false), width(false), height(false), duration(false), active(false), recognition(false), attributes(false), updateSequenceNum(false), alternateData(false) {}
  bool guid;
  bool noteGuid;
  bool data;
  bool mime;
  bool width;
  bool height;
  bool duration;
  bool active;
  bool recognition;
  bool attributes;
  bool updateSequenceNum;
  bool alternateData;
} _Resource__isset;

class Resource {
 public:

  static const char* ascii_fingerprint; // = "DE051FC9AA97874E785B790F8086691F";
  static const uint8_t binary_fingerprint[16]; // = {0xDE,0x05,0x1F,0xC9,0xAA,0x97,0x87,0x4E,0x78,0x5B,0x79,0x0F,0x80,0x86,0x69,0x1F};

  Resource() : guid(""), noteGuid(""), mime(""), width(0), height(0), duration(0), active(0), updateSequenceNum(0) {
  }

  virtual ~Resource() throw() {}

  Guid guid;
  Guid noteGuid;
  Data data;
  std::string mime;
  int16_t width;
  int16_t height;
  int16_t duration;
  bool active;
  Data recognition;
  ResourceAttributes attributes;
  int32_t updateSequenceNum;
  Data alternateData;

  _Resource__isset __isset;

  bool operator == (const Resource & rhs) const
  {
    if (__isset.guid != rhs.__isset.guid)
      return false;
    else if (__isset.guid && !(guid == rhs.guid))
      return false;
    if (__isset.noteGuid != rhs.__isset.noteGuid)
      return false;
    else if (__isset.noteGuid && !(noteGuid == rhs.noteGuid))
      return false;
    if (__isset.data != rhs.__isset.data)
      return false;
    else if (__isset.data && !(data == rhs.data))
      return false;
    if (__isset.mime != rhs.__isset.mime)
      return false;
    else if (__isset.mime && !(mime == rhs.mime))
      return false;
    if (__isset.width != rhs.__isset.width)
      return false;
    else if (__isset.width && !(width == rhs.width))
      return false;
    if (__isset.height != rhs.__isset.height)
      return false;
    else if (__isset.height && !(height == rhs.height))
      return false;
    if (__isset.duration != rhs.__isset.duration)
      return false;
    else if (__isset.duration && !(duration == rhs.duration))
      return false;
    if (__isset.active != rhs.__isset.active)
      return false;
    else if (__isset.active && !(active == rhs.active))
      return false;
    if (__isset.recognition != rhs.__isset.recognition)
      return false;
    else if (__isset.recognition && !(recognition == rhs.recognition))
      return false;
    if (__isset.attributes != rhs.__isset.attributes)
      return false;
    else if (__isset.attributes && !(attributes == rhs.attributes))
      return false;
    if (__isset.updateSequenceNum != rhs.__isset.updateSequenceNum)
      return false;
    else if (__isset.updateSequenceNum && !(updateSequenceNum == rhs.updateSequenceNum))
      return false;
    if (__isset.alternateData != rhs.__isset.alternateData)
      return false;
    else if (__isset.alternateData && !(alternateData == rhs.alternateData))
      return false;
    return true;
  }
  bool operator != (const Resource &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Resource & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _NoteAttributes__isset {
  _NoteAttributes__isset() : subjectDate(false), latitude(false), longitude(false), altitude(false), author(false), source(false), sourceURL(false), sourceApplication(false), shareDate(false), reminderOrder(false), reminderDoneTime(false), reminderTime(false), placeName(false), contentClass(false), applicationData(false), lastEditedBy(false), classifications(false), creatorId(false), lastEditorId(false) {}
  bool subjectDate;
  bool latitude;
  bool longitude;
  bool altitude;
  bool author;
  bool source;
  bool sourceURL;
  bool sourceApplication;
  bool shareDate;
  bool reminderOrder;
  bool reminderDoneTime;
  bool reminderTime;
  bool placeName;
  bool contentClass;
  bool applicationData;
  bool lastEditedBy;
  bool classifications;
  bool creatorId;
  bool lastEditorId;
} _NoteAttributes__isset;

class NoteAttributes {
 public:

  static const char* ascii_fingerprint; // = "05191C2C3618087A364FEEB9B4854C4C";
  static const uint8_t binary_fingerprint[16]; // = {0x05,0x19,0x1C,0x2C,0x36,0x18,0x08,0x7A,0x36,0x4F,0xEE,0xB9,0xB4,0x85,0x4C,0x4C};

  NoteAttributes() : subjectDate(0), latitude(0), longitude(0), altitude(0), author(""), source(""), sourceURL(""), sourceApplication(""), shareDate(0), reminderOrder(0), reminderDoneTime(0), reminderTime(0), placeName(""), contentClass(""), lastEditedBy(""), creatorId(0), lastEditorId(0) {
  }

  virtual ~NoteAttributes() throw() {}

  Timestamp subjectDate;
  double latitude;
  double longitude;
  double altitude;
  std::string author;
  std::string source;
  std::string sourceURL;
  std::string sourceApplication;
  Timestamp shareDate;
  int64_t reminderOrder;
  Timestamp reminderDoneTime;
  Timestamp reminderTime;
  std::string placeName;
  std::string contentClass;
  LazyMap applicationData;
  std::string lastEditedBy;
  std::map<std::string, std::string>  classifications;
  UserID creatorId;
  UserID lastEditorId;

  _NoteAttributes__isset __isset;

  bool operator == (const NoteAttributes & rhs) const
  {
    if (__isset.subjectDate != rhs.__isset.subjectDate)
      return false;
    else if (__isset.subjectDate && !(subjectDate == rhs.subjectDate))
      return false;
    if (__isset.latitude != rhs.__isset.latitude)
      return false;
    else if (__isset.latitude && !(latitude == rhs.latitude))
      return false;
    if (__isset.longitude != rhs.__isset.longitude)
      return false;
    else if (__isset.longitude && !(longitude == rhs.longitude))
      return false;
    if (__isset.altitude != rhs.__isset.altitude)
      return false;
    else if (__isset.altitude && !(altitude == rhs.altitude))
      return false;
    if (__isset.author != rhs.__isset.author)
      return false;
    else if (__isset.author && !(author == rhs.author))
      return false;
    if (__isset.source != rhs.__isset.source)
      return false;
    else if (__isset.source && !(source == rhs.source))
      return false;
    if (__isset.sourceURL != rhs.__isset.sourceURL)
      return false;
    else if (__isset.sourceURL && !(sourceURL == rhs.sourceURL))
      return false;
    if (__isset.sourceApplication != rhs.__isset.sourceApplication)
      return false;
    else if (__isset.sourceApplication && !(sourceApplication == rhs.sourceApplication))
      return false;
    if (__isset.shareDate != rhs.__isset.shareDate)
      return false;
    else if (__isset.shareDate && !(shareDate == rhs.shareDate))
      return false;
    if (__isset.reminderOrder != rhs.__isset.reminderOrder)
      return false;
    else if (__isset.reminderOrder && !(reminderOrder == rhs.reminderOrder))
      return false;
    if (__isset.reminderDoneTime != rhs.__isset.reminderDoneTime)
      return false;
    else if (__isset.reminderDoneTime && !(reminderDoneTime == rhs.reminderDoneTime))
      return false;
    if (__isset.reminderTime != rhs.__isset.reminderTime)
      return false;
    else if (__isset.reminderTime && !(reminderTime == rhs.reminderTime))
      return false;
    if (__isset.placeName != rhs.__isset.placeName)
      return false;
    else if (__isset.placeName && !(placeName == rhs.placeName))
      return false;
    if (__isset.contentClass != rhs.__isset.contentClass)
      return false;
    else if (__isset.contentClass && !(contentClass == rhs.contentClass))
      return false;
    if (__isset.applicationData != rhs.__isset.applicationData)
      return false;
    else if (__isset.applicationData && !(applicationData == rhs.applicationData))
      return false;
    if (__isset.lastEditedBy != rhs.__isset.lastEditedBy)
      return false;
    else if (__isset.lastEditedBy && !(lastEditedBy == rhs.lastEditedBy))
      return false;
    if (__isset.classifications != rhs.__isset.classifications)
      return false;
    else if (__isset.classifications && !(classifications == rhs.classifications))
      return false;
    if (__isset.creatorId != rhs.__isset.creatorId)
      return false;
    else if (__isset.creatorId && !(creatorId == rhs.creatorId))
      return false;
    if (__isset.lastEditorId != rhs.__isset.lastEditorId)
      return false;
    else if (__isset.lastEditorId && !(lastEditorId == rhs.lastEditorId))
      return false;
    return true;
  }
  bool operator != (const NoteAttributes &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteAttributes & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Note__isset {
  _Note__isset() : guid(false), title(false), content(false), contentHash(false), contentLength(false), created(false), updated(false), deleted(false), active(false), updateSequenceNum(false), notebookGuid(false), tagGuids(false), resources(false), attributes(false), tagNames(false) {}
  bool guid;
  bool title;
  bool content;
  bool contentHash;
  bool contentLength;
  bool created;
  bool updated;
  bool deleted;
  bool active;
  bool updateSequenceNum;
  bool notebookGuid;
  bool tagGuids;
  bool resources;
  bool attributes;
  bool tagNames;
} _Note__isset;

class Note {
 public:

  static const char* ascii_fingerprint; // = "7353B8F6A0836D0275C7D15623BC4B42";
  static const uint8_t binary_fingerprint[16]; // = {0x73,0x53,0xB8,0xF6,0xA0,0x83,0x6D,0x02,0x75,0xC7,0xD1,0x56,0x23,0xBC,0x4B,0x42};

  Note() : guid(""), title(""), content(""), contentHash(""), contentLength(0), created(0), updated(0), deleted(0), active(0), updateSequenceNum(0), notebookGuid("") {
  }

  virtual ~Note() throw() {}

  Guid guid;
  std::string title;
  std::string content;
  std::string contentHash;
  int32_t contentLength;
  Timestamp created;
  Timestamp updated;
  Timestamp deleted;
  bool active;
  int32_t updateSequenceNum;
  std::string notebookGuid;
  std::vector<Guid>  tagGuids;
  std::vector<Resource>  resources;
  NoteAttributes attributes;
  std::vector<std::string>  tagNames;

  _Note__isset __isset;

  bool operator == (const Note & rhs) const
  {
    if (__isset.guid != rhs.__isset.guid)
      return false;
    else if (__isset.guid && !(guid == rhs.guid))
      return false;
    if (__isset.title != rhs.__isset.title)
      return false;
    else if (__isset.title && !(title == rhs.title))
      return false;
    if (__isset.content != rhs.__isset.content)
      return false;
    else if (__isset.content && !(content == rhs.content))
      return false;
    if (__isset.contentHash != rhs.__isset.contentHash)
      return false;
    else if (__isset.contentHash && !(contentHash == rhs.contentHash))
      return false;
    if (__isset.contentLength != rhs.__isset.contentLength)
      return false;
    else if (__isset.contentLength && !(contentLength == rhs.contentLength))
      return false;
    if (__isset.created != rhs.__isset.created)
      return false;
    else if (__isset.created && !(created == rhs.created))
      return false;
    if (__isset.updated != rhs.__isset.updated)
      return false;
    else if (__isset.updated && !(updated == rhs.updated))
      return false;
    if (__isset.deleted != rhs.__isset.deleted)
      return false;
    else if (__isset.deleted && !(deleted == rhs.deleted))
      return false;
    if (__isset.active != rhs.__isset.active)
      return false;
    else if (__isset.active && !(active == rhs.active))
      return false;
    if (__isset.updateSequenceNum != rhs.__isset.updateSequenceNum)
      return false;
    else if (__isset.updateSequenceNum && !(updateSequenceNum == rhs.updateSequenceNum))
      return false;
    if (__isset.notebookGuid != rhs.__isset.notebookGuid)
      return false;
    else if (__isset.notebookGuid && !(notebookGuid == rhs.notebookGuid))
      return false;
    if (__isset.tagGuids != rhs.__isset.tagGuids)
      return false;
    else if (__isset.tagGuids && !(tagGuids == rhs.tagGuids))
      return false;
    if (__isset.resources != rhs.__isset.resources)
      return false;
    else if (__isset.resources && !(resources == rhs.resources))
      return false;
    if (__isset.attributes != rhs.__isset.attributes)
      return false;
    else if (__isset.attributes && !(attributes == rhs.attributes))
      return false;
    if (__isset.tagNames != rhs.__isset.tagNames)
      return false;
    else if (__isset.tagNames && !(tagNames == rhs.tagNames))
      return false;
    return true;
  }
  bool operator != (const Note &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Note & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Publishing__isset {
  _Publishing__isset() : uri(false), order(false), ascending(false), publicDescription(false) {}
  bool uri;
  bool order;
  bool ascending;
  bool publicDescription;
} _Publishing__isset;

class Publishing {
 public:

  static const char* ascii_fingerprint; // = "A62655866CF21A0C0C20242173A3567A";
  static const uint8_t binary_fingerprint[16]; // = {0xA6,0x26,0x55,0x86,0x6C,0xF2,0x1A,0x0C,0x0C,0x20,0x24,0x21,0x73,0xA3,0x56,0x7A};

  Publishing() : uri(""), ascending(0), publicDescription("") {
  }

  virtual ~Publishing() throw() {}

  std::string uri;
  NoteSortOrder::type order;
  bool ascending;
  std::string publicDescription;

  _Publishing__isset __isset;

  bool operator == (const Publishing & rhs) const
  {
    if (__isset.uri != rhs.__isset.uri)
      return false;
    else if (__isset.uri && !(uri == rhs.uri))
      return false;
    if (__isset.order != rhs.__isset.order)
      return false;
    else if (__isset.order && !(order == rhs.order))
      return false;
    if (__isset.ascending != rhs.__isset.ascending)
      return false;
    else if (__isset.ascending && !(ascending == rhs.ascending))
      return false;
    if (__isset.publicDescription != rhs.__isset.publicDescription)
      return false;
    else if (__isset.publicDescription && !(publicDescription == rhs.publicDescription))
      return false;
    return true;
  }
  bool operator != (const Publishing &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Publishing & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _BusinessNotebook__isset {
  _BusinessNotebook__isset() : notebookDescription(false), privilege(false), recommended(false) {}
  bool notebookDescription;
  bool privilege;
  bool recommended;
} _BusinessNotebook__isset;

class BusinessNotebook {
 public:

  static const char* ascii_fingerprint; // = "7A9832B34C9AE8645C18E89943F26D8C";
  static const uint8_t binary_fingerprint[16]; // = {0x7A,0x98,0x32,0xB3,0x4C,0x9A,0xE8,0x64,0x5C,0x18,0xE8,0x99,0x43,0xF2,0x6D,0x8C};

  BusinessNotebook() : notebookDescription(""), recommended(0) {
  }

  virtual ~BusinessNotebook() throw() {}

  std::string notebookDescription;
  SharedNotebookPrivilegeLevel::type privilege;
  bool recommended;

  _BusinessNotebook__isset __isset;

  bool operator == (const BusinessNotebook & rhs) const
  {
    if (__isset.notebookDescription != rhs.__isset.notebookDescription)
      return false;
    else if (__isset.notebookDescription && !(notebookDescription == rhs.notebookDescription))
      return false;
    if (__isset.privilege != rhs.__isset.privilege)
      return false;
    else if (__isset.privilege && !(privilege == rhs.privilege))
      return false;
    if (__isset.recommended != rhs.__isset.recommended)
      return false;
    else if (__isset.recommended && !(recommended == rhs.recommended))
      return false;
    return true;
  }
  bool operator != (const BusinessNotebook &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const BusinessNotebook & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _SavedSearchScope__isset {
  _SavedSearchScope__isset() : includeAccount(false), includePersonalLinkedNotebooks(false), includeBusinessLinkedNotebooks(false) {}
  bool includeAccount;
  bool includePersonalLinkedNotebooks;
  bool includeBusinessLinkedNotebooks;
} _SavedSearchScope__isset;

class SavedSearchScope {
 public:

  static const char* ascii_fingerprint; // = "81247BEACCBFEAACC0A7927FEC373161";
  static const uint8_t binary_fingerprint[16]; // = {0x81,0x24,0x7B,0xEA,0xCC,0xBF,0xEA,0xAC,0xC0,0xA7,0x92,0x7F,0xEC,0x37,0x31,0x61};

  SavedSearchScope() : includeAccount(0), includePersonalLinkedNotebooks(0), includeBusinessLinkedNotebooks(0) {
  }

  virtual ~SavedSearchScope() throw() {}

  bool includeAccount;
  bool includePersonalLinkedNotebooks;
  bool includeBusinessLinkedNotebooks;

  _SavedSearchScope__isset __isset;

  bool operator == (const SavedSearchScope & rhs) const
  {
    if (__isset.includeAccount != rhs.__isset.includeAccount)
      return false;
    else if (__isset.includeAccount && !(includeAccount == rhs.includeAccount))
      return false;
    if (__isset.includePersonalLinkedNotebooks != rhs.__isset.includePersonalLinkedNotebooks)
      return false;
    else if (__isset.includePersonalLinkedNotebooks && !(includePersonalLinkedNotebooks == rhs.includePersonalLinkedNotebooks))
      return false;
    if (__isset.includeBusinessLinkedNotebooks != rhs.__isset.includeBusinessLinkedNotebooks)
      return false;
    else if (__isset.includeBusinessLinkedNotebooks && !(includeBusinessLinkedNotebooks == rhs.includeBusinessLinkedNotebooks))
      return false;
    return true;
  }
  bool operator != (const SavedSearchScope &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const SavedSearchScope & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _SavedSearch__isset {
  _SavedSearch__isset() : guid(false), name(false), query(false), format(false), updateSequenceNum(false), scope(false) {}
  bool guid;
  bool name;
  bool query;
  bool format;
  bool updateSequenceNum;
  bool scope;
} _SavedSearch__isset;

class SavedSearch {
 public:

  static const char* ascii_fingerprint; // = "559518531C75490BE1B22653A81FD670";
  static const uint8_t binary_fingerprint[16]; // = {0x55,0x95,0x18,0x53,0x1C,0x75,0x49,0x0B,0xE1,0xB2,0x26,0x53,0xA8,0x1F,0xD6,0x70};

  SavedSearch() : guid(""), name(""), query(""), updateSequenceNum(0) {
  }

  virtual ~SavedSearch() throw() {}

  Guid guid;
  std::string name;
  std::string query;
  QueryFormat::type format;
  int32_t updateSequenceNum;
  SavedSearchScope scope;

  _SavedSearch__isset __isset;

  bool operator == (const SavedSearch & rhs) const
  {
    if (__isset.guid != rhs.__isset.guid)
      return false;
    else if (__isset.guid && !(guid == rhs.guid))
      return false;
    if (__isset.name != rhs.__isset.name)
      return false;
    else if (__isset.name && !(name == rhs.name))
      return false;
    if (__isset.query != rhs.__isset.query)
      return false;
    else if (__isset.query && !(query == rhs.query))
      return false;
    if (__isset.format != rhs.__isset.format)
      return false;
    else if (__isset.format && !(format == rhs.format))
      return false;
    if (__isset.updateSequenceNum != rhs.__isset.updateSequenceNum)
      return false;
    else if (__isset.updateSequenceNum && !(updateSequenceNum == rhs.updateSequenceNum))
      return false;
    if (__isset.scope != rhs.__isset.scope)
      return false;
    else if (__isset.scope && !(scope == rhs.scope))
      return false;
    return true;
  }
  bool operator != (const SavedSearch &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const SavedSearch & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _SharedNotebookRecipientSettings__isset {
  _SharedNotebookRecipientSettings__isset() : reminderNotifyEmail(false), reminderNotifyInApp(false) {}
  bool reminderNotifyEmail;
  bool reminderNotifyInApp;
} _SharedNotebookRecipientSettings__isset;

class SharedNotebookRecipientSettings {
 public:

  static const char* ascii_fingerprint; // = "1959DF646639D95C0F1375CF60F71F5B";
  static const uint8_t binary_fingerprint[16]; // = {0x19,0x59,0xDF,0x64,0x66,0x39,0xD9,0x5C,0x0F,0x13,0x75,0xCF,0x60,0xF7,0x1F,0x5B};

  SharedNotebookRecipientSettings() : reminderNotifyEmail(0), reminderNotifyInApp(0) {
  }

  virtual ~SharedNotebookRecipientSettings() throw() {}

  bool reminderNotifyEmail;
  bool reminderNotifyInApp;

  _SharedNotebookRecipientSettings__isset __isset;

  bool operator == (const SharedNotebookRecipientSettings & rhs) const
  {
    if (__isset.reminderNotifyEmail != rhs.__isset.reminderNotifyEmail)
      return false;
    else if (__isset.reminderNotifyEmail && !(reminderNotifyEmail == rhs.reminderNotifyEmail))
      return false;
    if (__isset.reminderNotifyInApp != rhs.__isset.reminderNotifyInApp)
      return false;
    else if (__isset.reminderNotifyInApp && !(reminderNotifyInApp == rhs.reminderNotifyInApp))
      return false;
    return true;
  }
  bool operator != (const SharedNotebookRecipientSettings &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const SharedNotebookRecipientSettings & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _SharedNotebook__isset {
  _SharedNotebook__isset() : id(false), userId(false), notebookGuid(false), email(false), notebookModifiable(false), requireLogin(false), serviceCreated(false), serviceUpdated(false), shareKey(false), username(false), privilege(false), allowPreview(false), recipientSettings(false) {}
  bool id;
  bool userId;
  bool notebookGuid;
  bool email;
  bool notebookModifiable;
  bool requireLogin;
  bool serviceCreated;
  bool serviceUpdated;
  bool shareKey;
  bool username;
  bool privilege;
  bool allowPreview;
  bool recipientSettings;
} _SharedNotebook__isset;

class SharedNotebook {
 public:

  static const char* ascii_fingerprint; // = "ADE8562808728688B25423E5F39AA8F5";
  static const uint8_t binary_fingerprint[16]; // = {0xAD,0xE8,0x56,0x28,0x08,0x72,0x86,0x88,0xB2,0x54,0x23,0xE5,0xF3,0x9A,0xA8,0xF5};

  SharedNotebook() : id(0), userId(0), notebookGuid(""), email(""), notebookModifiable(0), requireLogin(0), serviceCreated(0), serviceUpdated(0), shareKey(""), username(""), allowPreview(0) {
  }

  virtual ~SharedNotebook() throw() {}

  int64_t id;
  int32_t userId;
  std::string notebookGuid;
  std::string email;
  bool notebookModifiable;
  bool requireLogin;
  Timestamp serviceCreated;
  Timestamp serviceUpdated;
  std::string shareKey;
  std::string username;
  SharedNotebookPrivilegeLevel::type privilege;
  bool allowPreview;
  SharedNotebookRecipientSettings recipientSettings;

  _SharedNotebook__isset __isset;

  bool operator == (const SharedNotebook & rhs) const
  {
    if (__isset.id != rhs.__isset.id)
      return false;
    else if (__isset.id && !(id == rhs.id))
      return false;
    if (__isset.userId != rhs.__isset.userId)
      return false;
    else if (__isset.userId && !(userId == rhs.userId))
      return false;
    if (__isset.notebookGuid != rhs.__isset.notebookGuid)
      return false;
    else if (__isset.notebookGuid && !(notebookGuid == rhs.notebookGuid))
      return false;
    if (__isset.email != rhs.__isset.email)
      return false;
    else if (__isset.email && !(email == rhs.email))
      return false;
    if (__isset.notebookModifiable != rhs.__isset.notebookModifiable)
      return false;
    else if (__isset.notebookModifiable && !(notebookModifiable == rhs.notebookModifiable))
      return false;
    if (__isset.requireLogin != rhs.__isset.requireLogin)
      return false;
    else if (__isset.requireLogin && !(requireLogin == rhs.requireLogin))
      return false;
    if (__isset.serviceCreated != rhs.__isset.serviceCreated)
      return false;
    else if (__isset.serviceCreated && !(serviceCreated == rhs.serviceCreated))
      return false;
    if (__isset.serviceUpdated != rhs.__isset.serviceUpdated)
      return false;
    else if (__isset.serviceUpdated && !(serviceUpdated == rhs.serviceUpdated))
      return false;
    if (__isset.shareKey != rhs.__isset.shareKey)
      return false;
    else if (__isset.shareKey && !(shareKey == rhs.shareKey))
      return false;
    if (__isset.username != rhs.__isset.username)
      return false;
    else if (__isset.username && !(username == rhs.username))
      return false;
    if (__isset.privilege != rhs.__isset.privilege)
      return false;
    else if (__isset.privilege && !(privilege == rhs.privilege))
      return false;
    if (__isset.allowPreview != rhs.__isset.allowPreview)
      return false;
    else if (__isset.allowPreview && !(allowPreview == rhs.allowPreview))
      return false;
    if (__isset.recipientSettings != rhs.__isset.recipientSettings)
      return false;
    else if (__isset.recipientSettings && !(recipientSettings == rhs.recipientSettings))
      return false;
    return true;
  }
  bool operator != (const SharedNotebook &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const SharedNotebook & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _NotebookRestrictions__isset {
  _NotebookRestrictions__isset() : noReadNotes(false), noCreateNotes(false), noUpdateNotes(false), noExpungeNotes(false), noShareNotes(false), noEmailNotes(false), noSendMessageToRecipients(false), noUpdateNotebook(false), noExpungeNotebook(false), noSetDefaultNotebook(false), noSetNotebookStack(false), noPublishToPublic(false), noPublishToBusinessLibrary(false), noCreateTags(false), noUpdateTags(false), noExpungeTags(false), noSetParentTag(false), noCreateSharedNotebooks(false), updateWhichSharedNotebookRestrictions(false), expungeWhichSharedNotebookRestrictions(false) {}
  bool noReadNotes;
  bool noCreateNotes;
  bool noUpdateNotes;
  bool noExpungeNotes;
  bool noShareNotes;
  bool noEmailNotes;
  bool noSendMessageToRecipients;
  bool noUpdateNotebook;
  bool noExpungeNotebook;
  bool noSetDefaultNotebook;
  bool noSetNotebookStack;
  bool noPublishToPublic;
  bool noPublishToBusinessLibrary;
  bool noCreateTags;
  bool noUpdateTags;
  bool noExpungeTags;
  bool noSetParentTag;
  bool noCreateSharedNotebooks;
  bool updateWhichSharedNotebookRestrictions;
  bool expungeWhichSharedNotebookRestrictions;
} _NotebookRestrictions__isset;

class NotebookRestrictions {
 public:

  static const char* ascii_fingerprint; // = "2F7A0A57E7093F201243B7214760883C";
  static const uint8_t binary_fingerprint[16]; // = {0x2F,0x7A,0x0A,0x57,0xE7,0x09,0x3F,0x20,0x12,0x43,0xB7,0x21,0x47,0x60,0x88,0x3C};

  NotebookRestrictions() : noReadNotes(0), noCreateNotes(0), noUpdateNotes(0), noExpungeNotes(0), noShareNotes(0), noEmailNotes(0), noSendMessageToRecipients(0), noUpdateNotebook(0), noExpungeNotebook(0), noSetDefaultNotebook(0), noSetNotebookStack(0), noPublishToPublic(0), noPublishToBusinessLibrary(0), noCreateTags(0), noUpdateTags(0), noExpungeTags(0), noSetParentTag(0), noCreateSharedNotebooks(0) {
  }

  virtual ~NotebookRestrictions() throw() {}

  bool noReadNotes;
  bool noCreateNotes;
  bool noUpdateNotes;
  bool noExpungeNotes;
  bool noShareNotes;
  bool noEmailNotes;
  bool noSendMessageToRecipients;
  bool noUpdateNotebook;
  bool noExpungeNotebook;
  bool noSetDefaultNotebook;
  bool noSetNotebookStack;
  bool noPublishToPublic;
  bool noPublishToBusinessLibrary;
  bool noCreateTags;
  bool noUpdateTags;
  bool noExpungeTags;
  bool noSetParentTag;
  bool noCreateSharedNotebooks;
  SharedNotebookInstanceRestrictions::type updateWhichSharedNotebookRestrictions;
  SharedNotebookInstanceRestrictions::type expungeWhichSharedNotebookRestrictions;

  _NotebookRestrictions__isset __isset;

  bool operator == (const NotebookRestrictions & rhs) const
  {
    if (__isset.noReadNotes != rhs.__isset.noReadNotes)
      return false;
    else if (__isset.noReadNotes && !(noReadNotes == rhs.noReadNotes))
      return false;
    if (__isset.noCreateNotes != rhs.__isset.noCreateNotes)
      return false;
    else if (__isset.noCreateNotes && !(noCreateNotes == rhs.noCreateNotes))
      return false;
    if (__isset.noUpdateNotes != rhs.__isset.noUpdateNotes)
      return false;
    else if (__isset.noUpdateNotes && !(noUpdateNotes == rhs.noUpdateNotes))
      return false;
    if (__isset.noExpungeNotes != rhs.__isset.noExpungeNotes)
      return false;
    else if (__isset.noExpungeNotes && !(noExpungeNotes == rhs.noExpungeNotes))
      return false;
    if (__isset.noShareNotes != rhs.__isset.noShareNotes)
      return false;
    else if (__isset.noShareNotes && !(noShareNotes == rhs.noShareNotes))
      return false;
    if (__isset.noEmailNotes != rhs.__isset.noEmailNotes)
      return false;
    else if (__isset.noEmailNotes && !(noEmailNotes == rhs.noEmailNotes))
      return false;
    if (__isset.noSendMessageToRecipients != rhs.__isset.noSendMessageToRecipients)
      return false;
    else if (__isset.noSendMessageToRecipients && !(noSendMessageToRecipients == rhs.noSendMessageToRecipients))
      return false;
    if (__isset.noUpdateNotebook != rhs.__isset.noUpdateNotebook)
      return false;
    else if (__isset.noUpdateNotebook && !(noUpdateNotebook == rhs.noUpdateNotebook))
      return false;
    if (__isset.noExpungeNotebook != rhs.__isset.noExpungeNotebook)
      return false;
    else if (__isset.noExpungeNotebook && !(noExpungeNotebook == rhs.noExpungeNotebook))
      return false;
    if (__isset.noSetDefaultNotebook != rhs.__isset.noSetDefaultNotebook)
      return false;
    else if (__isset.noSetDefaultNotebook && !(noSetDefaultNotebook == rhs.noSetDefaultNotebook))
      return false;
    if (__isset.noSetNotebookStack != rhs.__isset.noSetNotebookStack)
      return false;
    else if (__isset.noSetNotebookStack && !(noSetNotebookStack == rhs.noSetNotebookStack))
      return false;
    if (__isset.noPublishToPublic != rhs.__isset.noPublishToPublic)
      return false;
    else if (__isset.noPublishToPublic && !(noPublishToPublic == rhs.noPublishToPublic))
      return false;
    if (__isset.noPublishToBusinessLibrary != rhs.__isset.noPublishToBusinessLibrary)
      return false;
    else if (__isset.noPublishToBusinessLibrary && !(noPublishToBusinessLibrary == rhs.noPublishToBusinessLibrary))
      return false;
    if (__isset.noCreateTags != rhs.__isset.noCreateTags)
      return false;
    else if (__isset.noCreateTags && !(noCreateTags == rhs.noCreateTags))
      return false;
    if (__isset.noUpdateTags != rhs.__isset.noUpdateTags)
      return false;
    else if (__isset.noUpdateTags && !(noUpdateTags == rhs.noUpdateTags))
      return false;
    if (__isset.noExpungeTags != rhs.__isset.noExpungeTags)
      return false;
    else if (__isset.noExpungeTags && !(noExpungeTags == rhs.noExpungeTags))
      return false;
    if (__isset.noSetParentTag != rhs.__isset.noSetParentTag)
      return false;
    else if (__isset.noSetParentTag && !(noSetParentTag == rhs.noSetParentTag))
      return false;
    if (__isset.noCreateSharedNotebooks != rhs.__isset.noCreateSharedNotebooks)
      return false;
    else if (__isset.noCreateSharedNotebooks && !(noCreateSharedNotebooks == rhs.noCreateSharedNotebooks))
      return false;
    if (__isset.updateWhichSharedNotebookRestrictions != rhs.__isset.updateWhichSharedNotebookRestrictions)
      return false;
    else if (__isset.updateWhichSharedNotebookRestrictions && !(updateWhichSharedNotebookRestrictions == rhs.updateWhichSharedNotebookRestrictions))
      return false;
    if (__isset.expungeWhichSharedNotebookRestrictions != rhs.__isset.expungeWhichSharedNotebookRestrictions)
      return false;
    else if (__isset.expungeWhichSharedNotebookRestrictions && !(expungeWhichSharedNotebookRestrictions == rhs.expungeWhichSharedNotebookRestrictions))
      return false;
    return true;
  }
  bool operator != (const NotebookRestrictions &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NotebookRestrictions & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _Notebook__isset {
  _Notebook__isset() : guid(false), name(false), updateSequenceNum(false), defaultNotebook(false), serviceCreated(false), serviceUpdated(false), publishing(false), published(false), stack(false), sharedNotebookIds(false), sharedNotebooks(false), businessNotebook(false), contact(false), restrictions(false) {}
  bool guid;
  bool name;
  bool updateSequenceNum;
  bool defaultNotebook;
  bool serviceCreated;
  bool serviceUpdated;
  bool publishing;
  bool published;
  bool stack;
  bool sharedNotebookIds;
  bool sharedNotebooks;
  bool businessNotebook;
  bool contact;
  bool restrictions;
} _Notebook__isset;

class Notebook {
 public:

  static const char* ascii_fingerprint; // = "1C897B74029D7B8562961FC4E1C828E3";
  static const uint8_t binary_fingerprint[16]; // = {0x1C,0x89,0x7B,0x74,0x02,0x9D,0x7B,0x85,0x62,0x96,0x1F,0xC4,0xE1,0xC8,0x28,0xE3};

  Notebook() : guid(""), name(""), updateSequenceNum(0), defaultNotebook(0), serviceCreated(0), serviceUpdated(0), published(0), stack("") {
  }

  virtual ~Notebook() throw() {}

  Guid guid;
  std::string name;
  int32_t updateSequenceNum;
  bool defaultNotebook;
  Timestamp serviceCreated;
  Timestamp serviceUpdated;
  Publishing publishing;
  bool published;
  std::string stack;
  std::vector<int64_t>  sharedNotebookIds;
  std::vector<SharedNotebook>  sharedNotebooks;
  BusinessNotebook businessNotebook;
  User contact;
  NotebookRestrictions restrictions;

  _Notebook__isset __isset;

  bool operator == (const Notebook & rhs) const
  {
    if (__isset.guid != rhs.__isset.guid)
      return false;
    else if (__isset.guid && !(guid == rhs.guid))
      return false;
    if (__isset.name != rhs.__isset.name)
      return false;
    else if (__isset.name && !(name == rhs.name))
      return false;
    if (__isset.updateSequenceNum != rhs.__isset.updateSequenceNum)
      return false;
    else if (__isset.updateSequenceNum && !(updateSequenceNum == rhs.updateSequenceNum))
      return false;
    if (__isset.defaultNotebook != rhs.__isset.defaultNotebook)
      return false;
    else if (__isset.defaultNotebook && !(defaultNotebook == rhs.defaultNotebook))
      return false;
    if (__isset.serviceCreated != rhs.__isset.serviceCreated)
      return false;
    else if (__isset.serviceCreated && !(serviceCreated == rhs.serviceCreated))
      return false;
    if (__isset.serviceUpdated != rhs.__isset.serviceUpdated)
      return false;
    else if (__isset.serviceUpdated && !(serviceUpdated == rhs.serviceUpdated))
      return false;
    if (__isset.publishing != rhs.__isset.publishing)
      return false;
    else if (__isset.publishing && !(publishing == rhs.publishing))
      return false;
    if (__isset.published != rhs.__isset.published)
      return false;
    else if (__isset.published && !(published == rhs.published))
      return false;
    if (__isset.stack != rhs.__isset.stack)
      return false;
    else if (__isset.stack && !(stack == rhs.stack))
      return false;
    if (__isset.sharedNotebookIds != rhs.__isset.sharedNotebookIds)
      return false;
    else if (__isset.sharedNotebookIds && !(sharedNotebookIds == rhs.sharedNotebookIds))
      return false;
    if (__isset.sharedNotebooks != rhs.__isset.sharedNotebooks)
      return false;
    else if (__isset.sharedNotebooks && !(sharedNotebooks == rhs.sharedNotebooks))
      return false;
    if (__isset.businessNotebook != rhs.__isset.businessNotebook)
      return false;
    else if (__isset.businessNotebook && !(businessNotebook == rhs.businessNotebook))
      return false;
    if (__isset.contact != rhs.__isset.contact)
      return false;
    else if (__isset.contact && !(contact == rhs.contact))
      return false;
    if (__isset.restrictions != rhs.__isset.restrictions)
      return false;
    else if (__isset.restrictions && !(restrictions == rhs.restrictions))
      return false;
    return true;
  }
  bool operator != (const Notebook &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const Notebook & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _LinkedNotebook__isset {
  _LinkedNotebook__isset() : shareName(false), username(false), shardId(false), shareKey(false), uri(false), guid(false), updateSequenceNum(false), noteStoreUrl(false), webApiUrlPrefix(false), stack(false), businessId(false) {}
  bool shareName;
  bool username;
  bool shardId;
  bool shareKey;
  bool uri;
  bool guid;
  bool updateSequenceNum;
  bool noteStoreUrl;
  bool webApiUrlPrefix;
  bool stack;
  bool businessId;
} _LinkedNotebook__isset;

class LinkedNotebook {
 public:

  static const char* ascii_fingerprint; // = "A7A04DDD02DE723E01FAAF74523796C6";
  static const uint8_t binary_fingerprint[16]; // = {0xA7,0xA0,0x4D,0xDD,0x02,0xDE,0x72,0x3E,0x01,0xFA,0xAF,0x74,0x52,0x37,0x96,0xC6};

  LinkedNotebook() : shareName(""), username(""), shardId(""), shareKey(""), uri(""), guid(""), updateSequenceNum(0), noteStoreUrl(""), webApiUrlPrefix(""), stack(""), businessId(0) {
  }

  virtual ~LinkedNotebook() throw() {}

  std::string shareName;
  std::string username;
  std::string shardId;
  std::string shareKey;
  std::string uri;
  Guid guid;
  int32_t updateSequenceNum;
  std::string noteStoreUrl;
  std::string webApiUrlPrefix;
  std::string stack;
  int32_t businessId;

  _LinkedNotebook__isset __isset;

  bool operator == (const LinkedNotebook & rhs) const
  {
    if (__isset.shareName != rhs.__isset.shareName)
      return false;
    else if (__isset.shareName && !(shareName == rhs.shareName))
      return false;
    if (__isset.username != rhs.__isset.username)
      return false;
    else if (__isset.username && !(username == rhs.username))
      return false;
    if (__isset.shardId != rhs.__isset.shardId)
      return false;
    else if (__isset.shardId && !(shardId == rhs.shardId))
      return false;
    if (__isset.shareKey != rhs.__isset.shareKey)
      return false;
    else if (__isset.shareKey && !(shareKey == rhs.shareKey))
      return false;
    if (__isset.uri != rhs.__isset.uri)
      return false;
    else if (__isset.uri && !(uri == rhs.uri))
      return false;
    if (__isset.guid != rhs.__isset.guid)
      return false;
    else if (__isset.guid && !(guid == rhs.guid))
      return false;
    if (__isset.updateSequenceNum != rhs.__isset.updateSequenceNum)
      return false;
    else if (__isset.updateSequenceNum && !(updateSequenceNum == rhs.updateSequenceNum))
      return false;
    if (__isset.noteStoreUrl != rhs.__isset.noteStoreUrl)
      return false;
    else if (__isset.noteStoreUrl && !(noteStoreUrl == rhs.noteStoreUrl))
      return false;
    if (__isset.webApiUrlPrefix != rhs.__isset.webApiUrlPrefix)
      return false;
    else if (__isset.webApiUrlPrefix && !(webApiUrlPrefix == rhs.webApiUrlPrefix))
      return false;
    if (__isset.stack != rhs.__isset.stack)
      return false;
    else if (__isset.stack && !(stack == rhs.stack))
      return false;
    if (__isset.businessId != rhs.__isset.businessId)
      return false;
    else if (__isset.businessId && !(businessId == rhs.businessId))
      return false;
    return true;
  }
  bool operator != (const LinkedNotebook &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const LinkedNotebook & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

typedef struct _NotebookDescriptor__isset {
  _NotebookDescriptor__isset() : guid(false), notebookDisplayName(false), contactName(false), hasSharedNotebook(false), joinedUserCount(false) {}
  bool guid;
  bool notebookDisplayName;
  bool contactName;
  bool hasSharedNotebook;
  bool joinedUserCount;
} _NotebookDescriptor__isset;

class NotebookDescriptor {
 public:

  static const char* ascii_fingerprint; // = "7C04E117F0486F5C405AFB211B3082DD";
  static const uint8_t binary_fingerprint[16]; // = {0x7C,0x04,0xE1,0x17,0xF0,0x48,0x6F,0x5C,0x40,0x5A,0xFB,0x21,0x1B,0x30,0x82,0xDD};

  NotebookDescriptor() : guid(""), notebookDisplayName(""), contactName(""), hasSharedNotebook(0), joinedUserCount(0) {
  }

  virtual ~NotebookDescriptor() throw() {}

  Guid guid;
  std::string notebookDisplayName;
  std::string contactName;
  bool hasSharedNotebook;
  int32_t joinedUserCount;

  _NotebookDescriptor__isset __isset;

  bool operator == (const NotebookDescriptor & rhs) const
  {
    if (__isset.guid != rhs.__isset.guid)
      return false;
    else if (__isset.guid && !(guid == rhs.guid))
      return false;
    if (__isset.notebookDisplayName != rhs.__isset.notebookDisplayName)
      return false;
    else if (__isset.notebookDisplayName && !(notebookDisplayName == rhs.notebookDisplayName))
      return false;
    if (__isset.contactName != rhs.__isset.contactName)
      return false;
    else if (__isset.contactName && !(contactName == rhs.contactName))
      return false;
    if (__isset.hasSharedNotebook != rhs.__isset.hasSharedNotebook)
      return false;
    else if (__isset.hasSharedNotebook && !(hasSharedNotebook == rhs.hasSharedNotebook))
      return false;
    if (__isset.joinedUserCount != rhs.__isset.joinedUserCount)
      return false;
    else if (__isset.joinedUserCount && !(joinedUserCount == rhs.joinedUserCount))
      return false;
    return true;
  }
  bool operator != (const NotebookDescriptor &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NotebookDescriptor & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

}} // namespace

#endif
