% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svy_median.R, R/wtd_chisqtest.R, R/wtd_cor.R,
%   R/wtd_mean.R, R/wtd_median.R, R/wtd_mwu.R, R/wtd_sd.R, R/wtd_se.R,
%   R/wtd_ttest.R
\name{survey_median}
\alias{survey_median}
\alias{weighted_chisqtest}
\alias{weighted_chisqtest.default}
\alias{weighted_chisqtest.formula}
\alias{weighted_correlation}
\alias{weighted_correlation.default}
\alias{weighted_correlation.formula}
\alias{weighted_mean}
\alias{weighted_median}
\alias{weighted_mannwhitney}
\alias{weighted_mannwhitney.default}
\alias{weighted_mannwhitney.formula}
\alias{weighted_sd}
\alias{wtd_sd}
\alias{weighted_se}
\alias{weighted_ttest}
\alias{weighted_ttest.default}
\alias{weighted_ttest.formula}
\title{Weighted statistics for tests and variables}
\usage{
survey_median(x, design)

weighted_chisqtest(data, ...)

\method{weighted_chisqtest}{default}(data, x, y, weights, ...)

\method{weighted_chisqtest}{formula}(formula, data, ...)

weighted_correlation(data, ...)

\method{weighted_correlation}{default}(data, x, y, weights, ci.lvl = 0.95, ...)

\method{weighted_correlation}{formula}(formula, data, ci.lvl = 0.95, ...)

weighted_mean(x, weights = NULL)

weighted_median(x, weights = NULL)

weighted_mannwhitney(data, ...)

\method{weighted_mannwhitney}{default}(data, x, grp, weights, ...)

\method{weighted_mannwhitney}{formula}(formula, data, ...)

weighted_sd(x, weights = NULL)

wtd_sd(x, weights = NULL)

weighted_se(x, weights = NULL)

weighted_ttest(data, ...)

\method{weighted_ttest}{default}(
  data,
  x,
  y = NULL,
  weights,
  mu = 0,
  paired = FALSE,
  ci.lvl = 0.95,
  alternative = c("two.sided", "less", "greater"),
  ...
)

\method{weighted_ttest}{formula}(
  formula,
  data,
  mu = 0,
  paired = FALSE,
  ci.lvl = 0.95,
  alternative = c("two.sided", "less", "greater"),
  ...
)
}
\arguments{
\item{x}{(Numeric) vector or a data frame. For \code{survey_median()}, \code{weighted_ttest()},
\code{weighted_mannwhitney()} and \code{weighted_chisqtest()} the bare (unquoted) variable
name, or a character vector with the variable name.}

\item{design}{An object of class \code{\link[survey]{svydesign}}, providing
a specification of the survey design.}

\item{data}{A data frame.}

\item{...}{For \code{weighted_ttest()} and \code{weighted_mannwhitney()}, currently not used.
For \code{weighted_chisqtest()}, further arguments passed down to
\code{\link[stats]{chisq.test}}.}

\item{y}{Optional, bare (unquoted) variable name, or a character vector with
the variable name.}

\item{weights}{Bare (unquoted) variable name, or a character vector with
the variable name of the numeric vector of weights. If \code{weights = NULL},
unweighted statistic is reported.}

\item{formula}{A formula of the form \code{lhs ~ rhs1 + rhs2} where \code{lhs} is a
numeric variable giving the data values and \code{rhs1} a factor with two
levels giving the corresponding groups and \code{rhs2} a variable with weights.}

\item{ci.lvl}{Confidence level of the interval.}

\item{grp}{Bare (unquoted) name of the cross-classifying variable, where
\code{x} is grouped into the categories represented by \code{grp},
or a character vector with the variable name.}

\item{mu}{A number indicating the true value of the mean (or difference in
means if you are performing a two sample test).}

\item{paired}{Logical, whether to compute a paired t-test.}

\item{alternative}{A character string specifying the alternative hypothesis,
must be one of \code{"two.sided"} (default), \code{"greater"} or
\code{"less"}. You can specify just the initial letter.}
}
\value{
The weighted (test) statistic.
}
\description{
\strong{Weighted statistics for variables}
  \cr \cr
  \code{weighted_sd()}, \code{weighted_se()}, \code{weighted_mean()} and \code{weighted_median()}
  compute weighted standard deviation, standard error, mean or median for a
  variable or for all variables of a data frame. \code{survey_median()} computes the
  median for a variable in a survey-design (see \code{\link[survey]{svydesign}}).
  \code{weighted_correlation()} computes a weighted correlation for a two-sided alternative
  hypothesis.
  \cr \cr
  \strong{Weighted tests}
  \cr \cr
  \code{weighted_ttest()} computes a weighted t-test, while \code{weighted_mannwhitney()}
  computes a weighted Mann-Whitney-U test or a Kruskal-Wallis test
  (for more than two groups). \code{weighted_chisqtest()} computes a weighted
  Chi-squared test for contigency tables.
}
\note{
\code{weighted_chisq()} is a convenient wrapper for \code{\link{crosstable_statistics}}.
   For a weighted one-way Anova, use \code{means_by_group()} with
   \code{weights}-argument.
   \cr \cr
   \code{weighted_ttest()} assumes unequal variance between the two groups.
}
\examples{
# weighted sd and se ----

weighted_sd(rnorm(n = 100, mean = 3), runif(n = 100))

data(efc)
weighted_sd(efc[, 1:3], runif(n = nrow(efc)))
weighted_se(efc[, 1:3], runif(n = nrow(efc)))

# survey_median ----

# median for variables from weighted survey designs
if (require("survey")) {
  data(nhanes_sample)

  des <- svydesign(
    id = ~SDMVPSU,
    strat = ~SDMVSTRA,
    weights = ~WTINT2YR,
    nest = TRUE,
    data = nhanes_sample
  )

  survey_median(total, des)
  survey_median("total", des)
}

# weighted t-test ----

efc$weight <- abs(rnorm(nrow(efc), 1, .3))
weighted_ttest(efc, e17age, weights = weight)
weighted_ttest(efc, e17age, c160age, weights = weight)
weighted_ttest(e17age ~ e16sex + weight, efc)

# weighted Mann-Whitney-U-test ----

weighted_mannwhitney(c12hour ~ c161sex + weight, efc)

# weighted Chi-squared-test ----

weighted_chisqtest(efc, c161sex, e16sex, weights = weight, correct = FALSE)
weighted_chisqtest(c172code ~ c161sex + weight, efc)
}
