% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_reshape.R
\name{cor_gather}
\alias{cor_gather}
\alias{cor_spread}
\title{Reshape Correlation Data}
\usage{
cor_gather(data, drop.na = TRUE)

cor_spread(data, value = "cor")
}
\arguments{
\item{data}{a data frame or matrix.}

\item{drop.na}{logical. If TRUE, drop rows containing missing values after gathering the data.}

\item{value}{column name containing the value to spread.}
}
\description{
Reshape correlation analysis results. Key functions: \itemize{
  \item \code{cor_gather()}: takes a correlation matrix and collapses (i.e. melt) it into a paired list
  (long format). \item \code{cor_spread()}: spread a long correlation data format across
  multiple columns. Particularly, it takes the results of \code{\link{cor_test}}
  and transforms it into a correlation matrix. }
}
\section{Functions}{
\itemize{
\item \code{cor_gather}: takes a correlation matrix and collapses (or melt) it into long
format data frame (paired list)

\item \code{cor_spread}: spread a long correlation data frame into wide
format. Expects the columns "var1", "var2" and "cor" in the data.
(correlation matrix).
}}

\examples{
# Data preparation
#::::::::::::::::::::::::::::::::::::::::::
mydata <- mtcars \%>\%
  select(mpg, disp, hp, drat, wt, qsec)
head(mydata, 3)

# Reshape a correlation matrix
#::::::::::::::::::::::::::::::::::::::::::
# Compute a correlation matrix
cor.mat <- mydata \%>\% cor_mat()
cor.mat

# Collapse the correlation matrix into long format
# paired list data frame
long.format <- cor.mat \%>\% cor_gather()
long.format

# Spread a correlation data format
#::::::::::::::::::::::::::::::::::::::::::
# Spread the correlation coefficient value
long.format \%>\% cor_spread(value = "cor")
# Spread the p-value
long.format \%>\% cor_spread(value = "p")
}
\seealso{
\code{\link{cor_mat}()}, \code{\link{cor_reorder}()}
}
