% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rle_utils.R
\name{Ops.rle}
\alias{Ops.rle}
\title{Unary and Binary Operations for \code{\link{rle}} Objects}
\usage{
\method{Ops}{rle}(e1, e2)
}
\arguments{
\item{e1, e2}{Arguments to unary (\code{e1}) and binary (\code{e1} and \code{e2})
operators.}
}
\value{
In every supported case, the operation should result in an
\code{\link{rle}} that would have resulted had the operation been applied
to the original (uncompressed) vectors, then compressed using
\code{\link{rle}}, with the proviso that if the resulting function creates
adjacent runs of the same value, they are \emph{not} merged. This must
be done explicitly with \code{\link{compress.rle}}. (At no point in the
calculation are the uncompressed vectors actually constructed, of
course.)

An operation between an \code{rle} and a zero-length object produces
an empty \code{rle}.
}
\description{
Unary and binary \link{Arithmetic} and \link{Logic} operators (with
exceptions given below) are implemented between two \code{\link{rle}} objects
and between an \code{\link{rle}} object and a scalar.
}
\details{
Supported operations include all elements of the \code{Ops}
group, as well as \code{\link{xor}}. Within the \link{Arithmetic} and \link{Logic}
operators, this includes (taken from the R help): \code{+}, \code{-}, \code{*},
\code{/}, \code{^}, \code{<} , \code{>}, \code{<=}, \code{>=}, \code{!=}, \code{==}, \code{\%\%}, \code{\%/\%}, \code{&},
\code{|}, \code{!}, and \code{xor}; but excludes non-vector logical functions
and operators such as \code{\link{isTRUE}} and \code{\link{&&}}.
}
\examples{

x <- rle(as.logical(rbinom(10,1,.7)))
y <- rle(as.logical(rbinom(10,1,.3)))

stopifnot(isTRUE(all.equal((!inverse.rle(x)),inverse.rle(!x))))

stopifnot(isTRUE(all.equal((inverse.rle(x)|inverse.rle(y)),inverse.rle(x|y))))

stopifnot(isTRUE(all.equal((inverse.rle(x)&inverse.rle(y)),inverse.rle(x&y))))

x <- rle(sample(c(-1,+1), 10, c(.7,.3), replace=TRUE))
y <- rle(sample(c(-1,+1), 10, c(.3,.7), replace=TRUE))

stopifnot(isTRUE(all.equal((inverse.rle(x)*inverse.rle(y)),inverse.rle(x*y))))
stopifnot(isTRUE(all.equal((2*inverse.rle(y)),inverse.rle(2*y))))
stopifnot(isTRUE(all.equal((inverse.rle(x)*2),inverse.rle(x*2))))

stopifnot(isTRUE(all.equal((inverse.rle(x)/inverse.rle(y)),inverse.rle(x/y))))
stopifnot(isTRUE(all.equal((2/inverse.rle(y)),inverse.rle(2/y))))
stopifnot(isTRUE(all.equal((inverse.rle(x)/2),inverse.rle(x/2))))

stopifnot(isTRUE(all.equal((-inverse.rle(y)),inverse.rle(-y))))
stopifnot(isTRUE(all.equal((inverse.rle(x)-inverse.rle(y)),inverse.rle(x-y))))

stopifnot(isTRUE(all.equal((inverse.rle(x)\%/\%inverse.rle(y)),inverse.rle(x\%/\%y))))

stopifnot(isTRUE(all.equal(inverse.rle(x)==inverse.rle(y),inverse.rle(x==y))))

stopifnot(isTRUE(all.equal((inverse.rle(x)>inverse.rle(y)),inverse.rle(x>y))))
}
