% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_timeseries_dsg.R
\name{write_timeseries_dsg}
\alias{write_timeseries_dsg}
\title{Write time series to NetCDF-CF}
\usage{
write_timeseries_dsg(
  nc_file,
  instance_names,
  lats,
  lons,
  times,
  data,
  alts = NA,
  data_unit = "",
  data_prec = "double",
  data_metadata = list(name = "data", long_name = "unnamed data"),
  time_units = "days since 1970-01-01 00:00:00",
  coordvar_long_names = list(instance = "Station Names", time = "time of measurement",
    lat = "latitude of the measurement", lon = "longitude of the measurement", alt =
    "altitude of the measurement"),
  attributes = list(),
  add_to_existing = FALSE,
  overwrite = FALSE
)
}
\arguments{
\item{nc_file}{\code{character} file path to the nc file to be created.}

\item{instance_names}{\code{character} or \code{numeric} vector of names for each instance 
(e.g. station or geometry) to be added to the file.}

\item{lats}{\code{numeric} vector of latitudes}

\item{lons}{\code{numeric} vector of longitudes}

\item{times}{\code{POSIXct} vector of times. Must be of type \code{POSIXct} or an attempt to 
convert it will be made using \code{as.POSIXct(times)}.}

\item{data}{\code{data.frame} with each column corresponding to an instance. Rows correspond to 
time steps. nrow must be the same length as times. Column names must match instance names.}

\item{alts}{\code{numeric} vector of altitudes (m above sea level) (Optional)}

\item{data_unit}{\code{character} vector of data units. Length must be the same as number 
of columns in \code{data} parameter.}

\item{data_prec}{\code{character} precision of observation data in NetCDF file. 
Valid options: 'short' 'integer' 'float' 'double' 'char'.}

\item{data_metadata}{\code{list} A named list of strings: list(name='ShortVarName', long_name='A Long Name')}

\item{time_units}{\code{character} units string in udunits format to use for time. Defaults to 'days since 1970-01-01 00:00:00'}

\item{coordvar_long_names}{\code{list} values for long names on coordinate variables. Names should be `instance`, time`, `lat`, `lon`, and `alt.`}

\item{attributes}{list An optional list of attributes that will be added at the global level. 
See details for useful attributes.}

\item{add_to_existing}{\code{boolean} If TRUE and the file already exists, 
variables will be added to the existing file. See details for more.}

\item{overwrite}{boolean error if file exists.}
}
\description{
This function creates a timeseries discrete sampling geometry NetCDF file.
It uses the orthogonal array encoding to write one \code{data.frame} per
function call. This encoding is best suited to data with the same number of
timesteps per instance (e.g. geometry or station).
}
\details{
Suggested Global Variables:
c(title = "title", 
abstract = "history", 
provider site = "institution", 
provider name ="source", 
description = "description")

Note regarding add_to_existing:
add_to_existing = TRUE should only be used to add variables to an existing 
NetCDF discrete sampling geometry file. All other inputs should be the 
same as are already in the file. If the functions is called with 
add_to_existing=FALSE (the default), it will overwrite an existing file 
with the same name. The expected usage is to call this function repeatedly 
only changing the data, data_unit, data_prec and data_metadata inputs.

See the timeseries vignette for more information.
}
\references{
\enumerate{
  \item \url{https://www.unidata.ucar.edu/software/netcdf-java/v4.6/reference/FeatureDatasets/CFpointImplement.html}
  \item \url{http://cfconventions.org/cf-conventions/cf-conventions.html#_orthogonal_multidimensional_array_representation}
  \item \url{http://cfconventions.org/Data/cf-conventions/cf-conventions-1.7/build/cf-conventions.html#time-series-data}
}
}
