% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/url.R
\name{url_modify}
\alias{url_modify}
\alias{url_modify_relative}
\alias{url_modify_query}
\title{Modify a URL}
\usage{
url_modify(
  url,
  scheme = as_is,
  hostname = as_is,
  username = as_is,
  password = as_is,
  port = as_is,
  path = as_is,
  query = as_is,
  fragment = as_is
)

url_modify_relative(url, relative_url)

url_modify_query(
  .url,
  ...,
  .multi = c("error", "comma", "pipe", "explode"),
  .space = c("percent", "form")
)
}
\arguments{
\item{url, .url}{A string or \link[=url_parse]{parsed URL}.}

\item{scheme}{The scheme, typically either \code{http} or \code{https}.}

\item{hostname}{The hostname, e.g., \code{www.google.com} or \code{posit.co}.}

\item{username, password}{Username and password to embed in the URL.
Not generally recommended but needed for some legacy applications.}

\item{port}{An integer port number.}

\item{path}{The path, e.g., \verb{/search}. Paths must start with \code{/}, so this
will be automatically added if omitted.}

\item{query}{Either a query string or a named list of query components.}

\item{fragment}{The fragment, e.g., \verb{#section-1}.}

\item{relative_url}{A relative URL to append to the base URL.}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}>
Name-value pairs that define query parameters. Each value must be either
an atomic vector or \code{NULL} (which removes the corresponding parameters).
If you want to opt out of escaping, wrap strings in \code{I()}.}

\item{.multi}{Controls what happens when a value is a vector:
\itemize{
\item \code{"error"}, the default, throws an error.
\item \code{"comma"}, separates values with a \verb{,}, e.g. \verb{?x=1,2}.
\item \code{"pipe"}, separates values with a \code{|}, e.g. \code{?x=1|2}.
\item \code{"explode"}, turns each element into its own parameter, e.g. \code{?x=1&x=2}
}

If none of these options work for your needs, you can instead supply a
function that takes a character vector of argument values and returns a
a single string.}

\item{.space}{How should spaces in query params be escaped? The default,
"percent", uses standard percent encoding (i.e. \verb{\%20}), but you can opt-in
to "form" encoding, which uses \code{+} instead.}
}
\value{
An object of the same type as \code{url}.
}
\description{
Use \code{url_modify()} to modify any component of the URL,
\code{url_modify_relative()} to modify with a relative URL,
or \code{url_modify_query()} to modify individual query parameters.

For \code{url_modify()}, components that aren't specified in the
function call will be left as is; components set to \code{NULL} will be removed,
and all other values will be updated. Note that removing \code{scheme} or
\code{hostname} will create a relative URL.
}
\examples{
url_modify("http://hadley.nz", path = "about")
url_modify("http://hadley.nz", scheme = "https")
url_modify("http://hadley.nz/abc", path = "/cde")
url_modify("http://hadley.nz/abc", path = "")
url_modify("http://hadley.nz?a=1", query = "b=2")
url_modify("http://hadley.nz?a=1", query = list(c = 3))

url_modify_query("http://hadley.nz?a=1&b=2", c = 3)
url_modify_query("http://hadley.nz?a=1&b=2", b = NULL)
url_modify_query("http://hadley.nz?a=1&b=2", a = 100)

url_modify_relative("http://hadley.nz/a/b/c.html", "/d.html")
url_modify_relative("http://hadley.nz/a/b/c.html", "d.html")
url_modify_relative("http://hadley.nz/a/b/c.html", "../d.html")
}
\seealso{
Other URL manipulation: 
\code{\link{url_build}()},
\code{\link{url_parse}()}
}
\concept{URL manipulation}
