% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tag.r
\docType{methods}
\name{tag_delete}
\alias{tag_delete}
\alias{tag_delete,git_repository-method}
\alias{tag_delete,character-method}
\alias{tag_delete,git_tag-method}
\title{Delete an existing tag reference}
\usage{
tag_delete(object, ...)

\S4method{tag_delete}{git_repository}(object, name)

\S4method{tag_delete}{character}(object)

\S4method{tag_delete}{git_tag}(object)
}
\arguments{
\item{object}{Can be either a
(\code{\linkS4class{git_repository}}) object, a
\code{\linkS4class{git_tag}} object or the tag name. If the
\code{object} argument is the tag name, the repository is
searched for with \code{\link{discover_repository}} in the
current working directory.}

\item{...}{Additional arguments}

\item{name}{If the \code{object} argument is a
\code{git_repository}, the name of the tag to delete.}
}
\value{
\code{invisible(NULL)}
}
\description{
Delete an existing tag reference
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Create a user
config(repo, user.name="Alice", user.email="alice@example.org")

## Commit a text file
writeLines("Hello world!", file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "First commit message")

## Create two tags
tag(repo, "Tag1", "Tag message 1")
t2 <- tag(repo, "Tag2", "Tag message 2")

## List the two tags in the repository
tags(repo)

## Delete the two tags in the repository
tag_delete(repo, "Tag1")
tag_delete(t2)

## Show the empty list with tags in the repository
tags(repo)
}
}
\keyword{methods}
