## Look for detritus files
testme <- as.environment("testme")
path <- dirname(tempdir())

if (basename(path) == "working_dir") {
  files <- dir(pattern = "^Rscript", path = path, all.files = TRUE, full.names = TRUE)
  if (length(files) > 0L) {
    message(sprintf("Detritus 'Rscript*' files generated by test %s:", sQuote(testme[["name"]])))
    print(files)

    ## Remove detritus files produced by this test script, so that
    ## other test scripts will not fail because of these files.
    unlink(files)

    ## Signal the problem
    msg <- sprintf("Detected 'Rscript*' files: [n=%d] %s", length(files), paste(sQuote(basename(files)), collapse = ", "))
    ## Are detritus files files expected by design on MS Windows?
    ## If so, produce a warning, otherwise an error
    if ("detritus-files" %in% testme[["tags"]] &&
        .Platform[["OS.type"]] == "windows") {
      warning(msg, immediate. = TRUE)
    } else {
      stop(msg)
    }
  }
} else {
  message(sprintf("Skipping, because path appears not to be an 'R CMD check' folder: %s", sQuote(path)))
}
