% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explain.r
\name{explain}
\alias{explain}
\alias{show_query}
\title{Explain details of a tbl}
\usage{
explain(x, ...)

show_query(x, ...)
}
\arguments{
\item{x}{An object to explain}

\item{...}{Other parameters possibly used by generic}
}
\value{
The first argument, invisibly.
}
\description{
This is a generic function which gives more details about an object than
\code{\link[=print]{print()}}, and is more focused on human readable output than
\code{\link[=str]{str()}}.
}
\section{Databases}{

Explaining a \code{tbl_sql} will run the SQL \code{EXPLAIN} command which
will describe the query plan. This requires a little bit of knowledge about
how \code{EXPLAIN} works for your database, but is very useful for
diagnosing performance problems.
}

\examples{
\dontshow{if (requireNamespace("dbplyr", quietly = TRUE) && requireNamespace("RSQLite", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
lahman_s <- dbplyr::lahman_sqlite()
batting <- tbl(lahman_s, "Batting")
batting \%>\% show_query()
batting \%>\% explain()

# The batting database has indices on all ID variables:
# SQLite automatically picks the most restrictive index
batting \%>\% filter(lgID == "NL" & yearID == 2000L) \%>\% explain()

# OR's will use multiple indexes
batting \%>\% filter(lgID == "NL" | yearID == 2000) \%>\% explain()

# Joins will use indexes in both tables
teams <- tbl(lahman_s, "Teams")
batting \%>\% left_join(teams, c("yearID", "teamID")) \%>\% explain()
}
\dontshow{\}) # examplesIf}
}
