% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmark_matrix_calculations.R, R/benchmarks.R
\name{bm_matrix_cal_manip}
\alias{bm_matrix_cal_manip}
\alias{bm_matrix_cal_power}
\alias{bm_matrix_cal_sort}
\alias{bm_matrix_cal_cross_product}
\alias{bm_matrix_cal_lm}
\alias{benchmark_matrix_cal}
\title{Matrix calculation benchmarks}
\usage{
bm_matrix_cal_manip(runs = 3, verbose = TRUE)

bm_matrix_cal_power(runs = 3, verbose = TRUE)

bm_matrix_cal_sort(runs = 3, verbose = TRUE)

bm_matrix_cal_cross_product(runs = 3, verbose = TRUE)

bm_matrix_cal_lm(runs = 3, verbose = TRUE)

benchmark_matrix_cal(runs = 3, verbose = TRUE, cores = 0L)
}
\arguments{
\item{runs}{Number of times to run the test. Default 3.}

\item{verbose}{Default TRUE.}

\item{cores}{Default 0 (serial). When cores > 0, the benchmark is run in parallel.}
}
\description{
A collection of matrix benchmark functions aimed at
assessing the calculation speed.
\itemize{
\item Creation, transp., deformation of a 2500x2500 matrix.
\item 2500x2500 normal distributed random matrix ^1000.
\item Sorting of 7,000,000 random values.
\item 2500x2500 cross-product matrix (b = a' * a)
\item Linear regr. over a 3000x3000 matrix.
}
These benchmarks have been developed by many authors.
See http://r.research.att.com/benchmarks/R-benchmark-25.R
for a complete history. The function \code{benchmark_matrix_cal()} runs
the five \code{bm} functions.
}
\references{
http://r.research.att.com/benchmarks/R-benchmark-25.R
}
