% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimizeSubInts.R
\name{optimizeSubInts}
\alias{optimizeSubInts}
\title{Naive multi-start version of \code{\link{optimize}} for global optimization.}
\usage{
optimizeSubInts(
  f,
  interval,
  ...,
  lower = min(interval),
  upper = max(interval),
  maximum = FALSE,
  tol = .Machine$double.eps^0.25,
  nsub = 50L
)
}
\arguments{
\item{f}{See \code{\link{optimize}}.}

\item{interval}{See \code{\link{optimize}}.}

\item{...}{See \code{\link{optimize}}.}

\item{lower}{See \code{\link{optimize}}.}

\item{upper}{See \code{\link{optimize}}.}

\item{maximum}{See \code{\link{optimize}}.}

\item{tol}{See \code{\link{optimize}}.}

\item{nsub}{[\code{integer(1)}]\cr
Number of subintervals. A value of 1 implies normal \code{\link{optimize}} behavior.
Default is 50L.}
}
\value{
See \code{\link{optimize}}.
}
\description{
The univariate \code{\link{optimize}} can stop at arbitrarily bad points when
\code{f} is not unimodal. This functions mitigates this effect in a very naive way:
\code{interval} is subdivided into \code{nsub} equally sized subintervals,
\code{\link{optimize}} is run on all of them (and on the original big interval) and
the best obtained point is returned.
}
