% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/300-extractDrugAIO.R
\name{extractDrugAIO}
\alias{extractDrugAIO}
\title{Calculate All Molecular Descriptors in Rcpi at Once}
\usage{
extractDrugAIO(molecules, silent = TRUE, warn = TRUE)
}
\arguments{
\item{molecules}{Parsed molucule object.}

\item{silent}{Logical. Whether the calculating process should be
shown or not, default is \code{TRUE}.}

\item{warn}{Logical. Whether the warning about some descriptors
need the 3D coordinates should be shown or not after the calculation,
default is \code{TRUE}.}
}
\value{
A data frame, each row represents one of the molecules,
each column represents one descriptor.
Currently, this function returns total 293 descriptors
composed of 48 descriptor types.
}
\description{
Calculate All Molecular Descriptors in Rcpi at Once
}
\details{
This function calculates all the molecular descriptors
in the Rcpi package at once.
}
\note{
Note that we need 3-D coordinates of the molecules to calculate
some of the descriptors, if not provided, these descriptors
values will be \code{NA}.
}
\examples{
# Load 20 small molecules that have 3D coordinates
sdf = system.file('sysdata/OptAA3d.sdf', package = 'Rcpi')
\donttest{
mol = readMolFromSDF(sdf)
dat = extractDrugAIO(mol, warn = FALSE)}
}
