% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{fastqFilter}
\alias{fastqFilter}
\title{Filter and trim a fastq file.}
\usage{
fastqFilter(fn, fout, truncQ = 2, truncLen = 0, maxLen = Inf,
  minLen = 20, trimLeft = 0, trimRight = 0, maxN = 0, minQ = 0,
  maxEE = Inf, rm.phix = TRUE, rm.lowcomplex = 0,
  orient.fwd = NULL, n = 1e+06, OMP = TRUE, qualityType = "Auto",
  compress = TRUE, verbose = FALSE, ...)
}
\arguments{
\item{fn}{(Required). The path to the input fastq file.}

\item{fout}{(Required). The path to the output file.
Note that by default (\code{compress=TRUE}) the output fastq file is gzipped.}

\item{truncQ}{(Optional). Default 2.
Truncate reads at the first instance of a quality score less than or equal to \code{truncQ}.}

\item{truncLen}{(Optional). Default 0 (no truncation).
Truncate reads after \code{truncLen} bases. Reads shorter than this are discarded.}

\item{maxLen}{(Optional). Default Inf (no maximum).
Remove reads with length greater than maxLen. maxLen is enforced on the raw reads.}

\item{minLen}{(Optional). Default 20.
Remove reads with length less than minLen. minLen is enforced after all other trimming and truncation.}

\item{trimLeft}{(Optional). Default 0.
The number of nucleotides to remove from the start of each read. If both \code{truncLen} and 
\code{trimLeft} are provided, filtered reads will have length \code{truncLen-trimLeft}.}

\item{trimRight}{(Optional). Default 0.
The number of nucleotides to remove from the end of each read. If both \code{truncLen} and 
\code{trimRight} are provided, truncation will be performed after \code{trimRight} is enforced.}

\item{maxN}{(Optional). Default 0.
After truncation, sequences with more than \code{maxN} Ns will be discarded. 
Note that \code{\link{dada}} currently does not allow Ns.}

\item{minQ}{(Optional). Default 0.
After truncation, reads contain a quality score below minQ will be discarded.}

\item{maxEE}{(Optional). Default \code{Inf} (no EE filtering).
After truncation, reads with higher than maxEE "expected errors" will be discarded.
Expected errors are calculated from the nominal definition of the quality score: EE = sum(10^(-Q/10))}

\item{rm.phix}{(Optional). Default TRUE.
If TRUE, discard reads that match against the phiX genome, as determined by 
\code{\link{isPhiX}}.}

\item{rm.lowcomplex}{(Optional). Default 0.
If greater than 0, reads with an effective number of kmers less than this value will be removed.
The effective number of kmers is determined by \code{\link{seqComplexity}} using a Shannon information
approximation. The default kmer-size is 2, and therefore perfectly random sequences will approach an
effective kmer number of 16 = 4 (nucleotides) ^ 2 (kmer size).}

\item{orient.fwd}{(Optional). Default NULL.
A character string present at the start of valid reads. Only allows unambiguous nucleotides. 
This string is compared to the start of each read, and the reverse complement of each read.
If it exactly matches the start of the read, the read is kept.
If it exactly matches the start of the reverse-complement read, the read is reverse-complemented and kept.
Otherwise the read if filtered out.
The primary use of this parameter is to unify the orientation of amplicon sequencing libraries that
are a mixture of forward and reverse orientations, and that include the forward primer on the reads.}

\item{n}{(Optional). The number of records (reads) to read in and filter at any one time. 
This controls the peak memory requirement so that very large fastq files are supported. 
Default is \code{1e6}, one-million reads. See \code{\link[ShortRead]{FastqStreamer}} for details.}

\item{OMP}{(Optional). Default TRUE.
Whether or not to use OMP multithreading when calling \code{\link[ShortRead]{FastqStreamer}}. 
Set this to FALSE if calling this function within a parallelized chunk of code 
(eg. within \code{\link[parallel]{mclapply}}).}

\item{qualityType}{(Optional). \code{character(1)}.
The quality encoding of the fastq file(s). "Auto" (the default) means to
attempt to auto-detect the encoding. This may fail for PacBio files with
uniformly high quality scores, in which case use "FastqQuality". This
parameter is passed on to \code{\link[ShortRead]{readFastq}}; see
information there for details.}

\item{compress}{(Optional). Default TRUE.
Whether the output fastq file should be gzip compressed.}

\item{verbose}{(Optional). Default FALSE.
Whether to output status messages.}

\item{...}{(Optional). Arguments passed on to \code{\link{isPhiX}}.}
}
\value{
\code{integer(2)}.
 The number of reads read in, and the number of reads that passed the filter and were output.
}
\description{
fastqFilter takes an input fastq file (can be compressed), filters it based on several
user-definable criteria, and outputs those reads which pass the filter
to a new fastq file (also can be compressed). Several functions in the \code{ShortRead}
package are leveraged to do this filtering.
}
\examples{
testFastq = system.file("extdata", "sam1F.fastq.gz", package="dada2")
filtFastq <- tempfile(fileext=".fastq.gz")
fastqFilter(testFastq, filtFastq, maxN=0, maxEE=2)
fastqFilter(testFastq, filtFastq, trimLeft=10, truncLen=200, maxEE=2, verbose=TRUE)

}
\seealso{
\code{\link{fastqPairedFilter}}
 \code{\link[ShortRead]{FastqStreamer}}
 \code{\link[ShortRead]{trimTails}}
}
