/****************************************************************************
**
** Copyright (C) 2019 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qbs.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef QBS_MODULEPROVIDERINFO_H
#define QBS_MODULEPROVIDERINFO_H

#include "qualifiedid.h"
#include <tools/persistence.h>

#include <QtCore/qstringlist.h>
#include <QtCore/qvariant.h>

#include <vector>

namespace qbs {
namespace Internal {

class ModuleProviderInfo
{
public:
    ModuleProviderInfo() = default;
    ModuleProviderInfo(QualifiedId name, QVariantMap config,
                   QStringList searchPaths, bool transientOutput)
        : name(std::move(name))
        , config(std::move(config))
        , searchPaths(std::move(searchPaths))
        , transientOutput(transientOutput)
    {}

    static QString outputBaseDirName() { return QStringLiteral("genmodules"); }
    static QString outputDirPath(const QString &baseDir, const QualifiedId &name)
    {
        return baseDir + QLatin1Char('/') + outputBaseDirName() + QLatin1Char('/')
                + name.toString();
    }
    QString outputDirPath(const QString &baseDir) const
    {
        return outputDirPath(baseDir, name);
    }

    template<PersistentPool::OpType opType> void completeSerializationOp(PersistentPool &pool)
    {
        pool.serializationOp<opType>(
                reinterpret_cast<QStringList &>(name), config, providerFile, searchPaths);
    }

    QualifiedId name;
    QVariantMap config;
    QString providerFile;
    QStringList searchPaths;
    bool transientOutput = false; // Not to be serialized.
};

using ModuleProviderInfoList = std::vector<ModuleProviderInfo>;

// Persistent info stored between sessions
struct StoredModuleProviderInfo
{
    using CacheKey = std::tuple<QString /*name*/, QVariantMap /*config*/, int /*lookup*/>;
    using ModuleProvidersCache = QHash<CacheKey, ModuleProviderInfo>;

    ModuleProvidersCache providers;

    template<PersistentPool::OpType opType> void completeSerializationOp(PersistentPool &pool)
    {
        pool.serializationOp<opType>(providers);
    }
};

} // namespace Internal
} // namespace qbs

#endif // Include guard
