# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class CorrelationFilter(Model):
    """Represents the correlation filter expression.

    :param properties: dictionary object for custom filters
    :type properties: dict[str, str]
    :param correlation_id: Identifier of the correlation.
    :type correlation_id: str
    :param message_id: Identifier of the message.
    :type message_id: str
    :param to: Address to send to.
    :type to: str
    :param reply_to: Address of the queue to reply to.
    :type reply_to: str
    :param label: Application specific label.
    :type label: str
    :param session_id: Session identifier.
    :type session_id: str
    :param reply_to_session_id: Session identifier to reply to.
    :type reply_to_session_id: str
    :param content_type: Content type of the message.
    :type content_type: str
    :param requires_preprocessing: Value that indicates whether the rule
     action requires preprocessing. Default value: True .
    :type requires_preprocessing: bool
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': '{str}'},
        'correlation_id': {'key': 'correlationId', 'type': 'str'},
        'message_id': {'key': 'messageId', 'type': 'str'},
        'to': {'key': 'to', 'type': 'str'},
        'reply_to': {'key': 'replyTo', 'type': 'str'},
        'label': {'key': 'label', 'type': 'str'},
        'session_id': {'key': 'sessionId', 'type': 'str'},
        'reply_to_session_id': {'key': 'replyToSessionId', 'type': 'str'},
        'content_type': {'key': 'contentType', 'type': 'str'},
        'requires_preprocessing': {'key': 'requiresPreprocessing', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(CorrelationFilter, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)
        self.correlation_id = kwargs.get('correlation_id', None)
        self.message_id = kwargs.get('message_id', None)
        self.to = kwargs.get('to', None)
        self.reply_to = kwargs.get('reply_to', None)
        self.label = kwargs.get('label', None)
        self.session_id = kwargs.get('session_id', None)
        self.reply_to_session_id = kwargs.get('reply_to_session_id', None)
        self.content_type = kwargs.get('content_type', None)
        self.requires_preprocessing = kwargs.get('requires_preprocessing', True)
