# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .copy_translator import CopyTranslator


class TabularTranslator(CopyTranslator):
    """A copy activity tabular translator.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param type: Required. Constant filled by server.
    :type type: str
    :param column_mappings: Column mappings. Example: "UserId: MyUserId,
     Group: MyGroup, Name: MyName" Type: string (or Expression with resultType
     string).
    :type column_mappings: object
    :param schema_mapping: The schema mapping to map between tabular data and
     hierarchical data. Example: {"Column1": "$.Column1", "Column2":
     "$.Column2.Property1", "Column3": "$.Column2.Property2"}. Type: object (or
     Expression with resultType object).
    :type schema_mapping: object
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'column_mappings': {'key': 'columnMappings', 'type': 'object'},
        'schema_mapping': {'key': 'schemaMapping', 'type': 'object'},
    }

    def __init__(self, **kwargs):
        super(TabularTranslator, self).__init__(**kwargs)
        self.column_mappings = kwargs.get('column_mappings', None)
        self.schema_mapping = kwargs.get('schema_mapping', None)
        self.type = 'TabularTranslator'
