#include <stdarg.h>
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <stddef.h>
#include <setjmp.h>
#include <cmocka.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <locale.h>
#include <langinfo.h>

#include "config.h"
#include "xmpp/chat_session.h"
#include "helpers.h"
#include "test_autocomplete.h"
#include "test_chat_session.h"
#include "test_common.h"
#include "test_contact.h"
#include "test_cmd_connect.h"
#include "test_cmd_account.h"
#include "test_cmd_rooms.h"
#include "test_cmd_sub.h"
#include "test_cmd_presence.h"
#include "test_cmd_otr.h"
#include "test_cmd_pgp.h"
#include "test_jid.h"
#include "test_parser.h"
#include "test_roster_list.h"
#include "test_preferences.h"
#include "test_server_events.h"
#include "test_cmd_alias.h"
#include "test_cmd_bookmark.h"
#include "test_cmd_join.h"
#include "test_muc.h"
#include "test_cmd_roster.h"
#include "test_cmd_disconnect.h"
#include "test_form.h"
#include "test_callbacks.h"
#include "test_plugins_disco.h"

#define muc_unit_test(f) cmocka_unit_test_setup_teardown(f, muc_before_test, muc_after_test)

int
main(int argc, char* argv[])
{
    setlocale(LC_ALL, "en_GB.UTF-8");
    char* codeset = nl_langinfo(CODESET);
    char* lang = getenv("LANG");

    printf("Charset information:\n");

    if (lang) {
        printf("  LANG:       %s\n", lang);
    }
    if (codeset) {
        printf("  CODESET:    %s\n", codeset);
    }
    printf("  MB_CUR_MAX: %d\n", (int)MB_CUR_MAX);
    printf("  MB_LEN_MAX: %d\n", (int)MB_LEN_MAX);

    if (argc > 1)
        cmocka_set_test_filter(argv[1]);

    const struct CMUnitTest all_tests[] = {

        cmocka_unit_test(replace_one_substr),
        cmocka_unit_test(replace_one_substr_beginning),
        cmocka_unit_test(replace_one_substr_end),
        cmocka_unit_test(replace_two_substr),
        cmocka_unit_test(replace_char),
        cmocka_unit_test(replace_when_none),
        cmocka_unit_test(replace_when_match),
        cmocka_unit_test(replace_when_string_empty),
        cmocka_unit_test(replace_when_string_null),
        cmocka_unit_test(replace_when_sub_empty),
        cmocka_unit_test(replace_when_sub_null),
        cmocka_unit_test(replace_when_new_empty),
        cmocka_unit_test(replace_when_new_null),
        cmocka_unit_test(test_online_is_valid_resource_presence_string),
        cmocka_unit_test(test_chat_is_valid_resource_presence_string),
        cmocka_unit_test(test_away_is_valid_resource_presence_string),
        cmocka_unit_test(test_xa_is_valid_resource_presence_string),
        cmocka_unit_test(test_dnd_is_valid_resource_presence_string),
        cmocka_unit_test(test_available_is_not_valid_resource_presence_string),
        cmocka_unit_test(test_unavailable_is_not_valid_resource_presence_string),
        cmocka_unit_test(test_blah_is_not_valid_resource_presence_string),
        cmocka_unit_test(utf8_display_len_null_str),
        cmocka_unit_test(utf8_display_len_1_non_wide),
        cmocka_unit_test(utf8_display_len_1_wide),
        cmocka_unit_test(utf8_display_len_non_wide),
        cmocka_unit_test(utf8_display_len_wide),
        cmocka_unit_test(utf8_display_len_all_wide),
        cmocka_unit_test(strip_quotes_does_nothing_when_no_quoted),
        cmocka_unit_test(strip_quotes_strips_first),
        cmocka_unit_test(strip_quotes_strips_last),
        cmocka_unit_test(strip_quotes_strips_both),
        cmocka_unit_test(format_call_external_argv_td),
        cmocka_unit_test(unique_filename_from_url_td),

        cmocka_unit_test(clear_empty),
        cmocka_unit_test(reset_after_create),
        cmocka_unit_test(find_after_create),
        cmocka_unit_test(get_after_create_returns_null),
        cmocka_unit_test(add_one_and_complete),
        cmocka_unit_test(add_two_and_complete_returns_first),
        cmocka_unit_test(add_two_and_complete_returns_second),
        cmocka_unit_test(add_two_adds_two),
        cmocka_unit_test(add_two_same_adds_one),
        cmocka_unit_test(add_two_same_updates),
        cmocka_unit_test(complete_accented_with_accented),
        cmocka_unit_test(complete_accented_with_base),
        cmocka_unit_test(complete_both_with_accented),
        cmocka_unit_test(complete_both_with_base),
        cmocka_unit_test(complete_ignores_case),
        cmocka_unit_test(complete_previous),

        cmocka_unit_test(create_jid_from_null_returns_null),
        cmocka_unit_test(create_jid_from_empty_string_returns_null),
        cmocka_unit_test(create_jid_from_full_returns_full),
        cmocka_unit_test(create_jid_from_full_returns_bare),
        cmocka_unit_test(create_jid_from_full_returns_resourcepart),
        cmocka_unit_test(create_jid_from_full_returns_localpart),
        cmocka_unit_test(create_jid_from_full_returns_domainpart),
        cmocka_unit_test(create_jid_from_full_nolocal_returns_full),
        cmocka_unit_test(create_jid_from_full_nolocal_returns_bare),
        cmocka_unit_test(create_jid_from_full_nolocal_returns_resourcepart),
        cmocka_unit_test(create_jid_from_full_nolocal_returns_domainpart),
        cmocka_unit_test(create_jid_from_full_nolocal_returns_null_localpart),
        cmocka_unit_test(create_jid_from_bare_returns_null_full),
        cmocka_unit_test(create_jid_from_bare_returns_null_resource),
        cmocka_unit_test(create_jid_from_bare_returns_bare),
        cmocka_unit_test(create_jid_from_bare_returns_localpart),
        cmocka_unit_test(create_jid_from_bare_returns_domainpart),
        cmocka_unit_test(create_room_jid_returns_room),
        cmocka_unit_test(create_room_jid_returns_nick),
        cmocka_unit_test(create_with_slash_in_resource),
        cmocka_unit_test(create_with_at_in_resource),
        cmocka_unit_test(create_with_at_and_slash_in_resource),
        cmocka_unit_test(create_full_with_trailing_slash),
        cmocka_unit_test(returns_fulljid_when_exists),
        cmocka_unit_test(returns_barejid_when_fulljid_not_exists),

        cmocka_unit_test(parse_null_returns_null),
        cmocka_unit_test(parse_empty_returns_null),
        cmocka_unit_test(parse_space_returns_null),
        cmocka_unit_test(parse_cmd_no_args_returns_null),
        cmocka_unit_test(parse_cmd_with_space_returns_null),
        cmocka_unit_test(parse_cmd_with_too_few_returns_null),
        cmocka_unit_test(parse_cmd_with_too_many_returns_null),
        cmocka_unit_test(parse_cmd_one_arg),
        cmocka_unit_test(parse_cmd_two_args),
        cmocka_unit_test(parse_cmd_three_args),
        cmocka_unit_test(parse_cmd_three_args_with_spaces),
        cmocka_unit_test(parse_cmd_with_freetext),
        cmocka_unit_test(parse_cmd_one_arg_with_freetext),
        cmocka_unit_test(parse_cmd_two_args_with_freetext),
        cmocka_unit_test(parse_cmd_min_zero),
        cmocka_unit_test(parse_cmd_min_zero_with_freetext),
        cmocka_unit_test(parse_cmd_with_quoted),
        cmocka_unit_test(parse_cmd_with_quoted_and_space),
        cmocka_unit_test(parse_cmd_with_quoted_and_many_spaces),
        cmocka_unit_test(parse_cmd_with_many_quoted_and_many_spaces),
        cmocka_unit_test(parse_cmd_freetext_with_quoted),
        cmocka_unit_test(parse_cmd_freetext_with_quoted_and_space),
        cmocka_unit_test(parse_cmd_freetext_with_quoted_and_many_spaces),
        cmocka_unit_test(parse_cmd_freetext_with_many_quoted_and_many_spaces),
        cmocka_unit_test(parse_cmd_with_quoted_freetext),
        cmocka_unit_test(parse_cmd_with_third_arg_quoted_0_min_3_max),
        cmocka_unit_test(parse_cmd_with_second_arg_quoted_0_min_3_max),
        cmocka_unit_test(parse_cmd_with_second_and_third_arg_quoted_0_min_3_max),
        cmocka_unit_test(count_one_token),
        cmocka_unit_test(count_one_token_quoted_no_whitespace),
        cmocka_unit_test(count_one_token_quoted_with_whitespace),
        cmocka_unit_test(count_two_tokens),
        cmocka_unit_test(count_two_tokens_first_quoted),
        cmocka_unit_test(count_two_tokens_second_quoted),
        cmocka_unit_test(count_two_tokens_both_quoted),
        cmocka_unit_test(get_first_of_one),
        cmocka_unit_test(get_first_of_two),
        cmocka_unit_test(get_first_two_of_three),
        cmocka_unit_test(get_first_two_of_three_first_quoted),
        cmocka_unit_test(get_first_two_of_three_second_quoted),
        cmocka_unit_test(get_first_two_of_three_first_and_second_quoted),
        cmocka_unit_test(parse_options_when_none_returns_empty_hasmap),
        cmocka_unit_test(parse_options_when_opt1_no_val_sets_error),
        cmocka_unit_test(parse_options_when_one_returns_map),
        cmocka_unit_test(parse_options_when_opt2_no_val_sets_error),
        cmocka_unit_test(parse_options_when_two_returns_map),
        cmocka_unit_test(parse_options_when_opt3_no_val_sets_error),
        cmocka_unit_test(parse_options_when_three_returns_map),
        cmocka_unit_test(parse_options_when_unknown_opt_sets_error),
        cmocka_unit_test(parse_options_with_duplicated_option_sets_error),

        cmocka_unit_test(empty_list_when_none_added),
        cmocka_unit_test(contains_one_element),
        cmocka_unit_test(first_element_correct),
        cmocka_unit_test(contains_two_elements),
        cmocka_unit_test(first_and_second_elements_correct),
        cmocka_unit_test(contains_three_elements),
        cmocka_unit_test(first_three_elements_correct),
        cmocka_unit_test(add_twice_at_beginning_adds_once),
        cmocka_unit_test(add_twice_in_middle_adds_once),
        cmocka_unit_test(add_twice_at_end_adds_once),
        cmocka_unit_test(find_first_exists),
        cmocka_unit_test(find_second_exists),
        cmocka_unit_test(find_third_exists),
        cmocka_unit_test(find_returns_null),
        cmocka_unit_test(find_on_empty_returns_null),
        cmocka_unit_test(find_twice_returns_second_when_two_match),
        cmocka_unit_test(find_five_times_finds_fifth),
        cmocka_unit_test(find_twice_returns_first_when_two_match_and_reset),
        cmocka_unit_test(add_contact_with_no_group),
        cmocka_unit_test(add_contact_with_group),
        cmocka_unit_test(add_contact_with_two_groups),
        cmocka_unit_test(add_contact_with_three_groups),
        cmocka_unit_test(add_contact_with_three_groups_update_adding_two),
        cmocka_unit_test(add_contact_with_three_groups_update_removing_one),
        cmocka_unit_test(add_contact_with_three_groups_update_removing_two),
        cmocka_unit_test(add_contact_with_three_groups_update_removing_three),
        cmocka_unit_test(add_contact_with_three_groups_update_two_new),
        cmocka_unit_test(add_remove_contact_groups),
        cmocka_unit_test(add_contacts_with_different_groups),
        cmocka_unit_test(add_contacts_with_same_groups),
        cmocka_unit_test(add_contacts_with_overlapping_groups),
        cmocka_unit_test(remove_contact_with_remaining_in_group),
        cmocka_unit_test(get_contact_display_name),
        cmocka_unit_test(get_contact_display_name_is_barejid_if_name_is_empty),
        cmocka_unit_test(get_contact_display_name_is_passed_barejid_if_contact_does_not_exist),

        cmocka_unit_test_setup_teardown(returns_false_when_chat_session_does_not_exist,
                                        init_chat_sessions,
                                        close_chat_sessions),
        cmocka_unit_test_setup_teardown(creates_chat_session_on_recipient_activity,
                                        init_chat_sessions,
                                        close_chat_sessions),
        cmocka_unit_test_setup_teardown(replaces_chat_session_on_recipient_activity_with_different_resource,
                                        init_chat_sessions,
                                        close_chat_sessions),
        cmocka_unit_test_setup_teardown(removes_chat_session,
                                        init_chat_sessions,
                                        close_chat_sessions),

        cmocka_unit_test_setup_teardown(cmd_connect_shows_message_when_disconnecting,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(cmd_connect_shows_message_when_connecting,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(cmd_connect_shows_message_when_connected,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(cmd_connect_when_no_account,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(cmd_connect_fail_message,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(cmd_connect_lowercases_argument_with_account,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(cmd_connect_lowercases_argument_with_no_account,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(cmd_connect_asks_password_when_not_in_account,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(cmd_connect_shows_usage_when_no_server_value,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(cmd_connect_shows_message_when_connecting_with_account,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(cmd_connect_connects_with_account,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(cmd_connect_shows_usage_when_server_no_port_value,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(cmd_connect_shows_usage_when_no_port_value,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(cmd_connect_shows_usage_when_port_no_server_value,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(cmd_connect_shows_message_when_port_0,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(cmd_connect_shows_message_when_port_minus1,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(cmd_connect_shows_message_when_port_65536,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(cmd_connect_shows_message_when_port_contains_chars,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(cmd_connect_with_server_when_provided,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(cmd_connect_with_port_when_provided,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(cmd_connect_with_server_and_port_when_provided,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(cmd_connect_shows_usage_when_server_provided_twice,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(cmd_connect_shows_usage_when_port_provided_twice,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(cmd_connect_shows_usage_when_invalid_first_property,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(cmd_connect_shows_usage_when_invalid_second_property,
                                        load_preferences,
                                        close_preferences),

        cmocka_unit_test(cmd_rooms_shows_message_when_disconnected),
        cmocka_unit_test(cmd_rooms_shows_message_when_disconnecting),
        cmocka_unit_test(cmd_rooms_shows_message_when_connecting),
        cmocka_unit_test(cmd_rooms_uses_account_default_when_no_arg),
        cmocka_unit_test(cmd_rooms_service_arg_used_when_passed),
        cmocka_unit_test(cmd_rooms_filter_arg_used_when_passed),

        cmocka_unit_test(cmd_account_shows_usage_when_not_connected_and_no_args),
        cmocka_unit_test(cmd_account_shows_account_when_connected_and_no_args),
        cmocka_unit_test(cmd_account_list_shows_accounts),
        cmocka_unit_test(cmd_account_show_shows_usage_when_no_arg),
        cmocka_unit_test(cmd_account_show_shows_message_when_account_does_not_exist),
        cmocka_unit_test(cmd_account_show_shows_account_when_exists),
        cmocka_unit_test(cmd_account_add_shows_usage_when_no_arg),
        cmocka_unit_test(cmd_account_add_adds_account),
        cmocka_unit_test(cmd_account_enable_shows_usage_when_no_arg),
        cmocka_unit_test(cmd_account_enable_enables_account),
        cmocka_unit_test(cmd_account_enable_shows_message_when_account_doesnt_exist),
        cmocka_unit_test(cmd_account_disable_shows_usage_when_no_arg),
        cmocka_unit_test(cmd_account_disable_disables_account),
        cmocka_unit_test(cmd_account_disable_shows_message_when_account_doesnt_exist),
        cmocka_unit_test(cmd_account_rename_shows_usage_when_no_args),
        cmocka_unit_test(cmd_account_rename_shows_usage_when_one_arg),
        cmocka_unit_test(cmd_account_rename_renames_account),
        cmocka_unit_test(cmd_account_rename_shows_message_when_not_renamed),
        cmocka_unit_test(cmd_account_set_shows_usage_when_no_args),
        cmocka_unit_test(cmd_account_set_shows_usage_when_one_arg),
        cmocka_unit_test(cmd_account_set_shows_usage_when_two_args),
        cmocka_unit_test(cmd_account_set_shows_message_when_account_doesnt_exist),
        cmocka_unit_test(cmd_account_set_jid_shows_message_for_malformed_jid),
        cmocka_unit_test(cmd_account_set_jid_sets_barejid),
        cmocka_unit_test(cmd_account_set_jid_sets_resource),
        cmocka_unit_test(cmd_account_set_server_sets_server),
        cmocka_unit_test(cmd_account_set_resource_sets_resource),
        cmocka_unit_test(cmd_account_set_resource_sets_resource_with_online_message),
        cmocka_unit_test(cmd_account_set_password_sets_password),
        cmocka_unit_test(cmd_account_set_eval_password_sets_eval_password),
        cmocka_unit_test(cmd_account_set_password_when_eval_password_set),
        cmocka_unit_test(cmd_account_set_eval_password_when_password_set),
        cmocka_unit_test(cmd_account_set_muc_sets_muc),
        cmocka_unit_test(cmd_account_set_nick_sets_nick),
#ifdef HAVE_LIBOTR
        cmocka_unit_test(cmd_account_show_message_for_missing_otr_policy),
        cmocka_unit_test(cmd_account_show_message_for_invalid_otr_policy),
        cmocka_unit_test(cmd_account_set_otr_sets_otr),
#endif
        cmocka_unit_test(cmd_account_set_status_shows_message_when_invalid_status),
        cmocka_unit_test(cmd_account_set_status_sets_status_when_valid),
        cmocka_unit_test(cmd_account_set_status_sets_status_when_last),
        cmocka_unit_test(cmd_account_set_invalid_presence_string_priority_shows_message),
        cmocka_unit_test(cmd_account_set_last_priority_shows_message),
        cmocka_unit_test(cmd_account_set_online_priority_sets_preference),
        cmocka_unit_test(cmd_account_set_chat_priority_sets_preference),
        cmocka_unit_test(cmd_account_set_away_priority_sets_preference),
        cmocka_unit_test(cmd_account_set_xa_priority_sets_preference),
        cmocka_unit_test(cmd_account_set_dnd_priority_sets_preference),
        cmocka_unit_test(cmd_account_set_priority_too_low_shows_message),
        cmocka_unit_test(cmd_account_set_priority_too_high_shows_message),
        cmocka_unit_test(cmd_account_set_priority_when_not_number_shows_message),
        cmocka_unit_test(cmd_account_set_priority_when_empty_shows_message),
        cmocka_unit_test(cmd_account_set_priority_updates_presence_when_account_connected_with_presence),
        cmocka_unit_test(cmd_account_clear_shows_usage_when_no_args),
        cmocka_unit_test(cmd_account_clear_shows_usage_when_one_arg),
        cmocka_unit_test(cmd_account_clear_shows_message_when_account_doesnt_exist),
        cmocka_unit_test(cmd_account_clear_shows_message_when_invalid_property),

        cmocka_unit_test(cmd_sub_shows_message_when_not_connected),
        cmocka_unit_test(cmd_sub_shows_usage_when_no_arg),

        cmocka_unit_test(contact_in_group),
        cmocka_unit_test(contact_not_in_group),
        cmocka_unit_test(contact_name_when_name_exists),
        cmocka_unit_test(contact_jid_when_name_not_exists),
        cmocka_unit_test(contact_string_when_name_exists),
        cmocka_unit_test(contact_string_when_name_not_exists),
        cmocka_unit_test(contact_string_when_default_resource),
        cmocka_unit_test(contact_presence_offline),
        cmocka_unit_test(contact_presence_uses_highest_priority),
        cmocka_unit_test(contact_presence_chat_when_same_prioroty),
        cmocka_unit_test(contact_presence_online_when_same_prioroty),
        cmocka_unit_test(contact_presence_away_when_same_prioroty),
        cmocka_unit_test(contact_presence_xa_when_same_prioroty),
        cmocka_unit_test(contact_presence_dnd),
        cmocka_unit_test(contact_subscribed_when_to),
        cmocka_unit_test(contact_subscribed_when_both),
        cmocka_unit_test(contact_not_subscribed_when_from),
        cmocka_unit_test(contact_not_subscribed_when_no_subscription_value),
        cmocka_unit_test(contact_not_available),
        cmocka_unit_test(contact_not_available_when_highest_priority_away),
        cmocka_unit_test(contact_not_available_when_highest_priority_xa),
        cmocka_unit_test(contact_not_available_when_highest_priority_dnd),
        cmocka_unit_test(contact_available_when_highest_priority_online),
        cmocka_unit_test(contact_available_when_highest_priority_chat),

        cmocka_unit_test(cmd_presence_shows_usage_when_bad_subcmd),
        cmocka_unit_test(cmd_presence_shows_usage_when_bad_console_setting),
        cmocka_unit_test(cmd_presence_shows_usage_when_bad_chat_setting),
        cmocka_unit_test(cmd_presence_shows_usage_when_bad_muc_setting),
        cmocka_unit_test_setup_teardown(cmd_presence_console_sets_all,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(cmd_presence_console_sets_online,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(cmd_presence_console_sets_none,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(cmd_presence_chat_sets_all,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(cmd_presence_chat_sets_online,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(cmd_presence_chat_sets_none,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(cmd_presence_room_sets_all,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(cmd_presence_room_sets_online,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(cmd_presence_room_sets_none,
                                        load_preferences,
                                        close_preferences),

        cmocka_unit_test_setup_teardown(statuses_console_defaults_to_all,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(statuses_chat_defaults_to_all,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(statuses_muc_defaults_to_all,
                                        load_preferences,
                                        close_preferences),

        cmocka_unit_test_setup_teardown(console_shows_online_presence_when_set_online,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(console_shows_online_presence_when_set_all,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(console_shows_dnd_presence_when_set_all,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(handle_offline_removes_chat_session,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(lost_connection_clears_chat_sessions,
                                        load_preferences,
                                        close_preferences),

        cmocka_unit_test(cmd_alias_add_shows_usage_when_no_args),
        cmocka_unit_test(cmd_alias_add_shows_usage_when_no_value),
        cmocka_unit_test(cmd_alias_remove_shows_usage_when_no_args),
        cmocka_unit_test(cmd_alias_show_usage_when_invalid_subcmd),
        cmocka_unit_test_setup_teardown(cmd_alias_add_adds_alias,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(cmd_alias_add_shows_message_when_exists,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(cmd_alias_remove_removes_alias,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(cmd_alias_remove_shows_message_when_no_alias,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(cmd_alias_list_shows_all_aliases,
                                        load_preferences,
                                        close_preferences),

        cmocka_unit_test_setup_teardown(test_muc_invites_add, muc_before_test, muc_after_test),
        cmocka_unit_test_setup_teardown(test_muc_remove_invite, muc_before_test, muc_after_test),
        cmocka_unit_test_setup_teardown(test_muc_invites_count_0, muc_before_test, muc_after_test),
        cmocka_unit_test_setup_teardown(test_muc_invites_count_5, muc_before_test, muc_after_test),
        cmocka_unit_test_setup_teardown(test_muc_room_is_not_active, muc_before_test, muc_after_test),
        cmocka_unit_test_setup_teardown(test_muc_active, muc_before_test, muc_after_test),

        cmocka_unit_test(cmd_bookmark_shows_message_when_disconnected),
        cmocka_unit_test(cmd_bookmark_shows_message_when_disconnecting),
        cmocka_unit_test(cmd_bookmark_shows_message_when_connecting),
        cmocka_unit_test(cmd_bookmark_shows_usage_when_no_args),
        cmocka_unit_test(cmd_bookmark_list_shows_bookmarks),
        cmocka_unit_test(cmd_bookmark_add_shows_message_when_invalid_jid),
        cmocka_unit_test(cmd_bookmark_add_adds_bookmark_with_jid),
        muc_unit_test(cmd_bookmark_uses_roomjid_in_room),
        muc_unit_test(cmd_bookmark_add_uses_roomjid_in_room),
        muc_unit_test(cmd_bookmark_add_uses_supplied_jid_in_room),
        muc_unit_test(cmd_bookmark_remove_uses_roomjid_in_room),
        muc_unit_test(cmd_bookmark_remove_uses_supplied_jid_in_room),
        cmocka_unit_test(cmd_bookmark_add_adds_bookmark_with_jid_nick),
        cmocka_unit_test(cmd_bookmark_add_adds_bookmark_with_jid_autojoin),
        cmocka_unit_test(cmd_bookmark_add_adds_bookmark_with_jid_nick_autojoin),
        cmocka_unit_test(cmd_bookmark_remove_removes_bookmark),
        cmocka_unit_test(cmd_bookmark_remove_shows_message_when_no_bookmark),

#ifdef HAVE_LIBOTR
        cmocka_unit_test(cmd_otr_log_shows_usage_when_no_args),
        cmocka_unit_test(cmd_otr_log_shows_usage_when_invalid_subcommand),
        cmocka_unit_test_setup_teardown(cmd_otr_log_on_enables_logging,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(cmd_otr_log_off_disables_logging,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(cmd_otr_redact_redacts_logging,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(cmd_otr_log_on_shows_warning_when_chlog_disabled,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(cmd_otr_log_redact_shows_warning_when_chlog_disabled,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test(cmd_otr_libver_shows_libotr_version),
        cmocka_unit_test(cmd_otr_gen_shows_message_when_not_connected),
        cmocka_unit_test(cmd_otr_gen_generates_key_for_connected_account),
        cmocka_unit_test(cmd_otr_gen_shows_message_when_disconnected),
        cmocka_unit_test(cmd_otr_gen_shows_message_when_connecting),
        cmocka_unit_test(cmd_otr_gen_shows_message_when_disconnecting),
        cmocka_unit_test(cmd_otr_myfp_shows_message_when_disconnected),
        cmocka_unit_test(cmd_otr_myfp_shows_message_when_connecting),
        cmocka_unit_test(cmd_otr_myfp_shows_message_when_disconnecting),
        cmocka_unit_test(cmd_otr_myfp_shows_message_when_no_key),
        cmocka_unit_test(cmd_otr_myfp_shows_my_fingerprint),
        cmocka_unit_test(cmd_otr_theirfp_shows_message_when_in_console),
        cmocka_unit_test(cmd_otr_theirfp_shows_message_when_in_muc),
        cmocka_unit_test(cmd_otr_theirfp_shows_message_when_in_private),
        cmocka_unit_test(cmd_otr_theirfp_shows_message_when_non_otr_chat_window),
        cmocka_unit_test(cmd_otr_theirfp_shows_fingerprint),
        cmocka_unit_test(cmd_otr_start_shows_message_when_in_console),
        cmocka_unit_test(cmd_otr_start_shows_message_when_in_muc),
        cmocka_unit_test(cmd_otr_start_shows_message_when_in_private),
        cmocka_unit_test(cmd_otr_start_shows_message_when_already_started),
        cmocka_unit_test(cmd_otr_start_shows_message_when_no_key),
        cmocka_unit_test_setup_teardown(cmd_otr_start_sends_otr_query_message_to_current_recipeint,
                                        load_preferences,
                                        close_preferences),
#else
        cmocka_unit_test(cmd_otr_shows_message_when_otr_unsupported),
#endif

#ifdef HAVE_LIBGPGME
        cmocka_unit_test(cmd_pgp_shows_usage_when_no_args),
        cmocka_unit_test(cmd_pgp_start_shows_message_when_disconnected),
        cmocka_unit_test(cmd_pgp_start_shows_message_when_disconnecting),
        cmocka_unit_test(cmd_pgp_start_shows_message_when_connecting),
        cmocka_unit_test(cmd_pgp_start_shows_message_when_no_arg_in_console),
        cmocka_unit_test(cmd_pgp_start_shows_message_when_no_arg_in_muc),
        cmocka_unit_test(cmd_pgp_start_shows_message_when_no_arg_in_conf),
        cmocka_unit_test(cmd_pgp_start_shows_message_when_no_arg_in_private),
        cmocka_unit_test(cmd_pgp_start_shows_message_when_no_arg_in_xmlconsole),
#else
        cmocka_unit_test(cmd_pgp_shows_message_when_pgp_unsupported),
#endif

        cmocka_unit_test(cmd_join_shows_message_when_disconnecting),
        cmocka_unit_test(cmd_join_shows_message_when_connecting),
        cmocka_unit_test(cmd_join_shows_message_when_disconnected),
        cmocka_unit_test(cmd_join_shows_error_message_when_invalid_room_jid),
        muc_unit_test(cmd_join_uses_account_mucservice_when_no_service_specified),
        muc_unit_test(cmd_join_uses_supplied_nick),
        muc_unit_test(cmd_join_uses_account_nick_when_not_supplied),
        muc_unit_test(cmd_join_uses_password_when_supplied),

        cmocka_unit_test(cmd_roster_shows_message_when_disconnecting),
        cmocka_unit_test(cmd_roster_shows_message_when_connecting),
        cmocka_unit_test(cmd_roster_shows_message_when_disconnected),
        cmocka_unit_test(cmd_roster_shows_roster_when_no_args),
        cmocka_unit_test(cmd_roster_add_shows_message_when_no_jid),
        cmocka_unit_test(cmd_roster_add_sends_roster_add_request),
        cmocka_unit_test(cmd_roster_remove_shows_message_when_no_jid),
        cmocka_unit_test(cmd_roster_remove_sends_roster_remove_request),
        cmocka_unit_test(cmd_roster_remove_nickname_sends_roster_remove_request),
        cmocka_unit_test(cmd_roster_nick_shows_message_when_no_jid),
        cmocka_unit_test(cmd_roster_nick_shows_message_when_no_nick),
        cmocka_unit_test(cmd_roster_nick_shows_message_when_no_contact_exists),
        cmocka_unit_test(cmd_roster_nick_sends_name_change_request),
        cmocka_unit_test(cmd_roster_clearnick_shows_message_when_no_jid),
        cmocka_unit_test(cmd_roster_clearnick_shows_message_when_no_contact_exists),
        cmocka_unit_test(cmd_roster_clearnick_sends_name_change_request_with_empty_nick),

        cmocka_unit_test(get_form_type_field_returns_null_no_fields),
        cmocka_unit_test(get_form_type_field_returns_null_when_not_present),
        cmocka_unit_test(get_form_type_field_returns_value_when_present),
        cmocka_unit_test(get_field_type_returns_unknown_when_no_fields),
        cmocka_unit_test(get_field_type_returns_correct_type),
        cmocka_unit_test(set_value_adds_when_none),
        cmocka_unit_test(set_value_updates_when_one),
        cmocka_unit_test(add_unique_value_adds_when_none),
        cmocka_unit_test(add_unique_value_does_nothing_when_exists),
        cmocka_unit_test(add_unique_value_adds_when_doesnt_exist),
        cmocka_unit_test(add_value_adds_when_none),
        cmocka_unit_test(add_value_adds_when_some),
        cmocka_unit_test(add_value_adds_when_exists),
        cmocka_unit_test(remove_value_does_nothing_when_none),
        cmocka_unit_test(remove_value_does_nothing_when_doesnt_exist),
        cmocka_unit_test(remove_value_removes_when_one),
        cmocka_unit_test(remove_value_removes_when_many),
        cmocka_unit_test(remove_text_multi_value_does_nothing_when_none),
        cmocka_unit_test(remove_text_multi_value_does_nothing_when_doesnt_exist),
        cmocka_unit_test(remove_text_multi_value_removes_when_one),
        cmocka_unit_test(remove_text_multi_value_removes_when_many),

        cmocka_unit_test_setup_teardown(clears_chat_sessions,
                                        load_preferences,
                                        close_preferences),

        cmocka_unit_test(prof_partial_occurrences_tests),
        cmocka_unit_test(prof_whole_occurrences_tests),
        cmocka_unit_test(prof_occurrences_of_large_message_tests),

        cmocka_unit_test_setup_teardown(returns_no_commands,
                                        load_preferences,
                                        close_preferences),
        cmocka_unit_test_setup_teardown(returns_commands,
                                        load_preferences,
                                        close_preferences),

        cmocka_unit_test(returns_empty_list_when_none),
        cmocka_unit_test(returns_added_feature),
        cmocka_unit_test(resets_features_on_close),
        cmocka_unit_test(returns_all_added_features),
        cmocka_unit_test(does_not_add_duplicate_feature),
        cmocka_unit_test(removes_plugin_features),
        cmocka_unit_test(does_not_remove_feature_when_more_than_one_reference),
    };
    return cmocka_run_group_tests(all_tests, NULL, NULL);
}
