import { minify } from 'terser';
const pkg = require(process.env.PWD+'/package.json');
if(!pkg.dependencies) pkg.dependencies={};
const file = pkg.main ? pkg.main : 'index.cjs';

const config = {
	input: process.env.START_FILE,
	output: [{
		format: 'cjs',
		file: file,
		preferConst: true,
		interop: false,
		freeze: false,
		strict: false
	}],
	external: [
		...Object.keys(pkg.dependencies),
		...require('module').builtinModules,
	],
	plugins: [
		{
			name: 'terser',
			renderChunk(code) {
				return minify(code, {
					module: true,
					toplevel: false
				})
			}
		}
	]
}

export default config;
