<?php
/**
*
* This file is part of the Norwegian (bokmål) Language Pack
* for the phpBB Forum Software.
*
* @copyright (c) phpBB Limited <https://www.phpbb.com>
* @copyright (c) Lars Christian Schreiner
* @license GNU General Public License, version 2 (GPL-2.0)
*
* For full copyright and license information, please see
* the docs/CREDITS.txt file.
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine

// Privacy policy and T&C
$lang = array_merge($lang, array(
	'TERMS_OF_USE_CONTENT'	=> 'Ved å bruke «%1$s» (heretter omtalt som «vi», «oss», «vår», «%1$s», «%2$s»), godtar du å være juridisk bundet av følgende vilkår. Hvis du ikke godtar å være juridisk bundet av alle de følgende vilkårene, kan du ikke bruke «%1$s». Vi forbeholder oss retten til når som helst å endre disse, og vi vil strekke oss til vårt ytterste for å informere deg om dette, men det vil likevel være tilrådelig at du selv holder deg oppdatert på disse ettersom fortsatt bruk av «%1$s» etter endringer innebærer at du er juridisk bundet av disse vilkårene etter de er oppdatert og/eller utvidet.<br />
	<br />
	Foraene våre kjører på phpBB (heretter omtalt som «de», «dem», «deres», «sine», «phpBB-programvare», «www.phpbb.com», «phpBB Limited», «phpBB-team») som er en forumløsning som er utgitt under «<a href="http://opensource.org/licenses/gpl-2.0.php">GNU General Public License v2</a>» (heretter omtalt som «GPL») og som kan lastes ned fra <a href="https://www.phpbb.com/">www.phpbb.com</a>. phpBB-programvaren gjør det bare mulig med Internett-baserte diskusjoner – phpBB Limited er ikke ansvarlig for hva vi tillater og/eller forbyr som akseptabelt innhold og/eller atferd. Hvis du vil ha mer informasjon om phpBB, kan du se: <a href="https://www.phpbb.com/">https://www.phpbb.com/</a>.<br />
	<br />
	Du godtar å avstå fra å legge inn nedsettende, obskønt, vulgært, krenkende, hatefullt, truende, seksuelt orientert materiale eller annet materiale som kan være i strid med lover og regler i landet du bor i eller landet der «%1$s» holder til, eller internasjonale lover og konvensjoner. Brudd på dette kan føre til at du umiddelbart blir permanent utestengt, etterfulgt av varsling av tjenesteleverandøren, dersom vi finner det nødvendig. IP-adresse regsistreres for alle innlegg, for at disse vilkårene skal kunne håndheves. Du godtar at «%1$s» har rett til når som helst å fjerne, redigere, flytte eller lukke alle emner, i den grad vi finner det nødvendig. Som bruker godtar du at informasjon du har oppgitt, lagres i en database. Selv om denne informasjonen ikke vil bli gjort tilgjengelig for tredjeparter uten ditt samtykke, kan verken «%1$s» eller phpBB holdes ansvarlig for forsøk på hacking som kan føre til at data kommer på avveie.
	',

	'PRIVACY_POLICY'		=> 'Denne policyen forklarer detaljert hvordan «%1$s» og dets tilknyttede selskaper (heretter omtalt som «vi», «oss», «vår», «%1$s», «%2$s») og phpBB (heretter omtalt som «de», «dem», «deres», «sine», «phpBB-programvare», «www.phpbb.com», «phpBB Limited», «phpBB-teams») bruker informasjon som samles inn i løpet av en av dine bruksøkter (heretter omtalt som «informasjonen din»).<br />
	<br />
	Informasjonen din samles inn på to måter. For det første vil bruk av «%1$s» medføre at phpBB-programvaren oppretter et antall informasjonskapsler («cookies»), som er små tekstfiler som lastes ned til nettleserens midlertidige filer på datamaskinen din. De første to informasjonskapslene inneholder bare en brukeridentifikator (heretter «bruker-ID» og en anonym øktsidentifikator (heretter «økts-ID») som automatisk tildeles deg av phpBB-programvaren. En tredje informasjonskapsel opprettes når du har vært innom emner i «%1$s», og brukes til å lagre hvilke emner som er lest, noe som forbedrer brukeropplevelsen din.<br />
	<br />
	Vi kan også opprette informasjonskapsler som er eksterne for phpBB-programvaren under bruken av «%1$s», selv om disse faller utenfor dette dokumentets rekkevidde, som bare er ment å dekke sider som opprettes av phpBB-programvaren. Den andre måten vi kan samle inn informasjon på, er hva du sender inn til oss. Dette kan omfatte, men er ikke begrenset til: skriving av innlegg som en anonym bruker (heretter «anonyme innlegg»), registrering på «%1$s» (heretter «kontoen din») og innlegg som er sendt inn etter registrering og mens du er pålogget (heretter «dine innlegg»).<br />
	<br />
	Kontoen din vil som et minimum inneholde et unikt identifiserbart navn (heretter «brukernavnet nitt»), et personlig passord som brukes til å logge inn på kontoen (heretter «passordet ditt») og en personlig, gyldig e-postadresse (heretter «e-postadressen din). Informasjonen din for kontoen på «%1$s» beskyttes av lover om datavern i det landet hvor sidene fysisk er lagret. All informasjon ut over brukernavnet ditt, passordet ditt og e-postadressen din, som kreves av «%1$s» under registreringsprosessen er enten obligatorisk eller valgfri, etter «%1$s»s eget valg. I alle tilfeller har du mulighet til å velge hvilken informasjon som vises offentlig. Videre har du, fra kontoen din, muligheten til å velge eller velge bort automatisk generert e-post fra phpBB-programvaren.<br />
	<br />
	Passordet ditt er kodet (en enveis-hash), slik at det er sikret. Det anbefales imidlertid at du ikke bruker samme passord på flere nettsteder. Passordet er nøkkelen til kontoen din hos «%1$s», så pass godt på det. Personer med tilknytning til «%1$s», phpBB eller andre tredjeparter vil aldri legitimt kunne be deg om passordet. Hvis du glemmer passordet til kontoen, kan du bruke funksjonen «Jeg har glemt passordet» i phpBB-programvaren. I løpet av denne prosessen vil du bli bedt om å oppgi brukernavn og e-postadresse, og deretter vil phpBB-programvaren opprette et nytt passord, slik at du får tilgang til kontoen din igjen.<br />
	',
));

// Common language entries
$lang = array_merge($lang, array(
	'ACCOUNT_ACTIVE'				=> 'Kontoen er nå aktivert. Takk for at du registrerte deg.',
	'ACCOUNT_ACTIVE_ADMIN'			=> 'Kontoen er nå aktivert.',
	'ACCOUNT_ACTIVE_PROFILE'		=> 'Kontoen er nå reaktivert.',
	'ACCOUNT_ADDED'					=> 'Takk for at du registrerte deg, kontoen er nå opprettet. Du kan nå logge inn med brukernavn og passord.',
	'ACCOUNT_COPPA'					=> 'Kontoen er opprettet, men må gkdjennes. Sjekk e-posten for mer informasjon.',
	'ACCOUNT_EMAIL_CHANGED'			=> 'Kontoen er oppdatert. Dette systemet krever imidlertid reaktivering av kontoen ved endring av e-postadresse. Det er sendt en aktiveringsnøkkel til e-postadressen du angav. Sjekk e-posten for mer informasjon.',
	'ACCOUNT_EMAIL_CHANGED_ADMIN'	=> 'Kontoen er oppdatert. Dette systemet krever imidlertid at kontoen reaktiveres av en administrator ved endring av e-postadresse. Det er sendt en e-post til dem, og du vil bli varslet når kontoen er reaktivert.',
	'ACCOUNT_INACTIVE'				=> 'Kontoen er opprettet. Dette systemet krever imidlertid at kontoen aktiveres. En aktiveringsnøkkel er sendt til e-postadressen du angav. Sjekk e-posten for mer informasjon.',
	'ACCOUNT_INACTIVE_ADMIN'		=> 'Kontoen er opprettet. Dette systemet krever imidlertid at kontoen aktiveres av en administrator. Det er sendt en e-post til dem, og du vil bli varslet når kontoen er aktivert.',
	'ACTIVATION_EMAIL_SENT'			=> 'Aktiverings-e-posten er sendt til e-postadressen din.',
	'ACTIVATION_EMAIL_SENT_ADMIN'	=> 'Aktiverings-e-posten er sendt til administratorenes e-postadresse.',
	'ADD'							=> 'Legg til',
	'ADD_BCC'						=> 'Legg til [Blindkopi]',
	'ADD_FOES'						=> 'Legg til nye uvenner',
	'ADD_FOES_EXPLAIN'				=> 'Du kan legge til flere brukernavn hvis du skriver ett på hver sin linje.',
	'ADD_FOLDER'					=> 'Legg til mappe',
	'ADD_FRIENDS'					=> 'Legg til nye venner',
	'ADD_FRIENDS_EXPLAIN'			=> 'Du kan legge til flere brukernavn hvis du skriver ett på hver sin linje.',
	'ADD_NEW_RULE'					=> 'Legg til ny regel',
	'ADD_RULE'						=> 'Legg til regel',
	'ADD_TO'						=> 'Legg til [Til]',
	'ADD_USERS_UCP_EXPLAIN'			=> 'Her kan du legge til nye brukere i gruppen. Du kan velge om denne gruppen skal være standard for de valgte brukerne. Skriv inn brukernavnene på hver sin linje.',
	'ADMIN_EMAIL'					=> 'Administratorer kan sende meg informasjon per e-post',
	'AGREE'							=> 'Jeg godtar disse vilkårene',
	'ALLOW_PM'						=> 'Tillat at brukere sender deg private meldinger',
	'ALLOW_PM_EXPLAIN'				=> 'Merk at administratorer og moderatorer alltid vil kunne sende deg meldinger.',
	'ALREADY_ACTIVATED'				=> 'Du har allerede aktivert kontoen.',
	'ATTACHMENTS_EXPLAIN'			=> 'Dette er en liste over vedlegg du har lagt til i innlegg på dette systemet.',
	'ATTACHMENTS_DELETED'			=> 'Vedleggene er slettet.',
	'ATTACHMENT_DELETED'			=> 'Vedlegget er slettet.',
	'AUTOLOGIN_SESSION_KEYS_DELETED'=> 'Da valgte «Husk meg»-nøklene ble slettet.',
	'AVATAR_CATEGORY'				=> 'Kategori',
	'AVATAR_DRIVER_GRAVATAR_TITLE'	=> 'Gravatar',
	'AVATAR_DRIVER_GRAVATAR_EXPLAIN'=> 'Gravatar er en tjeneste som lar deg bruke den samme avataren på mange nettsteder. Gå til <a href="http://www.gravatar.com/">Gravatar</a> for mer informasjon.',
	'AVATAR_DRIVER_LOCAL_TITLE'		=> 'Galleriavatar',
	'AVATAR_DRIVER_LOCAL_EXPLAIN'	=> 'Du kan velge avatar fra et sett med avatarer som er tilgjengelig lokalt.',
	'AVATAR_DRIVER_REMOTE_TITLE'	=> 'Ekstern avatar',
	'AVATAR_DRIVER_REMOTE_EXPLAIN'	=> 'Lenk til avatarbilder fra et annet nettsted.',
	'AVATAR_DRIVER_UPLOAD_TITLE'	=> 'Last opp avatar',
	'AVATAR_DRIVER_UPLOAD_EXPLAIN'	=> 'Last opp din egen, personlige avatar.',
	'AVATAR_EXPLAIN'				=> 'Maksimal størrelse: Bredde: %1$s, høyde: %2$s, filstørrelse: %3$.2f kiB.',
	'AVATAR_FEATURES_DISABLED'		=> 'Avatarfunksjonaliteten er for øyeblikket deaktivert.',
	'AVATAR_GALLERY'				=> 'Lokalt galleri',
	'AVATAR_GENERAL_UPLOAD_ERROR'	=> 'Kan ikke laste opp avatar til %s.',
	'AVATAR_NOT_ALLOWED'			=> 'Avataren din kan ikke vises, fordi avatarer ikke er tillatt.',
	'AVATAR_PAGE'					=> 'Side',
	'AVATAR_SELECT'					=> 'Velg avatar',
	'AVATAR_TYPE'					=> 'Avatartype',
	'AVATAR_TYPE_NOT_ALLOWED'		=> 'Gjeldende avatar kan ikke vises, fordi typen ikke er tillatt.',

	'BACK_TO_DRAFTS'			=> 'Tilbake til lagrede kladder',
	'BACK_TO_LOGIN'				=> 'Tilbake til innloggingsskjermen',
	'BIRTHDAY'					=> 'Fødselsdag',
	'BIRTHDAY_EXPLAIN'			=> 'Hvis du angir et årstall, vil alderen vises når du har fødselsdag.',
	'BOARD_DATE_FORMAT'			=> 'Mitt datoformat',
	'BOARD_DATE_FORMAT_EXPLAIN'	=> 'Syntaksen er identisk med funksjonen <a href="http://www.php.net/date">date()</a> i PHP.',
	'BOARD_LANGUAGE'			=> 'Mitt språk',
	'BOARD_STYLE'				=> 'Min systemstil',
	'BOARD_TIMEZONE'			=> 'Min tidssone',
	'BOOKMARKS'					=> 'Bokmerker',
	'BOOKMARKS_EXPLAIN'			=> 'Du kan bokmerke emner for å finne tilbake til dem senere. Merk av i boksen for bokmerkene du vil slette, og klikk så <em>Fjern merkede bokmerker</em>.',
	'BOOKMARKS_DISABLED'		=> 'Bokmerker er deaktivert på dette systemet.',
	'BOOKMARKS_REMOVED'			=> 'Bokmerkene er fjernet.',

	'CANNOT_EDIT_MESSAGE_TIME'	=> 'Du kan ikke lenger redigere eller slette den meldingen.',
	'CANNOT_MOVE_TO_SAME_FOLDER'=> 'Meldinger kan ikke flyttes til mappen du vil fjerne.',
	'CANNOT_MOVE_FROM_SPECIAL'	=> 'Meldinger kan ikke flyttes fra utboksen.',
	'CANNOT_RENAME_FOLDER'		=> 'Denne mappen kan du ikke endre navnet på.',
	'CANNOT_REMOVE_FOLDER'		=> 'Denne mappen kan ikke fjernes.',
	'CHANGE_DEFAULT_GROUP'		=> 'Endre standardgruppe',
	'CHANGE_PASSWORD'			=> 'Endre passord',
	'CLICK_GOTO_FOLDER'			=> '%1$sGå til «%3$s»-mappen%2$s',
	'CLICK_RETURN_FOLDER'		=> '%1$sGå tilbake til «%3$s»-mappen%2$s',
	'CONFIRMATION'				=> 'Registreringsbekreftelse',
	'CONFIRM_CHANGES'			=> 'Bekreft endringer',
	'CONFIRM_EXPLAIN'			=> 'For å forhindre automatisert registrering, krever systemet at du angir en bekreftelseskode. Koden vises i bildet du ser nedenfor. Hvis du er svaksynt eller av andre grunner ikke kan lese denne koden, kan du kontakte %ssystemadministratoren%s.',
	'VC_REFRESH'				=> 'Oppdater bekreftelseskode',
	'VC_REFRESH_EXPLAIN'		=> 'Hvis du ikke kan lese koden, kan du be om en ny kode ved å klikke på knappen.',

	'CONFIRM_PASSWORD'			=> 'Bekreft passord',
	'CONFIRM_PASSWORD_EXPLAIN'	=> 'Du trenger bare å bekrefte passordet hvis du har endret det ovenfor.',
	'COPPA_BIRTHDAY'			=> 'Du fortsetter registreringsprosessen ved å fortelle oss når du ble født.',
	'COPPA_COMPLIANCE'			=> 'COPPA-kompatibilitet',
	'COPPA_EXPLAIN'				=> 'Når du klikker på innsendingsknappen, vil kontoen bli opprettet. Den kan imidlertid ikke aktiveres før en forelder eller en verge godkjenner registreringen. Du vil bli tilsendt en kopi av det nødvendige skjemaet, inkludert detaljer for hvor du sender det.',
	'CREATE_FOLDER'				=> 'Legg til mappe…',
	'CURRENT_IMAGE'				=> 'Gjeldende bilde',
	'CURRENT_PASSWORD'			=> 'Gjeldende passord',
	'CURRENT_PASSWORD_EXPLAIN'	=> 'Du må angi gjeldende passord hvis du vil endre e-postadresse eller brukernavn.',
	'CURRENT_CHANGE_PASSWORD_EXPLAIN' => 'Hvis du vil endre passrd, e-postadresse eller brukernavn, må du angi gjeldende passord.',
	'CUR_PASSWORD_EMPTY'		=> 'Du angav ikke gjeldende passord.',
	'CUR_PASSWORD_ERROR'		=> 'Det gjeldende passordet du angav, er feil.',
	'CUSTOM_DATEFORMAT'			=> 'Egendefinert…',

	'DEFAULT_ACTION'			=> 'Standardhandling',
	'DEFAULT_ACTION_EXPLAIN'	=> 'Denne handlingen vil bli utløst hvis intet av det ovenstående gjelder.',
	'DEFAULT_ADD_SIG'			=> 'Legg ved signaturen min som standard',
	'DEFAULT_BBCODE'			=> 'Aktiver BBCode som standard',
	'DEFAULT_NOTIFY'			=> 'Varsle meg ved svar som standard',
	'DEFAULT_SMILIES'			=> 'Aktiver smilefjes som standard',
	'DEFINED_RULES'				=> 'Definerte regler',
	'DELETED_TOPIC'				=> 'Emnet er fjernet.',
	'DELETE_ATTACHMENT'			=> 'Slett vedlegg',
	'DELETE_ATTACHMENTS'		=> 'Slett vedlegg',
	'DELETE_ATTACHMENT_CONFIRM'	=> 'Er du sikker på at du vil slette dette vedlegget?',
	'DELETE_ATTACHMENTS_CONFIRM'=> 'Er du sikker på at du vil slette disse vedleggene?',
	'DELETE_AVATAR'				=> 'Slett bilde',
	'DELETE_COOKIES_CONFIRM'	=> 'Er du sikker på at du vil slette alle informasjonskapsler på dette systemet?',
	'DELETE_MARKED_PM'			=> 'Slett merkede meldinger',
	'DELETE_MARKED_PM_CONFIRM'	=> 'Er du sikker på at du vil slette alle merkede meldinger?',
	'DELETE_OLDEST_MESSAGES'	=> 'Slett eldste meldinger',
	'DELETE_MESSAGE'			=> 'Slett melding',
	'DELETE_MESSAGE_CONFIRM'	=> 'Er du sikker på at du vil slette denne private meldingen?',
	'DELETE_MESSAGES_IN_FOLDER'	=> 'Slett alle meldinger i den fjernede mappen',
	'DELETE_RULE'				=> 'Slett regel',
	'DELETE_RULE_CONFIRM'		=> 'Er du sikker på at du vil slette denne regelen?',
	'DEMOTE_SELECTED'			=> 'Degrader valgte',
	'DISABLE_CENSORS'			=> 'Aktiver ordsensur',
	'DISPLAY_GALLERY'			=> 'Vis galleri',
	'DOMAIN_NO_MX_RECORD_EMAIL'	=> 'Det angitte e-postdomenet har ingen gyldige MX-poster.',
	'DOWNLOADS'					=> 'Nedlastinger',
	'DRAFTS_DELETED'			=> 'Alle valgte kladder ble slettet.',
	'DRAFTS_EXPLAIN'			=> 'Her kan du vise, redigere og slette lagrede kladder.',
	'DRAFT_UPDATED'				=> 'Kladden er oppdatert.',

	'EDIT_DRAFT_EXPLAIN'		=> 'Her kan du redigere kladder. Kladder inngeholder ikke informasjon om vedlegg og avstemminger.',
	'EMAIL_BANNED_EMAIL'		=> 'E-postadressen du angav, tillates ikke brukt.',
	'EMAIL_REMIND'				=> 'Dette må være den samme e-postadressen som er tilknyttet kontoen din. Hvis du ikke har endret dette i brukerkontrollpanelet, er det den e-postadressen du registrerte kontoen med.',
	'EMAIL_TAKEN_EMAIL'			=> 'Den angitte e-postadressen er allerede i bruk.',
	'EMPTY_DRAFT'				=> 'Du må angi en melding for å sende inn endringene.',
	'EMPTY_DRAFT_TITLE'			=> 'Du må angi en tittel for kladden.',
	'EXPORT_AS_XML'				=> 'Eksporter som XML',
	'EXPORT_AS_CSV'				=> 'Eksporter som CSV',
	'EXPORT_AS_CSV_EXCEL'		=> 'Eksporter som CSV (Excel)',
	'EXPORT_AS_TXT'				=> 'Eksporter som TXT',
	'EXPORT_AS_MSG'				=> 'Eksporter som MSG',
	'EXPORT_FOLDER'				=> 'Eksporter denne visningen',

	'FIELD_REQUIRED'					=> 'Feltet «%s» må fylles ut.',
	'FIELD_TOO_SHORT'					=> array(
		1	=> 'Feltet «%2$s» er for kort, det kreves minst %1$d tegn.',
		2	=> 'Feltet «%2$s» er for kort, det kreves minst %1$d tegn.',
	),
	'FIELD_TOO_LONG'					=> array(
		1	=> 'Feltet «%2$s» er for langt, det tillates maksimalt %1$d tegn.',
		2	=> 'Feltet «%2$s» er for langt, det tillates maksimalt %1$d tegn.',
	),
	'FIELD_TOO_SMALL'					=> 'Verdien til «%2$s» er for liten, det kreves en verdi på minst %1$d.',
	'FIELD_TOO_LARGE'					=> 'Verdien til «%2$s» er for stor, det tillates en verdi på maksimalt %1$d.',
	'FIELD_INVALID_CHARS_INVALID'		=> 'Feltet «%s» har ugyldige tegn.',
	'FIELD_INVALID_CHARS_NUMBERS_ONLY'	=> 'Feltet «%s» har ugyldige tegn, bare sifre tillates.',
	'FIELD_INVALID_CHARS_ALPHA_DOTS'	=> 'Feltet «%s» har ugyldige tegn, bare alfanumeriske tegn eller . tillates.',
	'FIELD_INVALID_CHARS_ALPHA_ONLY'	=> 'Feltet «%s» har ugyldige tegn, bare alfanumeriske tegn tillates.',
	'FIELD_INVALID_CHARS_ALPHA_PUNCTUATION'	=> 'Feltet «%s» har ugyldige tegn, bare alfanumeriske tegn og tegnene _,-. tillates, og det første tegnet må være alfabetisk.',
	'FIELD_INVALID_CHARS_ALPHA_SPACERS'	=> 'Feltet «%s» har ugyldige tegn, bare alfanumeriske tegn, mellomrom og tegnene -+_[] tillates.',
	'FIELD_INVALID_CHARS_ALPHA_UNDERSCORE'	=> 'Feltet «%s» har ugyldige tegn, bare alfanumeriske tegn og _ tillates.',
	'FIELD_INVALID_CHARS_LETTER_NUM_DOTS'	=> 'Feltet «%s» har ugyldige tegn, bare bokstaver, sifre og . tillates.',
	'FIELD_INVALID_CHARS_LETTER_NUM_ONLY'	=> 'Feltet «%s» har ugyldige tegn, bare bokstaver og sifre tillates.',
	'FIELD_INVALID_CHARS_LETTER_NUM_PUNCTUATION'	=> 'Feltet «%s» har ugyldige tegn, bare bokstaver, sifre og tegnene _,-. tillates, og det første tegnet må være alfabetisk.',
	'FIELD_INVALID_CHARS_LETTER_NUM_SPACERS'		=> 'Feltet «%s» har ugyldige tegn, bare bokstaver, sifre, mellomrom og tegnene -+_[] tillates.',
	'FIELD_INVALID_CHARS_LETTER_NUM_UNDERSCORE'		=> 'Feltet «%s» har ugyldige tegn, bare bokstaver, sifre og _ tillates.',
	'FIELD_INVALID_DATE'				=> 'Feltet «%s» har en ugyldig dato.',
	'FIELD_INVALID_URL'					=> 'Feltet «%s» har en ugyldig URL.',
	'FIELD_INVALID_VALUE'				=> 'Feltet «%s» har en ugyldig verdi.',

	'FOE_MESSAGE'				=> 'Melding fra uvenn',
	'FOES_EXPLAIN'				=> 'Uvenner er brukere som ignoreres som standard. Innlegg av disse brukerne vil ikke være fullt synlige. Personlige meldinger fra uvenner tillates likevel. Merk at du ikke kan ignorere moderatorer og administratorer.',
	'FOES_UPDATED'				=> 'Uvennelisten din er oppdatert.',
	'FOLDER_ADDED'				=> 'Mappen er lagt til.',
	'FOLDER_MESSAGE_STATUS'		=> array(
		1	=> '%2$d av %1$s er lagret',
		2	=> '%2$d av %1$s er lagret',
	),
	'FOLDER_NAME_EMPTY'			=> 'Du må angi et navn på denne mpappen.',
	'FOLDER_NAME_EXIST'			=> 'Mappen <strong>%s</strong> finnes allerede.',
	'FOLDER_OPTIONS'			=> 'Mappealternativer',
	'FOLDER_RENAMED'			=> 'Navnet på mappen er endret.',
	'FOLDER_REMOVED'			=> 'Mappen er fjernet.',
	'FOLDER_STATUS_MSG'			=> array(
		1	=> 'Mappen er %3$d %% full (%2$d av %1$s er lagret)',
		2	=> 'Mappen er %3$d %% full (%2$d av %1$s er lagret)',
	),
	'FORWARD_PM'				=> 'Videresend PM',
	'FORCE_PASSWORD_EXPLAIN'	=> 'Før du kan fortsette å lese på systemet, må du endre passordet.',
	'FRIEND_MESSAGE'			=> 'Melding fra venn',
	'FRIENDS'					=> 'Venner',
	'FRIENDS_EXPLAIN'			=> 'Venner gjør at du får enkel tilgang til brukere du kommuniserer ofte med. Hvis malen har støtte for det, kan innlegg av venner bli uthevet.',
	'FRIENDS_OFFLINE'			=> 'Offline',
	'FRIENDS_ONLINE'			=> 'Online',
	'FRIENDS_UPDATED'			=> 'Vennelisten er oppdatert.',
	'FULL_FOLDER_OPTION_CHANGED'=> 'Handlingen som skal utføres når en mappe er full, er endret.',
	'FWD_ORIGINAL_MESSAGE'		=> '-------- Opprinnelig melding --------',
	'FWD_SUBJECT'				=> 'Emne: %s',
	'FWD_DATE'					=> 'Dato: %s',
	'FWD_FROM'					=> 'Fra:  %s',
	'FWD_TO'					=> 'Til:  %s',

	'GLOBAL_ANNOUNCEMENT'		=> 'Global kunngjøring',

	'GRAVATAR_AVATAR_EMAIL'			=> 'E-postadresse for Gravatar',
	'GRAVATAR_AVATAR_EMAIL_EXPLAIN'	=> 'Angi e-postadressen du brukte til å registrere kontoen på <a href="http://www.gravatar.com/">Gravatar</a>.',
	'GRAVATAR_AVATAR_SIZE'			=> 'Avatarstørrelse',
	'GRAVATAR_AVATAR_SIZE_EXPLAIN'	=> 'Angi bredden og høyden på avataren, la stå tom for å prøve å fastslå dette automatisk.',

	'HIDE_ONLINE'				=> 'Skjul online-statusen min',
	'HIDE_ONLINE_EXPLAIN'		=> 'Endring av denne innstillingen vil ikke tre i kraft før neste gang du besøker systemet.',
	'HOLD_NEW_MESSAGES'			=> 'Ikke godta nye meldinger (Nye meldinger holdes tilbake til det er nok ledig plass)',
	'HOLD_NEW_MESSAGES_SHORT'	=> 'Nye meldinger holdes tilbake',

	'IF_FOLDER_FULL'			=> 'Hvis mappen er full',
	'IMPORTANT_NEWS'			=> 'Viktige kunngjøringer',
	'INVALID_USER_BIRTHDAY'		=> 'Den angitte fødselsdagen er ikke en gyldig dato.',
	'INVALID_CHARS_USERNAME'	=> 'Brukernavnet inneholder forbudte tegn.',
	'INVALID_CHARS_NEW_PASSWORD'=> 'Passordet inneholder ikke de nødvendige tegnene.',
	'ITEMS_REQUIRED'			=> 'Elementene som er merket med *, er obligatoriske profilfelt og må fylles ut.',

	'JOIN_SELECTED'				=> 'Bli med i valgte',

	'LANGUAGE'					=> 'Språk',
	'LINK_REMOTE_AVATAR'		=> 'Lenke til annet nettsted',
	'LINK_REMOTE_AVATAR_EXPLAIN'=> 'Angi URL-en til avatarbildet du ønsker å lenke til.',
	'LINK_REMOTE_SIZE'			=> 'Avatarstørrelse',
	'LINK_REMOTE_SIZE_EXPLAIN'	=> 'Angi bredden og høyden på avataren, la stå tom for å prøve å fastslå dette automatisk.',
	'LOGIN_EXPLAIN_UCP'			=> 'Logg inn for å få tilgang til brukerkontrollpanelet.',
	'LOGIN_LINK'					=> 'Knytt til eller registrer kontoen på en ekstern tjeneste med forumkontoen din.',
	'LOGIN_LINK_EXPLAIN'			=> 'Du har prøvd å logge inn med en ekstern tjeneste som ikke er knyttet til en konto på dette systemet ennå. Du må nå enten knytte denne kontoen til en eksisterende konto eller opprette en ny.',
	'LOGIN_LINK_MISSING_DATA'		=> 'Data som kreves for å knytte kontoen til en ekstern tjeneste, er ikke tilgjengelig. Start innloggingsprosessen på nytt.',
	'LOGIN_LINK_NO_DATA_PROVIDED'	=> 'Ingen data er angitt for denne siden til å knytte en ekstern konto til en forumkonto. Kontakt systemadministratoren hvis disse problemene vedvarer.',
	'LOGIN_KEY'					=> 'Innloggingsnøkkel',
	'LOGIN_TIME'				=> 'Innloggingsklokkeslett',
	'LOGIN_REDIRECT'			=> 'Du er logget inn.',
	'LOGOUT_FAILED'				=> 'Du ble ikke logget ut, ettersom forespørselen ikke samsvarte med økten. Kontakt systemadministratoren hvis disse problemene vedvarer.',
	'LOGOUT_REDIRECT'			=> 'Du er logget ut.',

	'MARK_IMPORTANT'				=> 'Merk/fjern merking som viktig',
	'MARKED_MESSAGE'				=> 'Merket melding',
	'MAX_FOLDER_REACHED'			=> 'Det maksimale antallet brukere som tillates for brukerdefinerte mapper, er nådd.',
	'MESSAGE_BY_AUTHOR'				=> 'av',
	'MESSAGE_COLOURS'				=> 'Meldingsfarger',
	'MESSAGE_DELETED'				=> 'Meldingen er slettet.',
	'MESSAGE_EDITED'				=> 'Meldingen er redigert.',
	'MESSAGE_HISTORY'				=> 'Meldingshistorikk',
	'MESSAGE_REMOVED_FROM_OUTBOX'	=> 'Denne meldingen ble slettet av forfatteren.',
	'MESSAGE_SENT_ON'				=> 'den',
	'MESSAGE_STORED'				=> 'Denne meldingen er sendt.',
	'MESSAGE_TO'					=> 'Til',
	'MESSAGES_DELETED'				=> 'Meldingene er slettet',
	'MOVE_DELETED_MESSAGES_TO'		=> 'Flytt meldinger fra fjernet mappe til',
	'MOVE_DOWN'						=> 'Flytt nedover',
	'MOVE_MARKED_TO_FOLDER'			=> 'Flytt merkede til %s',
	'MOVE_PM_ERROR'					=> array(
		1	=> 'Det oppstod en feil ved flytting av meldingene til den nye mappen. Bare %2$d av %1$s ble flyttet.',
		2	=> 'Det oppstod en feil ved flytting av meldingene til den nye mappen. Bare %2$d av %1$s ble flyttet.',
	),
	'MOVE_TO_FOLDER'				=> 'Flytt til mappe',
	'MOVE_UP'						=> 'Flytt oppover',

	'NEW_FOLDER_NAME'				=> 'Nytt mappenavn',
	'NEW_PASSWORD'					=> 'Nytt passord',
	'NEW_PASSWORD_CONFIRM_EMPTY'	=> 'Du angav ikke noe bekreftelsespassord.',
	'NEW_PASSWORD_ERROR'			=> 'Passordene du angav, samsvarer ikke.',

	'NOTIFICATIONS_MARK_ALL_READ'						=> 'Merk alle varsler som lest',
	'NOTIFICATIONS_MARK_ALL_READ_CONFIRM'				=> 'Er du sikker på at du vil merke alle varsler som lest?',
	'NOTIFICATIONS_MARK_ALL_READ_SUCCESS'				=> 'Alle varslinger er merket som lest.',
	'NOTIFICATION_GROUP_MISCELLANEOUS'					=> 'Diverse varslinger',
	'NOTIFICATION_GROUP_MODERATION'						=> 'Modereringsvarslinger',
	'NOTIFICATION_GROUP_ADMINISTRATION'					=> 'Administrasjonsvarslinger',
	'NOTIFICATION_GROUP_POSTING'						=> 'Innleggsvarslinger',
	'NOTIFICATION_METHOD_EMAIL'							=> 'E-post',
	'NOTIFICATION_METHOD_JABBER'						=> 'Jabber',
	'NOTIFICATION_TYPE'									=> 'Varslingstype',
	'NOTIFICATION_TYPE_BOOKMARK'						=> 'Noen har svart på et emne du har bokmerket',
	'NOTIFICATION_TYPE_GROUP_REQUEST'					=> 'Noen har bedt om å få bli med i en gruppe du er leder i',
	'NOTIFICATION_TYPE_IN_MODERATION_QUEUE'				=> 'Et innlegg eller emne krever godkjenning',
	'NOTIFICATION_TYPE_MODERATION_QUEUE'				=> 'Emnene/innleggene dine er godkjent eller avslått av en moderator',
	'NOTIFICATION_TYPE_PM'								=> 'Noen sender deg en privat melding',
	'NOTIFICATION_TYPE_POST'							=> 'Noen svarer på et emne som du har abonnert på',
	'NOTIFICATION_TYPE_QUOTE'							=> 'Noen har sitert deg i et innlegg',
	'NOTIFICATION_TYPE_REPORT'							=> 'Noen rapporterer et innlegg',
	'NOTIFICATION_TYPE_TOPIC'							=> 'Noen oppretter et emne i et forum som du abonnerer på',
	'NOTIFICATION_TYPE_ADMIN_ACTIVATE_USER'				=> 'Nylig registrert bruker krever aktivering',

	'NOTIFY_METHOD'					=> 'Varslingsmetode',
	'NOTIFY_METHOD_BOTH'			=> 'Begge',
	'NOTIFY_METHOD_EMAIL'			=> 'Bare e-post',
	'NOTIFY_METHOD_EXPLAIN'			=> 'Metode for sending av meldinger via dette systemet.',
	'NOTIFY_METHOD_IM'				=> 'Bare Jabber',
	'NOTIFY_ON_PM'					=> 'Varsle meg om nye private meldinger',
	'NOT_ADDED_FRIENDS_ANONYMOUS'	=> 'Du kan ikke legge til den anonyme brukeren på vennelisten.',
	'NOT_ADDED_FRIENDS_BOTS'		=> 'Du kan ikke legge til boter på vennelisten.',
	'NOT_ADDED_FRIENDS_FOES'		=> 'Du kan ikke legge til brukere på vennelisten så lenge de er på uvennlisten.',
	'NOT_ADDED_FRIENDS_SELF'		=> 'Du kan ikke legge til deg selv på vennelisten.',
	'NOT_ADDED_FOES_MOD_ADMIN'		=> 'Du kan ikke legge til administratorer eller moderatorer på uvennlisten.',
	'NOT_ADDED_FOES_ANONYMOUS'		=> 'Du kan ikke legge til den anonyme brukeren på uvennlisten.',
	'NOT_ADDED_FOES_BOTS'			=> 'Du kan ikke legge til boter på uvennlisten.',
	'NOT_ADDED_FOES_FRIENDS'		=> 'Du kan ikke legge til brukere på uvennlisten så lenge de er på vennelisten.',
	'NOT_ADDED_FOES_SELF'			=> 'Du kan ikke legge til deg selv på uvennlisten.',
	'NOT_AGREE'						=> 'Jeg godtar ikke disse vilkårene',
	'NOT_ENOUGH_SPACE_FOLDER'		=> 'Målmappen «%s» ser ut til å være full. Den forespurte handlingen er ikke utført.',
	'NOT_MOVED_MESSAGES'			=> array(
		1	=> 'Du har %d privat melding på vent fordi mappen er full.',
		2	=> 'Du har %d private meldinger på vent fordi mappen er full.',
	),
	'NO_ACTION_MODE'				=> 'Ingen meldingshandling er angitt.',
	'NO_AUTHOR'						=> 'Ingen forfatter er angitt for denne meldingen',
	'NO_AVATAR'						=> 'Ingen avatar er valgt',
	'NO_AVATAR_CATEGORY'			=> 'Ingen',

	'NO_AUTH_DELETE_MESSAGE'		=> 'Du har ikke tillatelse til å slette private meldinger.',
	'NO_AUTH_EDIT_MESSAGE'			=> 'Du har ikke tillatelse til å redigere private meldinger.',
	'NO_AUTH_FORWARD_MESSAGE'		=> 'Du har ikke tillatelse til å videresende private meldinger.',
	'NO_AUTH_GROUP_MESSAGE'			=> 'Du har ikke tillatelse til å sende private meldinger til grupper.',
	'NO_AUTH_PASSWORD_REMINDER'		=> 'Du har ikke tillatelse til å be om nytt passord.',
	'NO_AUTH_PROFILEINFO'			=> 'Du har ikke tillatelse til å endre profilinformasjonen.',
	'NO_AUTH_READ_HOLD_MESSAGE'		=> 'Du har ikke tillatelse til å lese private meldinger som er på vent.',
	'NO_AUTH_READ_MESSAGE'			=> 'Du har ikke tillatelse til å lese private meldinger.',
	'NO_AUTH_READ_REMOVED_MESSAGE'	=> 'Du har ikke tillatelse til å lese denne meldingen fordi den ble fjernet av forfatteren.',
	'NO_AUTH_SEND_MESSAGE'			=> 'Du har ikke tillatelse til å sende private meldinger.',
	'NO_AUTH_SIGNATURE'				=> 'Du har ikke tillatelse til å definere en signatur.',

	'NO_BCC_RECIPIENT'			=> 'Ingen',
	'NO_BOOKMARKS'				=> 'Du har ingen bokmerker.',
	'NO_BOOKMARKS_SELECTED'		=> 'Du har ikke valgt noen bokmerker.',
	'NO_EDIT_READ_MESSAGE'		=> 'Privat melding kan ikke redigeres fordi den allerede er lest.',
	'NO_EMAIL_USER'				=> 'Finner ikke innsendt informasjon om e-post/brukernavn.',
	'NO_FOES'					=> 'Ingen uvenner er definert ennå',
	'NO_FRIENDS'				=> 'Ingen venner er definert ennå',
	'NO_FRIENDS_OFFLINE'		=> 'Ingen venner er offline',
	'NO_FRIENDS_ONLINE'			=> 'Ingen venner er online',
	'NO_GROUP_SELECTED'			=> 'Ingen gruppe er angitt.',
	'NO_IMPORTANT_NEWS'			=> 'Ingen viktige kunngjøringer finnes.',
	'NO_MESSAGE'				=> 'Finner ikke privat melding.',
	'NO_NEW_FOLDER_NAME'		=> 'Du må angi et nytt mappenavn.',
	'NO_NEWER_PM'				=> 'Ingen nyere meldinger.',
	'NO_OLDER_PM'				=> 'Ingen eldre meldinger.',
	'NO_PASSWORD_SUPPLIED'		=> 'Du kan ikke logge inn uten passord.',
	'NO_RECIPIENT'				=> 'Ingen mottaker er definert.',
	'NO_RULES_DEFINED'			=> 'Ingen regler er definert.',
	'NO_SAVED_DRAFTS'			=> 'Ingen kladder er lagret.',
	'NO_TO_RECIPIENT'			=> 'Ingen',
	'NO_WATCHED_FORUMS'			=> 'Du har ikke abonnert på noen fora.',
	'NO_WATCHED_SELECTED'		=> 'Du har ikke valgt noen emner eller fora du abonnerer på.',
	'NO_WATCHED_TOPICS'			=> 'Du abonnerer ikke på noen emner.',

	'PASS_TYPE_ALPHA_EXPLAIN'	=> 'Passord må ha en lengde på mellom %1$s og %2$s, må inneholde både store og små bokstaver, og må inneholde sifre.',
	'PASS_TYPE_ANY_EXPLAIN'		=> 'Må være mellom %1$s og %2$s.',
	'PASS_TYPE_CASE_EXPLAIN'	=> 'Passord må ha en lengde på mellom %1$s og %2$s, og må inneholde både store og små bokstaver.',
	'PASS_TYPE_SYMBOL_EXPLAIN'	=> 'Passord må ha en lengde på mellom %1$s og %2$s, og må inneholde både store og små bokstaver og symboler.',
	'PASSWORD'					=> 'Passord',
	'PASSWORD_ACTIVATED'		=> 'Det nye passordet ditt er aktivert.',
	'PASSWORD_UPDATED'			=> 'Et nytt passord er sendt til den registrerte e-postadressen.',
	'PERMISSIONS_RESTORED'		=> 'De opprinnelige tillatelsene er gjenopprettet.',
	'PERMISSIONS_TRANSFERRED'	=> 'Tillatelser er overført fra <strong>%s</strong>. Du kan nå bruke systemet med denne brukerens tillatelser.<br />Merk at administrasjonstillatelser ikke ble overført. Du kan når som helst gå tilbake til ditt eget sett med tillatelser.',
	'PM_DISABLED'				=> 'Privatemeldinger er deaktivert på dette systemet.',
	'PM_FROM'					=> 'Fra',
	'PM_FROM_REMOVED_AUTHOR'	=> 'Denne meldingen ble sendt av en bruker som ikke lenger er registrert.',
	'PM_ICON'					=> 'PM-ion',
	'PM_INBOX'					=> 'Innboks',
	'PM_MARK_ALL_READ'			=> 'Merk alle meldinger som lest',
	'PM_MARK_ALL_READ_SUCCESS'	=> 'Alle private meldinger i denne mappen er merket som lest',
	'PM_NO_USERS'				=> 'Brukerne som ble forespurt lagt til, finnes ikke.',
	'PM_OUTBOX'					=> 'Utboks',
	'PM_SENTBOX'				=> 'Sendte meldinger',
	'PM_SUBJECT'				=> 'Meldingsemne',
	'PM_TO'						=> 'Send til',
	'PM_TOOLS'					=> 'Meldingsverktøy',
	'PM_USERS_REMOVED_NO_PERMISSION'	=> 'Enkelte brukere kunne ikke legges til ettersom de ikke har tillatelse til å lese private meldinger.',
	'PM_USERS_REMOVED_NO_PM'	=> 'Enkelte brukere kunne ikke legges til ettersom de har deaktivert mottak av private meldinger.',
	'POST_EDIT_PM'				=> 'Rediger melding',
	'POST_FORWARD_PM'			=> 'Videresend melding',
	'POST_NEW_PM'				=> 'Skriv ny melding',
	'POST_PM_LOCKED'			=> 'Private meldinger er låst.',
	'POST_PM_POST'				=> 'Siter innlegg',
	'POST_QUOTE_PM'				=> 'Siter melding',
	'POST_REPLY_PM'				=> 'Svar på melding',
	'PRINT_PM'					=> 'Utskriftsvisning',
	'PREFERENCES_UPDATED'		=> 'Preferansene er oppdatert.',
	'PROFILE_INFO_NOTICE'		=> 'Merk at denne informasjonen kan vises av andre brukere. Vær forsiktig når du inkluderer personlige detaljer. Alle felt merket med * er obligatoriske.',
	'PROFILE_UPDATED'			=> 'Profilen er oppdatert.',
	'PROFILE_AUTOLOGIN_KEYS'	=> '«Husk meg»-innloggingsnøklene logger deg inn automatisk når du besøker systemet. Hvis du logger ut, slettes innloggingsnøkkelen bare på den datamaskinen du logger ut fra. Her kan du se «Husk meg»-innloggingsnøkler som er opprettet på andre datamaskiner du har brukt dette systemet fra.',
	'PROFILE_NO_AUTOLOGIN_KEYS'	=> 'Det finnes ingen lagrede «Husk meg»-innloggingsnøkler.',

	'RECIPIENT'							=> 'Mottaker',
	'RECIPIENTS'						=> 'Mottakere',
	'REGISTRATION'						=> 'Registrering',
	'RELEASE_MESSAGES'					=> '%sFrigi alle meldinger på vent%s… De vil bli plassert i de aktuelle mappene hvis det er nok ledig plass.',
	'REMOVE_ADDRESS'					=> 'Fjern adresse',
	'REMOVE_SELECTED_BOOKMARKS'			=> 'Fjern valgte bokmerker',
	'REMOVE_SELECTED_BOOKMARKS_CONFIRM'	=> 'Er du sikker på at du vil slette alle de valgte bokmerkene?',
	'REMOVE_BOOKMARK_MARKED'			=> 'Fjern merkede bokmerker',
	'REMOVE_FOLDER'						=> 'Fjern mappe',
	'REMOVE_FOLDER_CONFIRM'				=> 'Er du sikker på at du vil fjerne denne mappen?',
	'RENAME'							=> 'Endre navn',
	'RENAME_FOLDER'						=> 'Endre navn på mappe',
	'REPLIED_MESSAGE'					=> 'Svarte på melding',
	'REPLY_TO_ALL'						=> 'Svar til avsender og alle mottakere.',
	'REPORT_PM'							=> 'Rapporter privat melding',
	'RESIGN_SELECTED'					=> 'Trekk deg fra valgte',
	'RETURN_FOLDER'						=> '%1$sGå tilbake til forrige mappe%2$s',
	'RETURN_UCP'						=> '%sGå tilbake til brukerkontrollpanelet%s',
	'RULE_ADDED'						=> 'Regelen er lagt til.',
	'RULE_ALREADY_DEFINED'				=> 'Denne regelen er allerede definert.',
	'RULE_DELETED'						=> 'Regelen er fjernet.',
	'RULE_LIMIT_REACHED'				=> 'Du kan ikke legge til flere PM-regler. Du har nådd det maksimale antallet regler.',
	'RULE_NOT_DEFINED'					=> 'Regelen er ikke angitt på riktig måte.',
	'RULE_REMOVED_MESSAGES'				=> array(
		1	=> '%d privat melding ble fjernet på grunn av privatmeldingsfiltre.',
		2	=> '%d private meldinger ble fjernet på grunn av privatmeldingsfiltre.',
	),

	'SAME_PASSWORD_ERROR'		=> 'Det nye passordet du angav, er det samme som gjeldende passord.',
	'SEARCH_YOUR_POSTS'			=> 'Vis innleggene dine',
	'SEND_PASSWORD'				=> 'Send passord',
	'SENT_AT'					=> 'Sendt',			// Used before dates in private messages
	'SHOW_EMAIL'				=> 'Brukere kan kontakte meg per e-post',
	'SIGNATURE_EXPLAIN'			=> 'Dette er en tekstblokk som kan legges til i innleggene dine. Det er en grense på %d tegn.',
	'SIGNATURE_PREVIEW'			=> 'Signaturen vises som dette i innlegg',
	'SIGNATURE_TOO_LONG'		=> 'Signaturen er for lang.',
	'SELECT_CURRENT_TIME'		=> 'Velg gjeldende klokkeslett',
	'SELECT_TIMEZONE'			=> 'Velg tidssone',
	'SORT'						=> 'Sorter',
	'SORT_COMMENT'				=> 'Filkommentar',
	'SORT_DOWNLOADS'			=> 'Nedlastinger',
	'SORT_EXTENSION'			=> 'Filetternavn',
	'SORT_FILENAME'				=> 'Filnavn',
	'SORT_POST_TIME'			=> 'Innleggsklokkeslett',
	'SORT_SIZE'					=> 'Filstørrelse',

	'TIMEZONE'					=> 'Tidssone',
	'TIMEZONE_DATE_SUGGESTION'	=> 'Forslag: %s',
	'TIMEZONE_INVALID'			=> 'Tidssonen du valgte, er ugyldig.',
	'TO'						=> 'Mottaker',
	'TO_MASS'					=> 'Mottakere',
	'TO_ADD'					=> 'Legg til mottaker',
	'TO_ADD_MASS'				=> 'Legg til mottakere',
	'TO_ADD_GROUPS'				=> 'Legg til grupper',
	'TOO_MANY_RECIPIENTS'		=> 'Du prøvde å sende en privat melding til for mange mottakere.',
	'TOO_MANY_REGISTERS'		=> 'Du har overskredet det maksimale antallet registreringsforsøk for denne økten. Prøv igjen senere.',

	'UCP'						=> 'Brukerkontrollpanel',
	'UCP_ACTIVATE'				=> 'Aktiver konto',
	'UCP_ADMIN_ACTIVATE'		=> 'Merk at du vil måtte angi en gyldig e-postadresse før kontoen blir aktivert. Administratoren vil kontrollere kontoen, og hvis den godkjennes, mottar du en e-post på den angitte adressen.',
	'UCP_ATTACHMENTS'			=> 'Vedlegg',
	'UCP_AUTH_LINK'				=> 'Eksterne kontoer',
	'UCP_AUTH_LINK_ASK'			=> 'Du har for øyeblikket ingen konto tilknyttet denne eksterne tjenesten. Klikk på knappen nedenfor for å knytte forumkontoen til en konto hos denne eksterne tjenesten.',
	'UCP_AUTH_LINK_ID'			=> 'Unik identifikator',
	'UCP_AUTH_LINK_LINK'		=> 'Tilknytt',
	'UCP_AUTH_LINK_MANAGE'		=> 'Administrer tilknytninger til eksterne kontoer',
	'UCP_AUTH_LINK_NOT_SUPPORTED'	=> 'Tilknytting av forumkontoer til eksterne tjenester støttes ikke av autentiseringsmetoden som for tiden brukes på dette systemet.',
	'UCP_AUTH_LINK_TITLE'		=> 'Administrer dine tilknytninger til eksterne kontoer',
	'UCP_AUTH_LINK_UNLINK'		=> 'Fjern tilknytning',
	'UCP_COPPA_BEFORE'			=> 'Før %s',
	'UCP_COPPA_ON_AFTER'		=> 'På eller etter %s',
	'UCP_EMAIL_ACTIVATE'		=> 'Merk at du vil måtte angi en gyldig e-postadresse før kontoen blir aktivert. Du vil motta en e-post som inneholder en kontoaktiveringslenke, på adressen du angav.',
	'UCP_JABBER'				=> 'Jabber-adresse',
	'UCP_LOGIN_LINK'			=> 'Konfigurer tilknytning av en ekstern konto',

	'UCP_MAIN'					=> 'Oversikt',
	'UCP_MAIN_ATTACHMENTS'		=> 'Administrer vedlegg',
	'UCP_MAIN_BOOKMARKS'		=> 'Administrer bokmerker',
	'UCP_MAIN_DRAFTS'			=> 'Administrer kladder',
	'UCP_MAIN_FRONT'			=> 'Forside',
	'UCP_MAIN_SUBSCRIBED'		=> 'Administrer abonnementer',

	'UCP_NO_ATTACHMENTS'		=> 'Du har ikke lagt inn noen filer.',

	'UCP_NOTIFICATION_LIST'				=> 'Administrer varslinger',
	'UCP_NOTIFICATION_LIST_EXPLAIN'		=> 'Her kan du vise alle tidligere varslinger.',
	'UCP_NOTIFICATION_OPTIONS'			=> 'Rediger varslingsalternativer',
	'UCP_NOTIFICATION_OPTIONS_EXPLAIN'	=> 'Her kan du angi de foretrukne varslingsmetodene for systemet.',

	'UCP_PREFS'					=> 'Systempreferanser',
	'UCP_PREFS_PERSONAL'		=> 'Rediger globale innstillinger',
	'UCP_PREFS_POST'			=> 'Rediger innleggsstandarder',
	'UCP_PREFS_VIEW'			=> 'Rediger visningsalternativer',

	'UCP_PM'					=> 'Private meldinger',
	'UCP_PM_COMPOSE'			=> 'Skriv ny melding',
	'UCP_PM_DRAFTS'				=> 'Administrer PM-kladder',
	'UCP_PM_OPTIONS'			=> 'Regler, mapper og innstillinger',
	'UCP_PM_UNREAD'				=> 'Uleste meldinger',
	'UCP_PM_VIEW'				=> 'Vis meldinger',

	'UCP_PROFILE'				=> 'Profil',
	'UCP_PROFILE_AVATAR'		=> 'Rediger avatar',
	'UCP_PROFILE_PROFILE_INFO'	=> 'Rediger profil',
	'UCP_PROFILE_REG_DETAILS'	=> 'Rediger kontoinnstillinger',
	'UCP_PROFILE_SIGNATURE'		=> 'Rediger signatur',
	'UCP_PROFILE_AUTOLOGIN_KEYS'=> 'Administrer «Husk meg»-innloggingsnøkler',

	'UCP_USERGROUPS'			=> 'Brukergrupper',
	'UCP_USERGROUPS_MEMBER'		=> 'Rediger medlemskap',
	'UCP_USERGROUPS_MANAGE'		=> 'Administrer grupper',

	'UCP_PASSWORD_RESET_DISABLED'	=> 'Funksjonen for tilbakestilling av passord er deaktivert. Hvis du trenger hjelp til å få tilgang til kontoen, kontakter du %ssystemadministratoren%s',
	'UCP_REGISTER_DISABLE'			=> 'Det er ikke mulig å opprette en ny konto nå.',
	'UCP_REMIND'					=> 'Send passord',
	'UCP_RESEND'					=> 'Send aktiverings-e-post',
	'UCP_WELCOME'					=> 'Velkommen til brukerkontrollpanelet. Herfra kan du overvåke, vise og oppdatere profilen din, preferanser og fora og emner du abonnerer på. Du kan også sende meldinger til andre brukere (hvis det tillates). Sørg for å lese alle kunngjøringer før du fortsetter.',
	'UCP_ZEBRA'						=> 'Venner og uvenner',
	'UCP_ZEBRA_FOES'				=> 'Administrer uvenner',
	'UCP_ZEBRA_FRIENDS'				=> 'Administrer venner',
	'UNDISCLOSED_RECIPIENT'			=> 'Skjult mottaker',
	'UNKNOWN_FOLDER'				=> 'Ukjent mappe',
	'UNWATCH_MARKED'				=> 'Stopp abonnement på merkede',
	'UPLOAD_AVATAR_FILE'			=> 'Last opp fra datamaskinen',
	'UPLOAD_AVATAR_URL'				=> 'Last opp fra en URL',
	'UPLOAD_AVATAR_URL_EXPLAIN'		=> 'Angi URL-en til bildet. Bildet vil bli kopiert til dette systemet.',
	'USERNAME_ALPHA_ONLY_EXPLAIN'	=> 'Brukernavnet må ha en lengde på mellom %1$s og %2$s, og kan bare inneholde alfanumeriske tegn.',
	'USERNAME_ALPHA_SPACERS_EXPLAIN'=> 'Brukernavnet må ha en lengde på mellom %1$s og %2$s, og kan bare inneholde alfanumeriske tegn, mellomrom og -+_[].',
	'USERNAME_ASCII_EXPLAIN'		=> 'Brukernavnet må ha en lengde på mellom %1$s og %2$s, og kan bare inneholde ASCII-tagn, altså ingen spesialtegn.',
	'USERNAME_LETTER_NUM_EXPLAIN'	=> 'Brukernavnet må ha en lengde på mellom %1$s og %2$s, og kan bare inneholde bokstaver og sifre.',
	'USERNAME_LETTER_NUM_SPACERS_EXPLAIN'=> 'Brukernavnet må ha en lengde på mellom %1$s og %2$s, og kan bare inneholde bokstaver, sifre, mellomrom eller -+_[].',
	'USERNAME_CHARS_ANY_EXPLAIN'	=> 'Lengden må være på mellom %1$s og %2$s.',
	'USERNAME_TAKEN_USERNAME'		=> 'Brukernavnet du angav, er allerede i bruk. Velg et annet navn.',
	'USERNAME_DISALLOWED_USERNAME'	=> 'Brukernavnet du angav, tillates ikke eller inneholder et ord som ikke tillates. Velg et annet navn.',
	'USER_NOT_FOUND_OR_INACTIVE'	=> 'Brukernavnet du angav, finnes enten ikke, eller så er det ikke en aktivert bruker.',

	'VIEW_AVATARS'				=> 'Vis avatarer',
	'VIEW_EDIT'					=> 'Vis/rediger',
	'VIEW_FLASH'				=> 'Vis Flash-animasjoner',
	'VIEW_IMAGES'				=> 'Vis bilder i innlegg',
	'VIEW_NEXT_HISTORY'			=> 'Neste PM i historikken',
	'VIEW_NEXT_PM'				=> 'Neste PM',
	'VIEW_PM'					=> 'Vis melding',
	'VIEW_PM_INFO'				=> 'Meldingsdetaljer',
	'VIEW_PM_MESSAGES'			=> array(
		1	=> '%d melding',
		2	=> '%d meldinger',
	),
	'VIEW_PREVIOUS_HISTORY'		=> 'Forrige PM i historikken',
	'VIEW_PREVIOUS_PM'			=> 'Forrige PM',
	'VIEW_PROFILE'				=> 'Vis profil',
	'VIEW_SIGS'					=> 'Vis signaturer',
	'VIEW_SMILIES'				=> 'Vis smilefjes som bilder',
	'VIEW_TOPICS_DAYS'			=> 'Vis emner fra tidligere dager',
	'VIEW_TOPICS_DIR'			=> 'Vis retning på emnerekkefølge',
	'VIEW_TOPICS_KEY'			=> 'Vis sorteringsnøkkel for emner',
	'VIEW_POSTS_DAYS'			=> 'Vis innlegg fra tidligere dager',
	'VIEW_POSTS_DIR'			=> 'Vis retning på innleggsrekkefølge',
	'VIEW_POSTS_KEY'			=> 'Vis sorteringsnøkkel for innlegg',

	'WATCHED_EXPLAIN'			=> 'Nedenfor finner du en liste over fora og emner du abonnerer på. Du vil bli varslet om nye innlegg i begge kategorier. Hvis du vil stoppe abonnementet, merker du forumet eller emnet og klikker  <em>Stopp abonnement på merkede</em>.',
	'WATCHED_FORUMS'			=> 'Fora du abonnerer på',
	'WATCHED_TOPICS'			=> 'Emner du abonnerer på',
	'WRONG_ACTIVATION'			=> 'Aktiveringsnøkkelen du angav, samsvarer ikke med noen i databasen.',

	'YOUR_DETAILS'				=> 'Aktiviteten din',
	'YOUR_FOES'					=> 'Uvennene dine',
	'YOUR_FOES_EXPLAIN'			=> 'Du kan fjerne brukernavn ved å velge dem og klikke Send.',
	'YOUR_FRIENDS'				=> 'Vennene dine',
	'YOUR_FRIENDS_EXPLAIN'		=> 'Du kan fjerne brukernavn ved å velge dem og klikke Send.',
	'YOUR_WARNINGS'				=> 'Advarselsnivået ditt',

	'PM_ACTION' => array(
		'PLACE_INTO_FOLDER'	=> 'Plasser i mappe',
		'MARK_AS_READ'		=> 'Merk som lest',
		'MARK_AS_IMPORTANT'	=> 'Merk melding',
		'DELETE_MESSAGE'	=> 'Slett melding',
	),
	'PM_CHECK' => array(
		'SUBJECT'	=> 'Emne',
		'SENDER'	=> 'Avsender',
		'MESSAGE'	=> 'Melding',
		'STATUS'	=> 'Meldingsstatus',
		'TO'		=> 'Sendt til',
	),
	'PM_RULE' => array(
		'IS_LIKE'		=> 'er lik',
		'IS_NOT_LIKE'	=> 'er ikke lik',
		'IS'			=> 'er',
		'IS_NOT'		=> 'er ikke',
		'BEGINS_WITH'	=> 'begynner på',
		'ENDS_WITH'		=> 'slutter på',
		'IS_FRIEND'		=> 'er en venn',
		'IS_FOE'		=> 'er en uvenn',
		'IS_USER'		=> 'er en bruker',
		'IS_GROUP'		=> 'er i en brukergruppe',
		'ANSWERED'		=> 'besvart',
		'FORWARDED'		=> 'videresendt',
		'TO_GROUP'		=> 'til min standardbrukergruppe',
		'TO_ME'			=> 'til meg',
	),

	'GROUPS_EXPLAIN'	=> 'Brukergrupper setter systemadministratorer i stand til å administrere brukere på en enklere måte. Som standard vil du bli plassert i en bestemt gruppe, dette er standardgruppen din. Denne gruppen definerer hvordan du vises for andre brukere, for eksempel fargelegging av brukernavn, avatar, grad osv. Avhengig av om administratoren tillater det, kan det hende du kan endre standardgruppe. Du kan også bli plassert i, eller tillatt å bli med i, andre grupper. Enkelte grupper kan gi deg tilgang til å vise mer innhold eller øke mulighetene dine på andre områder.',
	'GROUP_LEADER'		=> 'Lederskap',
	'GROUP_MEMBER'		=> 'Medlemskap',
	'GROUP_PENDING'		=> 'Ventende medlemskap',
	'GROUP_NONMEMBER'	=> 'Ikke-medlemskap',
	'GROUP_DETAILS'		=> 'Gruppedetaljer',

	'NO_LEADER'		=> 'Intet gruppelederskap',
	'NO_MEMBER'		=> 'Intet gruppemedlemskap',
	'NO_PENDING'	=> 'Intet ventende medlemskap',
	'NO_NONMEMBER'	=> 'Ingen ikke-medlemsgrupper',
));
