with Standard_Floating_Numbers;          use Standard_Floating_Numbers;

package Fast_Double_Renormalizations is

-- DESCRIPTION :
--   The fast renormalization procedures are defined 
--   with generated code from the CAMPARY library, posted 01.06.17,
--   and based on QD-2.3.9.

  procedure fast_renorm
              ( x0,x1,x2,x3 : in double_float;
                r0,r1,r2 : out double_float );

  -- DESCRIPTION :
  --   The definition is based on the fast_renorm2L<4,3>,
  --   from code of the specRenorm.h, generated by the CAMPARY library,
  --   in an unrolled form (Valentina Popescu, Mioara Joldes), with
  --   double double basics of QD-2.3.9 (Y. Hida, X.S. Li, and D.H. Bailey).

  -- ON ENTRY :
  --   x0       most significant word;
  --   x1       second most significant word;
  --   x2       third most significant word;
  --   x3       least significant word.

  -- ON RETURN :
  --   r0       highest part of a triple double number;
  --   r1       middle part of a triple double number;
  --   r2       lowest part of a triple double number.

  procedure renorm_add1
              ( x0,x1,x2 : in double_float; y : in double_float;
                r0,r1,r2 : out double_float );

  -- DESCRIPTION :
  --   The definition is based on renorm2L_4Add1<3,3>
  --   from code of the specRenorm.h, generated by the CAMPARY library,
  --   in an unrolled form (Valentina Popescu, Mioara Joldes), with
  --   double double basics of QD-2.3.9 (Y. Hida, X.S. Li, and D.H. Bailey).

  -- ON ENTRY :
  --   x0       most significant word of a triple number x;
  --   x1       second most significant word of a triple number x;
  --   x2       third most significant word of a triple number x;
  --   y        double to be added to x.

  -- ON RETURN :
  --   r0       most significant word of x + y;
  --   r1       second most significant word of x + y;
  --   r2       least significant word of x + y.

  procedure renorm5
              ( f0,f1,f2,f3,f4,f5 : in double_float;
                pr : in out double_float;
                r0,r1,r2,r3,r4 : out double_float );

  -- DESCRIPTION :
  --   Definitions common to fast_renorm2L<6,5> and renorm2L_4Add1<5,5>
  --   from code of the specRenorm.h, generated by the CAMPARY library,
  --   in an unrolled form (Valentina Popescu, Mioara Joldes), with
  --   double double basics of QD-2.3.9 (Y. Hida, X.S. Li, and D.H. Bailey).

  -- ON ENTRY :
  --   f0       most significant word;
  --   f1       second most significant word;
  --   f2       third most significant word;
  --   f3       fourth most significant word;
  --   f4       fifth most significant word;
  --   f5       sixth most significant word;
  --   pr       computed by the start of the renormalization.

  -- ON RETURN :
  --   pr       updated value by renormalization;
  --   r0       highest part of a penta double number;
  --   r1       second highest part of a penta double number;
  --   r2       middle part of a penta double number.
  --   r3       second lowest part of a penta double number;
  --   r4       lowest part of a penta double number.

  procedure fast_renorm
              ( x0,x1,x2,x3,x4,x5 : in double_float;
                r0,r1,r2,r3,r4 : out double_float );

  -- DESCRIPTION :
  --   The definition is based on the fast_renorm2L<6,5>,
  --   from code of the specRenorm.h, generated by the CAMPARY library,
  --   in an unrolled form (Valentina Popescu, Mioara Joldes), with
  --   double double basics of QD-2.3.9 (Y. Hida, X.S. Li, and D.H. Bailey).

  -- ON ENTRY :
  --   x0       most significant word;
  --   x1       second most significant word;
  --   x2       third most significant word;
  --   x3       fourth most significant word;
  --   x4       fifth most significant word;
  --   x5       least significant word.

  -- ON RETURN :
  --   r0       highest part of a penta double number;
  --   r1       second highest part of a penta double number;
  --   r2       middle part of a penta double number.
  --   r3       second lowest part of a penta double number;
  --   r4       lowest part of a penta double number.

  procedure renorm_add1
              ( x0,x1,x2,x3,x4 : in double_float;
                y : in double_float;
                r0,r1,r2,r3,r4 : out double_float );

  -- DESCRIPTION :
  --   The definition is based on the renorm2L_4Add1<5,5>,
  --   from code of the specRenorm.h, generated by the CAMPARY library,
  --   in an unrolled form (Valentina Popescu, Mioara Joldes), with
  --   double double basics of QD-2.3.9 (Y. Hida, X.S. Li, and D.H. Bailey).

  -- ON ENTRY :
  --   x0       most significant word of a penta double x;
  --   x1       second most significant word of a penta double x;
  --   x2       third most significant word of a penta double x;
  --   x3       fourth most significant word of a penta double x;
  --   x4       least significant word of a penta double x;
  --   y        double to be added to x.

  -- ON RETURN :
  --   r0       highest part of x + y;
  --   r1       second highest part of x + y;
  --   r2       middle part of x + y;
  --   r3       second lowest part of x + y;
  --   r4       lowest part of x + y.

  procedure renorm8
              ( f0,f1,f2,f3,f4,f5,f6,f7,f8 : in double_float;
                pr : in out double_float;
                r0,r1,r2,r3,r4,r5,r6,r7 : out double_float );

  -- DESCRIPTION :
  --   Definitions common to fast_renorm2L<9,8> and renorm2L_4Add1<8,8>
  --   from code of the specRenorm.h, generated by the CAMPARY library,
  --   in an unrolled form (Valentina Popescu, Mioara Joldes), with
  --   double double basics of QD-2.3.9 (Y. Hida, X.S. Li, and D.H. Bailey).

  -- ON ENTRY :
  --   x0       most significant word;
  --   x1       second most significant word;
  --   x2       third most significant word;
  --   x3       fourth most significant word;
  --   x4       fifth most significant word;
  --   x5       sixth most significant word;
  --   x6       seventh most significant word;
  --   x7       eighth most significant word;
  --   x8       least significant word;
  --   pr       computed by the start of the renormalization.

  -- ON RETURN :
  --   pr       updated value by renormalization;
  --   r0       highest part of an octo double number;
  --   r1       second highest part of an octo double number;
  --   r2       third highest part of an octo double number.
  --   r3       fourth highest part of an octo double number;
  --   r4       fourth lowest part of an octo double number;
  --   r5       third lowest part of an octo double number;
  --   r6       second lowest part of an octo double number;
  --   r7       lowest part of an octo double number.

  procedure fast_renorm
              ( x0,x1,x2,x3,x4,x5,x6,x7,x8 : in double_float;
                r0,r1,r2,r3,r4,r5,r6,r7 : out double_float );

  -- DESCRIPTION :
  --   The definition is based on the fast_renorm2L<9,8>,
  --   from code of the specRenorm.h, generated by the CAMPARY library,
  --   in an unrolled form (Valentina Popescu, Mioara Joldes), with
  --   double double basics of QD-2.3.9 (Y. Hida, X.S. Li, and D.H. Bailey).

  -- ON ENTRY :
  --   x0       most significant word;
  --   x1       second most significant word;
  --   x2       third most significant word;
  --   x3       fourth most significant word;
  --   x4       fifth most significant word;
  --   x5       sixth most significant word;
  --   x6       seventh most significant word;
  --   x7       eighth most significant word;
  --   x8       least significant word.

  -- ON RETURN :
  --   r0       highest part of an octo double number;
  --   r1       second highest part of an octo double number;
  --   r2       third highest part of an octo double number.
  --   r3       fourth highest part of an octo double number;
  --   r4       fourth lowest part of an octo double number;
  --   r5       third lowest part of an octo double number;
  --   r6       second lowest part of an octo double number;
  --   r7       lowest part of an octo double number.

  procedure renorm_add1
              ( x0,x1,x2,x3,x4,x5,x6,x7 : in double_float;
                y : in double_float;
                r0,r1,r2,r3,r4,r5,r6,r7 : out double_float );

  -- DESCRIPTION :
  --   The definition is based on renorm2L_4Add1<8,8>
  --   from code of the specRenorm.h, generated by the CAMPARY library,
  --   in an unrolled form (Valentina Popescu, Mioara Joldes), with
  --   double double basics of QD-2.3.9 (Y. Hida, X.S. Li, and D.H. Bailey).

  -- ON ENTRY :
  --   x0       most significant word of an octo double x;
  --   x1       second most significant word of an octo double x;
  --   x2       third most significant word of an octo double x;
  --   x3       fourth most significant word of an octo double x;
  --   x4       fourth least significant word of an octo double x;
  --   x5       third least significant word of an octo double x;
  --   x6       second least significant word of an octo double x;
  --   x7       least significant word of an octo double x;
  --   y        double to be added to x.

  -- ON RETURN :
  --   r0       most significant word of x + y;
  --   r1       second most significant word of x + y;
  --   r2       third most significant word of x + y;
  --   r3       fourth most significant word of x + y;
  --   r4       fourth least significant word of x + y;
  --   r5       third least significant word of x + y;
  --   r6       second least significant word of x + y;
  --   r7       least significant word of x + y.

  procedure renorm10
              ( f0,f1,f2,f3,f4,f5,f6,f7,f8,f9,f10 : in double_float;
                pr : in out double_float;
                r0,r1,r2,r3,r4,r5,r6,r7,r8,r9 : out double_float );

  -- DESCRIPTION :
  --   Definitions common to fast_renorm2L<11,10> and renorm2L_4Add1<10,10>
  --   from code of the specRenorm.h, generated by the CAMPARY library,
  --   in an unrolled form (Valentina Popescu, Mioara Joldes), with
  --   double double basics of QD-2.3.9 (Y. Hida, X.S. Li, and D.H. Bailey).

  -- ON ENTRY :
  --   x0       most significant word;
  --   x1       second most significant word;
  --   x2       third most significant word;
  --   x3       fourth most significant word;
  --   x4       fifth most significant word;
  --   x5       sixth most significant word;
  --   x6       seventh most significant word;
  --   x7       eighth most significant word;
  --   x8       nineth most significant word;
  --   x9       tenth most significant word;
  --   x10      least significant word;
  --   pr       computed by the start of the renormalization.

  -- ON RETURN :
  --   pr       updated value by renormalization;
  --   r0       highest part of a deca double number;
  --   r1       second highest part of a deca double number;
  --   r2       third highest part of a deca double number.
  --   r3       fourth highest part of a deca double number;
  --   r4       fifth highest part of a deca double number;
  --   r5       fifth lowest part of a deca double number;
  --   r6       fourth lowest part of a deca double number;
  --   r7       third lowest part of a deca double number;
  --   r8       second lowest part of a deca double number;
  --   r9       lowest part of a deca double number.

  procedure fast_renorm
              ( x0,x1,x2,x3,x4,x5,x6,x7,x8,x9,x10 : in double_float;
                r0,r1,r2,r3,r4,r5,r6,r7,r8,r9 : out double_float );

  -- DESCRIPTION :
  --   The definition is based on the fast_renorm2L<11,10>,
  --   from code of the specRenorm.h, generated by the CAMPARY library,
  --   in an unrolled form (Valentina Popescu, Mioara Joldes), with
  --   double double basics of QD-2.3.9 (Y. Hida, X.S. Li, and D.H. Bailey).

  -- ON ENTRY :
  --   x0       most significant word;
  --   x1       second most significant word;
  --   x2       third most significant word;
  --   x3       fourth most significant word;
  --   x4       fifth most significant word;
  --   x5       sixth most significant word;
  --   x6       seventh most significant word;
  --   x7       eighth most significant word;
  --   x8       nineth most significant word;
  --   x9       tenth most significant word;
  --   x10      least significant word.

  -- ON RETURN :
  --   r0       highest part of a deca double number;
  --   r1       second highest part of a deca double number;
  --   r2       third highest part of a deca double number.
  --   r3       fourth highest part of a deca double number;
  --   r4       fifth highest part of a deca double number;
  --   r5       fifth lowest part of a deca double number;
  --   r6       fourth lowest part of a deca double number;
  --   r7       third lowest part of a deca double number;
  --   r8       second lowest part of a deca double number;
  --   r9       lowest part of a deca double number.

  procedure renorm_add1
              ( x0,x1,x2,x3,x4,x5,x6,x7,x8,x9 : in double_float;
                y : in double_float;
                r0,r1,r2,r3,r4,r5,r6,r7,r8,r9 : out double_float );

  -- DESCRIPTION :
  --   The definition is based on renorm2L_4Add1<10,10>
  --   from code of the specRenorm.h, generated by the CAMPARY library,
  --   in an unrolled form (Valentina Popescu, Mioara Joldes), with
  --   double double basics of QD-2.3.9 (Y. Hida, X.S. Li, and D.H. Bailey).

  -- ON ENTRY :
  --   x0       most significant word of a deca double x;
  --   x1       second most significant word of a deca double x;
  --   x2       third most significant word of a deca double x;
  --   x3       fourth most significant word of a deca double x;
  --   x4       fifth most significant word of a deca double x;
  --   x5       fifth least significant word of a deca double x;
  --   x6       fourth least significant word of a deca double x;
  --   x7       third least significant word of a deca double x;
  --   x8       second least significant word of a deca double x;
  --   x9       least significant word of a deca double x;
  --   y        double to be added to x.

  -- ON RETURN :
  --   r0       most significant word of x + y;
  --   r1       second most significant word of x + y;
  --   r2       third most significant word of x + y;
  --   r3       fourth most significant word of x + y;
  --   r4       fifth most significant word of x + y;
  --   r5       fifth least significant word of x + y;
  --   r6       fourth least significant word of x + y;
  --   r7       third least significant word of x + y;
  --   r8       second least significant word of x + y;
  --   r9       least significant word of x + y.

end Fast_Double_Renormalizations;
