## Acknowledgements

### Contributors

PC-BASIC would not exist without those contributing code, reporting bugs,
sending in patches, and documenting GW-BASIC's behaviour. Thank you all!

Development is led by

- **Rob Hagemans**

Bug fixes and guidance by

- **Wengier Wu**
- **Jan Bredenbeek**
- **WJB**
- **Rutger van Bergen**
- **Daniel Santana**

Avid testers and bug hunters

- **Ronald Herrera**
- **Kenneth Wayne Boyd**
- **Nauman Umer**
- **Steve Pagliarulo**
- **Miguel Dorta**
- **Patrik**
- **Duane**
- **Justin R. Miller**


### Shoulders of Giants

PC-BASIC incorporates code derived from other projects, in particular:

  * **Marcus von Appen**'s [PySDL2](https://pysdl2.readthedocs.org/en/latest/)
  * **Jonathan Hartley**'s [colorama](https://github.com/tartley/colorama)
  * **Valentin Lab**'s [win_subprocess.py](https://gist.github.com/vaab/2ad7051fc193167f15f85ef573e54eb9)

PC-BASIC depends on the following open-source projects:

  * [Python](http://www.python.org)
  * [Setuptools](https://pypi.python.org/pypi/setuptools)
  * [Simple DirectMedia Layer (SDL)](http://www.libsdl.org)
  * [SDL2_gfx](http://www.ferzkopp.net/wordpress/2016/01/02/sdl_gfx-sdl2_gfx/)
  * [PySerial](https://github.com/pyserial/pyserial)
  * [PyParallel](https://github.com/pyserial/pyparallel)
  * [PyAudio](http://people.csail.mit.edu/hubert/pyaudio/)


### Fond memories

PC-BASIC would not have been what it is without the following open-source projects
which it has depended on in the past:

  * **Tom Rothamel**'s [PyGame Subset for Android](https://web.archive.org/web/20150712040220/http://pygame.renpy.org/) (superseded by [RAPT](http://www.renpy.org/doc/html/android.html))
  * **J-L Morel**'s [Win32::Console::ANSI](http://search.cpan.org/~jlmorel/Win32-Console-ANSI-1.11/lib/Win32/Console/ANSI.pm)
  * [Python for Windows Extensions (PyWin32)](https://sourceforge.net/projects/pywin32/)
  * [PExpect](http://pexpect.readthedocs.org/en/latest/)
  * [PyGame](http://www.pygame.org)
  * [NumPy](http://www.numpy.org)


### Technical Documentation

Building PC-BASIC would have been impossible without the immense amounts of
technical documentation that has been made available online. It has proven not
to be feasible to compile a complete list of the documentation used. Many
thanks to all those who make technical information freely available, and
apologies to those whose contribution I have failed to acknowledge here.

##### GW-BASIC tokenised file format

  * **Norman De Forest**'s seminal [documentation of GW-BASIC tokens](http://www.chebucto.ns.ca/~af380/GW-BASIC-tokens.html).
    _This documentation was the starting point for the development of PC-BASIC._
  * **Dan Vanderkam**'s [online GW-BASIC decoder](http://www.danvk.org/wp/2008-02-03/reading-old-gw-basic-programs/)

##### GW-BASIC protected file format

  * **Paul Kocher**, _The Cryptogram computer supplement_ **19**, American Cryptogram Association, Summer 1994

##### Technical information on many topics

  * [VOGONS](http://www.vogons.org/)
  * **Erik S. Klein**'s [vintage computer forums](http://www.vintage-computer.com)
  * **John Elliott**'s [Vintage PC pages](http://www.seasip.info/VintagePC/)
  * **Peter Berg**'s [Pete's QBasic/QuickBasic site](http://www.petesqbsite.com/)
  * **Vernon Brooks**'s [PC-DOS retro](https://sites.google.com/site/pcdosretro/)

##### Video hardware

  * **Dan Rollins**' [TechHelp](http://webpages.charter.net/danrollins/techhelp/0089.HTM) pages on PC video memory layout
  * **Great Hierophant**'s [Nerdly Pleasures Blog](http://nerdlypleasures.blogspot.com)

##### Microsoft Binary Format

  * Forum contributions by **[Julian Brucknall](http://www.boyet.com/Articles/MBFSinglePrecision.html)** and **[Adam Burgoyne](http://www.experts-exchange.com/Programming/Languages/Pascal/Delphi/Q_20245266.html)**

##### Data cassette format

  * **Mike Brutman**'s [Analysis of the IBM PC data cassette format](http://www.brutman.com/Cassette_Waveforms/Cassette_Waveforms.html)
  * **Dan Tobias**' [IBM PC data cassette format documentation](http://fileformats.archiveteam.org/wiki/IBM_PC_data_cassette)

##### Serial ports

  * **Craig Peacock**'s documentation on [interfacing the serial port](http://retired.beyondlogic.org/serial/serial.htm)
  * **Christopher E. Strangio**'s tutorial on [the RS232 standard](http://www.camiresearch.com/Data_Com_Basics/RS232_standard.html)
  * [QB64 documentation](http://www.qb64.net/wiki/index.php/Port_Access_Libraries#Serial_Communication_Registers)

##### Keyboard scancodes

  * **John Savard**'s [Scan Codes Demystified](http://www.quadibloc.com/comp/scan.htm)
  * **Andries Brouwer**'s extensive reference of [Keyboard scancodes](https://www.win.tue.nl/~aeb/linux/kbd/scancodes.html)
  * **Philip Storr**'s [PC Hardware book](http://www.philipstorr.id.au/pcbook/book3/scancode.htm)
  * Altek Instruments documentation on [PC Keyboard Scan Codes](http://www.barcodeman.co.uk/altek/mule/scandoc.php)

### Fonts

  * **Henrique Peron**'s [CPIDOS codepage pack](http://www.freedos.org/software/?prog=cpidos)
  * **Dmitry Bolkhovityanov**'s [Uni-VGA font](http://www.inp.nsk.su/~bolkhov/files/fonts/univga/)
  * **Roman Czyborra**, **Qianqian Fang** and others' [GNU UniFont](https://savannah.gnu.org/projects/unifont)
  * [DOSBox](http://www.dosbox.com) VGA fonts
  * **Andries Brouwer**'s [CPI font file format documentation](http://www.win.tue.nl/~aeb/linux/kbd/font-formats-3.html)

### Unicode-codepage mappings

  * [The Unicode Consortium and contributors](http://www.unicode.org/Public/MAPPINGS/VENDORS)
  * [GNU libiconv Project](https://www.gnu.org/software/libiconv/)
  * [Aivosto](http://www.aivosto.com/vbtips/charsets-codepages.html)
  * **Konstantinos Kostis**' [Charsets Index](http://www.kostis.net/charsets/)
  * [IBM CDRA](http://www-01.ibm.com/software/globalization/cdra/)
  * **Masaki Tojo**'s [Camellia](https://github.com/mtojo/camellia)

### Bibliography

  * _GW-BASIC 3.23 User's Guide_, Microsoft Corporation, 1987.
  * _IBM Personal Computer Hardware Reference Library: BASIC_, IBM, 1982.
  * _Tandy 1000 BASIC, A Reference Guide_, Tandy Corporation.
  * **William Barden, Jr.**, _Graphics and Sound for the Tandy 1000s and PC Compatibles_, Microtrend, 1987.
  * **Don Inman** and **Bob Albrecht**, _The GW-BASIC Reference_, Osborne McGraw-Hill, 1990.
  * **Thomas C. McIntyre**, _BLUE: BASIC Language User Essay_, 1991, [available online](https://web.archive.org/web/20060410121551/http://scottserver.net/basically/geewhiz.html).
  * **David I. Schneider**, _Handbook of BASIC: Third Edition for the IBM PC, XT, AT, PS/2, and Compatibles_, Brady, 1988.


### Development tools

Development tools:

  * [Git](https://git-scm.com/)
  * [Atom](https://atom.io/)
  * [PyLint](https://pypi.python.org/pypi/pylint/1.7.6)
  * [Coverage](https://pypi.python.org/pypi/coverage)
  * [Ubuntu](http://www.ubuntu.com/)
  * [The GNU Base System](http://www.gnu.org/)

Documentation tools:

  * [LXML](http://lxml.de)
  * [Markdown](https://pypi.python.org/pypi/Markdown)
  * [Prince](https://www.princexml.com/download/)

Packaging tools:

  * [Wheel](https://pypi.python.org/pypi/wheel)
  * [Twine](https://pypi.python.org/pypi/twine)
  * [cx_Freeze](https://anthony-tuininga.github.io/cx_Freeze/)
  * [fpm](https://github.com/jordansissel/fpm)

Source code and releases are hosted on:

  * [GitHub](https://github.com/)
  * [SourceForge](https://sourceforge.net/)
  * [PyPI](https://pypi.org/project/pcbasic/)


### Emulators

These excellent emulators have been indispensable tools in documenting the
behaviour of various Microsoft BASIC dialects.

  * [DOSBox](http://www.dosbox.com)
  * [MESS](http://www.mess.org)
  * [PCE PC Emulator](http://www.hampa.ch/pce/)
