# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-820-1 (pidgin)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(64776);
 script_cve_id("CVE-2009-2694");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 script_name("Ubuntu USN-820-1 (pidgin)");

 desc = "The remote host is missing an update to pidgin
announced via advisory USN-820-1.

Details follow:

Federico Muttis discovered that Pidgin did not properly handle certain
malformed messages in the MSN protocol handler. A remote attacker could
send a specially crafted message and possibly execute arbitrary code with
user privileges.

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 6.06 LTS:
  libgnutls12                     1.2.9-2ubuntu1.7

Ubuntu 8.04 LTS:
  libgnutls13                     2.0.4-1ubuntu2.6

Ubuntu 8.10:
  libgnutls26                     2.4.1-1ubuntu0.4

Ubuntu 9.04:
  libgnutls26                     2.4.2-6ubuntu0.1

In general, a standard system upgrade is sufficient to effect the
necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-820-1

Risk factor : High";

 script_description(desc);

 script_summary("Ubuntu USN-820-1 (pidgin)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Ubuntu Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"finch-dev", ver:"2.4.1-1ubuntu2.6", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpurple-bin", ver:"2.4.1-1ubuntu2.6", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpurple-dev", ver:"2.4.1-1ubuntu2.6", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pidgin-data", ver:"2.4.1-1ubuntu2.6", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pidgin-dev", ver:"2.4.1-1ubuntu2.6", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gaim", ver:"2.4.1-1ubuntu2.6", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"finch", ver:"2.4.1-1ubuntu2.6", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpurple0", ver:"2.4.1-1ubuntu2.6", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pidgin-dbg", ver:"2.4.1-1ubuntu2.6", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pidgin", ver:"2.4.1-1ubuntu2.6", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"finch-dev", ver:"2.5.2-0ubuntu1.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpurple-bin", ver:"2.5.2-0ubuntu1.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpurple-dev", ver:"2.5.2-0ubuntu1.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pidgin-data", ver:"2.5.2-0ubuntu1.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pidgin-dev", ver:"2.5.2-0ubuntu1.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"finch", ver:"2.5.2-0ubuntu1.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpurple0", ver:"2.5.2-0ubuntu1.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pidgin-dbg", ver:"2.5.2-0ubuntu1.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pidgin", ver:"2.5.2-0ubuntu1.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"finch-dev", ver:"2.5.5-1ubuntu8.4", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpurple-bin", ver:"2.5.5-1ubuntu8.4", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpurple-dev", ver:"2.5.5-1ubuntu8.4", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pidgin-data", ver:"2.5.5-1ubuntu8.4", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pidgin-dev", ver:"2.5.5-1ubuntu8.4", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"finch", ver:"2.5.5-1ubuntu8.4", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpurple0", ver:"2.5.5-1ubuntu8.4", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pidgin-dbg", ver:"2.5.5-1ubuntu8.4", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pidgin", ver:"2.5.5-1ubuntu8.4", rls:"UBUNTU9.04")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
