# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-812-1 (subversion)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(64652);
 script_cve_id("CVE-2009-2411");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"8.5");
 script_tag(name:"risk_factor", value:"Critical");
 script_name("Ubuntu USN-812-1 (subversion)");

 desc = "The remote host is missing an update to subversion
announced via advisory USN-812-1.

Details follow:

Matt Lewis discovered that Subversion did not properly sanitize its input
when processing svndiff streams, leading to various integer and heap
overflows. If a user or automated system processed crafted input, a remote
attacker could cause a denial of service or potentially execute arbitrary
code as the user processing the input.

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 6.06 LTS:
  libsvn0                         1.3.1-3ubuntu1.2

Ubuntu 8.04 LTS:
  libsvn1                         1.4.6dfsg1-2ubuntu1.1

Ubuntu 8.10:
  libsvn1                         1.5.1dfsg1-1ubuntu2.1

Ubuntu 9.04:
  libsvn1                         1.5.4dfsg1-1ubuntu2.1

After a standard system upgrade you need to restart any applications that
use Subversion, such as Apache when using mod_dav_svn, to effect the
necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-812-1

Risk factor : High";

 script_description(desc);

 script_summary("Ubuntu USN-812-1 (subversion)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Ubuntu Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libsvn-doc", ver:"1.3.1-3ubuntu1.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsvn-ruby", ver:"1.3.1-3ubuntu1.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.4-subversion", ver:"1.3.1-3ubuntu1.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"subversion-tools", ver:"1.3.1-3ubuntu1.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache2-svn", ver:"1.3.1-3ubuntu1.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsvn-core-perl", ver:"1.3.1-3ubuntu1.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsvn-javahl", ver:"1.3.1-3ubuntu1.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsvn-ruby1.8", ver:"1.3.1-3ubuntu1.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsvn0-dev", ver:"1.3.1-3ubuntu1.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsvn0", ver:"1.3.1-3ubuntu1.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-subversion", ver:"1.3.1-3ubuntu1.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"subversion", ver:"1.3.1-3ubuntu1.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsvn-doc", ver:"1.4.6dfsg1-2ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsvn-javahl", ver:"1.4.6dfsg1-2ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsvn-ruby", ver:"1.4.6dfsg1-2ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"subversion-tools", ver:"1.4.6dfsg1-2ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache2-svn", ver:"1.4.6dfsg1-2ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsvn-dev", ver:"1.4.6dfsg1-2ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsvn-java", ver:"1.4.6dfsg1-2ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsvn-perl", ver:"1.4.6dfsg1-2ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsvn-ruby1.8", ver:"1.4.6dfsg1-2ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsvn1", ver:"1.4.6dfsg1-2ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-subversion-dbg", ver:"1.4.6dfsg1-2ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-subversion", ver:"1.4.6dfsg1-2ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"subversion", ver:"1.4.6dfsg1-2ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsvn-doc", ver:"1.5.1dfsg1-1ubuntu2.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsvn-ruby", ver:"1.5.1dfsg1-1ubuntu2.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"subversion-tools", ver:"1.5.1dfsg1-1ubuntu2.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache2-svn", ver:"1.5.1dfsg1-1ubuntu2.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsvn-dev", ver:"1.5.1dfsg1-1ubuntu2.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsvn-java", ver:"1.5.1dfsg1-1ubuntu2.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsvn-perl", ver:"1.5.1dfsg1-1ubuntu2.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsvn-ruby1.8", ver:"1.5.1dfsg1-1ubuntu2.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsvn1", ver:"1.5.1dfsg1-1ubuntu2.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-subversion-dbg", ver:"1.5.1dfsg1-1ubuntu2.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-subversion", ver:"1.5.1dfsg1-1ubuntu2.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"subversion", ver:"1.5.1dfsg1-1ubuntu2.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsvn-doc", ver:"1.5.4dfsg1-1ubuntu2.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"subversion-tools", ver:"1.5.4dfsg1-1ubuntu2.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsvn-ruby", ver:"1.5.4dfsg1-1ubuntu2.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsvn-dev", ver:"1.5.4dfsg1-1ubuntu2.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsvn-perl", ver:"1.5.4dfsg1-1ubuntu2.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsvn1", ver:"1.5.4dfsg1-1ubuntu2.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-subversion-dbg", ver:"1.5.4dfsg1-1ubuntu2.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-subversion", ver:"1.5.4dfsg1-1ubuntu2.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"subversion", ver:"1.5.4dfsg1-1ubuntu2.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache2-svn", ver:"1.5.4dfsg1-1ubuntu2.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsvn-java", ver:"1.5.4dfsg1-1ubuntu2.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsvn-ruby1.8", ver:"1.5.4dfsg1-1ubuntu2.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
