###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_php_mbstring_func_overload_dos_vuln.nasl 761 2009-03-13 21:14:56Z mar $
#
# PHP 'mbstring.func_overload' DoS Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800373);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"2.1");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-0754");
  script_bugtraq_id(33542);
  script_name("PHP 'mbstring.func_overload' DoS Vulnerability");
  desc = "

  Overview:
  The host is running PHP and is prone to denial of service vulnerability.

  Vulnerability Insight:
  This bug is due to an error in 'mbstring.func_overload' setting in .htaccess
  file. It can be exploited via modifying behavior of other sites hosted on
  the same web server which causes this setting to be applied to other virtual
  hosts on the same server.

  Impact:
  Successful exploitation will let the local attackers to crash an affected web
  server.

  Impact Level: Application

  Affected Software/OS:
  PHP version 4.4.4 and prior
  PHP 5.1.x to 5.1.6
  PHP 5.2.x to 5.2.5

  Fix: No solution or patch is available as on 17th March, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.php.net

  References:
  http://bugs.php.net/bug.php?id=27421
  https://bugzilla.redhat.com/show_bug.cgi?id=479272

  CVSS Score:
    CVSS Base Score     : 2.1 (AV:L/AC:L/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 1.9
  Risk factor : Low";

  script_description(desc);
  script_summary("Check for the version of PHP");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_php_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("version_func.inc");

phpPort = get_kb_item("Services/www");
if(!phpPort){
  exit(0);
}

phpVer = get_kb_item("www/" + phpPort + "/PHP");
if(!phpVer){
  exit(0);
}

# Grep for vulnerable PHP versions
if(version_is_less_equal(version:phpVer, test_version:"4.4.4") ||
   version_in_range(version:phpVer, test_version:"5.1", test_version2:"5.1.6") ||
   version_in_range(version:phpVer, test_version:"5.2", test_version2:"5.2.5")){
  security_hole(phpPort);
}
