###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for lirc MDKA-2007:007 (lirc)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830079);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "MDKA", value: "2007:007");
  script_name( "Mandriva Update for lirc MDKA-2007:007 (lirc)");
  desc = "

  Vulnerability Insight:

  Dkms-lirc allows one to install LIRC drivers on non-Mandriva kernels.
  It contains a driver named lirc_parallel.ko which does not work on
  SMP-enabled kernels, preventing the driver installation on such
  kernels. The lirc_parallel.ko driver has been removed from the updated
  package and moved to a separate package named dkms-lirc-parallel.

  Affected Software/OS:
  lirc on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-01/msg00016.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of lirc");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"dkms-lirc", rpm:"dkms-lirc~0.8.1~0.20060722.4.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"dkms-lirc-parallel", rpm:"dkms-lirc-parallel~0.8.1~0.20060722.4.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"liblirc0", rpm:"liblirc0~0.8.1~0.20060722.4.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"liblirc0-devel", rpm:"liblirc0-devel~0.8.1~0.20060722.4.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lirc", rpm:"lirc~0.8.1~0.20060722.4.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64lirc0", rpm:"lib64lirc0~0.8.1~0.20060722.4.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64lirc0-devel", rpm:"lib64lirc0-devel~0.8.1~0.20060722.4.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}