#
#VID acf80afa-c3ef-11dd-a721-0030843d3802
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID acf80afa-c3ef-11dd-a721-0030843d3802
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(62856);
 script_cve_id("CVE-2008-5276");
 script_bugtraq_id(32545);
 script_version ("$");
 script_tag(name:"cvss_base", value:"9.3");
 script_tag(name:"risk_factor", value:"Critical");
 name = "FreeBSD Ports: vlc-devel";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: vlc-devel

CVE-2008-5276
Integer overflow in the ReadRealIndex function in real.c in the Real
demuxer plugin in VideoLAN VLC media player 0.9.0 through 0.9.7 allows
remote attackers to execute arbitrary code via a malformed RealMedia
(.rm) file that triggers a heap-based buffer overflow.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.trapkit.de/advisories/TKADV2008-013.txt
http://www.videolan.org/security/sa0811.html
http://www.vuxml.org/freebsd/acf80afa-c3ef-11dd-a721-0030843d3802.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: vlc-devel";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"vlc-devel");
if(!isnull(bver) && revcomp(a:bver, b:"0.9.8a")<0) {
    security_note(0, data:"Package vlc-devel version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
