#
#VID f11b219a-44b6-11d9-ae2f-021106004fd6
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52284);
 script_bugtraq_id(11791,11792);
 script_cve_id("CVE-2004-1161", "CVE-2004-1162");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "FreeBSD Ports: rssh";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   rssh
   scponly

CVE-2004-1161:
The installed version of rssh does not properly
restrict programs that can be run, which could
allow remote authenticated users to bypass intended
access restrictions and execute arbitrary programs
via (1) rdist -P, (2) rsync, or (3) scp -S.

CVE-2004-1162:
The unison command in scponly before 4.0 does not
properly restrict programs that can be run, which
could allow remote authenticated users to bypass
intended access restrictions and execute arbitrary
programs via the (1) -rshcmd or (2) -sshcmd flags.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://marc.theaimsgroup.com/?l=bugtraq&m=110202047507273
http://www.vuxml.org/freebsd/f11b219a-44b6-11d9-ae2f-021106004fd6.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: rssh";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"rssh");
if(!isnull(bver) && revcomp(a:bver, b:"2.2.2")<=0) {
    security_note(0, data:"Package rssh version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"scponly");
if(!isnull(bver) && revcomp(a:bver, b:"4.0")<0) {
    security_note(0, data:"Package scponly version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
