#
#VID ef253f8b-0727-11d9-b45d-000c41e2cdad
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52386);
 script_cve_id("CVE-2004-0687", "CVE-2004-0688");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "xpm -- image decoding vulnerabilities";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   agenda-snow-libs
   linux_base
   open-motif-devel
   mupad
   zh-cle_base
   libXpm
   XFree86-libraries
   xorg-libraries
   lesstif
   xpm
   linux-openmotif
   open-motif

CVE-2004-0687
Multiple stack-based buffer overflows in (1) xpmParseColors in
parse.c, (2) ParseAndPutPixels in create.c, and (3) ParsePixels in
parse.c for libXpm before 6.8.1 allow remote attackers to execute
arbitrary code via a malformed XPM image file.

CVE-2004-0688
Multiple integer overflows in (1) the xpmParseColors function in
parse.c, (2) XpmCreateImageFromXpmImage, (3) CreateXImage, (4)
ParsePixels, and (5) ParseAndPutPixels for libXpm before 6.8.1 may
allow remote attackers to execute arbitrary code via a malformed XPM
image file.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://freedesktop.org/pipermail/xorg/2004-September/003172.html
http://scary.beasts.org/security/CESA-2004-003.txt
http://www.vuxml.org/freebsd/ef253f8b-0727-11d9-b45d-000c41e2cdad.html

Risk factor : High";

 script_description(desc);

 summary = "xpm -- image decoding vulnerabilities";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"agenda-snow-libs");
if(!isnull(bver) && revcomp(a:bver, b:"0")>=0) {
    security_note(0, data:"Package agenda-snow-libs version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"linux_base");
if(!isnull(bver) && revcomp(a:bver, b:"0")>=0) {
    security_note(0, data:"Package linux_base version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"open-motif-devel");
if(!isnull(bver) && revcomp(a:bver, b:"0")>=0) {
    security_note(0, data:"Package open-motif-devel version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"mupad");
if(!isnull(bver) && revcomp(a:bver, b:"0")>=0) {
    security_note(0, data:"Package mupad version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"zh-cle_base");
if(!isnull(bver) && revcomp(a:bver, b:"0")>=0) {
    security_note(0, data:"Package zh-cle_base version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"libXpm");
if(!isnull(bver) && revcomp(a:bver, b:"3.5.1_1")<0) {
    security_note(0, data:"Package libXpm version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"XFree86-libraries");
if(!isnull(bver) && revcomp(a:bver, b:"4.4.0_1")<0) {
    security_note(0, data:"Package XFree86-libraries version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"xorg-libraries");
if(!isnull(bver) && revcomp(a:bver, b:"6.7.0_2")<0) {
    security_note(0, data:"Package xorg-libraries version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"lesstif");
if(!isnull(bver) && revcomp(a:bver, b:"0.93.96,2")<0) {
    security_note(0, data:"Package lesstif version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"xpm");
if(!isnull(bver) && revcomp(a:bver, b:"3.4k_1")<0) {
    security_note(0, data:"Package xpm version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"linux-openmotif");
if(!isnull(bver) && revcomp(a:bver, b:"2.2.4")<0) {
    security_note(0, data:"Package linux-openmotif version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"open-motif");
if(!isnull(bver) && revcomp(a:bver, b:"2.2.3_1")<0) {
    security_note(0, data:"Package open-motif version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
