# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-8826 (pidgin)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64723);
 script_cve_id("CVE-2009-2694");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 script_name("Fedora Core 10 FEDORA-2009-8826 (pidgin)");

 desc = "The remote host is missing an update to pidgin
announced via advisory FEDORA-2009-8826.

Update Information:

2.6.1 fixes an issue where pidgin can crash if you are sent a certain type of
URL over Yahoo.

ChangeLog:

* Wed Aug 19 2009 Warren Togami  2.6.1-1
- 2.6.1: Fix a crash when some users send you a link in a Yahoo IM
* Tue Aug 18 2009 Warren Togami  2.6.0-1
- CVE-2009-2694
- Voice and Video support via farsight2 (Fedora 11+)
- Numerous other bug fixes
* Thu Aug  6 2009 Warren Togami  2.6.0-0.11.20090812
- new snapshot at the request of maiku
* Thu Aug  6 2009 Warren Togami  2.6.0-0.10.20090806
- new snapshot - theoretically better sound quality in voice chat
* Tue Aug  4 2009 Warren Togami  2.6.0-0.9.20090804
- new snapshot

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update pidgin' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-8826

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 10 FEDORA-2009-8826 (pidgin)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"finch", rpm:"finch~2.6.1~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"finch-devel", rpm:"finch-devel~2.6.1~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpurple", rpm:"libpurple~2.6.1~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpurple-devel", rpm:"libpurple-devel~2.6.1~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpurple-perl", rpm:"libpurple-perl~2.6.1~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpurple-tcl", rpm:"libpurple-tcl~2.6.1~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pidgin", rpm:"pidgin~2.6.1~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pidgin-devel", rpm:"pidgin-devel~2.6.1~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pidgin-docs", rpm:"pidgin-docs~2.6.1~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pidgin-perl", rpm:"pidgin-perl~2.6.1~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pidgin-debuginfo", rpm:"pidgin-debuginfo~2.6.1~1.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
