###############################################################################
# OpenVAS Vulnerability Test
# $Id$
#
# @Mail WebMail Email Body HTML Injection Vulnerability
#
# Authors
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100149);
 script_bugtraq_id(34529);
 script_version ("1.0");
 script_tag(name:"risk_factor", value:"Low");

 script_name("@Mail WebMail Email Body HTML Injection Vulnerability");
 desc = "

 Overview:
  @Mail and @Mail WebMail are prone to an HTML-injection vulnerability
  because the applications fail to properly sanitize user-supplied
  input before using it in dynamically generated content.

  Hostile HTML and script code may be injected into vulnerable
  sections of the application. When viewed, this code may be rendered
  in the browser of a user viewing a malicious site.

 See also:
  http://www.securityfocus.com/bid/34529

 Risk factor : Low";

 script_description(desc);
 script_summary("Determine if Atmail is vulnerable to HTML Injection");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("atmail_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);

if(!version = get_kb_item(string("www/", port, "/atmail")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers  = matches[1];

  if(!isnull(vers) && vers >!< "unknown") {

       if(version_is_equal(version:vers, test_version:"5.6"))
       {    
  	  security_warning(port:port);
	  exit(0);
       }
  }


exit(0);
