/*
 * Copyright 2013 Canonical Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <QTimer>

#include "QNetworkReply"

QNetworkReply::QNetworkReply(QObject* parent)
    : m_error(QNetworkReply::NoError)
{
}

QVariant QNetworkReply::attribute(QNetworkRequest::Attribute code) const
{
    if (code == QNetworkRequest::RedirectionTargetAttribute) {
        return QVariant(m_redirectUrl);
    } else {
        return QVariant();
    }
}

QNetworkReply::NetworkError QNetworkReply::error() const
{
    return m_error;
}

QString QNetworkReply::errorString() const
{
    return QString();
}

void QNetworkReply::setRedirectUrl(QUrl url) {
    m_redirectUrl = url;
}

/* The original QNetworkReply would retrieve the data from the network
 * asynchronously and fire the "finished" signal when done. Here in the
 * mock class we try to fire it as soon as we know that something is
 * interested in getting it. */
void QNetworkReply::connectNotify(const QMetaMethod &signal)
{
    if (signal == QMetaMethod::fromSignal(&QNetworkReply::finished)) {
        /* Emit the finished signal at the next iteration of the main loop.
         * If we try to emit it immediately it will not be received as when
         * this method is called the signal is not fully connected yet */
        QTimer::singleShot(0, this, SIGNAL(finished()));
    }
}

