.TH MH-FOLDERS %manext5% "February 26, 2014" "%nmhversion%"
.\"
.\" %nmhwarning%
.\"
.SH NAME
mh-folders \- specification of storage format used by nmh message system
.SH DESCRIPTION
.B nmh
stores messages in the files and directories of the host filesystem
according to the following rules:
.PP
.B one folder per directory
.RS 5
A
.B nmh
folder corresponds to directory.  There are no limits on folder
names beyond those of the host filesystem.
.RE
.PP
.B one message per file
.RS 5
The file name is a positive integer.  Other files containing metadata or
arbitrary names can exist in a folder; while the preference is that non\-message
files begin with \*(lq.\*(rq, all files that are not positive integers
.B must
be ignored by a
.BR MH \-compatible
implementation.  However, implementations are free to indicate to the user
the existence of non\-message files that are not prefixed with a \*(lq.\*(rq.
.PP
The filename for a new
message is one greater than the highest numbered message in
the folder; its full path can be accessed by the pseudo\-sequence
.I new
(e.g.,
.B mhpath
.IR new ).
New messages are
.B only
permitted to be added to a folder at the end of the message number range.
.PP
To add a new message to a folder, the recommended sequence is:
.PP
.IP \(bu 4
Create a temporary file in the desired folder.
.IP \(bu 4
Attempt to link the temporary file to the new message number.
.IP \(bu 4
If successful, remove the temporary file.  If the link fails, increment the
message number and try again.
.PP
.RE
.B context
.RS 5
There is one context file.  Its default location is in the
user's Path and default name is
.IR context ,
but those can be overridden with the $MHCONTEXT environment
variable.
.B context
has the following format:
.PP
.RS 5
.BI "Current-Folder: +" folder
.RE
.RS 5
.BI "atr-" sequence-path ": " "m[-n] [...]"
.RE
.PP
where
.I folder
is the directory name of the current folder.  Lines beginning
with \*(lqatr\*(rq are used for private sequences.
.I sequence
is the name of the private sequence,
.I path
is the full path to the folder with the private sequence, and
.I m[-n]
is a message number or range of message numbers in the sequence.
.RE
.PP
.B sequences
.RS 5
There is one sequences file in each
.B nmh
folder.  Its default name is
.IR \&.mh\(rusequences ,
but that can be overridden with the \*(lqmh\-sequences\*(rq profile entry.
.B sequences
has the following format:
.PP
.RS 5
.BI "sequence: " "m[-n] [...]"
.RE
.PP
showing the (possibly empty) message numbers and/or ranges of message
numbers in each sequence.  The
.B cur
sequence has at most just a single message number, not a range.
.PP
Sequence names have a maximum size of 998 characters.  Each line is also
limited to a maximum of 998 characters, but RFC 822 continuation rules
apply; sequences can be continued across multiple lines by prefixing
continuation lines with a whitespace character.
.PP
If an implementation finds messages in a sequence that do not exist,
the sequence file should be updated to remove the missing messages
from the sequence.  If a sequence contains no messages, it should be
removed from the sequence file.  The exception to this is the
.B cur
sequence, which can refer to a nonexistant message.
.RE
.PP
.SS Locking
.B nmh
programs read and write the context and sequences files, and lock
these files when accessing them.  There should not be a need to
access these files directly; instead, programs such as
.BR flist ,
.BR folder ,
.BR mark ,
.BR pick ,
and
.B rcvstore
should be used to query and update their contents.  Any program
outside of
.B nmh
that accesses these files must be sure to lock them using the same
locking method as
.BR nmh .
The default data locking method is selected when
.B nmh
is configured and can be accessed as a string using
.BR "mhparam datalocking" .
By default, fcntl locking is used, but this may be overridden with
the
.B datalocking
profile entry.
.PP
A second, possibly different, locking method is used by
.BR inc (1)
when accessing the user's mail spool file or by
.B nmh
programs that open any mbox file.  This locking method is selected
when
.B nmh
is configured and can be accessed as a string using
.BR "mhparam spoollocking" .
By default, kernel-level locking is used if appropriate for the
platform, and it is for popular platforms.  That default should also
be the same as used by the
.B mail
program, if provided on the platform.
.SH FILES
.fc ^ ~
.nf
.ta \w'^<folder>/\&.mh\(rusequences~'u
^<mh\-dir>/context~^The user context
^or $MHCONTEXT~^Rather than the standard context
^<folder>/\&.mh\(rusequences~^Public sequences for <folder>
.fi
.SH "SEE ALSO"
.I
.IR flist (1),
.IR folder (1),
.IR mail (1),
.IR mark (1),
.IR mh\-param (1),
.IR mh\-path (1),
.IR mh\-profile (5),
.IR mh\-sequence (5),
.IR pick (1),
.IR rcvstore (1)
