/***************************************************************************
 *   Copyright (C) 2005-2008 by Eugene V. Lyubimkin aka jackyf             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License                  *
 *   (version 3 or above) as published by the Free Software Foundation.    *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU GPL                        *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA               *
 ***************************************************************************/
#include <QApplication>
#include <QTranslator>
#include <QLocale>
#include <QString>
#include <QDir>
#include <QMessageBox>

#include <yf/random/random.hpp>

#include "MainWidget.hpp"
#include "ProfileManager.hpp"
#include "FortunesGetter.hpp"
#include "UserProfile.hpp"
#include "Logic.hpp"
#include "Setup.hpp"

const int programResultOtherInstance = 1;

int main(int argc, char* argv[])
{
	QApplication app(argc, argv);
	QCoreApplication::setOrganizationName("jackyf");
	QCoreApplication::setApplicationName(programName);

	QDir::setCurrent(QCoreApplication::applicationDirPath());

	// installing translators
	QTranslator myTranslator;
	myTranslator.load("nlkt_" + QLocale::system().name(), pathToTranslations);
	app.installTranslator(&myTranslator);

	// creating dirs if necessary
	QString previousPath = QDir::currentPath();
	QDir newDir;
	newDir.mkpath(pathToUserProfiles);
	QDir::setCurrent(previousPath);

	// checking for other instances
	if (!system("test `pgrep -u $(id -u) nlkt | wc -l` -gt 1"))
	{
		QMessageBox::critical(NULL,
				QCoreApplication::translate("main", "Other instance exists"),
				QCoreApplication::translate("main", "You are already running other instance of this program."));
		return programResultOtherInstance;
	}

	QString profile;
	ProfileManager profileManager(profile);
	profileManager.show();
	app.exec();
	profileManager.hide();
	qDebug("selected profile = %s", qPrintable(profile));

	if (profile != QString())
	{
		UserProfile userProfile(pathToUserProfiles + profile);
		FortunesGetter fortunesGetter(userProfile);
		Logic logic(fortunesGetter, userProfile);

		yf::random::rnd_init();

		MainWidget window(userProfile);
		QObject::connect(&window, SIGNAL(startExercise()), &logic, SLOT(startExercise()));
		QObject::connect(&window, SIGNAL(terminateExercise()), &logic, SLOT(terminateExercise()));
		QObject::connect(&window, SIGNAL(typedSymbol()), &logic, SLOT(typedSymbol()), Qt::QueuedConnection);
		QObject::connect(&window, SIGNAL(errorOnSymbol()), &logic, SLOT(errorOnSymbol()), Qt::QueuedConnection);

		QObject::connect(&logic, SIGNAL(startTyping(const QString&, const QString&)),
			&window, SLOT(startTyping(const QString&, const QString&)));
		QObject::connect(&logic, SIGNAL(mistakeCount(int)), &window, SLOT(mistakeCount(int)));
		QObject::connect(&logic, SIGNAL(maxMistakeCount(int)), &window, SLOT(maxMistakeCount(int)));
		QObject::connect(&logic, SIGNAL(endTyping()), &window, SLOT(endTyping()));
		QObject::connect(&logic, SIGNAL(tooManyMistakes()), &window, SLOT(tooManyMistakes()));
		QObject::connect(&logic, SIGNAL(exerciseFinished(const ExerciseResult&)),
			&window, SLOT(exerciseFinished(const ExerciseResult&)));
		QObject::connect(&logic, SIGNAL(wait(int)), &window, SLOT(displayWaitMessage(int)));

		QObject::connect(qApp, SIGNAL(aboutToQuit()), &window, SLOT(writeGuiSettings()));

		window.setWindowTitle(QString("nlkt - ") + QObject::tr("non-linear keyboard trainer"));
		window.show();

		return app.exec();
	}
	else
	{
		return 255;
	}
}

//TODO: implement levels

