/* Copyright (C) 1999 Beau Kuiper

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "ftpd.h"

void ftpstate_init(FTPSTATE *ftp, int fd, int ip, int threadnum, int portnum, VSERVER *vs)
{
	ftp->remotefd = fd;
	ftp->remoteip = ip;
	ftp->dataip = ip;
	ftp->hostname = getnetworkstr(ip);
	ftp->threadnum = threadnum;
	ftp->connport = portnum;
	ftp->username = strdupwrapper("<unknown>");
	ftp->outbuffer = string_new();

	ftp->pwd = NULL;
	ftp->homedir = NULL;
	ftp->renameoldname = NULL;
	
	ftp->loggedin = FALSE;
	ftp->restartpos = 0;
	ftp->binary = TRUE;
	ftp->remoteport = 0;
	ftp->passiveport = 0;
	ftp->nicevalue = 0;
	ftp->chroot = 0;
	ftp->droproot = 0;
	ftp->realdir = 0;
	
	ftp->maxtranspd = 0;
	ftp->maxtranspd_up = 0;
	ftp->maxtranspd_down = 0;
	ftp->epsv_forced = 0;
	ftp->basedir = NULL;
	
	ftp->logindump = NULL;

	ftp->inbuffer = string_new();
	
	ftp->maxusers = vs->maxusers;
	ftp->maxtimeout = ftp->timeout = vs->timeout;
	
	ftp->acldata = NULL;
	ftp->umask = vs->umask;       /* set default umask */
	ftp->chmodable = FALSE;
	ftp->dport = NULL;
	ftp->cwddump = NULL;
	ftp->busydump = NULL;
	ftp->quitdump = NULL;
	ftp->cwddumpdata = NULL;
	ftp->busydumpdata = NULL;
	ftp->quitdumpdata = NULL;
	ftp->logindumpdata = NULL;
	
	ftp->groupname = NULL;
	ftp->fakegroup = NULL;
	ftp->fakename = NULL;
	ftp->fakemode = -1;
	ftp->loginsleft = vs->logincount;
	ftp->jailenabled = FALSE;
	ftp->ratioinfo = NULL;
	ftp->supgids = NULL;
	ftp->accessdevices = FALSE;
	ftp->cmddisableset = disableset_create();
	ftp->sitedisableset = disableset_create();

	/* set session stats stuff! */
	ftp->downloadedfiles = 0;
	ftp->uploadedfiles = 0;
	ftp->downloadedfilebytes = 0;
	ftp->uploadedfilebytes = 0;
	ftp->listdownloadedbytes = 0;
	ftp->listconns = 0;
}

void ftpstate_dest(FTPSTATE *ftp)
{
	freeifnotnull(ftp->cmddisableset);
	freeifnotnull(ftp->sitedisableset);
	freeifnotnull(ftp->username);
	freeifnotnull(ftp->pwd);
	freeifnotnull(ftp->homedir);
	freeifnotnull(ftp->renameoldname);
	freeifnotnull(ftp->basedir);
	freeifnotnull(ftp->logindump);
	freeifnotnull(ftp->inbuffer);
	freeifnotnull(ftp->outbuffer);
	freeifnotnull(ftp->cwddump);
	freeifnotnull(ftp->busydump);
	freeifnotnull(ftp->quitdump);
	freeifnotnull(ftp->hostname);
	freeifnotnull(ftp->fakename);
	freeifnotnull(ftp->fakegroup);
	if (ftp->ratioinfo) ratio_finish(ftp->ratioinfo);
	freeifnotnull(ftp->supgids);
	freeifnotnull(ftp->logindumpdata);
	freeifnotnull(ftp->cwddumpdata);
	freeifnotnull(ftp->quitdumpdata);
	freeifnotnull(ftp->busydumpdata); 
	if (ftp->dport)
	{
		freewrapper(ftp->dport->buffer);
		freewrapper(ftp->dport);
	}
	freewrapper(ftp);
}		
