
; MINLOG: hao_cnf.scm


(display"
Begin of hao_cnf.scm

")



(begin

;; Predicate NORMAL

(add-program-constant "N" (mk-arrow (py "ord")(py "boole")) 1 'const 1)

(acr "N ø"  "True")
(acr "N (OP ord ø)"  "N ord")
(acr "N (OP ord (OP ord1 ord2))"
     "N ord and N (OP ord1 ord2) and (ord1≼ord)")



;; HEIGHT HT OF AN ORDINAL TERM ht

(add-program-constant "ht" (mk-arrow (py "ord")(py "nat"))
 1 'const 1)

(acr "ht ø"  "0")
(acr "ht (OP ord1 ord2)"  "SUCC (natMAX (ht ord1) (ht ord2))")




(set! OLD-COMMENT-FLAG COMMENT-FLAG)
(set! COMMENT-FLAG #t)

(display"

We define the normality predicate
as boolean valued function
N : ord -> boole
")

(display-program-constants "N")
(display"

Test of N
"
)
(display "N ø             ")(pnt "N ø")
(display "N ①            ")(pnt "N ①")
(display "N ⑭            ")(pnt "N ⑭")
(display "N OP ω ω⁶       ")(pnt "N (OP ω ω⁶)")
(display "N OP ② ω⁷      ")(pnt "N (OP ② ω⁷)")
(display "N OP ω₆ ω₇      ")(pnt "N (OP ω₆ ω₇)")
(display "N OP ω₉ ⑧      ")(pnt "N (OP ω₉ ⑧)")


(display"

We define the height of an ordinal term
ht : ord -> nat
")

(display-program-constants "ht")
(display"

Test of ht
"
)
(display "ht ø             ")(pnt "ht ø")
(display "ht ①            ")(pnt "ht ①")
(display "ht ⑭            ")(pnt "ht ⑭")
(display "ht OP ω ω⁶       ")(pnt "ht (OP ω ω⁶)")
(display "ht OP ② ω⁷      ")(pnt "ht (OP ② ω⁷)")
(display "ht OP ω₆ ω₇      ")(pnt "ht (OP ω₆ ω₇)")
(display "ht OP ω₉ ⑧      ")(pnt "ht (OP ω₉ ⑧)")

(set! COMMENT-FLAG OLD-COMMENT-FLAG)

)




(display"

There is only one normal term !

( α~β ∧ Nα ∧ Nβ ) → ( α=β )


Proof takes a while.
")

(time(begin

(sg "all ord1.N (OP ord1 ord2) → (N ord1 ∧ N ord2)")
(ind)
(auto)
; Proof finished.
(nrw "N (OP ord1 ord2) → (N ord1 ∧ N ord2)")
(nrw "N (OP ord1 ord2) → N ord1")
(nrw "N (OP ord1 ord2) → N ord2")


(sg "(ord1~ord2 ∧ N ord1 ∧ N ord2) → (ord2=ord1)")

(ind)
  (cases)
  (auto)
(assume "ord11" "ord12" "IH11" "IH12")
(ind)
  (use "Truth-Axiom")
(assume "ord21" "ord22" "IH21" "IH22")
(ng #t)
(cd "ord21≺ord11" "21<11")
(ng #t)
(simp(pf"(ord11≺ord21)=F"))
(ng #t)
(simp(pf"(ord11=ord21)=F"))
(ng #t)
(cd "N(OP ord21 ord22)" "N(21 22)")
(ng #t)
(use "BooleNegationTwo")
(assume "Hyp")
(simp "<-" (pf"(ord11≼ord21)=F"))
(use-with  (pf"(N ord21 ∧ N(OP ord11 ord12)) ∧ ord11≼ord21") 'right)
(cut(pf"N(OP ord21 (OP ord11 ord12))"))
(search)
(simp(pf"OP ord11 ord12 = ord22"))
(use "N(21 22)")
(booleimp  "ord22~OP ord11 ord12 ∧ N ord22 ∧ N(OP ord11 ord12)")
(use "IH22")
(simp (pf"N ord22"))
(use "Hyp")
(booleimp  "N(OP ord21 ord22)")
(auto)
(simp "21<11")
(auto)
(use "Atom-False")
(assume "11=21")
(simp "<-" (pf"(ord21≺ord11)=F"))
(use "21<11")
(simp "11=21")
(auto)
(booleimp "ord21≺ord11")
(auto)

(assume "11≤21")
(cd "ord11≺ord21" "11<21")
(simp(pf"(ord11=ord21)=F"))
(ng #t)
(cd "N(OP ord11 ord12)" "N(11 12)")
(ng #t)
(use "BooleNegationTwo")
(assume "Hyp")
(simp "<-" (pf"(ord21≼ord11)=F"))
(use-with (pf"N ord11 ∧ N(OP ord21 ord22) ∧ ord21≼ord11") 'right)
(cut(pf"N(OP ord11 (OP ord21 ord22))"))
(search)
(simp(pf"OP ord21 ord22 = ord12"))
(use "N(11 12)")
(simp "ordEQsym")
(booleimp  "OP ord21 ord22~ord12 ∧ N(OP ord21 ord22) ∧ N(ord12)")
(use "IH12")
(simp (pf"N ord12"))
(use "Hyp")
(booleimp  "N(OP ord11 ord12)")
(auto)
(simp "11<21")
(auto)
(use "Atom-False")
(assume "11=21")
(simp "<-" (pf"(ord11≺ord21)=F"))
(use "11<21")
(simp "11=21")
(use "Truth-Axiom")

(assume "21≤11")
(ng #t)
(cd "N(OP ord11 ord12)" "N(11 12)")
(cd "N(OP ord21 ord22)" "N(21 22)")
(simp(pf"ord11=ord21"))
(simp(pf"(ord22~ord12∧True∧True)=(ord22~ord12∧N ord22∧N ord12)"))
(use "IH12")
(simp (pf"N ord12"))
(simp (pf"N ord22"))
(use "Truth-Axiom")
(booleimp "N(OP ord21 ord22)")
(auto)
(booleimp "N(OP ord11 ord12)")
(auto)
(booleimp "ord21~ord11∧N ord21∧N ord11")
(use "IH11")
(simp "11≤21")
(simp "21≤11")
(simp (pf"N ord11"))
(simp (pf"N ord21"))
(use "Truth-Axiom")
(booleimp "N(OP ord21 ord22)")
(auto)
(booleimp "N(OP ord11 ord12)")
(auto)
; Proof finished.
(nrw "(ord1~ord2 ∧ N ord1 ∧ N ord2) → (ord2=ord1)")
(nrw "(ord1~ord2 ∧ N ord1 ∧ N ord2) → (ord1=ord2)")

(newline)
(display "(ord1~ord2 ∧ N ord1 ∧ N ord2) → (ord2=ord1) :  ")
(pnt "(ord1~ord2 ∧ N ord1 ∧ N ord2) → (ord2=ord1)")
(newline)
))



(sg "(ht ord=0)=(ord= ø)")
(cases)
(auto)
; Proof finished.
(save "ht=0")
(display-theorems "ht=0")





(animate "FO")

(display"

Some RW-rules for ht

")

(begin

(display"

ht( cFO n )  = n
")

(sg "ht(cFO nat)=nat")
(ind)
  (use "Truth-Axiom")
(assume "nat1" "hyp")
(ng #t)
(simp "hyp")
(simp "natMAX0n")
(use "Truth-Axiom")
; Proof finished.
(arw "ht(cFO nat)" "nat")
(arw "ht((Rec nat=>ord)ø([nat0]OPø)nat)" "nat")


(sg"(1<ht ord)=(¬(ord= ø) ∧ ¬(ord= ①))")

(cases)
  (search)
(assume "ord1" "ord2")
(ng #t)
(cds "ord1= ø" "1=0")
  (ng #t)
  (simp "natMAX0n")
  (simp "ht=0")
  (use "Truth-Axiom")
(assume "2≠0")
(simp "natMAX0")
(simp "ht=0")
(simp "2≠0")
(use "Truth-Axiom")
; Proof finished.
(arw  "2<ht ord" "¬(ord= ø) ∧ ¬(ord= ①)")


(sg "(0<ht ord)=(¬(ord= ø))")
(cases)
(auto)
; Proof finished.
(arw "1<ht ord" "¬(ord= ø)")


(set! OLD-COMMENT-FLAG COMMENT-FLAG)
(set! COMMENT-FLAG #t)
(display-program-constants "ht")
(set! COMMENT-FLAG OLD-COMMENT-FLAG)

(display"

ht's RW-rules end

")

)



(display "

Some RW-rules involving N

")

(time(begin

(display "

N(ω^α+β) → α≺γ →  β≺ω^γ+δ
")

(sg "all ord2,ord1,ord3,ord4.(N (OP ord1 ord2) ∧ ord1≺ord3) →  (ord2 ≺ (OP ord3 ord4))")
(ind)
   (auto)
(assume "ord21" "ord22" "IH21"  "IH22" "ord1" "ord3" "ord4")
(drop "IH21")
(ass "hyp")
(ng)
(cas "ord21≺ord3" "21<3")
(ng)
(booleimp "N(OP ord21 ord22)∧ord21≺ord3")
(use "IH22")
(simp-with "hyp" 'left 'left 'right)
(use "21<3")
(booleimp "ord21≼ord1∧ord1≺ord3")
(use "Truth-Axiom")
(simp-with "hyp" 'left 'right)
(use-with "hyp" 'right)
; Proof finished.
(nrw "(N (OP ord1 ord2) ∧ ord1≺ord3) →  (ord2 ≺ OP ord3 ord4)")



(display "

N(1+α) =   α ≺ ω

")

(sg "N(OP ø ord)=(ord ≺ ω)")
(ind)
  (auto)
(assume "ord1" "ord2" "IH1" "IH2")
(ng #t)
(cds "ord1= ø" "1=0")
(auto)
; Proof finished.
(arw "N(OP ø ord)"  "ord ≺ ω")



(display"

N(ω^α+β)  →  β ~ ω^γ  →  γ ≼ α

")

(sg"all ord2,ord1,ord3.(N(OP ord1 ord2) ∧ ord2 ~ ω^ ord3 ) →  (¬(ord1≺ord3))")
(assume "ord2" "ord1" "ord3")
(ng #t)
(cd "N(OP ord1 ord2)" "N(1,2)")
(cd "ord1≺ord3" "1<3")
(simp (pf"ord2≺OP ord3ø"))
(auto)
(ng)
(booleimp "N (OP ord1 ord2) ∧ ord1≺ord3")
(use "Truth-Axiom")
(simp "N(1,2)")
(auto)
; Proof finished.
(nrw "¬(N(OP ord1 ord2)∧ord2≼OP ord3ø ∧OP ord3ø ≼ord2∧ord1≺ord3)")



(display"

N(ω^α+β) →  β ≺ ω^α+β

")

(sg "all ord2,ord1.N(OP ord1 ord2) → ord2≺OP ord1 ord2")

(ind)
  (search)
(assume "ord21")
(cases)
    (assume "IH21" "T")
    (drop "IH21" "T")
    (ng #t)
    (assume "ord1")
    (cases(pt"ord1≺ord21"))
    (auto)
(assume "ord221" "ord222" "IH21" "IH22" "ord1")
(drop "IH21")
(ass "Norm")
(ng "Norm" #t)
(cas "(ord1≺ord221)=F" "1≮221")
(ng #t)
(cas "(ord1≺ord21)=F" "1≮21")
(ng #t)
(cas "(ord21≺ord221)=F" "21≮221")
(ng #t)
(cd "ord21≺ord1" "21<1")
(cas "ord221≺ord1" "221<1")
(ng #t)

; ?_40: ord222≺OP ord1(OP ord21(OP ord221 ord222))

(booleimp "ord222≺OP ord1(OP ord221 ord222)
     ∧ OP ord1(OP ord221 ord222)≼OP ord1(OP ord21(OP ord221 ord222))")
(use "Truth-Axiom")
(ng #t)
(booleimp "ord222≼OP ord221 ord222 ∧ OP ord221 ord222≺OP ord1(OP ord221 ord222)")
(use "Truth-Axiom")
(booleimp "N(OP ord1(OP ord221 ord222))")
(use "IH22")
(ng #t)
(simp "1≮221")
(simp-with "Norm" 'left 'left 'right)
(use-with "Norm" 'left 'left 'left 'left)
(booleimp "ord221≼ord21 ∧ ord21≺ord1")
(use "Truth-Axiom")
(simp "21≮221")
(use "21<1")

(assume "21≮1")
(ng #t)
(cd "ord221≺ord21" "221<21")
(ng #t)

; ?_59: ord222≺OP ord21(OP ord221 ord222)

(booleimp "ord222≼OP ord221 ord222
	 ∧ OP ord221 ord222≺OP ord21 (OP ord221 ord222)")
(use "Truth-Axiom")
(simp
 (pf"(ord222≼OP ord221 ord222∧OP ord221 ord222≺OP ord21(OP ord221 ord222))
     =(OP ord221 ord222≺OP ord21(OP ord221 ord222))"))
(booleimp "OP ord221 ord222≺OP ord1(OP ord221 ord222)
	 ∧ OP ord1(OP ord221 ord222)≼OP ord21 (OP ord221 ord222)")
(use(pf "all ord1,ord2,ord3. ord1≺ord2∧ord2≼ord3→ord1≺ord3"))
(search)
(split)
    (booleimp "N(OP ord1(OP ord221 ord222))")
    (use "IH22")
    (ng #t)
    (simp "1≮221")
    (simp-with "Norm" 'left 'left 'right)
    (use-with "Norm" 'left 'left 'left 'left)
(ng #t)
(simp "21≮1")
(auto)
(assume "221≮21")
(ng #t)

; ?_77: ord222≺OP ord221 ord222

(cases(pt"ord222≺OP ord221 ord222"))
    (search)
(assume "222≮(221,222)")
(simp (pf "F=(ord222=OP ord221 ord222)"))
(booleimp "OP ord221 ord222~ord222 ∧ N(OP ord221 ord222) ∧ N ord222 ")
(use (pf"all ord1,ord2.(ord1~ord2 ∧ N ord1 ∧ N ord2) → (ord2=ord1)"))
(search)
(simp-with "Norm" 'left 'left 'right)
(simp "222≮(221,222)")
(ng #t)
(booleimp "N(OP ord221 ord222)")
(use "Truth-Axiom")
(use-with "Norm" 'left 'left 'right)
(simp "BooleFalseLeft")
(use "Truth-Axiom")
(simp "BooleFalseRight")
(use-with "Norm" 'left 'right)
(simp "BooleFalseRight")
(use-with "Norm" 'right)
(simp "BooleFalseRight")
(trans "ord21")
(simp-with "Norm" 'right)
(use-with "Norm" 'left 'right)
; Proof finished.
(nrw "N(OP ord1 ord2) → ord2≺OP ord1 ord2")




(sg "¬(N ord1∧ord1≼ord2∧ord2≼ord1∧ht ord2<ht ord1)")
(set! COMMENT-FLAG #f)
(ind)
    (search)
(assume "ord11" "ord12" "IH11" "IH12")
(ind)
    (use "Truth-Axiom")
(assume "ord21" "ord22" "IH21" "IH22")
(cd "N(OP ord11 ord12)" "N(11,12)")
(ng #t)
(cd "ord21≺ord11" "21<11")
(drop "IH11" "IH12" "IH21")
(simp(pf"(ord11≺ord21)=F"))
(ng #t)
(cd "OP ord11 ord12~ord22" "(11,12)=22")
(ng #t)
(trans "ht ord22")
(ng #t)
(trans "ht(OP ord11 ord12)")
(ng #t)
(booleimp "N(OP ord11 ord12)∧OP ord11 ord12~ord22")
(use "IH22")
(simp "N(11,12)")
(drop "IH22" "N(11,12)")
(auto)
(simp "BooleFalseRight")
(booleimp "ord21≺ord11")
(auto)

(assume "21≮11")
(drop "IH21" "IH22")
(ng #t)
(cd "ord11≺ord21" "11<21")
(drop "IH11" "IH12")
(ng #t)
(simp (pf "(ord12~OP ord21 ord22)=F"))
(use "Truth-Axiom")
(cd "ord12~OP ord21 ord22" "12=(21,22)")
(ng #t)
(simp(pf"F=(ord12≺OP ord11 ord12)"))
(booleimp "N(OP ord11 ord12)")
(auto)
(simp "BooleFalseLeft")
(trans "OP ord21 ord22")
(simp-with "12=(21,22)" 'right)
(ng #t)
(simp "21≮11")
(simp "11<21")
(ng #t)
(use-with "12=(21,22)" 'left)
(search)
(assume "11≮12")
(ng #t)
(cd "ord12~ord22" "12=22")
(ng #t)
(cd "ht ord11<ht ord12" "h11<h12")
    (ng #t)
    (trans "ht ord22")
    (ng #t)
    (booleimp "N ord12∧ord12~ord22")
    (use "IH12")
    (simp "12=22")
    (booleimp "N(OP ord11 ord12)")
    (auto)
(assume "h11≮h12")
(drop "IH12" "12=22")
(ng #t)
(trans "ht ord21")
(ng #t)
(booleimp "N ord11∧ord11~ord21")
(use "IH11")
(simp "21≮11")
(simp "11≮12")
(booleimp "N(OP ord11 ord12)")
(auto)
; Proof finished.
(nrw "¬(N ord1∧ord1≼ord2∧ord2≼ord1∧ht ord2<ht ord1)")

(set! OLD-COMMENT-FLAG COMMENT-FLAG)
(set! COMMENT-FLAG #t)
(display "
Normal Terms are of minimal height:

(N α ∧ α~β) →  ht α ≼ ht β

       N ord1 ∧ ord1~ord2  →  ht ord1≤ht ord2    ")
(pnt "(N ord1 ∧ ord1~ord2) →  ht ord1≤ht ord2")
(newline)(newline)
(set! COMMENT-FLAG OLD-COMMENT-FLAG)


))







(display"


We now extract the Cantor-Normal-Form from

∃ξ .  α=ξ ∧ Nξ

")

(begin

(sg "ex ord2.ord1~ord2 ∧ N ord2")

(ind)
  (ex-intro(pt"ø"))
  (use "Truth-Axiom")
(assume "ord11")
(cases)
(assume "IH11" "IH0")
(drop "IH0")
(by-assume-with "IH11" "ord21" "IH21")

(ex-intro(pt"OP ord21 ø"))
(ng #t)
(use "IH21")
(assume  "ord12" "ord13" "IH11" "IH1213")
(by-assume-with "IH11" "ord21" "IH21")
(by-assume-with "IH1213" "ord22" "IH22")
(ca "ord22=OP (left right(cComp ord22))(right right(cComp ord22))" "22=l22r22")
(cd "left right(cComp ord22) ≼ ord21" "l22≤21")
(ex-intro(pt"OP ord21 ord22"))

(split)
    (booleimp " ord11~ord21∧OP ord12 ord13~ord22")
    (use "Truth-Axiom")
    (simp-with "IH21" 'left)
    (use-with "IH22" 'left)
(simp "22=l22r22")
(ng #t)
(simp-with "IH21" 'right)
(simp "l22≤21")
(simp "<-" "22=l22r22")
(use-with "IH22" 'right)
(assume "¬l22≤21")
(ca "ord21≺left right(cComp ord22)" "21<l22")
(ca "(left right(cComp ord22)≺ord21)=F" "21≤l22")

(ex-intro(pt"ord22"))
(simp-with "IH22" 'right)
(ng #t)


(ordeqtrans "OP ord21 ord22")
(split)
(booleimp "ord11~ord21 ∧ OP ord12 ord13~ord22")
(use "Truth-Axiom")
(simp-with "IH21" 'left)
(use-with "IH22" 'left)
(ng #t)
(simp "22=l22r22")
(ng #t)
(simp "21≤l22")
(ng #t)
(simp "21<l22")
(use "Truth-Axiom")
(booleimp "ord21≺left right(cComp ord22)")
(auto)
(simp (pf "(ord21≺left right(cComp ord22))=(¬(¬(ord21≺left right(cComp ord22))))"))
(simp "¬l22≤21")
(auto)

; ?_23: ord22=OP left right(cComp ord22)right right(cComp ord22)

(drop "IH21")
(booleimp "(ord22= ø) ∨ (ord22=OP (left (right (cComp ord22))) (right (right (cComp ord22))))")
(cd "ord22= ø" "22=0")
(booleimp "OP ord12 ord13~ord22")
(simp "22=0")
(auto)
(use-with "IH22" 'left)

(auto)

; Proof finished.
(save "nf")
(display-theorems "nf")

(add-theorem "cnf_Soundness"
             (proof-to-soundness-proof
		 (theorem-name-to-proof "nf")))
; (display-theorems "cnf_Soundness")

(animate "Comp")
(test-extracted-unary "nf")
(deanimate "Comp")

)



(animate "nf")


(display "

   Some RW-rules involving
   Cantor-Normal-Form  cnf

")

(begin

(sg "N(cnf ord)")
(assume "ord")
(inst-with-to "cnf_Soundness" (pt"ord") 'right "nfSound")
(search)
; Proof finished.
(trw "N(cnf ord)")
(trw "N ((Rec ord=>ord)ø
         ([ord0,ord1,ord2,ord3]
           [if ord1
             (OP ord2ø)
             ([ord4,ord5]
              [if (left[if ord3 (ø @ ø) ([ord6,ord7]ord6@ord7)]≼ord2)
                (OP ord2 ord3)
                ord3])])
         ord)")


(sg "cnf ord≼ord")
(assume "ord")
(inst-with-to "cnf_Soundness" (pt"ord") 'left "nfSound")
(ng "nfSound")
(use-with "nfSound" 'right)
; Proof finished.
(nrw "cnf ord≼ord")
(nrw "(Rec ord=>ord)ø
      ([ord0,ord1,ord2,ord3]
        [if ord1
          (OP ord2ø)
          ([ord4,ord5][if (left right(cComp ord3)≼ord2) (OP ord2 ord3) ord3])])
      ord≼  ord")


(sg "ord≼cnf ord")
(assume "ord")
(inst-with-to "cnf_Soundness" (pt"ord") 'left "nfSound")
(search)
; Proof finished.
(nrw "ord≼cnf ord")
(nrw "ord≼ (Rec ord=>ord)ø
           ([ord0,ord1,ord2,ord3]
             [if ord1
               (OP ord2ø)
               ([ord4,ord5][if (left right(cComp ord3)≼ord2) (OP ord2 ord3) ord3])])
           ord")


(deanimate "nf")




(sg "cnf ord1 ~ cnf ord2 → cnf ord1 = cnf ord2")
(assume "ord2" "ord1")
(ass "nf1=nf2")
(booleimp "cnf ord1~cnf ord2 ∧ N (cnf ord1) ∧ N (cnf ord2)")
(use (pf "all ord1,ord2.  ord1~ ord2∧N( ord1)∧N( ord2)→ ord1= ord2"))
(auto)
; Proof finished.
(nrw "cnf ord1 ~ cnf ord2 → cnf ord1 = cnf ord2")
(nrw "(Rec ord=>ord)ø
      ([ord3,ord4,ord5,ord6]
        [if ord4
          (OP ord5ø)
          ([ord7,ord8][if (left right(cComp ord6)≼ord5) (OP ord5 ord6) ord6])])
      ord1≼
      (Rec ord=>ord)ø
      ([ord3,ord4,ord5,ord6]
        [if ord4
          (OP ord5ø)
          ([ord7,ord8][if (left right(cComp ord6)≼ord5) (OP ord5 ord6) ord6])])
      ord2∧
      (Rec ord=>ord)ø
      ([ord3,ord4,ord5,ord6]
        [if ord4
          (OP ord5ø)
          ([ord7,ord8][if (left right(cComp ord6)≼ord5) (OP ord5 ord6) ord6])])
      ord2≼
      (Rec ord=>ord)ø
      ([ord3,ord4,ord5,ord6]
        [if ord4
          (OP ord5ø)
          ([ord7,ord8][if (left right(cComp ord6)≼ord5) (OP ord5 ord6) ord6])])
      ord1→
      (Rec ord=>ord)ø
      ([ord3,ord4,ord5,ord6]
        [if ord4
          (OP ord5ø)
          ([ord7,ord8][if (left right(cComp ord6)≼ord5) (OP ord5 ord6) ord6])])
      ord1=
      (Rec ord=>ord)ø
      ([ord3,ord4,ord5,ord6]
        [if ord4
          (OP ord5ø)
          ([ord7,ord8][if (left right(cComp ord6)≼ord5) (OP ord5 ord6) ord6])])
      ord2")



(sg "ord1 ~ ord2 → cnf ord1 = cnf ord2")
(assume "ord2" "ord1")
(ass "1=2")
(booleimp "cnf ord1~cnf ord2 ∧ N (cnf ord1) ∧ N (cnf ord2)")
(use "Truth-Axiom")
(ng #t)
(ordeqtrans "ord1")
(ng #t)
(ordeqtrans "ord2")
(search)
; Proof finished.
(nrw "ord1 ~ ord2 → cnf ord1 = cnf ord2")
(nrw "ord1~ord2→
      (Rec ord=>ord)ø
      ([ord3,ord4,ord5,ord6]
        [if ord4
          (OP ord5ø)
          ([ord7,ord8][if (left right(cComp ord6)≼ord5) (OP ord5 ord6) ord6])])
      ord1=
      (Rec ord=>ord)ø
      ([ord3,ord4,ord5,ord6]
        [if ord4
          (OP ord5ø)
          ([ord7,ord8][if (left right(cComp ord6)≼ord5) (OP ord5 ord6) ord6])])
      ord2")


(set! OLD-COMMENT-FLAG COMMENT-FLAG)
(set! COMMENT-FLAG #t)

(newline)(newline)
(display "The Cantor-Normal-Form is normal :

   N(cnf ord) ∧ cnf ord ~ ord     ")
(pnt  "N(cnf ord) ∧ cnf ord ~ ord")
(newline)(newline)
(display " There is a unique term in CNF

   cnf ord1 ~ cnf ord2  →  cnf ord1 = cnf ord2     ")
(pnt "cnf ord1 ~ cnf ord2 → cnf ord1 = cnf ord2")
(newline)
(display "       ord1 ~ ord       →  cnf ord1 = cnf ord2     ")
(pnt "ord1 ~ ord2 → cnf ord1 = cnf ord2")

(set! COMMENT-FLAG OLD-COMMENT-FLAG)

)



(display"

End of hao_cnf.scm

")

